<?php
/*
 * $Horde: turba/deleteobject.php,v 1.3.2.13 2005/01/03 11:26:03 jan Exp $
 *
 * Turba: Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';

$source = Horde::getFormData('source');
$driver = &Turba_Source::singleton($source, $cfgSources[$source]);

$key = Horde::getFormData('key');
if ($driver->removeObject($key)) {
    if (!empty($_SESSION['turba_search_results'])) {
        require_once TURBA_BASE . '/lib/List.php';
        require_once TURBA_BASE . '/lib/Object.php';
        $list = Turba_List::unserialize($_SESSION['turba_search_results']);
        $list->remove($key);
        $_SESSION['turba_search_results'] = $list->serialize();
    }
    if (Horde::getFormData('url')) {
        header('Location: ' . Horde::getFormData('url'));
    } else {
        header('Location: ' . Horde::url($prefs->getValue('initial_page'), true));
    }
} else {
    Horde::raiseMessage(_("There was an error deleting this object. Contact your system administrator for further help."), HORDE_ERROR);

    $title = _("Deletion failed");
    $js_onLoad = null;
    include TURBA_TEMPLATES . '/common-header.inc';
    include TURBA_BASE . '/menu.php';
    include TURBA_BASE . '/status.php';
    include TURBA_TEMPLATES . '/common-footer.inc';
}
