/*
 * twclock:  A world clock implemented with Motif widgets
 * Copyright (C) 1997 Ted Williams WA0EIR (ted@bluestone.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139, USA.
 * See the COPYING file in this directory.
 *
 * Versions: 1.4 -  July 2001
 */

/*
 * TWCLOCK MAIN 
 */

#include "twclock.h"
#include "twclock.xpm"

int main (int argc, char *argv[])
{
   Widget iconwin;
   Pixmap pixmap, mask;
   XpmAttributes pix_attributes;
   XpmColorSymbol transparentColor[1] = {{NULL, "none", 0}};
   Pixel bg;
                            
   XtResource appRes_desc[] =
   {
      {
      XmNtzone,                       /* Name */
      XmCTzone,                       /* Class */
      XmRInt,                         /* Target data type */
      sizeof (int),                   /* size of target type */
      XtOffsetOf (AppRes, tzone),     /* Offset into struct */
      XtRImmediate,                   /* Default data type */
      (XtPointer) 0                   /* Pointer to default value */
      },

      {
      XmNblink,                       /* Same as above */           
      XmCBlink,                       
      XmRInt,                         
      sizeof (int),                   
      XtOffsetOf (AppRes, blink),     
      XtRImmediate,                   
      (XtPointer)1                    
      },
              
      {
      XmNbeep,                        /* Same as above */
      XmCBeep,                       
      XmRInt,                         
      sizeof (int),                   
      XtOffsetOf (AppRes, beep),     
      XtRImmediate,                   
      (XtPointer)1                    
      },
              
      {
      XmNflashColor,                  /* Same as above */
      XmCFlashColor,                       
      XmRPixel,                         
      sizeof (Pixel),                   
      XtOffsetOf (AppRes, flashColor),     
      XtRImmediate,                   
      (XtPointer)1                    
      },
              
      {
      XmNminutes,                     /* Same as above */
      XmCMinutes,                       
      XmRInt,                         
      sizeof (int),                   
      XtOffsetOf (AppRes, minutes),     
      XtRImmediate,                   
      (XtPointer)10                    
      },

      {
      XmNseconds,                     /* Same as above */
      XmCSeconds,                       
      XmRInt,                         
      sizeof (int),                   
      XtOffsetOf (AppRes, seconds),     
      XtRImmediate,                   
      (XtPointer)0                    
      },
  };

   /*
    * Create clockShell and set some of its properties
    */

   clock_shell = XtVaAppInitialize (&app, "Twclock",
      NULL, 0, &argc, argv, NULL, 
      XmNminHeight, 175,
      XmNminWidth, 175,
      XmNmaxHeight, 250,
      XmNmaxWidth, 250,
      XmNminAspectX, 1,
      XmNminAspectY, 1,
      XmNmaxAspectX, 1,
      XmNmaxAspectY, 1,
      XmNtitle, "TW CLOCK ",
      XmNiconName, "TW CLOCK",
      NULL);

   XtGetApplicationResources (clock_shell, &appRes, appRes_desc,
      XtNumber (appRes_desc), NULL, 0);

   /*
    * Create Icon window and its pixmap
    */
   iconwin = XtVaAppCreateShell ("Iconwin", "clock_shell",
      wmShellWidgetClass, XtDisplay(clock_shell),
      XmNmappedWhenManaged, False,
      XmNwidth,  60,
      XmNheight, 40,
      NULL);
   
   XtVaGetValues (iconwin,
      XmNbackground, &bg,
      NULL);
   
   transparentColor[0].pixel = bg;
   pix_attributes.closeness = 40000;
   pix_attributes.valuemask = XpmColorSymbols | XpmCloseness;
   pix_attributes.colorsymbols = transparentColor;
   pix_attributes.numsymbols = 1;
   
   XpmCreatePixmapFromData (XtDisplay(clock_shell),
      DefaultRootWindow (XtDisplay(clock_shell)),
      twclock_xpm, &pixmap, &mask, &pix_attributes);

   /*
    * Build and Realize the rest of the widget tree
    */
   build_widgets();
   XtRealizeWidget (clock_shell);   
   XtRealizeWidget (iconwin);

   /*
    * Set pixmap properties in clock_shell and iconwin
    */
   XtVaSetValues (iconwin,
      XmNbackgroundPixmap, pixmap,
      NULL);
 
   XtVaSetValues (clock_shell,
      XmNiconWindow, XtWindow(iconwin),
      NULL);

   /*
    * Enter the event loop
    */
   XtAppMainLoop (app);
   return (0);
}

