<?php

Function ABParseTranslateFields( $type, $record )
	{
	include( "features/contacts/import.defs/" . $type . ".def.php3" );

	$TWIGFields = array( "item", "description", "url", "firstname", "lastname", "email", "company", "home_phone", "work_phone", "mobile", "fax", "address1", "address2", "city", "state", "zipcode", "country", "title", "pager", "ofax", "department", "office", "spouse", "bday", "oaddress1", "oaddress2", "ocity", "ozip", "ostate", "ocountry", "email2", "email3" );

	$j = count( $TWIGFields );

	for( $i = 0; $i < $j; $i++ )
		{
		$citem = $TWIGFields[$i];
		$crecnum = $ABInfo[$type]["TFields"][$citem];

		$ret[$citem] = trim(chop($record[$crecnum]));
		}

	return $ret;
	}

Function ABAddRecord( $fields )
	{
	GLOBAL $dbconfig, $login;

	$result = dbQuery( "SELECT id, item, firstname, lastname FROM " . $dbconfig["contact_table"] . " WHERE item = '" . SQLString( $fields["item"] ) . "' AND firstname = '" . SQLString( $fields["firstname"] ) . "' AND lastname = '" . SQLString( $fields["lastname"] ) . "'" );

	if( dbNumRows( $result ) == 1 )
		{
		$recid = dbResult( $result, 0, "id" );
		$fields["username"] = $login["username"];
		$result = dbQuery( "UPDATE " . $dbconfig["contact_table"] . " SET " . MakeUpdateString( $fields ) . " WHERE id = '" . $recid . "'" );
		}
	else
		{
		$ins = MakeInsertString( $fields );
		$result = dbQuery( "INSERT INTO " . $dbconfig["contact_table"] . " (" . $ins["fields"] . ") VALUES (" . $ins["values"] . ")" );
		}
	}

Function ABImportCSV( $filename, $type, $group )
	{
	GLOBAL $login;

	include( "features/contacts/import.defs/" . $type . ".def.php3" );

	$TWIGFields = array( "username", "item", "description", "url", "firstname", "lastname", "email", "company", "home_phone", "work_phone", "mobile", "fax", "address1", "address2", "city", "state", "zipcode", "country", "title", "pager", "ofax", "department", "office", "spouse", "bday", "oaddress1", "oaddress2", "ocity", "ozip", "ostate", "ocountry", "email2", "email3" );
	
	$records = ABParseCSV( $filename, $type );

	$j = count( $records );

	for( $i = $ABInfo[$type]["HeaderLine"]; $i < $j; $i ++ )
		{
		$ret = ABParseTranslateFields( $type, $records[$i] );

		$ret["username"] = $login["username"];
		$ret["groupid"] = $group;

		if( !$ret["item"] )
			{
			if( $ret["email"] )
				{
				$ret["item"] = substr( $ret["email"], 0, strchr( $ret["email"], "@" ) - 1 );
				}
			if( $ret["firstname"] )
				{
				$ret["item"] = $ret["firstname"];
				}
			elseif( $ret["company"] )
				{
				$ret["item"] = $ret["company"];
				}
			}
		
		ABAddRecord( $ret );
		}
	}
	
Function ABParseCSV( $filename, $type )
	{
	include( "features/contacts/import.defs/" . $type . ".def.php3" );
	
    	$fp = fopen( $filename, "r" );
	$cf = 0;

	if( $ABInfo[$type]["HeaderLine"] )
		{
		$ret[$cf] = fgetcsv( $fp, 4096, $ABInfo[$type]["Delimiter"] );

		$cf++;
		}
	else
		{
		for( $i = 0; $i < $ABInfo[$type]["FieldCount"]; $i++ )
			{
			$ret[0][$i] = $ABInfo[$type]["Fields"][$i];
			}
		}

	$cline = "1";

	while( $cline = fgetcsv( $fp, 4096, $ABInfo[$type]["Delimiter"] ) )
		{
		$ret[$cf] = $cline;

		$cf++;
		}

	fclose( $fp );

	return $ret;
	}

Function ABImportLDIF( $filename, $type, $group )
	{
	GLOBAL $login;
	// This'll get written at some point or another...
	}

Function ABParseLDIF( $filename, $type )
	{
	// This'll get written at some point or another...
	return $ret;
	}

Function ABImportVCARD( $filename, $type, $group )
	{
	GLOBAL $login;

	// Read up the file as a line by line array
    	$lines = file( $filename );

	// Get an array of lines for each VCARD in the file
	// Parse each set, and try to insert a Contact for each
	$groupedlines = ABParseVCARDExplode( $lines );
	while( list( $key, $val ) = each( $groupedlines ) )
		{
		$ret = ABParseVCARD( $val, $type );

		if( is_array( $ret ) )
			{
			$ret["username"] = $login["username"];
			$ret["groupid"] = $group;

			if( !$ret["item"] )
				{
				if( $ret["email"] )
					{
					$ret["item"] = substr( $ret["email"], 0, strchr( $ret["email"], "@" ) - 1 );
					}
				if( $ret["firstname"] )
					{
					$ret["item"] = $ret["firstname"];
					}
				elseif( $ret["company"] )
					{
					$ret["item"] = $ret["company"];
					}
				}

			ABAddRecord( $ret );
			}
		}
	}
	
Function ABParseVCARD( $lines, $type )
	{
	$type = ABParseVCARDVersion( $type, $lines );

	// Import the type definition
	include( "features/contacts/import.defs/" . $type . ".def.php3" );

	// Begin looping
	reset( $lines );
	while( list( $key, $val ) = each( $lines ) )
		{
		// Check if we're a new property or a continuation line
		// (the thing in the first quotes is a space, in the second quotes is a tab)
		if( substr( $val, 0, 1 ) == " " || substr( $val, 0, 1 ) == "	" )
			{
			// Yes, we're on a continuation line
			if( $lastkey )
				{
				$semiparsed[$loopkey] .= " " . trim( $val );
				}
			else
				{
				$unmatched .= $val;
				}
			}
		else
			{
			// Nope, not a continuation line

			// Split into property and value
			$valsplit = split( ":", $val, 2 );

			// Split the property up into its parts
			$prop = explode( ";", $valsplit[0] );

			// This may be encoded, the property will tell us further on
			$value = trim( $valsplit[1] );

			$loop = ABParseVCARDLoop( $ABInfo[$type], $prop, $value );

			if( is_array( $loop ) )
				{
				$lastkey = true;
				list( $loopkey, $loopval ) = each( $loop );
				$semiparsed[$loopkey] = $loopval;
				}
			else
				{
				$lastkey = false;
				$unmatched .= $val;
				}
			}
		}

	// Sanity check
	if( !is_array( $semiparsed ) ) { return -1; }

        // Match up the properties
	while( list( $semikey, $semival ) = each( $semiparsed ) )
		{
		$semikeys = explode( ";", $semikey );
		$semivals = explode( ";", $semival );

		for( $i = 0, $j = count( $semikeys ); $i < $j; $i++ )
			{
			if( $semivals[$i] )
				{
				$parsed[$semikeys[$i]] = $semivals[$i];
				}
			}
		}

	// Yank out superfluous "unmatched entries"
	$unmatched = eregi_replace( "BEGIN:VCARD.?\n", "", $unmatched );
	$unmatched = eregi_replace( "VERSION:[0-9]\.[0-9].?\n", "", $unmatched );
	$unmatched = eregi_replace( "END:VCARD.?\n", "", $unmatched );

	// Make sure there really are unmatched items before we say there are
	if( strlen( trim( $unmatched ) ) > 1 )
		{
		// Put all of the unmatched items into the description field
		$parsed["description"] = "The following entries were not imported:\n" . $unmatched . "\n" . $parsed["description"];
		}
	
	// Decode the values as needed
	// we want to wait until the end, so that we can do this with continued lines concatenated

	return $parsed;
	}

Function ABParseVCARDVersion( $type, &$lines )
 	{
	// Figure out what kind of vCard we're working with
	switch( strtoupper( $type ) )
		{
		case "VCARD21":
			// vCard version is set to 2.1,
			// so ignore the version string in the vCard itself
			$type = "vCard21";
			break;
		case "VCARD30":
			// vCard version is set to 3.0,
			// so ignore the version string in the vCard itself
			$type = "vCard30";
			break;
		default:
			// vCard version is to be auto detected,
			// do a loop to find the version field
			while( list( $key, $val ) = each( $lines ) )
				{
				if( eregi( "VERSION", $val ) )
					{
					if( ereg( "2.1", $val ) )
						{
						// vCard version 2.1 found
						$type = "vCard21";
						}
					elseif( ereg( "3.0", $val ) )
						{
						// vCard version 3.0 found
						$type = "vCard30";
						}
					else
						{
						// Whoa, something new and unusual I see!
						}
					break; // No need to keep looping if we already found the version
					}
				}
			break;
		}
	return $type;
	}

 Function ABParseVCARDLoop( $ABInfo, $prop, $value )
 	{
 	if( !is_array( $prop ) ) { return false; }
 	// Parse the property into a standardized thingy to match up with the import defs
 	while( list( $propkey, $propval ) = each( $prop ) )
 	       	{
        	if( is_array( $ABInfo[strtoupper($propval)] ) )
        		{
        		$loop = ABParseVCARDLoop( $ABInfo[strtoupper($propval)], $prop, $value );
        		if( is_array( $loop ) )
				{
				list( $loopkey, $loopval ) = each( $loop );
				$ret[$loopkey] = $loopval;
				}
			else
				{
				if( isset( $ABInfo[strtoupper($propval)]["default"] ) )
					{
					$ret[$ABInfo[strtoupper($propval)]["default"]] = $value;
					}
				}
        		}
        	elseif( is_string( $ABInfo[strtoupper($propval)] ) )
        		{
			if( $ABInfo[strtoupper($propval)] )
				{
				$ret[$ABInfo[strtoupper($propval)]] = $value;
				}
        		}
        	}
	// Return $ret if it is an array, otherwise return false
	return ( is_array( $ret ) ? $ret : false );
        }

 Function ABParseVCARDExplode( $lines )
 	{
	// Take the input lines, and look for BEGIN:VCARD and END:VCARD boundaries,
	// returning an array of single entries each bounded with a begin and end line
	$i = 0;
	while( list( $key, $val ) = each( $lines ) )
		{
		if( eregi( "^BEGIN:VCARD", $val ) )
			{
			// increment the target element
			$i++;
			}
		$ret[$i][] = $val;
		}
	return $ret;
	}

?>

