/*
 * twlog:  A basic ham loging program using Motif
 * Copyright (C) 1997 Ted Williams WA0EIR (ted@bluestone.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139,
 * USA. See the COPYING file in this directory.
 *
 * Versions: 1.2 -  Nov 1998
 */

/*
 * TWLOG CALLBACKS FUNCTIONS
 */

#include "twlog.h"

#define APPEND   0
#define EDIT     1
#define PRINT    2
#define NEW      3
#define QRT      4

#define ABOUT    0
#define HELP     1

/*
 * dateCB Callback
 * Puts the date into the date text field and forces 
 * focus to the startPB.
 */
void dateCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   Cdata *wids = (Cdata *) cdata;
   time_t current;
   struct tm *timestruct = NULL;
   char date[20];

   time(&current);
   timestruct = localtime (&current);

   strftime (date, sizeof(date), "%d %b %Y", timestruct);
   XtVaSetValues (wids->TF1,
      XmNvalue, date,
      NULL);
   XmProcessTraversal (wids->next, XmTRAVERSE_CURRENT);
}


/*
 * startCB Callback
 * Puts the date and time into the date and start time text fields
 * and forces focus to the Call text field.
 */
void startCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   Cdata *wids = (Cdata *)cdata;
   time_t current;
   struct tm *timestruct = NULL;
   char date[20];
   char stime[20];

   time(&current);
   timestruct = localtime (&current);

   strftime (date, sizeof(date), "%d %b %Y", timestruct);
   strftime (stime, sizeof(stime), "%H%M %Z", timestruct);

   XtVaSetValues (wids->TF1,
      XmNvalue, date,
      NULL);

   XtVaSetValues (wids->TF2,
      XmNvalue, stime,
      NULL);

   XmProcessTraversal (wids->next, XmTRAVERSE_CURRENT);
}


/*
 * callsignCB Callback
 * modify/verify callback changes all key strokes in CallTF to upper case
 * activate callback - Moves focus to next tab group, the Band Menu.
 */
void callsignCB (Widget w, XtPointer cdata, XtPointer cbstruct)
{
   int i;
   XmTextVerifyCallbackStruct *cbs = (XmTextVerifyCallbackStruct *) cbstruct;

   switch (cbs->reason)
      {
      case XmCR_MODIFYING_TEXT_VALUE:
         for (i = 0; i < cbs->text->length; i++)   /* all to upper case */
         {  
            cbs->text->ptr[i] = toupper (cbs->text->ptr[i]);
         }
         break;

      case XmCR_ACTIVATE:
             XmProcessTraversal (w, XmTRAVERSE_NEXT_TAB_GROUP);
             break;
      }
}


/*
 * endCB Callback
 * Puts the time into the End Time text field
 * and moves the focus to the Date Pushbutton.
 */
void endCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   Cdata *wids = (Cdata *) cdata;
   time_t current;
   struct tm *timestruct = NULL;
   char stime[20];

   time(&current);
   timestruct = localtime (&current);

   strftime (stime, sizeof(stime), "%H%M %Z", timestruct);
   XtVaSetValues (wids->TF1,
      XmNvalue, stime,
      NULL);
   XmProcessTraversal (wids->next, XmTRAVERSE_CURRENT);
}


/*
 * focusCB Callback
 * This callback is called for any lose or gain of focus in any
 * text field.  The I beam cursor will only be visible if the
 * textfield has focus.
 */
void focusCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   XmAnyCallbackStruct *cbstruct = (XmAnyCallbackStruct *) cbs;

   switch (cbstruct->reason)
   {
      case XmCR_FOCUS:
         XtVaSetValues (w,
            XmNcursorPositionVisible, TRUE,
            NULL);
         break;

      case XmCR_LOSING_FOCUS:
         XtVaSetValues (w,
            XmNcursorPositionVisible, FALSE,
            NULL);
         break;

      default:
         printf ("Oops\n");
         break;
   }
}


/*
 * fileCB Callback
 * All callbacks on the file pulldown come here.  The button number
 * is checked to see which option was selected.
 */
void fileCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   int btn = (int) cdata;
   char tail[MAXNAME];
   char *newname;
   char *lprstr;
   time_t current;
   struct tm *timestruct = NULL;
   Widget *col_2_wids;

   switch (btn)
      {
      case APPEND:
         XtVaGetValues (XtParent(w),
            XmNuserData, &col_2_wids,
            NULL);
         appendlog (logpath, col_2_wids);
         clearform (col_2_wids);
         break;

      case EDIT:
         popupEdit (logpath);
         break;

      case PRINT:
         if ((lprstr = malloc (sizeof (PRINT_CMD)
                             + sizeof(logpath)
                             + MAXNAME)) == NULL)
            {
            perror ("fileCB - print malloc failed"); 
            exit (1);
            }
         strcpy (lprstr, PRINT_CMD);
         strcat (lprstr, logpath);
         system (lprstr);
         free (lprstr);
         break;

      case NEW:
         time (&current);
         timestruct = localtime (&current);
         strftime (tail, MAXNAME, "/log.%Y.%j.%H%M%S", timestruct);
	 
         if ((newname = malloc (strlen (dirpath) + MAXNAME)) == NULL)
            {
            perror ("newname malloc failed:");
            exit (1);
            }
	 strcpy (newname, dirpath);
         strcat (newname, tail);
         
         if (rename (logpath, newname) == 0) 
            creat (logpath, 0644);
         else
            {
            perror ("Rename failed");
            exit (1);
            }
         free (newname);
         break;

      case QRT:
         exit (0);
      }        
}


/*
 * appendlog Function
 * Collects the data from the righthand column and writes it
 * to the end of the log file.  Two lines are written.  The
 * first line has all the data except for Notes, which are on
 * the second line.
 */

#define MAXBOX 20
#define MAXNOTE 80 

void appendlog (char logpath[], Widget *col_2_wids)
{
   int  i;
   FILE *fp;
   Widget btnwid;
   XmString label_xs;
   char *data;
   char abox[9][MAXBOX+1];
   char anote[MAXNOTE+1];

   for (i=0; i<9; i++)
      {
      if (i<3 || i>5)
         {
         XtVaGetValues (col_2_wids[i],      /* get text from a textfield */
            XmNvalue, &data,
            NULL);
         strncpy (abox[i], data, MAXBOX);
         }
      else                                  /* or get XmString from a menu */
         {
         XtVaGetValues (col_2_wids[i],      /* get the menu button wid, then */
            XmNmenuHistory, &btnwid,
            NULL);
         XtVaGetValues (btnwid,             /* get label for selected button */
            XmNlabelString, &label_xs,
            NULL);
         XmStringGetLtoR (label_xs, XmFONTLIST_DEFAULT_TAG, &data);
         strncpy (abox[i], data, MAXBOX);
         }
      }
   XtVaGetValues (col_2_wids[i],            /* get the Note field */
      XmNvalue, &data,
      NULL);
   strncpy (anote, data, MAXNOTE);

   if ((fp = fopen (logpath, "a")) == NULL) /* open logfile */
      {
      perror ("appendlog - open failed");
      exit (1);
      }
   fprintf (fp, "%-11s %-10s %-10s %-6s %-6s %-6s %-6s %-6s %-10s\n%-80s\n\n",
      abox[0], abox[1], abox[2], abox[3], abox[4],
      abox[5], abox[6], abox[7], abox[8], anote);
   fclose (fp);                             /* and close logfile */
}


/*
 * clearform Function
 * Clears all text field widgets
 */
void clearform (Widget *col_2_wids)
{
   int i;

   for (i=0; i<10; i++)
      {
      if (i<3 || i >5)
         XtVaSetValues (col_2_wids[i],
            XmNvalue, "",
            NULL);
      }
}


/*
 * helpCB Callback
 * All callbacks on the help pulldown come here.  The button number
 * is checked to see which option was selected.
 */
void helpCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   int btn = (int) cdata;
   switch (btn)
   {
      case ABOUT:
         aboutDiag ();
         break;
         
      case HELP:
         popupHelp (helppath);
         break;
   }
}


/*
 * CRkey Function
 * This action forces focus to the next widget when the Enter Key
 * is pressed in any of the Option Menus 
 */

void CRkey (Widget w, XEvent *event, String args[], Cardinal *nargs)
{
   XmProcessTraversal (w, XmTRAVERSE_NEXT_TAB_GROUP);
}
