/*
 * GUI.h Header File
 */

/* twpsk:  A gui application for PSK
 * Copyright (C) 1999 Ted Williams WA0EIR (ted_williams@HP.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 2.0 - Aug 2001
 */

/*
 * Include Files
 */
#ifndef GUI_INCLUDED
#define GUI_INCLUDED
#include <stdio.h>
#include <math.h>
#include <unistd.h>
#include <sys/stat.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#include <X11/cursorfont.h>
#include <Xm/Form.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/Separator.h>
#include <Xm/PanedW.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/Scale.h>
#include <Xm/DrawingA.h>
#include <Xm/ScrolledW.h>
#include <Xm/Text.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>
#include <Xm/ArrowB.h>
#include <Xm/DialogS.h>
#include <Xm/MwmUtil.h>
/* #include <X11/StringDefs.h> */
/* #include <X11/xpm.h> */

#define SAMPLE_RATE  8000

#define DISPLAY_WIDTH  128
#define DISPLAY_HEIGHT  32

#define RED 0
#define YELLOW 1
#define GREEN 2
#define PTT_ON  TIOCMBIS
#define PTT_OFF TIOCMBIC
#define HELPFILE "twpskHelp"
/*
 * Application Defined Resources
 */
#define XmNtwpskDir        "twpskDir"
#define XmCTwpskDir        "TwpskDir"

#define XmNbuttonNames     "buttonNames"
#define XmCButtonNames     "ButtonNames"

#define XmNrxFreq          "rxFreq"
#define XmCRxFreq          "RxFreq"

#define XmNafc             "afc"
#define XmCAfc             "Afc"

#define XmNtxFreq          "txFreq"
#define XmCTxFreq          "TxFreq"

#define XmNnet             "net"
#define XmCNet             "Net"

#define XmNnoMixer         "noMixer"
#define XmCNoMixer         "NoMixer"

#define XmNmainVol         "mainVol"
#define XmCMainVol         "MainVol"

#define XmNoutVol          "outVol"
#define XmCOutVol          "OutVol"

#define XmNinVol           "inVol"
#define XmCInVol           "InVol"

#define XmNcall            "call"
#define XmCCall            "Call"

#define XmNzero            "zero"
#define XmCZero            "Zero"

#define XmNptt             "ptt"
#define XmCPtt             "Ptt"

#define XmNserDev          "serDev"
#define XmCSerDev          "SerDev"

#define XmNcallBox         "callBox"
#define XmCCallBox         "CallBox"

typedef struct 
{
   char *twpskDir;
   char *buttonNames;
   float rxFreq;
   float txFreq;
   int afc;
   int net;
   int noMixer;
   int mainVol;
   int outVol;
   int inVol;
   char *call;
   int zero;
   int ptt;
   char *serDev;
   int callBox;
} AppRes;

/*
 * Function Declarations
 */

void iniProc (char mode);
void controlsBtnCB (Widget w, XtPointer cdata, XtPointer cbs);
void popupDiagCB (Widget w, XtPointer cdata, XtPointer cbs);
void closeDiagCB (Widget w, XtPointer cdata, XtPointer cbs);
void wideBtnCB (Widget w, XtPointer cdata, XtPointer cbs);
void mediunBtnCB (Widget w, XtPointer cdata, XtPointer cbs);
void narrowBtnCB (Widget w, XtPointer cdata, XtPointer cbs);
Boolean workProc(XtPointer cdata);
void appendRXtext (Widget w, char ch, int zero, XmHighlightMode mode);
void appendTXtext (char ch, int zero);
void rxScrollBarCB (Widget w, XtPointer cdata, XtPointer cbs);
void changeDisplayCB (Widget w, XtPointer cdata, XtPointer cbs);
void txTextCB (Widget w, XtPointer cdata, XtPointer cbs);
void txCB (Widget w, XtPointer cdata, XtPointer cbs);
void rxCB (Widget w, XtPointer cdata, XtPointer cbs);
void changeBG (void);
void tuneCB (Widget w, XtPointer cdata, XtPointer cbs);
void arrowCB (Widget w, XtPointer cdata, XtPointer cbs);
void freqTextCB (Widget w, XtPointer cdata, XtPointer cbs);
void afcCB (Widget w, XtPointer cdata, XtPointer cbs);
void netCB (Widget w, XtPointer cdata, XtPointer cbs);
void scopeCB (Widget w, XtPointer cdata, XtPointer cbs);
void wfCB (Widget w, XtPointer cdata, XtPointer cbs);
void openBtnCB (Widget w, XtPointer cdata, XtPointer cbs);
void audioCB (Widget w, XtPointer cdata, XtPointer cbs);
void setLevel (int device, int level);
void qpskCB (Widget w, XtPointer cdata, XtPointer cbs);
void lsbCB (Widget w, XtPointer cdata, XtPointer cbs);
void dcdCB (Widget w, XtPointer cdata, XtPointer cbs);
void bwCB (Widget w, XtPointer cdata, XtPointer cbs);
void brightCB (Widget w, XtPointer cdata, XtPointer cbs);
void fftScaleCB (Widget w, XtPointer cdata, XtPointer cbs);
void fileCB (Widget w, XtPointer cdata, XtPointer cbs);
void quitCB (Widget w, XtPointer cdata, XtPointer cbs);
void aboutCB (Widget w, XtPointer cdata, XtPointer cbs);
void helpCB (Widget w, XtPointer cdata, XtPointer cbs);
void promptDiag (char *word);
Boolean procFileText (XtPointer text); 
void popupHandler (Widget w, XtPointer cdata, XEvent *event, Boolean *cont);
void clrTextCB (Widget w, XtPointer cdata, XtPointer cbs);
char *getFile (char*filename);
void rxFreqFocusCB (Widget w, XtPointer cdata, XtPointer cbs);
int open2Rx (int x);
void seekCB (Widget w, XtPointer cdata, XtPointer cbs);
void haltCB (Widget w, XtPointer cdata, XtPointer cbs);
void bordersCB (Widget w, XtPointer cdata, XtPointer cbs);
void sendOver (Widget w, XEvent *e, String args[], Cardinal *argc);
void sendHisCall (Widget w, XEvent *e, String args[], Cardinal *argc);
void sendMacro (Widget w, XEvent *e, String args[], Cardinal *argc);
char *getHisCall (void);
void procMacroText (char *ch);
void seekTimeOut (XtPointer cdata, XtIntervalId id);
void callbox (Widget shell);
//TJW
//void gotSig (int stat);

#endif
