//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef TYPECONVERT_HH_
#define TYPECONVERT_HH_
#include "SourceBase.hh"

class VHDLType;
class VHDLkernelBase;

// This class is used to hold some temporary information and some permanent
// information which are needed during the TypeConversion. The Signal it points
// to is the signal which has the resolution tree for signal of a formal or
// actual on which type conversion is done ( whether up type or down type ).
// The Signal Netinfo is of the destination type where the type converted value
// should go. The Variable is used as a storage location where the type
// converted value is stored and SourceTypeConvert node reads it from that
// storage location.
class TypeConvert {
public:
  TypeConvert();
  ~TypeConvert();
private:
  VHDLType* upperSignalnetInfo;
  VHDLType* upperDriver;
  VHDLType* lowerSignal;
  TypeConversionFnId_t conversionFunctionId;
  bool sourceBaseDeleteFlag;
public:
  void setSignal(VHDLType* tmpSignal) {
    lowerSignal = tmpSignal;
  }
  void setSignalNetinfo(VHDLType* tmpSignalNetinfo) {
    upperSignalnetInfo = tmpSignalNetinfo;
  }
  void setVariable(VHDLType* tmpVariable) {
    upperDriver = tmpVariable;
  }
  void setConversionFunctionId(TypeConversionFnId_t id) {
    conversionFunctionId = id;
  }
  VHDLType* resolve(VHDLKernelBase*);
  void set_sourcebase_delete_flag(bool flag){
    sourceBaseDeleteFlag = flag;
  }
};
#endif
