#ifndef IMPSIGNAL_HH
#define IMPSIGNAL_HH

/** Copyright (c) 1995 Ohio Board of Regents and the University of
    Cincinnati.  All Rights Reserved.

    You may modify, distribute, and use the software contained in this
    package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
    version 2, June 1991. A copy of this license agreement can be found
    in the file "LGPL", distributed with this archive.

    $Id: ImplicitSignal.hh,v 1.1 2003/12/04 19:13:18 dmartin Exp $ */

#include "tyvis/SignalBase.hh"
#include "tyvis/UniversalBoolean.hh"

class SourceBase;

template <class Type> 
class ImplicitSignal : public SignalBase {
public:
  ImplicitSignal(void);
  ImplicitSignal(const VHDLData&);
  ImplicitSignal(const char*);
  ImplicitSignal(const int);

  void print(ostream&) const;

  virtual ObjectType getKind() const {return IMPLICIT_SIGNAL;};

  void updateDriver( const int, 
		     int processId,
		     const VHDLData *, 
		     const ArrayInfo * = NULL,
		     const ArrayInfo * = NULL );
  
  VHDLType* readDriver(VHDLKernel *);
  void updateDrvVal(const VHDLData*, const ArrayInfo* = NULL, 
		    const ArrayInfo* = NULL);
  VHDLData* readDrvVal();
  void updateEffVal(const VHDLData*, const ArrayInfo* = NULL,
		    const ArrayInfo* = NULL);
  void updateEffVal(const VHDLData&, const ArrayInfo* = NULL,
		    const ArrayInfo* = NULL);
  VHDLData* readEffVal();
  VHDLVTime& readTimeVal();
  VHDLVTime& updateTimeVal(const VHDLVTime& v = ZERO);

  ObjectBase& operator=(const ObjectBase&);
  ObjectBase& operator=(const VHDLData&);
  const VHDLData& readVal() const {
    return effVal;
  }
  void updateVal(const VHDLData& val) {
    updateEffVal((const VHDLData *) &val);
  }

  /**  time value for Stable, Quiet, Delayed */
  VHDLVTime timeval;       

  /** Source for this signal */
  SourceBase *source;

  /** driving value of the signal */
  Type drvVal;
  
  /** effective value of the signal */
  Type effVal;

  UniversalBoolean (*guardExpr)(void);

  ObjectBase* clone() const {
    ImplicitSignal<Type> *retval = new ImplicitSignal<Type>;
    *retval = *this;
    return retval;
  }

  void setSource(SourceBase *src) {
    source = src;
  }
};

#include "tyvis/ImplicitSignal.cc"
#endif





