/* ==================================================== ======== ======= *
 *
 *  ucolor.hh
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _ucolor_h
#define	_ucolor_h
//pragma ident	"@(#)ucolor.hh	ubit:b1.11.0"
#include <uprop.hh>

//shortcuts (see notes below):

class UColor& ucolor(const UColor&);
class UBgcolor& ubgcolor(const UColor&);

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UColor : public UProp {
  friend class UNatDisp;
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  static UColor none, inherit, white, black, grey, lightgrey, darkgrey, 
    navy, blue, red, green, yellow, orange, wheat, teal, disabled;

  // Creates a new UColor that is a copy of a pre-existing UColor
  UColor(const UColor& = UColor::black, u_modes = 0);

  // Creates a new UColor from an X color spec.
  // -- this color spec. can be a predefined color name (such as 
  //    "SteelBlue") or an RGB spec. (refer to X manual for details)
  UColor(const char *color_spec, u_modes = 0);
  ~UColor();

  void set(const UColor&, u_bool update = true);
  void set(const UColor*, u_bool update = true);
  void set(const UStr &color_spec, u_bool update = true);
  void set(const UStr *color_spec, u_bool update = true);
  void set(const char *color_spec, u_bool update = true);

  u_bool equals(const UColor&) const;
  u_bool equals(const UColor*) const;

  const char* getColspec() {return natspec;}

  // update parents' graphics
  virtual void update();

  // allocates the physical resources of the UColor. This operation is
  // automatically performed the first time the color is used. Thus, this 
  // function should only be called for allocating resources in advance.
  u_bool realize(class UDisp*);

  //==== Ubit Intrinsics ====
  virtual void putProp(class UContext*, class UCtrl*);
protected:
  UColor(int _ix, const char *color_name, u_modes);
  char *natspec;  //native ascii color spec.
  mutable int ix;
  void setIx(int i) const {ix = i;}
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UBgcolor : public UColor {
public:
  static const  UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  static UBgcolor none, inherit, white, black, grey, lightgrey, darkgrey, 
    navy, blue, red, green, yellow, orange, wheat, teal;

  UBgcolor(const UColor& = UBgcolor::white, u_modes = 0);

  // Creates a new UColor from an X color spec (see UColor)
  UBgcolor(const char *native_color_spec, u_modes = 0); 

  //==== Ubit Intrinsics ====
  virtual void putProp(class UContext*, class UCtrl*);
protected:
  UBgcolor(int _ix, const char *colname, u_modes m);
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */

