/* ==================================================== ======== ======= *
 *
 *  ucontext.hh
 *  Ubit Project  [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _ucontext_hh
#define	_ucontext_hh
//pragma ident	"@(#)ucontext.hh	ubit:b1.11.0"
#include <ufont.hh>

//package_private: ====[internal implementation]===========================
//NOTE: this header is reserved to Ubit intrinsics

class ULocalProps {
public:
  unsigned char orient, valign, halign;
  u_dim width, height;
  u_pos xpos, ypos;
  // for alpha blending
  float alpha;
  //short layer; not used

  // horizontal and vertical spacing between included items
  short vspacing, hspacing;

  // space beween content and border (if any)
  UMargin padding;
  class UBorder *border; 

  // if this group is not null the object it contains are added 
  // to children for normal display (this feature can for instance be used 
  // for adding list-item markers, checkbox markers, etc.
  class UGroup  *content;	//NB: = null in most cases

  // shape of the component
  class UShape  *shape;		//NB: = null in most cases

  // image or color background of the component
  const class UBackground *background;

  // used if the component is editable
  class UEdit  *edit;
};

/* ==================================================== ======== ======= */
// UContext =  a subcontext (not the first layer of the context cstack)
// and a base for UWinContext (the first layer of the cstack)
 
class UContext {
public:
  class UGroup *obj;
  class UView  *winview;
  ULocalProps  local;

  // the first view that is transparent in the tree (if any)
  class UView  *firstTranspView;

  // the first view that must be laid out
  class UView  *firstLayoutView;

  // define a common identified for a group of objects that can be browsed
  class UGroup *browseGroup;

  // current Cursor, Colors and Font descriptor
  const UCursor *cursor;
  const UColor  *color, *bgcolor; //, *symcolor;
  UFontDesc     fontdesc;

  // curent LOGICAL scale level (NB: the scale can be > 0 or < 0)
  signed short lscale;

  u_bool enabled, autoClose; //auto close menus
  // true if the object is Horizontally or Vertically Flexible
  u_bool boxIsHFlex, boxIsVFlex;

  // number of valid flags and ext(ensions) for this stack level
  // (only the first (flagCard, extCard) elements are valid for this level)
  // flag and ext vectors are shared by all stacked Contexts

  unsigned short flagCount, extCount;
  const UFlag ***pflags;
  UBrick ***pexts;

  // creates a subcontext (not the first layer of the context stack)
  UContext(UGroup*, UView* box_view, const UContext &parent_context);
protected:
  UContext(){}
};

/* ==================================================== ======== ======= */
// UWinContext = the first layer of the context cstack

class UWinContext : public UContext {
public:
  // references for pflags and pexts in subcontexts
  const UFlag **flags;
  UBrick **exts;

  // creates the first layer of the context stack
  // -- !Warning: 'win_view' must be a valid (NOT null) window view!
  UWinContext(UView* win_view);
  UWinContext(){}
  ~UWinContext();

  // this method recopies the internal flags and exts arrays
  void copy(UWinContext&);
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
