/* ==================================================== ======== ======= *
 *
 *  umenu.hh
 *  Ubit Project [Elc::2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _umenu_hh
#define	_umenu_hh
//pragma ident	"@(#)umenu.hh	ubit:b1.10.2"
#include <uwin.hh>

//shortcuts (see notes below):
//
class UMenubar& umenubar(UArgs = UArgs::none);
class UMenu&    umenu(UArgs = UArgs::none);
class UPopmenu& upopmenu(UArgs = UArgs::none);


/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UMenubar: public UBar {
public:
  static const UClass uclass;
  static UStyle *style;

  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
  virtual UGroup* getBrowseGroup() {return this;}

  UMenubar(UArgs = UArgs::none);

protected:
  void enterChildCB(UEvent*);
  void leaveChildCB(UEvent*);
  void relaxChildCB(UEvent*);
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// UMenu: pulldown or cascaded menu. 
// -- UMenu objects are AUTOMATICALLY OPENED by their parent(s)
// -- UMenu parents should generally be buttons (see example below)
// NOTE: if you need contextual menus, use UPopmenu
// Example:
//   umenubar( ubutton("Menu 1"
//                     + umenu( ubutton("aaa") + ubutton("bbb") )
//                     )
//            + ubutton("Menu 2"
//                     + umenu( ulabel("xxx") + ucheckbox("ccc") )
//                     )

class UMenu : public UWin {
  friend class UAppli;
public:
  static const UClass uclass;
  static UStyle *style;

  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
  virtual UGroup* getBrowseGroup();

  UMenu(UArgs = UArgs::none);
  virtual ~UMenu();

  // The open() method :
  // - grabs the mouse 
  // - closes menus that are already opened (except if they are cascaded 
  //   parents of this menu)
  // - enforces an autoclose behavior for this menu (it will be automatically
  //   closed when a button child is clicked)
  // NOTES:
  // - there is usually no need to call this method explicitely when using
  //   UMenu objects (but this is not the case for UPopmenu, see below)
  // - this method implicitely calls the (inherited) show() method
  virtual void open();

  // OBSOLETE: use:  move(0 then open()
  virtual void open(UEvent*, u_dim x_offset = 0, u_dim y_offset = 0);
  virtual void open(UView*, u_pos x_inview, u_pos y_inview);
  virtual void open(UView *view, UPlacement&);

  // The close() method:
  // - ungrabs the mouse 
  // - close 'this' menu and its cascaded children
  // NOTE: there is usually no need to call this function explicitely 
  //   as menus are automatically closed
  virtual void close();

  // Defines specific placement rules (see UPlacement)
  // -- null argument --> default placement rules
  // -- data given as an argument can be freed at any time by client
  // -- update() must be called to enforce new rules
  virtual void setPlacement(const class UPlacement*);
  virtual void setPlacement(const class UPlacement&);

  virtual u_bool realize();

protected:
  UGroup *menuBrowseGroup;
  class UCall *enter_opener, *arm_opener, *disarm_opener;
  class UPlacement *placement;

  virtual void addingTo(ULink *selflink, UGroup *parent);
  //NB: removingFrom() requires a destructor to be defined
  virtual void removingFrom(ULink *selflink, UGroup *parent);

  void enterChildCB(UEvent*);
  void leaveChildCB(UEvent*);
  void relaxChildCB(UEvent*);
  void enterOpenerCB(UEvent*);
  void armOpenerCB(UEvent*);
  void disarmOpenerCB(UEvent*);
  // internal function for opening menus
  virtual void openImpl(class UAppli*, UView *opener, 
			UGroup *menugroup, u_bool auto_place);
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// UPopmenu: contextual menu
// UPopmenu objects are NOT automatically OPENED by their parent(s)
// the application must:
// - move the menu to the appropriate location (use inherited move() methods)
// - open it by using the open() method (see class UMenu above)
// Example:
//   void foo(UEvent *e) {       // call-back function
//       popmenu->move(e);
//       popmenu->open();
//   }

class UPopmenu : public UMenu {
public:
  static const UClass uclass;
  static UStyle *style;

  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);

  UPopmenu(UArgs = UArgs::none);
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
