/* ==================================================== ======== ======= *
 *
 *  utimer.hh
 *  Ubit Project [Elc::2000]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:99] ======= *
 * ==================================================== ======== ======= */

#ifndef _utimer_hh
#define	_utimer_hh
//pragma ident	"@(#)utimer.hh	ubit2000.1"

#include <uctrl.hh>


class UTimer: public UBrick {
friend class UNatTimer;
protected:
  int step();
  int *lapse_durations;
  int lapse_count, current_lapse;
  int cycle_count, current_cycle;
  UChain lapses;
  u_bool running;
  class UAppli *appli;
  class UNatTimer *utc;		// pointer to Native Timer Impl

public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  // - Each cycle is made of a sequence of 'lapse_count' lapses
  // - The duration of each lapse is specified in the 'lapse_durations' array
  //   (lapse durations are in milli-seconds)
  // - The timer will execute 'cycle_count' cycles except if 'cycle_count' = -1
  //   in this case, the timer will continue unless its 'stop()' method is called
  
  // IMPORTANT NOTE: the timer must be added to the UAppli before it is used:
  // e.g.:
  //     UAppli *appli = new UAppli(...etc...);
  //     UTimer *timer = new UTimer(...etc...);
  //     appli->add(timer);

  UTimer(int* lapse_durations, int lapse_count, int cycle_count = -1);
  virtual ~UTimer() {clean();}

  // Create a Time Lapse Condition
  //##class UTimeLapse &when(int lapse_no);

  void start();
  void stop();
  void restart();

  u_bool isRunning() {return running;}
  int currentLapse() {return current_lapse;}
  int currentCycle() {return current_cycle;}

  //virtual void update() {}
  u_bool realize(class UAppli*);
};


/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */


class UTimeLapse: public UCond {
friend class UTimer;
protected:
  int lapse_no;
  class UTimer *timer;

public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  UTimeLapse(class UTimer*, int lapseNo);
  int getTimeLapseNo() {return lapse_no;}

  // for internal use only
  u_bool match(const UOn*);
};

#endif

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:99] ======= */


