/* ==================================================== ======== ======= *
 *
 *  uucursor.cc
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */


//#pragma ident	"@(#)uucursor.cc	ubit:b1.11.1"
#include <ubrick.hh>
#include <ubox.hh>
#include <ucolor.hh>
#include <uview.hh>
#include <uevent.hh>
#include <ucontext.hh>
#include <ugraph.hh>
#include <ucursor.hh>
#include <ucall.hh>
#include <uappli.hh>
#include <X11/cursorfont.h>


const UClass UCursor::uclass("UCursor");

UCursor UCursor::crosshair("crosshair", XC_crosshair, UMode::UCONST);
UCursor UCursor::xcross("xcross", XC_X_cursor, UMode::UCONST);
UCursor UCursor::arrow("arrow", XC_arrow, UMode::UCONST);
UCursor UCursor::plus("plus", XC_plus, UMode::UCONST);
UCursor UCursor::text("text", XC_xterm, UMode::UCONST);
UCursor UCursor::wait("wait", XC_watch, UMode::UCONST);
UCursor UCursor::hand("hand", XC_hand2, UMode::UCONST);
UCursor UCursor::question("question", XC_question_arrow, UMode::UCONST);
UCursor UCursor::kill("kill", XC_pirate, UMode::UCONST);
UCursor UCursor::sizing("sizing", XC_sizing, UMode::UCONST);

UCursor UCursor::pencil("pencil", XC_pencil, UMode::UCONST);
UCursor UCursor::spray("spray", XC_spraycan, UMode::UCONST);
UCursor UCursor::spider("spider", XC_spider, UMode::UCONST);
UCursor UCursor::finger("finger", XC_hand1, UMode::UCONST);
UCursor UCursor::umbrella("umbrella", XC_umbrella, UMode::UCONST);
UCursor UCursor::gumby("gumby", XC_gumby, UMode::UCONST);
UCursor UCursor::heart("heart", XC_heart, UMode::UCONST);


/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

UCursor::UCursor(const char *curname, int curshape, u_modes m): UProp(m){
  name = curname;
  shape = curshape;
}

//!! ATT aux delete: plusieurs objets peuvent pointer sur le meme NatCursor
//!! dans le UDisp
//
UCursor::UCursor(const UCursor &c, u_modes m) : UProp(m) {
  name = c.name;
  shape = c.shape;
}


void UCursor::set(const UCursor *new_value) {set(*new_value);}

void UCursor::set(const UCursor &new_value) {
  if (name == new_value.name && shape == new_value.shape) return;
  name  = new_value.name;
  shape = new_value.shape;
  changed(true);
}

u_bool UCursor::equals(const UCursor &c) const {
  return (shape == c.shape);
}

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

void UCursor::addingTo(ULink *selflink, UGroup *parent) {
  UProp::addingTo(selflink, parent);
  // Rendre parent sensitif aux events ad hoc
  parent->setCmodes(UMode::HAS_CURSOR, true);
}

void UCursor::removingFrom(ULink *selflink, UGroup *parent) {
  //int count = getChildClassCount<UGroup*, UCursor*>(parent);
  int count = parent->getTypedChildCount<UCursor>();
  if (count <= 1)   parent->setCmodes(UMode::HAS_CURSOR, false);
  UProp::removingFrom(selflink, parent);
}

/* ==================================================== [Elc:99] ======= */
/* ==================================================== ======== ======= */

void UCursor::update() {}

void UCursor::putProp(UContext *props, UCtrl *state) {
  //printf("putcurs: %d \n", this);
  props->cursor = this;
}

u_bool UCursor::realize(UDisp *d) {
  return d->realizeCursor(this);
}


/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
