
#ifndef __utree_hpp__
#define __utree_hpp__
#include <ubit/ubox.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class UTreebox : public UBox {
public:
	UTreebox(const UArgs& a = UArgs::none) : UBox(a) {}

	URadioSelect node_sel, content_sel;

	virtual void selectCB(class UNode*, bool state);
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class UNode : public UHbox {
public:
	uptr<UBox> state_btn, content;
	UVbox children;

	UNode(UTreebox&, const UArgs& = UArgs::none);

	virtual void addChild(UNode*);
	virtual void removeChild(UNode*);

};

#endif

/* ==================================================== [TheEnd] ======= */
/* ==================================================== ======== ======= */

