/* ==================================================== ======== ======= *
 *
 *  uuborder.cpp
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuborder.cpp	ubit:03.05.00"
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uctrl.hpp>
#include <uprop.hpp>
#include <ucolor.hpp>
#include <uborder.hpp>
#include <ugraph.hpp>
#include <uview.hpp>
#include <uviewImpl.hpp>
#include <ucontext.hpp>
#include <ubox.hpp>
#include <update.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UMargins::UMargins(short _top_bottom, short _left_right) {
  top  = bottom = _top_bottom;
  left = right = _left_right;
}

UMargins::UMargins(short _top, short _right, short _bottom, short _left) {
  top = _top; bottom = _bottom;
  left = _left; right = _right;
}

void UMargins::set(short _top_bottom, short _left_right) {
  top = bottom = _top_bottom;
  left = right = _left_right;
}

void UMargins::set(short _top, short _right, short _bottom, short _left) {
  top  = _top; bottom = _bottom;
  left = _left; right = _right;
}

void UMargins::incr(const UMargins &m) {
  top  += m.top; bottom += m.bottom;
  left += m.left; right += m.right;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UBorder UBorder::none(NONE,
                      UColor::inherit, UColor::inherit, 0, 0, UMode::UCONST);
UBorder UBorder::empty(NONE,
                       UColor::inherit, UColor::inherit, 1, 1, UMode::UCONST);
UBorder UBorder::flat(FLAT,
                      UColor::inherit, UColor::orange, 1, 1, UMode::UCONST);
UBorder UBorder::shadowOut(+SHADOW,  // OUTwards shadow
			   UColor::black, UColor::white, 1, 1, UMode::UCONST);
UBorder UBorder::shadowIn(-SHADOW,  // INwards shadow
			  UColor::black, UColor::white, 1, 1, UMode::UCONST);
UBorder UBorder::etchedOut(+ETCHED,
			   UColor::black, UColor::white, 2, 2, UMode::UCONST);
UBorder UBorder::etchedIn(-ETCHED, // inverted shadow
			  UColor::black, UColor::white, 2, 2, UMode::UCONST);

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
 
UBorder::UBorder(int d) {
  constructs(d, UColor::white, UColor::black);
  margins.set(1,1);
}

UBorder::UBorder(int d, UColor& _color, UColor& _bgcolor, 
		 int top_bottom_margin, int left_right_margin, u_modes m) :
  UProp(m) {
  constructs(d, _color, _bgcolor);
  margins.set(top_bottom_margin, left_right_margin);
}

UBorder::UBorder(const UBorder& b) {
  constructs(b.decoration, *b.pcolor, *b.pbgcolor);
  margins = b.margins;
}

UBorder::UBorder(bool _overlaid, const UArgs& a) {
  constructs(+SHADOW, UColor::white, UColor::black);
  margins.set(1,1);
  overlaid =  _overlaid;         // doit etre apres constructs() !
  psubgroup = new UGroup(a);        // doit etre apres constructs() !
  psubgroup->setCmodes(UMode::BORDER_LIST, true);      // !!
}

UBorder& UBorder::operator=(const UBorder& b) {
  constructs(b.decoration, *b.pcolor, *b.pbgcolor);
  margins = b.margins;
  update();
  return *this;
}

/* ==================================================== ========= ======= */

void UBorder::constructs(int d, UColor& _color, UColor& _bgcolor) {
  decoration = d;
  overlaid   = false;
  pcolor     = _color;
  pbgcolor   = _bgcolor;
  psubgroup     = null;
}

UBorder::~UBorder() {}

/* ==================================================== ========= ======= */ 

void UBorder::update() {
  parents.updateParents(UUpdate::all);
}

void UBorder::putProp(UContext *props, UCtrl *state) {
  // a defaut de mieux : ne pas ecraser une definition de border !!
  // s'il contient des elements (typiquement un scrollpane)
  if (!props->local.border || !props->local.border->psubgroup)
    props->local.border = this;
}

void UBorder::setDecoration(int decor)        {decoration = decor;}
int UBorder::getDecoration() const            {return decoration;}

const UMargins& UBorder::getMargins() const   {return margins;}
void UBorder::setMargins(const UMargins& _m)  {margins = _m;}

/* ==================================================== [Elc:002] ======= */
/* ==================================================== ========= ======= */

void UBorder::getSize(const UContext&, UMargins& _m) const {
  _m = margins;
}

void UBorder::paint(UWinGraph &g, const UContext& parp, 
		    const URegion &r) const {
  // new: fait avant:
  // vd.margin = margin;
  // if (!vd.can_paint) return;   // si rien a peindre on s'arrete la

  // !ATT: il peut y avoir des scrollbars meme si border == none
  if (decoration == NONE) return;

  int parx1 = r.x;
  int pary1 = r.y;
  int parx2 = r.x + r.width - 1;
  int pary2 = r.y + r.height -1;
 
  // invert is_active when the btn is pressed
  bool is_active;
  if (parp.obj->isSelected())
    is_active = (parp.obj->getState() != UOn::ARMED);
  else 
    is_active = (parp.obj->getState() == UOn::ARMED);

  const UColor *_color = 
    pcolor->equals(UColor::inherit) ? parp.color : pcolor;

  const UColor *_bgcolor = 
    pbgcolor->equals(UColor::inherit) ? parp.bgcolor : pbgcolor;

  const UColor *bg = null, *fg = null;
  int d;

  if (decoration > NONE) {  // OUT (normal case)
    d = decoration;
    if (is_active) {bg = _color; fg = _bgcolor;}
    else {bg = _bgcolor; fg = _color;}   // cas normal
  }
  else {                  // IN (inverted shadows)
    d = -decoration;
    if (is_active) {bg = _bgcolor; fg = _color;}
    else {bg = _color; fg = _bgcolor;}
  }

  switch (d) {
  case SHADOW:
    // out: fg = bottom+right and bg = top+left
    // in:  invert
    g.setColor(fg);
    g.drawLine(parx1+1,pary2, parx2,pary2); // bottom
    g.drawLine(parx2,pary1+1, parx2,pary2); // right
    g.setColor(bg);
    g.drawLine(parx1,pary1, parx2-1,pary1); // top
    g.drawLine(parx1,pary1, parx1,pary2-1); // left
    break;

  case ETCHED:
    g.setColor(fg);
    //g.drawRect(parx1+1, pary1+1, vd.view->getWidth()-2, vd.view->getHeight()-2);
    g.drawRect(parx1+1, pary1+1, r.width-2, r.height-2);

    g.setColor(bg);
    // g.drawRect(parx1, pary1, vd.view->getWidth()-2,  vd.view->getHeight()-2);
    g.drawRect(parx1, pary1, r.width-2,  r.height-2);
    break;

  case FLAT:
    g.setColor(fg);
    g.drawLine(parx1,pary2, parx2,pary2); // bottom
    g.drawLine(parx2,pary1, parx2,pary2); // right
    g.drawLine(parx1,pary1, parx2,pary1); // top
    g.drawLine(parx1,pary1, parx1,pary2); // left
    break;
  }
}

/* ==================================================== [The End] ======= */
/* ==================================================== [Elc:003] ======= */

