/* ==================================================== ======== ======= *
*
*  uumsproto.cc : UMS [Ubit Mouse Server] protocol
*  Ubit Project  [Elc][2003]
*  Author: Eric Lecolinet
*
*  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
*
*  (C) 1999-2003 Eric Lecolinet @ ENST Paris
*  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
*
* ***********************************************************************
* COPYRIGHT NOTICE :
* THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE
* IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
* YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU
* GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION;
* EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
* SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
* ***********************************************************************
*
* ==================================================== [Elc:03] ======= *
* ==================================================== ======== ======= */

//pragma ident	"@(#)uumsclient.cc	ubit:03.04.00"
#include <iostream>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <umsproto.hpp>
#include <uwin.hpp>
#include <unatwin.hpp>
#include <unatdisp.hpp>
#include <X11/Xatom.h>
using namespace std;

#include "config.h"
#ifdef HAVE_STDINT_H
#include <stdint.h>    // uint16_t etc.
#endif

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

const char *UMSprotocol::UBIT_SELECTION = "_UBIT_SELECTION";
const char *UMSprotocol::UBIT_MESSAGE   = "_UBIT_MESSAGE";
const char *UMSprotocol::UBIT_WINDOW    = "_UBIT_WINDOW";

void UMSprotocol::setUbitProtocols(UNatDisp* nd, UNatWin* nw) {
  // UbitEventFlow Protocol
  XChangeProperty(nd->getXDisplay(), nw->getXWindow(),
                  nd->atoms.UBIT_WINDOW, XA_STRING,
                  8/*format*/, PropModeReplace/*mode*/,
                  (unsigned char*)null, 0);

  // pour la reception des messages longs
  XChangeProperty(nd->getXDisplay(), nw->getXWindow(),
                  nd->atoms.UBIT_MESSAGE, XA_STRING,
                  8/*format*/, PropModeReplace/*mode*/,
                  (unsigned char*)null, 0);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UMSrequest::UMSrequest() {
  data[0] = 0;
  data[1] = 0;
  count = 2;
}

UMSrequest::UMSrequest(u_char reqtype) {
  data[0] = 0;        // octal size
  data[1] = reqtype;  // request type
  count = 2;
}

/* ==================================================== ======== ======= */

void UMSrequest::writeChar(char x) {
  data[count++] = (unsigned char)x;
}

char UMSrequest::readChar() {
  return char(data[count++]);
}

void UMSrequest::writeShort(short x) {
  uint16_t net_x = htons((uint16_t) x);
  memcpy(&data[count], &net_x, 2);
  count += 2;
}

short UMSrequest::readShort() {
  uint16_t netl;
  memcpy(&netl, &data[count], 2);
  count += 2;
  return short(htons(netl));
}

void UMSrequest::writeLong(long x) {
  uint32_t net_x = htonl((uint32_t) x);
  memcpy(&data[count], &net_x, 4);
  count += 4;
}

long UMSrequest::readLong() {
  uint32_t netl;
  memcpy(&netl, &data[count], 4);
  count += 4;
  return long(htonl(netl));
}

/* ==================================================== ======== ======= */

bool UMSrequest::writeString(const char* s) {
  bool enough_space = true;
  u_int ll = strlen(s) + 1;
  if (count + ll > sizeof(data)) {
    ll = sizeof(data) - count -1;
    data[sizeof(data)-1] = 0;    // null terminated
    enough_space = false;
  }
  memcpy(&data[count], s, ll);
  count += ll;

  return enough_space;
}

char* UMSrequest::getString() {
  return (char*)&data[count];
}

/* ==================================================== ======== ======= */

void UMSrequest::writeEvent(unsigned char event_type,
                            unsigned char event_flow,
                            long x, long y, unsigned long detail) {
  data[count] = event_type;
  count += 1;

  data[count] = event_flow;
  count += 1;

  uint32_t net_x = htonl((uint32_t) x);
  memcpy(&data[count], &net_x, 4);
  count += 4;

  uint32_t net_y = htonl((uint32_t) y);
  memcpy(&data[count], &net_y, 4);
  count += 4;

  uint32_t net_d = htonl((uint32_t)detail);
  memcpy(&data[count], &net_d, 4);
  count += 4;
};

/* ==================================================== ======== ======= */

void UMSrequest::readEvent(unsigned char& event_type,
                           unsigned char& event_flow,
                           long& x, long& y, unsigned long& detail) {
  event_type = data[count];
  count += 1;

  event_flow = data[count];
  count += 1;

  uint32_t netl;

  memcpy(&netl, &data[count], 4);
  x = long(htonl(netl));
  count += 4;

  memcpy(&netl, &data[count], 4);
  y = long(htonl(netl));
  count += 4;

  memcpy(&netl, &data[count], 4);
  detail = (unsigned long) htonl(netl);
  count += 4;
};

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

