/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qapplication.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcolordialog.h>
#include <qfontdialog.h>
//-----------------------------------------------------------------------------
#include "scriptwindow.h"
#include "propdialog.h"
//-----------------------------------------------------------------------------
extern QColor mglColorScheme[9];
extern QString defFontFamily;
extern int defFontSize;
extern QString pathHelp;
extern bool mglAutoExecute;
extern bool mglAutoSave;
extern bool editPosBottom;
extern bool loadInNewWnd;
QString pathFont;
//-----------------------------------------------------------------------------
PropDialog::PropDialog(QWidget *parent) : QDialog(parent)
{
	setWindowTitle(tr("UDAV - Properties"));
	QHBoxLayout *h;
	QVBoxLayout *v;
	QLabel *l;
	QPushButton *b;

	v = new QVBoxLayout(this);
	h = new QHBoxLayout();		v->addLayout(h);
	lbl = new QLabel(tr("Select font"), this);	h->addWidget(lbl);
	lbl->setFont(QFont(defFontFamily, defFontSize));
	h->addStretch(1);	defFont = QFont(defFontFamily, defFontSize);
	b = new QPushButton(tr("Change font"), this);	h->addWidget(b);
	connect(b, SIGNAL(clicked()),this, SLOT(setF()));

	cc[0]=mglColorScheme[0];	cc[1]=mglColorScheme[1];
	cc[2]=mglColorScheme[2];	cc[3]=mglColorScheme[3];
	cc[4]=mglColorScheme[4];	cc[5]=mglColorScheme[5];
	cc[6]=mglColorScheme[6];	cc[7]=mglColorScheme[7];
	cc[8]=mglColorScheme[8];//	cc[5]=mglColorScheme[5];
	QPixmap pic(16,16);
	l = new QLabel(tr("Setup colors for:"), this);	v->addWidget(l, Qt::AlignHCenter);
	QGridLayout *g = new QGridLayout();		v->addLayout(g);
	pic.fill(cc[0]);	cb[0] = new QPushButton(pic, tr("Comments"), this);
	connect(cb[0], SIGNAL(clicked()),this, SLOT(setC0()));
	g->addWidget(cb[0], 0, 0);
	pic.fill(cc[1]);	cb[1] = new QPushButton(pic, tr("Strings"), this);
	connect(cb[1], SIGNAL(clicked()),this, SLOT(setC1()));
	g->addWidget(cb[1], 0, 1);
	pic.fill(cc[2]);	cb[2] = new QPushButton(pic, tr("Keywords"), this);
	connect(cb[2], SIGNAL(clicked()),this, SLOT(setC2()));
	g->addWidget(cb[2], 0, 2);
	pic.fill(cc[3]);	cb[3] = new QPushButton(pic, tr("Options"), this);
	connect(cb[3], SIGNAL(clicked()),this, SLOT(setC3()));
	g->addWidget(cb[3], 1, 0);
	pic.fill(cc[4]);	cb[4] = new QPushButton(pic, tr("Suffixes"), this);
	connect(cb[4], SIGNAL(clicked()),this, SLOT(setC4()));
	g->addWidget(cb[4], 1, 1);
	pic.fill(cc[5]);	cb[5] = new QPushButton(pic, tr("Numbers"), this);
	connect(cb[5], SIGNAL(clicked()),this, SLOT(setC5()));
	g->addWidget(cb[5], 1, 2);
	pic.fill(cc[6]);	cb[6] = new QPushButton(pic, tr("AutoKey"), this);
	connect(cb[6], SIGNAL(clicked()),this, SLOT(setC6()));
	g->addWidget(cb[6], 2, 0);
	pic.fill(cc[7]);	cb[7] = new QPushButton(pic, tr("FlowKey"), this);
	connect(cb[7], SIGNAL(clicked()),this, SLOT(setC7()));
	g->addWidget(cb[7], 2, 1);

	l = new QLabel(tr("Path for help files"), this);	v->addWidget(l);
	hlp = new QLineEdit(pathHelp, this);	v->addWidget(hlp);
	l = new QLabel(tr("Path for user MathGL font files"), this);	v->addWidget(l);
	fnt = new QLineEdit(pathFont, this);	v->addWidget(fnt);
	run = new QCheckBox(tr("Automatically execute script after loading"), this);
	run->setChecked(mglAutoExecute);	v->addWidget(run);
	edt = new QCheckBox(tr("Place editor at top"), this);
	edt->setChecked(editPosBottom);	v->addWidget(edt);
	load = new QCheckBox(tr("Load script to new window"), this);
	load->setChecked(loadInNewWnd);	v->addWidget(load);
	save = new QCheckBox(tr("Automatical save before redrawing (F5)"), this);
	save->setChecked(mglAutoSave);	v->addWidget(save);

	h = new QHBoxLayout();		v->addLayout(h);
	h->addStretch(1);
	b = new QPushButton(tr("Cancel"), this);	h->addWidget(b);
	connect(b, SIGNAL(clicked()),this, SLOT(reject()));
	b = new QPushButton(tr("OK"), this);		h->addWidget(b);
	connect(b, SIGNAL(clicked()),this, SLOT(applyChanges()));
	b->setDefault(true);
}
//-----------------------------------------------------------------------------
PropDialog::~PropDialog()	{}
//-----------------------------------------------------------------------------
void PropDialog::setC0()	{	setC(0);	}
//-----------------------------------------------------------------------------
void PropDialog::setC1()	{	setC(1);	}
//-----------------------------------------------------------------------------
void PropDialog::setC2()	{	setC(2);	}
//-----------------------------------------------------------------------------
void PropDialog::setC3()	{	setC(3);	}
//-----------------------------------------------------------------------------
void PropDialog::setC4()	{	setC(4);	}
//-----------------------------------------------------------------------------
void PropDialog::setC5()	{	setC(5);	}
//-----------------------------------------------------------------------------
void PropDialog::setC6()	{	setC(6);	}
//-----------------------------------------------------------------------------
void PropDialog::setC7()	{	setC(7);	}
//-----------------------------------------------------------------------------
void PropDialog::setC8()	{	setC(8);	}
//-----------------------------------------------------------------------------
void PropDialog::setC(int k)
{
	if(k<0 || k>8)	return;
	QColor c = QColorDialog::getColor(cc[k], this);
	if(c.isValid())
	{
		QPixmap p(16,16);	p.fill(c);
		cb[k]->setIcon(p);	cc[k] = c;
	}
}
//-----------------------------------------------------------------------------
void PropDialog::setF()
{
	bool ok;
	QFont f = QFontDialog::getFont(&ok, defFont, this);
	if(ok)	{	defFont = f;	lbl->setFont(f);	}
}
//-----------------------------------------------------------------------------
void PropDialog::applyChanges()
{
	// defFont editPosBottom pathFont
	mglColorScheme[0]=cc[0];	mglColorScheme[1]=cc[1];
	mglColorScheme[2]=cc[2];	mglColorScheme[3]=cc[3];
	mglColorScheme[4]=cc[4];	mglColorScheme[5]=cc[5];
	mglAutoExecute = run->isChecked();
	editPosBottom = edt->isChecked();
	pathHelp = hlp->text();		pathFont = fnt->text();
	defFontFamily = defFont.family();
	defFontSize = defFont.pointSize();
	loadInNewWnd = load->isChecked();
	mglAutoSave = save->isChecked();

	// apply changes for all windows
	bool ok=true;
	foreach(QWidget *w, QApplication::topLevelWidgets())
	{
		if(w->inherits("ScriptWindow"))
		{
			ScriptWindow *s = (ScriptWindow *)w;
			if(ok)	{	s->writeSettings();	ok = false;	}
			s->setEditorFont();
			s->setMGLFont(pathFont);
			s->setEditPos(editPosBottom);
			s->update();
		}
	}
	accept();
}
//-----------------------------------------------------------------------------
