#include "cs.h"
/* depth-first-search of the graph of a matrix, starting at node j */
CS_INT cs_dfs (CS_INT j, cs *L, CS_INT top, CS_INT *xi, CS_INT *pstack, const CS_INT *Pinv)
{
    CS_INT i, p, p2, done, jnew, head = 0, *Lp, *Li ;
    if (!L || !xi || !pstack) return (-1) ;
    Lp = L->p ; Li = L->i ;
    xi [0] = j ;		/* initialize the recursion stack */
    while (head >= 0)
    {
	j = xi [head] ;		/* get j from the top of the recursion stack */
	jnew = Pinv ? (Pinv [j]) : j ;
	if (!CS_MARKED(Lp,j))
	{
	    CS_MARK (Lp,j) ;	    /* mark node j as visited */
	    pstack [head] = (jnew < 0) ? 0 : CS_UNFLIP (Lp [jnew]) ;
	}
	done = 1 ;		    /* node j done if no unvisited neighbors */
	p2 = (jnew < 0) ? 0 : CS_UNFLIP (Lp [jnew+1]) ;
	for (p = pstack [head] ; p < p2 ; p++)  /* examine all neighbors of j */
	{
	    i = Li [p] ;	    /* consider neighbor node i */
	    if (CS_MARKED (Lp,i)) continue ;	/* skip visited node i */
	    pstack [head] = p ;	    /* pause depth-first search of node j */
	    xi [++head] = i ;	    /* start dfs at node i */
	    done = 0 ;		    /* node j is not done */
	    break ;		    /* break, to start dfs (i) */
	}
	if (done)		/* depth-first search at node j is done */
	{
	    head-- ;		/* remove j from the recursion stack */
	    xi [--top] = j ;	/* and place in the output stack */
	}
    }
    return (top) ;
}
