#include "cs_malloc_test.h"
int malloc_count = INT_MAX ;

/* wrapper for malloc */
void *cs_malloc (CS_INT n, size_t size)
{
    if (--malloc_count < 0) return (NULL) ; /* pretend to fail */
    return (CS_OVERFLOW (n,size) ? NULL : malloc (CS_MAX (n,1) * size)) ;
}

/* wrapper for calloc */
void *cs_calloc (CS_INT n, size_t size)
{
    if (--malloc_count < 0) return (NULL) ; /* pretend to fail */
    return (CS_OVERFLOW (n,size) ? NULL : calloc (CS_MAX (n,1), size)) ;
}

/* wrapper for free */
void *cs_free (void *p)
{
    if (p) free (p) ;	    /* free p if it is not already NULL */
    return (NULL) ;	    /* return NULL to simplify the use of cs_free */
}

/* wrapper for realloc */
void *cs_realloc (void *p, CS_INT n, size_t size, CS_INT *ok)
{
    void *p2 ;
    *ok = 0 ;
    if (--malloc_count < 0) return (p) ;    /* pretend to fail */
    *ok = !CS_OVERFLOW (n,size) ;	    /* guard against CS_INT overflow */
    if (!(*ok)) return (p) ;		    /* p unchanged if n too large */
    p2 = realloc (p, CS_MAX (n,1) * size) ; /* realloc the block */
    *ok = (p2 != NULL) ;
    return ((*ok) ? p2 : p) ;		    /* return original p if failure */
}
