/* Drawing.

   Copyright (C) 2000 Daiki Ueno <ueno@unixuser.org>

   Author: Daiki Ueno <ueno@unixuser.org>
   Created: 2000-05-16

   This file is part of UltraPoint.

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)  
   any later version.                                                   

   This program is distributed in the hope that it will be useful,      
   but WITHOUT ANY WARRANTY; without even the implied warranty of       
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the        
   GNU General Public License for more details.                         

   You should have received a copy of the GNU General Public License    
   along with GNU Emacs; see the file COPYING.  If not, write to the    
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
   Boston, MA 02111-1307, USA.                                          

*/

#ifndef __UPT_CANVAS_H_
#define __UPT_CANVAS_H_

typedef struct _UptCanvas UptCanvas;
typedef struct _UptImage UptImage;

#include "page.h"
#include "color.h"

#ifdef HAVE_LIBMAGICK
#undef RGBColorDatabase
#include <magick/magick.h>
#endif

enum {
  ALIGN_DEFAULT = 0,
  ALIGN_NONE = 0,
  ALIGN_LEFT = 1,
  ALIGN_CENTER = 2,
  ALIGN_RIGHT = 3,
  ALIGN_TOP = 4,
  ALIGN_MIDDLE = 5,
  ALIGN_BOTTOM = 6
};

struct _UptCanvas {
  glong virt_x;
  glong virt_y;

  glong off_x;
  glong off_y;

  ggi_pixel fg;
  ggi_pixel bg;

  ggi_visual_t visual;
  ggi_mode mode;
  ggi_pixel *aa_map;

  UptImage *bg_image;

  gint align;
  gint font_size_base;
  gint psize;

  gboolean has_background_image;
  gboolean use_multiple_frames;
  gboolean disable_antialias;

  gint ref_count;
  GFreeFunc free;
};

struct _UptImage {
  gint width, height;
  guint8 *pbuf;

  gint ref_count;
  GFreeFunc free;
};

UptCanvas *upt_canvas_new (ggi_visual_t visual);
void upt_canvas_move (UptCanvas *canvas, gint off_x, gint off_y);
void upt_canvas_set_position (UptCanvas *canvas, gint off_x, gint off_y);
void upt_canvas_draw_page (UptCanvas *canvas, UptPage *page);
void upt_canvas_draw_hline (UptCanvas *canvas, gint width, gint thickness);
void upt_canvas_set_align (UptCanvas *canvas, gint align);
void upt_canvas_set_foreground (UptCanvas *canvas, ggi_pixel fg);
void upt_canvas_set_foreground_rgb (UptCanvas *canvas,
				    guint16 r, guint16 g, guint16 b);
void upt_canvas_set_undo_boundary (UptCanvas *canvas);
void upt_canvas_undo_horizontal (UptCanvas *canvas);
void upt_canvas_undo_vertical (UptCanvas *canvas);
void upt_canvas_clear (UptCanvas *canvas);
void upt_canvas_flush (UptCanvas *canvas);
void upt_canvas_draw_circle (UptCanvas *canvas, gint radius);
guint16 upt_canvas_get_font_size (UptCanvas *canvas, gint size_index);

UptImage *upt_image_new (void);
UptImage *upt_canvas_load_image (UptCanvas *canvas, const gchar *filename,
				 gint width, gint height,
				 gdouble mag_x, gdouble mag_y);
void upt_canvas_load_bg_image (UptCanvas *canvas, const gchar *filename);
gboolean upt_canvas_draw_image (UptCanvas *canvas, const gchar *filename,
				gint width, gint height,
				gdouble mag_x, gdouble mag_y);
gint upt_canvas_get_aa_pixel (UptCanvas *canvas, glong x, glong y,
			      gint n_bits, ggi_pixel *pixel);

#endif
