# Copyright (C) 2007  Lars Wirzenius <liw@iki.fi>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


"""Unit tests for Unperish plugin buildarea.py."""


import os
import shutil
import tempfile
import unittest

import unperishlib


class CreateBuildAreaTests(unittest.TestCase):

    def testAddsBuildAreaOption(self):
        app = unperishlib.Application(plugins=["plugins"])
        options, _ = app.parse_args(["--build-area=pink"])
        self.failUnlessEqual(options.build_area, "pink")

    def testCreatesBuildAreaDirectory(self):
        dirname = tempfile.mkdtemp()
        build_area = os.path.join(dirname, "build-area")
        app = unperishlib.Application(plugins=["plugins"])
        app.run(["--build-area", build_area, "create-build-area"])
        self.failUnless(os.path.isdir(build_area))
        shutil.rmtree(dirname)


class CleanBuildAreaTests(unittest.TestCase):

    def setUp(self):
        self.dirname = tempfile.mkdtemp()
        self.build_area = os.path.join(self.dirname, "build-area")
        self.app = unperishlib.Application(plugins=["plugins"])
        self.app.run(["--build-area", self.build_area, "create-build-area"])
        file(os.path.join(self.build_area, "pink"), "w").close()
        os.mkdir(os.path.join(self.build_area, "pretty"))
        
    def tearDown(self):
        shutil.rmtree(self.dirname)

    def testDeletesBuildAreaContentsButLeavesDirectory(self):
        self.app.run(["--build-area", self.build_area, "clean-build-area"])
        self.failUnlessEqual(os.listdir(self.build_area), [])

    def testHandlesNonExistendBuildAreaOk(self):
        shutil.rmtree(self.build_area)
        self.failUnlessEqual(self.app.run(["--build-area", self.build_area, 
                                           "clean-build-area"]),
                             None)
