#!/usr/bin/python
# Copyright (C) 2007  Lars Wirzenius <liw@iki.fi>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


"""Run all Unperish unit tests."""


import imp
import os
import sys
import unittest

def listdir(dir):
    return [os.path.join(dir, x) for x in os.listdir(dir)]

def tests(filenames):
    return [x for x in filenames if x.endswith("_tests.py")]

suite = unittest.TestSuite()
for filename in tests(listdir(".") + listdir("plugins")):
    module_name, _ = os.path.splitext(os.path.basename(filename))
    f = file(filename)
    m = imp.load_module(module_name, f, filename, (".py", "r", imp.PY_SOURCE))
    f.close()
    suite.addTest(unittest.defaultTestLoader.loadTestsFromModule(m))

runner = unittest.TextTestRunner()
result = runner.run(suite)
if not result.wasSuccessful(): #pragma: no cover
    sys.exit(1)
