/* amd64-linux.elf-entry.h
   created from amd64-linux.elf-entry.bin, 10080 (0x2760) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_AMD64_LINUX_ELF_ENTRY_SIZE    10080
#define STUB_AMD64_LINUX_ELF_ENTRY_ADLER32 0x83c806e2
#define STUB_AMD64_LINUX_ELF_ENTRY_CRC32   0x989209b3

unsigned char stub_amd64_linux_elf_entry[10080] = {
127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
  0,  0,  0,  0,  0,  0,  0,  0,112, 24,  0,  0,  0,  0,  0,  0,   /* 0x  20 */
  0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 23,  0, 20,  0,   /* 0x  30 */
232,  0,  0,  0,  0, 85, 83, 81, 82, 72,  1,254, 86, 72,137,254,   /* 0x  40 */
 72,137,215, 49,219, 49,201, 72,131,205,255,232, 80,  0,  0,  0,   /* 0x  50 */
  1,219,116,  2,243,195,139, 30, 72,131,238,252, 17,219,138, 22,   /* 0x  60 */
243,195, 72,141,  4, 47,131,249,  5,138, 16,118, 33, 72,131,253,   /* 0x  70 */
252,119, 27,131,233,  4,139, 16, 72,131,192,  4,131,233,  4,137,   /* 0x  80 */
 23, 72,141,127,  4,115,239,131,193,  4,138, 16,116, 16, 72,255,   /* 0x  90 */
192,136, 23,131,233,  1,138, 16, 72,141,127,  1,117,240,243,195,   /* 0x  a0 */
252, 65, 91, 65,128,248,  8,116, 13,233,172,  0,  0,  0, 72,255,   /* 0x  b0 */
198,136, 23, 72,255,199,138, 22,  1,219,117, 10,139, 30, 72,131,   /* 0x  c0 */
238,252, 17,219,138, 22,114,230,141, 65,  1,235,  7,255,200, 65,   /* 0x  d0 */
255,211, 17,192, 65,255,211, 17,192,  1,219,117, 10,139, 30, 72,   /* 0x  e0 */
131,238,252, 17,219,138, 22,115,228,131,232,  3,114, 29,193,224,   /* 0x  f0 */
  8, 15,182,210,  9,208, 72,255,198,131,240,255, 15,132,  0,  0,   /* 0x 100 */
  0,  0,209,248, 72, 99,232,114, 56,235, 14,  1,219,117,  8,139,   /* 0x 110 */
 30, 72,131,238,252, 17,219,114, 40,255,193,  1,219,117,  8,139,   /* 0x 120 */
 30, 72,131,238,252, 17,219,114, 24, 65,255,211, 17,201,  1,219,   /* 0x 130 */
117,  8,139, 30, 72,131,238,252, 17,219,115,237,131,193,  2,235,   /* 0x 140 */
  5, 65,255,211, 17,201, 72,129,253,  0,251,255,255,131,209,  2,   /* 0x 150 */
232,  0,  0,  0,  0,233, 92,255,255,255, 65,128,248,  5,116, 13,   /* 0x 160 */
233,147,  0,  0,  0, 72,255,198,136, 23, 72,255,199,138, 22,  1,   /* 0x 170 */
219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,114,230,141,   /* 0x 180 */
 65,  1,235,  7,255,200, 65,255,211, 17,192, 65,255,211, 17,192,   /* 0x 190 */
  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,115,228,   /* 0x 1a0 */
131,232,  3,114, 27,193,224,  8, 15,182,210,  9,208, 72,255,198,   /* 0x 1b0 */
131,240,255, 15,132,  0,  0,  0,  0,209,248, 72, 99,232,235,  3,   /* 0x 1c0 */
 65,255,211, 17,201, 65,255,211, 17,201,117, 24,255,193, 65,255,   /* 0x 1d0 */
211, 17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,115,   /* 0x 1e0 */
237,131,193,  2, 72,129,253,  0,251,255,255,131,209,  1,232,  0,   /* 0x 1f0 */
  0,  0,  0,233,117,255,255,255, 65,128,248,  2,116, 13,233,133,   /* 0x 200 */
  0,  0,  0, 72,255,198,136, 23, 72,255,199,138, 22,  1,219,117,   /* 0x 210 */
 10,139, 30, 72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,   /* 0x 220 */
 65,255,211, 17,192,  1,219,117, 10,139, 30, 72,131,238,252, 17,   /* 0x 230 */
219,138, 22,115,235,131,232,  3,114, 23,193,224,  8, 15,182,210,   /* 0x 240 */
  9,208, 72,255,198,131,240,255, 15,132,  0,  0,  0,  0, 72, 99,   /* 0x 250 */
232,141, 65,  1, 65,255,211, 17,201, 65,255,211, 17,201,117, 24,   /* 0x 260 */
137,193,131,192,  2, 65,255,211, 17,201,  1,219,117,  8,139, 30,   /* 0x 270 */
 72,131,238,252, 17,219,115,237, 72,129,253,  0,243,255,255, 17,   /* 0x 280 */
193,232,  0,  0,  0,  0,235,131, 65,128,248, 14, 15,133,  0,  0,   /* 0x 290 */
  0,  0, 85, 72,137,229, 68,139,  9, 73,137,208, 72,137,242, 72,   /* 0x 2a0 */
141,119,  2, 86,138,  7,255,202,136,193, 36,  7,192,233,  3, 72,   /* 0x 2b0 */
199,195,  0,253,255,255, 72,211,227,136,193, 72,141,156, 92,136,   /* 0x 2c0 */
241,255,255, 72,131,227,192,106,  0, 72, 57,220,117,249, 83, 72,   /* 0x 2d0 */
141,123,  8,138, 78,255,255,202,136, 71,  2,136,200,192,233,  4,   /* 0x 2e0 */
136, 79,  1, 36, 15,136,  7, 72,141, 79,252, 80, 65, 87, 72,141,   /* 0x 2f0 */
 71,  4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69,   /* 0x 300 */
 49,237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,137, 68, 36,216,   /* 0x 310 */
184,  1,  0,  0,  0, 72,137,116, 36,248, 76,137, 68, 36,232,137,   /* 0x 320 */
195, 68,137, 76, 36,228, 15,182, 79,  2,211,227,137,217, 72,139,   /* 0x 330 */
 92, 36, 56,255,201,137, 76, 36,212, 15,182, 79,  1,211,224, 72,   /* 0x 340 */
139, 76, 36,240,255,200,137, 68, 36,208, 15,182,  7,199,  1,  0,   /* 0x 350 */
  0,  0,  0,199, 68, 36,200,  0,  0,  0,  0,199, 68, 36,196,  1,   /* 0x 360 */
  0,  0,  0,199, 68, 36,192,  1,  0,  0,  0,199, 68, 36,188,  1,   /* 0x 370 */
  0,  0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,204, 15,182, 79,   /* 0x 380 */
  1,  1,193,184,  0,  3,  0,  0,211,224, 49,201,141,184, 54,  7,   /* 0x 390 */
  0,  0, 65, 57,255,115, 19, 72,139, 92, 36,216,137,200,255,193,   /* 0x 3a0 */
 57,249,102,199,  4, 67,  0,  4,235,235, 72,139,124, 36,248,137,   /* 0x 3b0 */
208, 69, 49,210, 65,131,203,255, 49,210, 73,137,252, 73,  1,196,   /* 0x 3c0 */
 76, 57,231, 15,132,239,  8,  0,  0, 15,182,  7, 65,193,226,  8,   /* 0x 3d0 */
255,194, 72,255,199, 65,  9,194,131,250,  4,126,227, 68, 59,124,   /* 0x 3e0 */
 36,228, 15,131,218,  8,  0,  0,139, 68, 36,212, 72, 99, 92, 36,   /* 0x 3f0 */
200, 72,139, 84, 36,216, 68, 33,248,137, 68, 36,184, 72, 99,108,   /* 0x 400 */
 36,184, 72,137,216, 72,193,224,  4, 72,  1,232, 65,129,251,255,   /* 0x 410 */
255,255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,132,150,  8,   /* 0x 420 */
  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,   /* 0x 430 */
 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202,   /* 0x 440 */
 15,175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,137,195,184,   /* 0x 450 */
  0,  8,  0,  0, 72,139, 92, 36,216, 41,200, 15,182, 76, 36,204,   /* 0x 460 */
190,  1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,182,213,102,   /* 0x 470 */
 65,137,  1,139, 68, 36,208, 68, 33,248,211,224,185,  8,  0,  0,   /* 0x 480 */
  0, 43, 76, 36,204,211,250,  1,208,105,192,  0,  3,  0,  0,131,   /* 0x 490 */
124, 36,200,  6,137,192, 76,141,140, 67,108, 14,  0,  0, 15,142,   /* 0x 4a0 */
184,  0,  0,  0, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 15,   /* 0x 4b0 */
182, 44,  2,  1,237, 72, 99,214,137,235,129,227,  0,  1,  0,  0,   /* 0x 4c0 */
 65,129,251,255,255,255,  0, 72, 99,195, 73,141,  4, 65, 76,141,   /* 0x 4d0 */
  4, 80,119, 26, 76, 57,231, 15,132,219,  7,  0,  0, 15,182,  7,   /* 0x 4e0 */
 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,   /* 0x 4f0 */
183,144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,   /* 0x 500 */
175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0,  1,   /* 0x 510 */
246, 41,200,193,248,  5,133,219,141,  4,  2,102, 65,137,128,  0,   /* 0x 520 */
  2,  0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,137,208,102,   /* 0x 530 */
193,232,  5,141,116, 54,  1,102, 41,194,133,219,102, 65,137,144,   /* 0x 540 */
  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142, 97,255,   /* 0x 550 */
255,255,235,120,129,254,255,  0,  0,  0,127,112, 72, 99,198, 65,   /* 0x 560 */
129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,   /* 0x 570 */
132, 67,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,   /* 0x 580 */
 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11,   /* 0x 590 */
 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,   /* 0x 5a0 */
  8,  0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,102, 65,137,   /* 0x 5b0 */
  0,235,161, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,   /* 0x 5c0 */
116, 54,  1,102, 41,194,102, 65,137, 16,235,136, 72,139, 76, 36,   /* 0x 5d0 */
232, 68,137,248, 65,255,199, 65,137,245, 64,136, 52,  1,131,124,   /* 0x 5e0 */
 36,200,  3,127, 13,199, 68, 36,200,  0,  0,  0,  0,233,166,  6,   /* 0x 5f0 */
  0,  0,139, 84, 36,200,139, 68, 36,200,131,234,  3,131,232,  6,   /* 0x 600 */
131,124, 36,200,  9, 15, 79,208,137, 84, 36,200,233,135,  6,  0,   /* 0x 610 */
  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,   /* 0x 620 */
 72,139, 68, 36,216, 65,129,251,255,255,255,  0,102, 65,137, 17,   /* 0x 630 */
 72,141, 52, 88,119, 26, 76, 57,231, 15,132,121,  6,  0,  0, 15,   /* 0x 640 */
182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,   /* 0x 650 */
 15,183,150,128,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202,   /* 0x 660 */
 15,175,193, 65, 57,194,115, 78, 65,137,195,184,  0,  8,  0,  0,   /* 0x 670 */
 76,139, 76, 36,216, 41,200,139, 76, 36,196, 68,137,116, 36,196,   /* 0x 680 */
193,248,  5,141,  4,  2,139, 84, 36,192,137, 76, 36,192,102,137,   /* 0x 690 */
134,128,  1,  0,  0, 49,192,131,124, 36,200,  6,137, 84, 36,188,   /* 0x 6a0 */
 15,159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,   /* 0x 6b0 */
200,233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,   /* 0x 6c0 */
232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,128,   /* 0x 6d0 */
  1,  0,  0,119, 26, 76, 57,231, 15,132,218,  5,  0,  0, 15,182,   /* 0x 6e0 */
  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,   /* 0x 6f0 */
183,150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,   /* 0x 700 */
175,193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,  0,  8,  0,   /* 0x 710 */
  0, 65,137,195, 72,193,227,  5, 68,137,192, 41,200,193,248,  5,   /* 0x 720 */
141,  4,  2,102,137,134,152,  1,  0,  0, 72,139, 68, 36,216, 72,   /* 0x 730 */
  1,216, 65,129,251,255,255,255,  0, 72,141, 52,104,119, 26, 76,   /* 0x 740 */
 57,231, 15,132,112,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,   /* 0x 750 */
193,227,  8, 72,255,199, 65,  9,194, 15,183,150,224,  1,  0,  0,   /* 0x 760 */
 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,   /* 0x 770 */
 79, 65, 41,200, 65,137,195, 65,193,248,  5, 69,133,255, 66,141,   /* 0x 780 */
  4,  2,102,137,134,224,  1,  0,  0, 15,132, 41,  5,  0,  0, 49,   /* 0x 790 */
192,131,124, 36,200,  6, 72,139, 92, 36,232, 15,159,192,141, 68,   /* 0x 7a0 */
  0,  9,137, 68, 36,200, 68,137,248, 68, 41,240, 68, 15,182, 44,   /* 0x 7b0 */
  3, 68,137,248, 65,255,199, 68,136, 44,  3,233,216,  4,  0,  0,   /* 0x 7c0 */
 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,102,   /* 0x 7d0 */
137,150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,195, 65, 41,   /* 0x 7e0 */
194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,   /* 0x 7f0 */
  0,102,137,150,152,  1,  0,  0,119, 26, 76, 57,231, 15,132,181,   /* 0x 800 */
  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,   /* 0x 810 */
199, 65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,216,193,232,   /* 0x 820 */
 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,   /* 0x 830 */
  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,176,   /* 0x 840 */
  1,  0,  0,139, 68, 36,196,233,152,  0,  0,  0, 65, 41,195, 65,   /* 0x 850 */
 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,   /* 0x 860 */
255,  0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,231, 15,132,   /* 0x 870 */
 68,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,   /* 0x 880 */
255,199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,137,216,193,   /* 0x 890 */
232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 29, 65,137,195,   /* 0x 8a0 */
184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,   /* 0x 8b0 */
200,  1,  0,  0,139, 68, 36,192,235, 34, 65, 41,195, 65, 41,194,   /* 0x 8c0 */
137,208,102,193,232,  5,102, 41,194,139, 68, 36,188,102,137,150,   /* 0x 8d0 */
200,  1,  0,  0,139, 84, 36,192,137, 84, 36,188,139, 76, 36,196,   /* 0x 8e0 */
137, 76, 36,192, 68,137,116, 36,196, 65,137,198, 49,192,131,124,   /* 0x 8f0 */
 36,200,  6, 76,139, 76, 36,216, 15,159,192, 73,129,193,104, 10,   /* 0x 900 */
  0,  0,141, 68, 64,  8,137, 68, 36,200, 65,129,251,255,255,255,   /* 0x 910 */
  0,119, 26, 76, 57,231, 15,132,156,  3,  0,  0, 15,182,  7, 65,   /* 0x 920 */
193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,   /* 0x 930 */
 17, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,   /* 0x 940 */
115, 39, 65,137,195,184,  0,  8,  0,  0, 69, 49,237, 41,200,193,   /* 0x 950 */
248,  5,141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,184, 72,193,   /* 0x 960 */
224,  4, 77,141, 68,  1,  4,235,120, 65, 41,195, 65, 41,194,137,   /* 0x 970 */
208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,   /* 0x 980 */
 65,137, 17,119, 26, 76, 57,231, 15,132, 42,  3,  0,  0, 15,182,   /* 0x 990 */
  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,   /* 0x 9a0 */
 15,183, 81,  2, 68,137,216,193,232, 11, 15,183,202, 15,175,193,   /* 0x 9b0 */
 65, 57,194,115, 52, 65,137,195,184,  0,  8,  0,  0, 65,189,  8,   /* 0x 9c0 */
  0,  0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,137, 65,  2,   /* 0x 9d0 */
 72, 99, 68, 36,184, 72,193,224,  4, 77,141,132,  1,  4,  1,  0,   /* 0x 9e0 */
  0, 65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65, 41,194,137,   /* 0x 9f0 */
208,102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,189, 16,  0,   /* 0x a00 */
  0,  0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,  0,  0,  0,   /* 0x a10 */
 68,137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,251,255,255,   /* 0x a20 */
255,  0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,135,  2,  0,   /* 0x a30 */
  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,   /* 0x a40 */
  9,194, 15,183, 14, 68,137,216,193,232, 11, 15,183,209, 15,175,   /* 0x a50 */
194, 65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,  0,  1,237,   /* 0x a60 */
 41,208,193,248,  5,141,  4,  1,102,137,  6,235, 22, 65, 41,195,   /* 0x a70 */
 65, 41,194,137,200,102,193,232,  5,141,108, 45,  1,102, 41,193,   /* 0x a80 */
102,137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,137,201,211,   /* 0x a90 */
224, 41,197, 68,  1,237,131,124, 36,200,  3, 15,143,194,  1,  0,   /* 0x aa0 */
  0,131, 68, 36,200,  7,184,  3,  0,  0,  0,131,253,  4, 15, 76,   /* 0x ab0 */
197, 72,139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,152, 72,193,   /* 0x ac0 */
224,  7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73,   /* 0x ad0 */
 99,192, 65,129,251,255,255,255,  0, 73,141, 52, 65,119, 26, 76,   /* 0x ae0 */
 57,231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,   /* 0x af0 */
193,227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,137,216,193,   /* 0x b00 */
232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,   /* 0x b10 */
184,  0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,141,  4,  2,   /* 0x b20 */
102,137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,102,193,232,   /* 0x b30 */
  5, 71,141, 68,  0,  1,102, 41,194,102,137, 22,255,203,117,143,   /* 0x b40 */
 65,131,232, 64, 65,131,248,  3, 69,137,198, 15,142, 13,  1,  0,   /* 0x b50 */
  0, 65,131,230,  1, 68,137,192,209,248, 65,131,206,  2, 65,131,   /* 0x b60 */
248, 13,141,112,255,127, 35,137,241, 72,139, 92, 36,216, 73, 99,   /* 0x b70 */
192, 65,211,230, 72,  1,192, 68,137,242, 72,141, 20, 83, 72, 41,   /* 0x b80 */
194, 76,141,138, 94,  5,  0,  0,235, 81,141,112,251, 65,129,251,   /* 0x b90 */
255,255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,   /* 0x ba0 */
182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,   /* 0x bb0 */
 65,209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,218, 65,131,   /* 0x bc0 */
206,  1,255,206,117,199, 76,139, 76, 36,216, 65,193,230,  4,190,   /* 0x bd0 */
  4,  0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,   /* 0x be0 */
  0,187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,255,255,  0,   /* 0x bf0 */
 77,141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,  0,  0, 15,   /* 0x c00 */
182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,   /* 0x c10 */
 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193,   /* 0x c20 */
 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,219, 41,   /* 0x c30 */
200,193,248,  5,141,  4,  2,102, 65,137,  0,235, 26, 65, 41,195,   /* 0x c40 */
 65, 41,194,137,208,102,193,232,  5,141, 92, 27,  1, 69,  9,238,   /* 0x c50 */
102, 41,194,102, 65,137, 16, 69,  1,237,255,206,117,136, 65,255,   /* 0x c60 */
198,116, 64,131,197,  2, 69, 57,254,119, 77, 72,139, 84, 36,232,   /* 0x c70 */
 68,137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,248, 65,255,   /* 0x c80 */
199,255,205, 68,136, 44,  2, 15,149,194, 49,192, 68, 59,124, 36,   /* 0x c90 */
228, 15,146,192,133,194,117,211, 68, 59,124, 36,228, 15,130, 69,   /* 0x ca0 */
247,255,255, 65,129,251,255,255,255,  0,119, 22, 76, 57,231,184,   /* 0x cb0 */
  1,  0,  0,  0,116, 35,235,  7,184,  1,  0,  0,  0,235, 26, 72,   /* 0x cc0 */
255,199,137,248, 43, 68, 36,248, 72,139, 76, 36,240, 72,139, 92,   /* 0x cd0 */
 36, 56,137,  1, 68,137, 59, 49,192, 91, 93, 65, 92, 65, 93, 65,   /* 0x ce0 */
 94, 65, 95, 65, 87, 72,141, 71,  4, 69, 49,255, 65, 86, 65,190,   /* 0x cf0 */
  1,  0,  0,  0, 65, 85, 69, 49,237, 65, 84, 85, 83, 72,137, 76,   /* 0x d00 */
 36,240, 72,137, 68, 36,216,184,  1,  0,  0,  0, 72,137,116, 36,   /* 0x d10 */
248, 76,137, 68, 36,232,137,195, 68,137, 76, 36,228, 15,182, 79,   /* 0x d20 */
  2,211,227,137,217, 72,139, 92, 36, 56,255,201,137, 76, 36,212,   /* 0x d30 */
 15,182, 79,  1,211,224, 72,139, 76, 36,240,255,200,137, 68, 36,   /* 0x d40 */
208, 15,182,  7,199,  1,  0,  0,  0,  0,199, 68, 36,200,  0,  0,   /* 0x d50 */
  0,  0,199, 68, 36,196,  1,  0,  0,  0,199, 68, 36,192,  1,  0,   /* 0x d60 */
  0,  0,199, 68, 36,188,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,   /* 0x d70 */
137, 68, 36,204, 15,182, 79,  1,  1,193,184,  0,  3,  0,  0,211,   /* 0x d80 */
224, 49,201,141,184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,139,   /* 0x d90 */
 92, 36,216,137,200,255,193, 57,249,102,199,  4, 67,  0,  4,235,   /* 0x da0 */
235, 72,139,124, 36,248,137,208, 69, 49,210, 65,131,203,255, 49,   /* 0x db0 */
210, 73,137,252, 73,  1,196, 76, 57,231, 15,132,239,  8,  0,  0,   /* 0x dc0 */
 15,182,  7, 65,193,226,  8,255,194, 72,255,199, 65,  9,194,131,   /* 0x dd0 */
250,  4,126,227, 68, 59,124, 36,228, 15,131,218,  8,  0,  0,139,   /* 0x de0 */
 68, 36,212, 72, 99, 92, 36,200, 72,139, 84, 36,216, 68, 33,248,   /* 0x df0 */
137, 68, 36,184, 72, 99,108, 36,184, 72,137,216, 72,193,224,  4,   /* 0x e00 */
 72,  1,232, 65,129,251,255,255,255,  0, 76,141, 12, 66,119, 26,   /* 0x e10 */
 76, 57,231, 15,132,150,  8,  0,  0, 15,182,  7, 65,193,226,  8,   /* 0x e20 */
 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,   /* 0x e30 */
216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,197,   /* 0x e40 */
  1,  0,  0, 65,137,195,184,  0,  8,  0,  0, 72,139, 92, 36,216,   /* 0x e50 */
 41,200, 15,182, 76, 36,204,190,  1,  0,  0,  0,193,248,  5,141,   /* 0x e60 */
  4,  2, 65, 15,182,213,102, 65,137,  1,139, 68, 36,208, 68, 33,   /* 0x e70 */
248,211,224,185,  8,  0,  0,  0, 43, 76, 36,204,211,250,  1,208,   /* 0x e80 */
105,192,  0,  3,  0,  0,131,124, 36,200,  6,137,192, 76,141,140,   /* 0x e90 */
 67,108, 14,  0,  0, 15,142,184,  0,  0,  0, 72,139, 84, 36,232,   /* 0x ea0 */
 68,137,248, 68, 41,240, 15,182, 44,  2,  1,237, 72, 99,214,137,   /* 0x eb0 */
235,129,227,  0,  1,  0,  0, 65,129,251,255,255,255,  0, 72, 99,   /* 0x ec0 */
195, 73,141,  4, 65, 76,141,  4, 80,119, 26, 76, 57,231, 15,132,   /* 0x ed0 */
219,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,   /* 0x ee0 */
255,199, 65,  9,194, 65, 15,183,144,  0,  2,  0,  0, 68,137,216,   /* 0x ef0 */
193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,   /* 0x f00 */
195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,133,219,141,   /* 0x f10 */
  4,  2,102, 65,137,128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,   /* 0x f20 */
195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,   /* 0x f30 */
194,133,219,102, 65,137,144,  0,  2,  0,  0,116, 14,129,254,255,   /* 0x f40 */
  0,  0,  0, 15,142, 97,255,255,255,235,120,129,254,255,  0,  0,   /* 0x f50 */
  0,127,112, 72, 99,198, 65,129,251,255,255,255,  0, 77,141,  4,   /* 0x f60 */
 65,119, 26, 76, 57,231, 15,132, 67,  7,  0,  0, 15,182,  7, 65,   /* 0x f70 */
193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,   /* 0x f80 */
 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,   /* 0x f90 */
115, 24, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,   /* 0x fa0 */
  5,141,  4,  2,102, 65,137,  0,235,161, 65, 41,195, 65, 41,194,   /* 0x fb0 */
137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,102, 65,137,   /* 0x fc0 */
 16,235,136, 72,139, 76, 36,232, 68,137,248, 65,255,199, 65,137,   /* 0x fd0 */
245, 64,136, 52,  1,131,124, 36,200,  3,127, 13,199, 68, 36,200,   /* 0x fe0 */
  0,  0,  0,  0,233,166,  6,  0,  0,139, 84, 36,200,139, 68, 36,   /* 0x ff0 */
200,131,234,  3,131,232,  6,131,124, 36,200,  9, 15, 79,208,137,   /* 0x1000 */
 84, 36,200,233,135,  6,  0,  0, 65, 41,195, 65, 41,194,137,208,   /* 0x1010 */
102,193,232,  5,102, 41,194, 72,139, 68, 36,216, 65,129,251,255,   /* 0x1020 */
255,255,  0,102, 65,137, 17, 72,141, 52, 88,119, 26, 76, 57,231,   /* 0x1030 */
 15,132,121,  6,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,   /* 0x1040 */
  8, 72,255,199, 65,  9,194, 15,183,150,128,  1,  0,  0, 68,137,   /* 0x1050 */
216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 78, 65,   /* 0x1060 */
137,195,184,  0,  8,  0,  0, 76,139, 76, 36,216, 41,200,139, 76,   /* 0x1070 */
 36,196, 68,137,116, 36,196,193,248,  5,141,  4,  2,139, 84, 36,   /* 0x1080 */
192,137, 76, 36,192,102,137,134,128,  1,  0,  0, 49,192,131,124,   /* 0x1090 */
 36,200,  6,137, 84, 36,188, 15,159,192, 73,129,193,100,  6,  0,   /* 0x10a0 */
  0,141,  4, 64,137, 68, 36,200,233, 84,  2,  0,  0, 65, 41,195,   /* 0x10b0 */
 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,   /* 0x10c0 */
255,255,  0,102,137,150,128,  1,  0,  0,119, 26, 76, 57,231, 15,   /* 0x10d0 */
132,218,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,   /* 0x10e0 */
 72,255,199, 65,  9,194, 15,183,150,152,  1,  0,  0, 68,137,216,   /* 0x10f0 */
193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,208,  0,   /* 0x1100 */
  0,  0, 65,184,  0,  8,  0,  0, 65,137,195, 72,193,227,  5, 68,   /* 0x1110 */
137,192, 41,200,193,248,  5,141,  4,  2,102,137,134,152,  1,  0,   /* 0x1120 */
  0, 72,139, 68, 36,216, 72,  1,216, 65,129,251,255,255,255,  0,   /* 0x1130 */
 72,141, 52,104,119, 26, 76, 57,231, 15,132,112,  5,  0,  0, 15,   /* 0x1140 */
182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,   /* 0x1150 */
 15,183,150,224,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202,   /* 0x1160 */
 15,175,193, 65, 57,194,115, 79, 65, 41,200, 65,137,195, 65,193,   /* 0x1170 */
248,  5, 69,133,255, 66,141,  4,  2,102,137,134,224,  1,  0,  0,   /* 0x1180 */
 15,132, 41,  5,  0,  0, 49,192,131,124, 36,200,  6, 72,139, 92,   /* 0x1190 */
 36,232, 15,159,192,141, 68,  0,  9,137, 68, 36,200, 68,137,248,   /* 0x11a0 */
 68, 41,240, 68, 15,182, 44,  3, 68,137,248, 65,255,199, 68,136,   /* 0x11b0 */
 44,  3,233,216,  4,  0,  0, 65, 41,195, 65, 41,194,137,208,102,   /* 0x11c0 */
193,232,  5,102, 41,194,102,137,150,224,  1,  0,  0,233, 17,  1,   /* 0x11d0 */
  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,   /* 0x11e0 */
194, 65,129,251,255,255,255,  0,102,137,150,152,  1,  0,  0,119,   /* 0x11f0 */
 26, 76, 57,231, 15,132,181,  4,  0,  0, 15,182,  7, 65,193,226,   /* 0x1200 */
  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,176,  1,   /* 0x1210 */
  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,   /* 0x1220 */
194,115, 32, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,   /* 0x1230 */
141,  4,  2,102,137,134,176,  1,  0,  0,139, 68, 36,196,233,152,   /* 0x1240 */
  0,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,   /* 0x1250 */
 41,194, 65,129,251,255,255,255,  0,102,137,150,176,  1,  0,  0,   /* 0x1260 */
119, 26, 76, 57,231, 15,132, 68,  4,  0,  0, 15,182,  7, 65,193,   /* 0x1270 */
226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,200,   /* 0x1280 */
  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,   /* 0x1290 */
 57,194,115, 29, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,   /* 0x12a0 */
  5,141,  4,  2,102,137,134,200,  1,  0,  0,139, 68, 36,192,235,   /* 0x12b0 */
 34, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,   /* 0x12c0 */
139, 68, 36,188,102,137,150,200,  1,  0,  0,139, 84, 36,192,137,   /* 0x12d0 */
 84, 36,188,139, 76, 36,196,137, 76, 36,192, 68,137,116, 36,196,   /* 0x12e0 */
 65,137,198, 49,192,131,124, 36,200,  6, 76,139, 76, 36,216, 15,   /* 0x12f0 */
159,192, 73,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,   /* 0x1300 */
200, 65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132,156,   /* 0x1310 */
  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,   /* 0x1320 */
199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,   /* 0x1330 */
202, 15,175,193, 65, 57,194,115, 39, 65,137,195,184,  0,  8,  0,   /* 0x1340 */
  0, 69, 49,237, 41,200,193,248,  5,141,  4,  2,102, 65,137,  1,   /* 0x1350 */
 72, 99, 68, 36,184, 72,193,224,  4, 77,141, 68,  1,  4,235,120,   /* 0x1360 */
 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,   /* 0x1370 */
129,251,255,255,255,  0,102, 65,137, 17,119, 26, 76, 57,231, 15,   /* 0x1380 */
132, 42,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,   /* 0x1390 */
 72,255,199, 65,  9,194, 65, 15,183, 81,  2, 68,137,216,193,232,   /* 0x13a0 */
 11, 15,183,202, 15,175,193, 65, 57,194,115, 52, 65,137,195,184,   /* 0x13b0 */
  0,  8,  0,  0, 65,189,  8,  0,  0,  0, 41,200,193,248,  5,141,   /* 0x13c0 */
  4,  2,102, 65,137, 65,  2, 72, 99, 68, 36,184, 72,193,224,  4,   /* 0x13d0 */
 77,141,132,  1,  4,  1,  0,  0, 65,185,  3,  0,  0,  0,235, 39,   /* 0x13e0 */
 65, 41,195, 65, 41,194,137,208,102,193,232,  5, 77,141,129,  4,   /* 0x13f0 */
  2,  0,  0, 65,189, 16,  0,  0,  0,102, 41,194,102, 65,137, 81,   /* 0x1400 */
  2, 65,185,  8,  0,  0,  0, 68,137,203,189,  1,  0,  0,  0, 72,   /* 0x1410 */
 99,197, 65,129,251,255,255,255,  0, 73,141, 52, 64,119, 26, 76,   /* 0x1420 */
 57,231, 15,132,135,  2,  0,  0, 15,182,  7, 65,193,226,  8, 65,   /* 0x1430 */
193,227,  8, 72,255,199, 65,  9,194, 15,183, 14, 68,137,216,193,   /* 0x1440 */
232, 11, 15,183,209, 15,175,194, 65, 57,194,115, 23, 65,137,195,   /* 0x1450 */
184,  0,  8,  0,  0,  1,237, 41,208,193,248,  5,141,  4,  1,102,   /* 0x1460 */
137,  6,235, 22, 65, 41,195, 65, 41,194,137,200,102,193,232,  5,   /* 0x1470 */
141,108, 45,  1,102, 41,193,102,137, 14,255,203,117,145,184,  1,   /* 0x1480 */
  0,  0,  0, 68,137,201,211,224, 41,197, 68,  1,237,131,124, 36,   /* 0x1490 */
200,  3, 15,143,194,  1,  0,  0,131, 68, 36,200,  7,184,  3,  0,   /* 0x14a0 */
  0,  0,131,253,  4, 15, 76,197, 72,139, 92, 36,216, 65,184,  1,   /* 0x14b0 */
  0,  0,  0, 72,152, 72,193,224,  7, 76,141,140,  3, 96,  3,  0,   /* 0x14c0 */
  0,187,  6,  0,  0,  0, 73, 99,192, 65,129,251,255,255,255,  0,   /* 0x14d0 */
 73,141, 52, 65,119, 26, 76, 57,231, 15,132,208,  1,  0,  0, 15,   /* 0x14e0 */
182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,   /* 0x14f0 */
 15,183, 22, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,   /* 0x1500 */
 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0, 69,  1,192, 41,   /* 0x1510 */
200,193,248,  5,141,  4,  2,102,137,  6,235, 23, 65, 41,195, 65,   /* 0x1520 */
 41,194,137,208,102,193,232,  5, 71,141, 68,  0,  1,102, 41,194,   /* 0x1530 */
102,137, 22,255,203,117,143, 65,131,232, 64, 65,131,248,  3, 69,   /* 0x1540 */
137,198, 15,142, 13,  1,  0,  0, 65,131,230,  1, 68,137,192,209,   /* 0x1550 */
248, 65,131,206,  2, 65,131,248, 13,141,112,255,127, 35,137,241,   /* 0x1560 */
 72,139, 92, 36,216, 73, 99,192, 65,211,230, 72,  1,192, 68,137,   /* 0x1570 */
242, 72,141, 20, 83, 72, 41,194, 76,141,138, 94,  5,  0,  0,235,   /* 0x1580 */
 81,141,112,251, 65,129,251,255,255,255,  0,119, 26, 76, 57,231,   /* 0x1590 */
 15,132, 25,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,   /* 0x15a0 */
  8, 72,255,199, 65,  9,194, 65,209,235, 69,  1,246, 69, 57,218,   /* 0x15b0 */
114,  7, 69, 41,218, 65,131,206,  1,255,206,117,199, 76,139, 76,   /* 0x15c0 */
 36,216, 65,193,230,  4,190,  4,  0,  0,  0, 73,129,193, 68,  6,   /* 0x15d0 */
  0,  0, 65,189,  1,  0,  0,  0,187,  1,  0,  0,  0, 72, 99,195,   /* 0x15e0 */
 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231,   /* 0x15f0 */
 15,132,185,  0,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,   /* 0x1600 */
  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232,   /* 0x1610 */
 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,   /* 0x1620 */
  0,  8,  0,  0,  1,219, 41,200,193,248,  5,141,  4,  2,102, 65,   /* 0x1630 */
137,  0,235, 26, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,   /* 0x1640 */
141, 92, 27,  1, 69,  9,238,102, 41,194,102, 65,137, 16, 69,  1,   /* 0x1650 */
237,255,206,117,136, 65,255,198,116, 64,131,197,  2, 69, 57,254,   /* 0x1660 */
119, 77, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 68, 15,182,   /* 0x1670 */
 44,  2, 68,137,248, 65,255,199,255,205, 68,136, 44,  2, 15,149,   /* 0x1680 */
194, 49,192, 68, 59,124, 36,228, 15,146,192,133,194,117,211, 68,   /* 0x1690 */
 59,124, 36,228, 15,130, 69,247,255,255, 65,129,251,255,255,255,   /* 0x16a0 */
  0,119, 22, 76, 57,231,184,  1,  0,  0,  0,116, 35,235,  7,184,   /* 0x16b0 */
  1,  0,  0,  0,235, 26, 72,255,199,137,248, 43, 68, 36,248, 72,   /* 0x16c0 */
139, 76, 36,240, 72,139, 92, 36, 56,137,  1, 68,137, 59, 49,192,   /* 0x16d0 */
 91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 72,139,117,248, 72,139,   /* 0x16e0 */
125, 16,139, 75,  4, 72,  1,206,139, 19, 72,  1,215,201, 89, 72,   /* 0x16f0 */
137,240, 72, 41,200, 90, 72, 41,215, 89,137, 57, 91, 93,195,104,   /* 0x1700 */
 30,  0,  0,  0, 90,232,  0,  0,  0,  0, 80, 82, 79, 84, 95, 69,   /* 0x1710 */
 88, 69, 67,124, 80, 82, 79, 84, 95, 87, 82, 73, 84, 69, 32,102,   /* 0x1720 */
 97,105,108,101,100, 46, 10,  0, 94,106,  2, 95,106,  1, 88, 15,   /* 0x1730 */
  5,106,127, 95,106, 60, 88, 15,  5, 91,191,  0,  0,  0,  0,106,   /* 0x1740 */
  7, 90,190,  0,  0,  0,  0,106, 50, 65, 90, 69, 41,192,106,  9,   /* 0x1750 */
 88, 15,  5, 57,199, 15,133,  0,  0,  0,  0,104,  0,  0,  0,  0,   /* 0x1760 */
104,  0,  0,  0,  0,190,  0,  0,  0,  0,104,  0,  0,  0,  0,104,   /* 0x1770 */
  0,  0,  0,  0, 65, 87,137,250, 41,242,116, 13,  1,213,137,217,   /* 0x1780 */
 41,241,193,233,  3,252,243, 72,165,151,137,222, 80,146,173, 80,   /* 0x1790 */
 72,137,225,173,151,173, 68, 15,182,192,135,254,255,213, 89,195,   /* 0x17a0 */
 93, 68,139,125,247, 65,129,239,200,  0,  0,  0,232,136,255,255,   /* 0x17b0 */
255,116,109,112, 47, 97,109,100, 54, 52, 45,108,105,110,117,120,   /* 0x17c0 */
 46,101,108,102, 45,101,110,116,114,121, 46, 98,105,110, 58, 32,   /* 0x17d0 */
 32, 32, 32, 32,102,105,108,101, 32,102,111,114,109, 97,116, 32,   /* 0x17e0 */
101,108,102, 54, 52, 45,120, 56, 54, 45, 54, 52, 10, 10, 83,101,   /* 0x17f0 */
 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101,   /* 0x1800 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32,   /* 0x1810 */
 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1820 */
 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32,   /* 0x1830 */
 32, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102,   /* 0x1840 */
 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32,   /* 0x1850 */
 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32, 32,   /* 0x1860 */
 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1870 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1880 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1890 */
 48, 48, 48, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x18a0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x18b0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 78, 82, 86, 95,   /* 0x18c0 */
 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x18d0 */
 54, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x18e0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x18f0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52,100,   /* 0x1900 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1910 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 78,   /* 0x1920 */
 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1930 */
 48, 48, 48, 98, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1940 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1950 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1960 */
 48, 98, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1970 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x1980 */
 79, 78, 76, 89, 10, 32, 32, 51, 32, 78, 82, 86, 50, 68, 32, 32,   /* 0x1990 */
 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 57,101, 32,   /* 0x19a0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x19b0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x19c0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54, 97, 32, 32, 50,   /* 0x19d0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x19e0 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x19f0 */
 32, 52, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1a00 */
 32, 48, 48, 48, 48, 48, 48, 57, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1a10 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1a20 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1a30 */
 48, 48, 48, 48, 50, 48, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1a40 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x1a50 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 76, 90, 77,   /* 0x1a60 */
 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x1a70 */
 48, 54, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1a80 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1a90 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 57,   /* 0x1aa0 */
 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x1ab0 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x1ac0 */
 76, 89, 10, 32, 32, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x1ad0 */
 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,102, 55, 32, 32, 48,   /* 0x1ae0 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1af0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1b00 */
 48, 32, 32, 48, 48, 48, 48, 48, 50,102, 99, 32, 32, 50, 42, 42,   /* 0x1b10 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x1b20 */
 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95, 68,   /* 0x1b30 */
 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,102, 55,   /* 0x1b40 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1b50 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1b60 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 99,102, 51, 32, 32,   /* 0x1b70 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x1b80 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 76, 90, 77,   /* 0x1b90 */
 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x1ba0 */
 48, 49, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1bb0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1bc0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 54,101,   /* 0x1bd0 */
 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x1be0 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32,   /* 0x1bf0 */
 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x1c00 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1c10 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1c20 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1c30 */
 49, 54,102,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1c40 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x1c50 */
 49, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32,   /* 0x1c60 */
 32, 48, 48, 48, 48, 48, 48, 51, 97, 32, 32, 48, 48, 48, 48, 48,   /* 0x1c70 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1c80 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1c90 */
 48, 48, 48, 49, 54,102,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1ca0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x1cb0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 69, 76, 70,   /* 0x1cc0 */
 77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x1cd0 */
 48, 56, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ce0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1cf0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 51,   /* 0x1d00 */
 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x1d10 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x1d20 */
 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58,   /* 0x1d30 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1d40 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72, 69,   /* 0x1d50 */
 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1d60 */
 48, 48, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48,   /* 0x1d70 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1d80 */
 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,   /* 0x1d90 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1da0 */
 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48,   /* 0x1db0 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1dc0 */
 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48,   /* 0x1dd0 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1de0 */
 69, 76, 70, 77, 65, 73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1df0 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1e00 */
 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,  9, 48, 48, 48, 48, 48,   /* 0x1e10 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77,   /* 0x1e20 */
 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e30 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76,   /* 0x1e40 */
 70, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e50 */
 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88,   /* 0x1e60 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e70 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,  9,   /* 0x1e80 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e90 */
 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ea0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x1eb0 */
 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ec0 */
 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,   /* 0x1ed0 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1ee0 */
 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48,   /* 0x1ef0 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,   /* 0x1f00 */
 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f10 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,   /* 0x1f20 */
 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f30 */
 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70,   /* 0x1f40 */
 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f50 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,   /* 0x1f60 */
 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f70 */
 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x1f80 */
 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f90 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,   /* 0x1fa0 */
 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1fb0 */
 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x1fc0 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1fd0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95,   /* 0x1fe0 */
 84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ff0 */
 48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 48,   /* 0x2000 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2010 */
103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,   /* 0x2020 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2030 */
 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x2040 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x2050 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2060 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 65, 68, 82, 77, 10, 48, 48,   /* 0x2070 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2080 */
 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,   /* 0x2090 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 69,   /* 0x20a0 */
 78, 77, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x20b0 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x20c0 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x20d0 */
 48, 48, 32, 74, 77, 80, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x20e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x20f0 */
 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2100 */
 48, 48, 48, 48, 48, 48, 48, 32, 65, 68, 82, 85, 10, 48, 48, 48,   /* 0x2110 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,   /* 0x2120 */
 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,   /* 0x2130 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 65, 68, 82,   /* 0x2140 */
 67, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2150 */
 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,   /* 0x2160 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2170 */
 48, 32, 76, 69, 78, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2180 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2190 */
 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x21a0 */
 48, 48, 48, 48, 48, 48, 32, 65, 68, 82, 88, 10, 10, 82, 69, 76,   /* 0x21b0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x21c0 */
 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10,   /* 0x21d0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x21e0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x21f0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x2200 */
 48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88, 56, 54, 95,   /* 0x2210 */
 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 76, 70, 77,   /* 0x2220 */
 65, 73, 78, 90, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2230 */
 48, 48, 48, 48, 48, 55, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x2240 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x2250 */
 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x2260 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x2270 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x2280 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2290 */
 97,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,   /* 0x22a0 */
 32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43, 48,120,   /* 0x22b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 49,   /* 0x22c0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,   /* 0x22d0 */
 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,   /* 0x22e0 */
 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 43, 48,120,102,   /* 0x22f0 */
102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,   /* 0x2300 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x2310 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58,   /* 0x2320 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2330 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2340 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x2350 */
 48, 48, 48, 48, 48, 48, 48, 48, 57, 53, 32, 82, 95, 88, 56, 54,   /* 0x2360 */
 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2370 */
 95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2380 */
 48, 48, 48, 48, 48, 48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x2390 */
 48, 48, 48, 48, 48, 48, 48, 53, 98, 32, 82, 95, 88, 56, 54, 95,   /* 0x23a0 */
 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 76, 70, 77,   /* 0x23b0 */
 65, 73, 78, 89, 43, 48,120,102,102,102,102,102,102,102,102,102,   /* 0x23c0 */
102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x23d0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x23e0 */
 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x23f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x2400 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x2410 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2420 */
 56, 97, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,   /* 0x2430 */
 32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43, 48,120,   /* 0x2440 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 49,   /* 0x2450 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,   /* 0x2460 */
 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,   /* 0x2470 */
 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 43, 48,120,102,   /* 0x2480 */
102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,   /* 0x2490 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x24a0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76,   /* 0x24b0 */
 70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,   /* 0x24c0 */
 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x24d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x24e0 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 32,   /* 0x24f0 */
 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,   /* 0x2500 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48,   /* 0x2510 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 48, 10,   /* 0x2520 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x2530 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78,   /* 0x2540 */
 89, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,   /* 0x2550 */
 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x2560 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x2570 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95,   /* 0x2580 */
 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,   /* 0x2590 */
 69, 76, 70, 77, 65, 73, 78, 90, 43, 48,120,102,102,102,102,102,   /* 0x25a0 */
102,102,102,102,102,102,102,102,102,102, 99, 10, 10, 82, 69, 76,   /* 0x25b0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x25c0 */
 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 90, 93, 58, 10,   /* 0x25d0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x25e0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x25f0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x2600 */
 48, 48, 48, 48, 48, 48, 48, 49, 51, 32, 82, 95, 88, 56, 54, 95,   /* 0x2610 */
 54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 65, 68, 82, 77,   /* 0x2620 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x2630 */
 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32,   /* 0x2640 */
 32, 32, 32, 32, 76, 69, 78, 77, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x2650 */
 48, 48, 48, 48, 48, 48, 48, 51, 52, 32, 82, 95, 88, 56, 54, 95,   /* 0x2660 */
 54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 74, 77, 80, 85,   /* 0x2670 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51,   /* 0x2680 */
 57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32,   /* 0x2690 */
 32, 32, 32, 32, 65, 68, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x26a0 */
 48, 48, 48, 48, 48, 48, 48, 51,101, 32, 82, 95, 88, 56, 54, 95,   /* 0x26b0 */
 54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 65, 68, 82, 67,   /* 0x26c0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,   /* 0x26d0 */
 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32,   /* 0x26e0 */
 32, 32, 32, 32, 76, 69, 78, 85, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x26f0 */
 48, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 88, 56, 54, 95,   /* 0x2700 */
 54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 65, 68, 82, 88,   /* 0x2710 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0x2720 */
102, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,   /* 0x2730 */
 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 43, 48,120, 48,   /* 0x2740 */
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100, 10    /* 0x2750 */
};
