/* arm-linux.kernel.vmlinux.h
   created from arm-linux.kernel.vmlinux.bin, 17091 (0x42c3) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_ARM_LINUX_KERNEL_VMLINUX_SIZE    17091
#define STUB_ARM_LINUX_KERNEL_VMLINUX_ADLER32 0x2af6ea3d
#define STUB_ARM_LINUX_KERNEL_VMLINUX_CRC32   0x12d16cc6

unsigned char stub_arm_linux_kernel_vmlinux[17091] = {
127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
180, 23,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
 29,  0, 26,  0,  2, 16,160,225,  0, 32,160,225, 14,  0,160,225,   /* 0x  30 */
  4,192, 33,229, 15, 32, 33,233,  0, 48,160,227,  1,208,160,225,   /* 0x  40 */
 20, 16,159,229,  4, 48, 45,229, 16, 48,159,229,  8, 48,141,229,   /* 0x  50 */
  8, 48,141,226,254,255,255,235, 14,  0,  0,234,  0,  0,  0,  0,   /* 0x  60 */
  0,  0,  0,  0,  0,  0, 80,227, 14,  0,  0, 26, 12,  0,157,229,   /* 0x  70 */
  8, 16,157,229,  0, 32,160,227,  0, 48,160,227,254,255,255,235,   /* 0x  80 */
 15,112,157,232,  3,  0,130,224, 14,240,160,225,255, 48,  3,226,   /* 0x  90 */
 80,  0, 83,227, 81,  0, 83,227, 14,240,160, 17, 33, 17,176,225,   /* 0x  a0 */
  0,  0, 80, 19, 14,240,160,  1,  1, 16, 65,226,  1, 33,144,231,   /* 0x  b0 */
 15, 52,  2,226, 11,  4, 83,227, 12,  0,  0, 26,255, 52,  2,226,   /* 0x  c0 */
  1, 32, 66,224,255, 36,194,227,  3, 32,130,225,  1, 33,128,231,   /* 0x  d0 */
  0,  0, 81,227,  2,  0,  0, 26, 14,240,160,225,  0, 16,129,224,   /* 0x  e0 */
 62, 64, 45,233,  0, 80,224,227,  2, 65,160,227, 23,  0,  0,234,   /* 0x  f0 */
 26,  0,189,232,  1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,   /* 0x 100 */
 48,128,189,232,  4, 64,148,224, 14,240,160, 17,  1, 64,208,228,   /* 0x 110 */
  4, 64,164,224,  4, 76,176,225, 14,240,160,225,  1, 16,160,227,   /* 0x 120 */
 14,192,160,225,  8,  0,  0,235,  1, 16,177,224,  8,  0,  0,235,   /* 0x 130 */
 16,  0,  0, 58, 12,240,160,225,  1, 48,208,228,  1, 48,194,228,   /* 0x 140 */
  8,  0,  0,235, 21,  0,  0, 42, 14,  0,  0,235,  3, 48, 81,226,   /* 0x 150 */
  0, 16,160,227, 33,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,   /* 0x 160 */
  5, 80,240,225,  3,  0,  0, 10,  8,  0,  0,235,  1, 16,177,224,   /* 0x 170 */
  8,  0,  0,235,  1, 16,177,224, 40,  0,  0, 26, 14,  0,  0,235,   /* 0x 180 */
  2, 16,129,226, 13, 12,117,227,  1, 16,129, 50,  5, 48,210,231,   /* 0x 190 */
  1, 16, 81,226,  1, 48,194,228, 42,  0,  0, 42, 23,  0,  0,234,   /* 0x 1a0 */
252, 64, 45,233,  0,112,129,224,  0, 80,224,227,  2, 65,160,227,   /* 0x 1b0 */
 14,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,  3, 32, 66,224,   /* 0x 1c0 */
  0, 32,132,229,240,128,189,232,  1, 64,208,228,  4, 64,164,224,   /* 0x 1d0 */
  4, 76,176,225, 14,240,160,225,  1, 48,208,228,  1, 48,194,228,   /* 0x 1e0 */
  4, 64,148,224,  8,  0,  0, 11, 12,  0,  0, 42,  1, 16,160,227,   /* 0x 1f0 */
 23,  0,  0,234,  1, 16, 65,226,  4, 64,148,224,  8,  0,  0, 11,   /* 0x 200 */
  1, 16,177,224,  4, 64,148,224,  8,  0,  0, 11,  1, 16,177,224,   /* 0x 210 */
  4, 64,148,224,  8,  0,  0, 11, 19,  0,  0, 58,  3, 48, 81,226,   /* 0x 220 */
  0, 16,160,227, 38,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,   /* 0x 230 */
  5, 80,240,225,  3,  0,  0, 10,197, 80,176,225, 40,  0,  0,234,   /* 0x 240 */
  4, 64,148,224,  8,  0,  0, 11,  1, 16,177,224,  4, 64,148,224,   /* 0x 250 */
  8,  0,  0, 11,  1, 16,177,224, 53,  0,  0, 26,  1, 16,160,227,   /* 0x 260 */
  4, 64,148,224,  8,  0,  0, 11,  1, 16,177,224,  4, 64,148,224,   /* 0x 270 */
  8,  0,  0, 11, 46,  0,  0, 58,  2, 16,129,226,  1, 16,129,226,   /* 0x 280 */
  5, 12,117,227,  1, 16,129, 50,  0, 48,210,229,  5, 48,210,231,   /* 0x 290 */
  1, 48,194,228,  1, 16, 81,226, 57,  0,  0, 26, 14,  0,  0,234,   /* 0x 2a0 */
252, 64, 45,233,  0,112,129,224,  0, 80,224,227,  2, 65,160,227,   /* 0x 2b0 */
 14,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,  3, 32, 66,224,   /* 0x 2c0 */
  0, 32,132,229,240,128,189,232,  1, 64,208,228,  4, 64,164,224,   /* 0x 2d0 */
  4, 76,176,225, 14,240,160,225,  1, 48,208,228,  1, 48,194,228,   /* 0x 2e0 */
  4, 64,148,224,  8,  0,  0, 11, 12,  0,  0, 42,  1, 16,160,227,   /* 0x 2f0 */
 23,  0,  0,234,  1, 16, 65,226,  4, 64,148,224,  8,  0,  0, 11,   /* 0x 300 */
  1, 16,161,224,  4, 64,148,224,  8,  0,  0, 11,  1, 16,161,224,   /* 0x 310 */
  4, 64,148,224,  8,  0,  0, 11, 19,  0,  0, 58,  3, 48, 81,226,   /* 0x 320 */
  0, 16,160,227, 39,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,   /* 0x 330 */
  5, 80,240,225,  3,  0,  0, 10,197, 80,176,225, 54,  0,  0, 42,   /* 0x 340 */
 42,  0,  0,234,  4, 64,148,224,  8,  0,  0, 11, 54,  0,  0, 42,   /* 0x 350 */
  1, 16,160,227,  4, 64,148,224,  8,  0,  0, 11, 54,  0,  0, 42,   /* 0x 360 */
  4, 64,148,224,  8,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,   /* 0x 370 */
  8,  0,  0, 11, 46,  0,  0, 58,  4, 16,129,226, 58,  0,  0,234,   /* 0x 380 */
  4, 64,148,224,  8,  0,  0, 11,  1, 16,161,224,  2, 16,129,226,   /* 0x 390 */
  5, 12,117,227,  1, 16,129, 50,  1, 48,130,224,  1, 48, 83,229,   /* 0x 3a0 */
  5, 48,210,231,  1, 48,194,228,  1, 16, 81,226, 62,  0,  0, 26,   /* 0x 3b0 */
 14,  0,  0,234,  0,192,221,229, 14,  0, 92,227,254,255,255, 26,   /* 0x 3c0 */
  0, 72, 45,233,  0,176,208,229,  6,204,160,227,171,177,160,225,   /* 0x 3d0 */
 28,203,160,225, 13,176,160,225, 58,205,140,226, 12,208, 77,224,   /* 0x 3e0 */
  0,192,147,229,  8, 48,141,229,  4,192,141,229,  0, 32,141,229,   /* 0x 3f0 */
 12, 48,141,226,  0,192,160,227,  4,192,131,228, 11,  0, 83,225,   /* 0x 400 */
 15,  0,  0, 26, 12, 48,141,226,  2, 32, 65,226,  0, 16,160,225,   /* 0x 410 */
  1,192,209,228,  7,192, 12,226, 18,192,205,229,  1,192,209,228,   /* 0x 420 */
 44,  2,160,225, 17,  0,205,229, 15,192, 12,226, 16,192,205,229,   /* 0x 430 */
 16,  0,141,226, 33,  0,  0,235, 11,208,160,225,  0,136,189,232,   /* 0x 440 */
240, 79, 45,233, 48,208, 77,226,  0, 48,141,229,  0, 48,208,229,   /* 0x 450 */
  2, 80,208,229,  1,224,208,229,  0,192,157,229, 20, 48,141,229,   /* 0x 460 */
 92, 48,157,229,  0, 64,160,227,  0, 64,140,229,  0, 64,131,229,   /* 0x 470 */
 20,192,157,229,  1, 48,208,229,  3, 48,140,224,  3,204,160,227,   /* 0x 480 */
 28,195,160,225,  1, 48,160,227, 19,238,160,225, 19, 53,160,225,   /* 0x 490 */
115,206,140,226,  1, 48, 67,226,  1,224, 78,226,  4,  0,128,226,   /* 0x 4a0 */
  6,192,140,226,  4, 16,141,229, 12, 48,141,229, 16,224,141,229,   /* 0x 4b0 */
  8,  0,141,229, 31,  0,  0,234,  8,  0,157,229,  1, 27,160,227,   /* 0x 4c0 */
176, 16,131,225, 12,  0, 84,225,132, 48,160,225,  1, 64,132,226,   /* 0x 4d0 */
 28,  0,  0, 26,  4, 48,157,229,  0, 96,160,227,  2,144,131,224,   /* 0x 4e0 */
  3,224,160,225,  6, 32,160,225,  4, 80,157,229,  9, 48,101,224,   /* 0x 4f0 */
  3,  0, 82,225,  1,224,142,226, 73,  2,  0, 10,  5, 48,210,231,   /* 0x 500 */
  1, 32,130,226,  5,  0, 82,227,  6,100,131,225, 40,  0,  0, 26,   /* 0x 510 */
  0,176,160,227,  1,192,160,227, 11,112,160,225,  0,  0,224,227,   /* 0x 520 */
 44,192,141,229, 24,176,141,229, 28,192,141,229, 32,192,141,229,   /* 0x 530 */
 36,192,141,229, 57,  2,  0,234,255,132,224,227,  8,  0, 80,225,   /* 0x 540 */
 68,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x 550 */
  0,  4,160,225,  6,100,131,225, 12, 16,157,229, 24, 32,157,229,   /* 0x 560 */
  1,160, 11,224,  2, 18,160,225,  1, 48,138,224,131, 80,160,225,   /* 0x 570 */
  8, 48,157,229,181,192,147,225,160, 53,160,225,156,  3,  4,224,   /* 0x 580 */
  4,  0, 86,225,185,  0,  0, 42, 20,  0,157,229,  8, 48, 96,226,   /* 0x 590 */
 87, 51,160,225, 16, 16,157,229,  1, 32, 11,224, 18, 48,131,224,   /* 0x 5a0 */
  8,  0,157,229,  6, 44,160,227,147,  2, 34,224, 24, 16,157,229,   /* 0x 5b0 */
  2, 59,108,226,  6,  0, 81,227,195, 50,140,224,230,142,130,226,   /* 0x 5c0 */
181, 48,128,225, 12,128,136,226,  4,  0,160,209,  1, 16,160,211,   /* 0x 5d0 */
164,  0,  0,218, 44, 32,157,229, 84, 80,157,229, 11, 48, 98,224,   /* 0x 5e0 */
  3,112,213,231,  4,  0,160,225,  1, 16,160,227,135,112,160,225,   /* 0x 5f0 */
  1, 92,  7,226,129,160,160,225,133, 48,136,224, 10, 48,131,224,   /* 0x 600 */
  1,  4, 80,227,  2, 76,131,226,  1,192,129,226,119,  0,  0, 42,   /* 0x 610 */
  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x 620 */
  6,100,131,225,176, 48,212,225,160, 37,160,225, 12, 16,129,224,   /* 0x 630 */
147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,   /* 0x 640 */
163, 50, 67,224,135,  0,  0, 42,  0,  0, 85,227, 12,  0,160,225,   /* 0x 650 */
176, 32,196,225, 10, 16,160,225,140,  0,  0, 10, 12,  0,160,225,   /* 0x 660 */
164,  0,  0,234,  0,  0, 85,227,176, 48,196,225,  6, 96,108,224,   /* 0x 670 */
  0,  0,108,224,164,  0,  0, 10,255,  0, 81,227,168,  0,  0,202,   /* 0x 680 */
105,  0,  0,234,  1,  4, 80,227,  3, 16,129,224,151,  0,  0, 42,   /* 0x 690 */
  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x 6a0 */
  6,100,131,225,180, 48,152,225,160, 37,160,225,147,  2, 12,224,   /* 0x 6b0 */
  2, 43, 99,226, 12,  0, 86,225,163, 82, 67,224,194, 50,131,224,   /* 0x 6c0 */
180, 48,136, 49,180, 80,136, 33,  0,  0,108,224,  4, 16,160, 49,   /* 0x 6d0 */
 12,  0,160, 49,  6, 96,108, 32,255,  0, 81,227,129, 64,160,225,   /* 0x 6e0 */
  1, 48,129,226,143,  0,  0,218, 24,192,157,229,255,112,  1,226,   /* 0x 6f0 */
  3,  0, 92,227, 84, 16,157,229,  0, 32,160,211, 11,112,193,231,   /* 0x 700 */
  1,176,139,226, 24, 32,141,213, 57,  2,  0,218, 24, 48,157,229,   /* 0x 710 */
  9,  0, 83,227, 24, 80,157,197,  3, 48, 67,210,  6, 80, 69,194,   /* 0x 720 */
 24, 48,141,213, 24, 80,141,197, 57,  2,  0,234,172, 50, 76,224,   /* 0x 730 */
  0, 32,100,224,  8,192,157,229,  8,  0, 82,225,181, 48,140,225,   /* 0x 740 */
  6, 96,100,224,197,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,   /* 0x 750 */
  1, 48,222,228,  2, 36,160,225,  6,100,131,225,  8,  0,157,229,   /* 0x 760 */
 24, 48,157,229,131,112,128,224,  6, 13,135,226,176,192,208,225,   /* 0x 770 */
162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,225,  0,  0, 42,   /* 0x 780 */
 24, 32,157,229,  8, 80,157,229,  6,  0, 82,227,  2, 59,108,226,   /* 0x 790 */
102, 30,133,226,  3, 32,160,195, 32, 80,157,229,  0, 32,160,211,   /* 0x 7a0 */
195, 50,140,224, 24, 32,141,229, 28,192,157,229, 44, 32,157,229,   /* 0x 7b0 */
 36, 80,141,229,  4, 16,129,226,  4, 80,160,225, 32,192,141,229,   /* 0x 7c0 */
 28, 32,141,229,176, 48,192,225, 98,  1,  0,234,  2, 32,100,224,   /* 0x 7d0 */
172, 50, 76,224,  8,  0, 82,225,176, 48,192,225,  6, 96,100,224,   /* 0x 7e0 */
236,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x 7f0 */
  2, 36,160,225,  6,100,131,225,102, 95,135,226,176,192,213,225,   /* 0x 800 */
162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 26,  1,  0, 42,   /* 0x 810 */
  2, 59,108,226,195, 50,140,224,  8,  0, 84,225,176, 48,197,225,   /* 0x 820 */
252,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x 830 */
  4, 68,160,225,  6,100,131,225,  8, 80,157,229,129, 48,133,224,   /* 0x 840 */
138, 48,131,224, 30, 30,131,226,176,192,209,225,164, 53,160,225,   /* 0x 850 */
156,  3,  2,224,  2,  0, 86,225,  6, 96, 98, 32,172, 50, 76, 32,   /* 0x 860 */
  4, 80, 98, 32, 50,  1,  0, 42,  2, 59,108,226,195, 50,140,224,   /* 0x 870 */
  0,  0, 91,227,176, 48,193,225, 73,  2,  0, 10, 44,192,157,229,   /* 0x 880 */
 24, 16,157,229, 84,  0,157,229, 11, 48,108,224,  3,112,208,231,   /* 0x 890 */
  6,  0, 81,227, 11, 16,160,195,  9, 16,160,211, 24, 16,141,229,   /* 0x 8a0 */
 11,112,192,231,  2,  0,160,225,  1,176,139,226, 57,  2,  0,234,   /* 0x 8b0 */
  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,176, 48,197,225,   /* 0x 8c0 */
  6, 96,100,224, 37,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,   /* 0x 8d0 */
  1, 48,222,228,  2, 36,160,225,  6,100,131,225, 27, 30,135,226,   /* 0x 8e0 */
176,192,209,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,   /* 0x 8f0 */
 52,  1,  0, 42, 44, 80,157,229,  2, 59,108,226, 28, 32,157,229,   /* 0x 900 */
195, 50,140,224, 28, 80,141,229,  4, 80,160,225, 44, 32,141,229,   /* 0x 910 */
176, 48,193,225, 90,  1,  0,234,  2, 32,100,224,172, 50, 76,224,   /* 0x 920 */
  8,  0, 82,225,176, 48,193,225,  6, 96,100,224, 63,  1,  0,138,   /* 0x 930 */
  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,   /* 0x 940 */
  6,100,131,225,114, 31,135,226,176,192,209,225,162, 53,160,225,   /* 0x 950 */
156,  3,  4,224,  4,  0, 86,225, 78,  1,  0, 42,  2, 59,108,226,   /* 0x 960 */
 32, 32,157,229,195, 50,140,224, 44,  0,157,229, 28,192,157,229,   /* 0x 970 */
  4, 80,160,225, 32,192,141,229, 28,  0,141,229, 49,  1,  0,234,   /* 0x 980 */
172, 50, 76,224,176, 48,193,225, 44,192,157,229, 32, 16,141,226,   /* 0x 990 */
 10,  0,145,232,  2, 80,100,224, 28, 32,157,229, 36, 16,141,229,   /* 0x 9a0 */
 32, 32,141,229, 28,192,141,229, 44, 48,141,229,  6, 96,100,224,   /* 0x 9b0 */
 24, 32,157,229,  8,  0,157,229,  6,  0, 82,227, 11, 32,160,195,   /* 0x 9c0 */
  8, 32,160,211,166, 30,128,226, 24, 32,141,229,  8, 16,129,226,   /* 0x 9d0 */
255,116,224,227,  7,  0, 85,225,106,  1,  0,138,  9,  0, 94,225,   /* 0x 9e0 */
 73,  2,  0, 10,  1, 48,222,228,  5, 84,160,225,  6,100,131,225,   /* 0x 9f0 */
176,192,209,225,165, 53,160,225,156,  3,  4,224,  4,  0, 86,225,   /* 0x a00 */
120,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,195, 50,140,224,   /* 0x a10 */
  4, 80,130,226,  4,  0,160,225,  3,160,160,227,  0,128,160,227,   /* 0x a20 */
176, 48,193,225,152,  1,  0,234,  5, 32,100,224,172, 50, 76,224,   /* 0x a30 */
  7,  0, 82,225,  6, 96,100,224,176, 48,193,225,131,  1,  0,138,   /* 0x a40 */
  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,   /* 0x a50 */
  6,100,131,225,178,192,209,225,162, 53,160,225,156,  3,  4,224,   /* 0x a60 */
  4,  0, 86,225,145,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,   /* 0x a70 */
195, 50,140,224, 65, 95,130,226,  4,  0,160,225,  3,160,160,227,   /* 0x a80 */
  8,128,160,227,178, 48,193,225,152,  1,  0,234,172, 50, 76,224,   /* 0x a90 */
178, 48,193,225,  6, 96,100,224,  2,  0,100,224,129, 95,129,226,   /* 0x aa0 */
  8,160,160,227, 16,128,160,227, 10,112,160,225,  1, 16,160,227,   /* 0x ab0 */
  1, 48,129,226,  1,  4, 80,227,129, 64,160,225,  3, 16,129,224,   /* 0x ac0 */
164,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,   /* 0x ad0 */
  1, 48,222,228,  6,100,131,225,180, 48,149,225,160, 37,160,225,   /* 0x ae0 */
147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,   /* 0x af0 */
163, 50, 67,224,  0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,   /* 0x b00 */
180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,  1,112, 87,226,   /* 0x b10 */
154,  1,  0, 26,  1, 32,160,227, 18, 58, 65,224, 24, 80,157,229,   /* 0x b20 */
  8, 48,131,224,  3,  0, 85,227, 40, 48,141,229, 36,  2,  0,202,   /* 0x b30 */
  8,192,157,229,  3,  0, 83,227,  3, 48,160,163,131, 51,140,224,   /* 0x b40 */
 54, 94,131,226,  2,112,160,225,  6,128,160,227,  1, 48,135,226,   /* 0x b50 */
  1,  4, 80,227,135, 64,160,225,  3,112,135,224,203,  1,  0, 42,   /* 0x b60 */
  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x b70 */
  6,100,131,225,180, 48,149,225,160, 37,160,225,147,  2, 12,224,   /* 0x b80 */
  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,   /* 0x b90 */
  0,  0,108,224,  4,112,160, 49, 12,  0,160, 49,180, 32,133, 49,   /* 0x ba0 */
  6, 96,108, 32,180, 48,133, 33,  1,128, 88,226,193,  1,  0, 26,   /* 0x bb0 */
 64, 32, 71,226,  3,  0, 82,227,  2, 80,160,209, 30,  2,  0,218,   /* 0x bc0 */
194, 64,160,225, 13,  0, 82,227,  1, 48,  2,226,  1,112, 68,226,   /* 0x bd0 */
  2,192,131,227,  5, 64, 68,194,  8, 32,160,193,237,  1,  0,202,   /* 0x be0 */
 28, 87,160,225,  8, 16,157,229,133, 48,129,224,130, 48, 67,224,   /* 0x bf0 */
 85, 78,131,226, 14, 64,132,226,  1,  2,  0,234,  1,  4, 80,227,   /* 0x c00 */
  1, 32,130,226,245,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225,   /* 0x c10 */
 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,160,  0,160,225,   /* 0x c20 */
  0,  0, 86,225,140,192,160,225,  6, 96, 96, 32,  1,192,140, 35,   /* 0x c30 */
  4,  0, 82,225,237,  1,  0, 26,  8, 32,157,229, 25, 77,130,226,   /* 0x c40 */
  4, 64,132,226, 12, 82,160,225,  4,112,160,227,  1,160,160,227,   /* 0x c50 */
 10,128,160,225,  1,  4, 80,227,136, 16,160,225,  1,192,136,226,   /* 0x c60 */
 12,  2,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,   /* 0x c70 */
  1, 48,222,228,  6,100,131,225,177, 48,148,225,160, 37,160,225,   /* 0x c80 */
 12,128,136,224,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,   /* 0x c90 */
194, 34,131,224,163, 50, 67,224, 10, 80,133, 33,  1,128,160, 49,   /* 0x ca0 */
 12,  0,160, 49,177, 32,132, 49,177, 48,132, 33,  6, 96,108, 32,   /* 0x cb0 */
  0,  0,108, 32,  1,112, 87,226,138,160,160,225,  3,  2,  0, 26,   /* 0x cc0 */
  1, 80,149,226, 44, 80,141,229, 60,  2,  0, 10, 24, 48,157,229,   /* 0x cd0 */
  7, 48,131,226, 24, 48,141,229, 44, 80,157,229, 11,  0, 85,225,   /* 0x ce0 */
 73,  2,  0,138, 40,192,157,229, 84, 16,157,229, 11, 48,101,224,   /* 0x cf0 */
  2, 32,140,226,  3, 64,129,224, 11,192,129,224,  1, 32, 82,226,   /* 0x d00 */
 88, 80,157,229,  0, 48,160,  3,  1, 48,160, 19,  1,176,139,226,   /* 0x d10 */
  5,  0, 91,225,  0, 48,160, 35,  1, 48,  3, 50,  1,112,212,228,   /* 0x d20 */
  0,  0, 83,227,  1,112,204,228, 45,  2,  0, 26, 88,192,157,229,   /* 0x d30 */
 12,  0, 91,225, 60,  0,  0, 58,  1,  4, 80,227, 65,  2,  0, 42,   /* 0x d40 */
  9,  0, 94,225, 73,  2,  0, 10,  1,224,142,226,  4,  0,157,229,   /* 0x d50 */
  0, 16,157,229, 92, 32,157,229, 14, 48, 96,224,  0,  0,160,227,   /* 0x d60 */
  0, 48,129,229,  0,176,130,229, 74,  2,  0,234,  1,  0,160,227,   /* 0x d70 */
 48,208,141,226,240,143,189,232,240, 79, 45,233, 48,208, 77,226,   /* 0x d80 */
  0, 48,141,229,  0, 48,208,229,  2, 80,208,229,  1,224,208,229,   /* 0x d90 */
  0,192,157,229, 20, 48,141,229, 92, 48,157,229,  0, 64,160,227,   /* 0x da0 */
  0, 64,140,229,  0, 64,131,229, 20,192,157,229,  1, 48,208,229,   /* 0x db0 */
  3, 48,140,224,  3,204,160,227, 28,195,160,225,  1, 48,160,227,   /* 0x dc0 */
 19,238,160,225, 19, 53,160,225,115,206,140,226,  1, 48, 67,226,   /* 0x dd0 */
  1,224, 78,226,  4,  0,128,226,  6,192,140,226,  4, 16,141,229,   /* 0x de0 */
 12, 48,141,229, 16,224,141,229,  8,  0,141,229, 31,  0,  0,234,   /* 0x df0 */
  8,  0,157,229,  1, 27,160,227,176, 16,131,225, 12,  0, 84,225,   /* 0x e00 */
132, 48,160,225,  1, 64,132,226, 28,  0,  0, 26,  4, 48,157,229,   /* 0x e10 */
  0, 96,160,227,  2,144,131,224,  3,224,160,225,  6, 32,160,225,   /* 0x e20 */
  4, 80,157,229,  9, 48,101,224,  3,  0, 82,225,  1,224,142,226,   /* 0x e30 */
 73,  2,  0, 10,  5, 48,210,231,  1, 32,130,226,  5,  0, 82,227,   /* 0x e40 */
  6,100,131,225, 40,  0,  0, 26,  0,176,160,227,  1,192,160,227,   /* 0x e50 */
 11,112,160,225,  0,  0,224,227, 44,192,141,229, 24,176,141,229,   /* 0x e60 */
 28,192,141,229, 32,192,141,229, 36,192,141,229, 57,  2,  0,234,   /* 0x e70 */
255,132,224,227,  8,  0, 80,225, 68,  0,  0,138,  9,  0, 94,225,   /* 0x e80 */
 73,  2,  0, 10,  1, 48,222,228,  0,  4,160,225,  6,100,131,225,   /* 0x e90 */
 12, 16,157,229, 24, 32,157,229,  1,160, 11,224,  2, 18,160,225,   /* 0x ea0 */
  1, 48,138,224,131, 80,160,225,  8, 48,157,229,181,192,147,225,   /* 0x eb0 */
160, 53,160,225,156,  3,  4,224,  4,  0, 86,225,185,  0,  0, 42,   /* 0x ec0 */
 20,  0,157,229,  8, 48, 96,226, 87, 51,160,225, 16, 16,157,229,   /* 0x ed0 */
  1, 32, 11,224, 18, 48,131,224,  8,  0,157,229,  6, 44,160,227,   /* 0x ee0 */
147,  2, 34,224, 24, 16,157,229,  2, 59,108,226,  6,  0, 81,227,   /* 0x ef0 */
195, 50,140,224,230,142,130,226,181, 48,128,225, 12,128,136,226,   /* 0x f00 */
  4,  0,160,209,  1, 16,160,211,164,  0,  0,218, 44, 32,157,229,   /* 0x f10 */
 84, 80,157,229, 11, 48, 98,224,  3,112,213,231,  4,  0,160,225,   /* 0x f20 */
  1, 16,160,227,135,112,160,225,  1, 92,  7,226,129,160,160,225,   /* 0x f30 */
133, 48,136,224, 10, 48,131,224,  1,  4, 80,227,  2, 76,131,226,   /* 0x f40 */
  1,192,129,226,119,  0,  0, 42,  9,  0, 94,225,  0,  4,160,225,   /* 0x f50 */
 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,176, 48,212,225,   /* 0x f60 */
160, 37,160,225, 12, 16,129,224,147,  2, 12,224,  2, 43, 99,226,   /* 0x f70 */
 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,135,  0,  0, 42,   /* 0x f80 */
  0,  0, 85,227, 12,  0,160,225,176, 32,196,225, 10, 16,160,225,   /* 0x f90 */
140,  0,  0, 10, 12,  0,160,225,164,  0,  0,234,  0,  0, 85,227,   /* 0x fa0 */
176, 48,196,225,  6, 96,108,224,  0,  0,108,224,164,  0,  0, 10,   /* 0x fb0 */
255,  0, 81,227,168,  0,  0,202,105,  0,  0,234,  1,  4, 80,227,   /* 0x fc0 */
  3, 16,129,224,151,  0,  0, 42,  9,  0, 94,225,  0,  4,160,225,   /* 0x fd0 */
 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,180, 48,152,225,   /* 0x fe0 */
160, 37,160,225,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,   /* 0x ff0 */
163, 82, 67,224,194, 50,131,224,180, 48,136, 49,180, 80,136, 33,   /* 0x1000 */
  0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,  6, 96,108, 32,   /* 0x1010 */
255,  0, 81,227,129, 64,160,225,  1, 48,129,226,143,  0,  0,218,   /* 0x1020 */
 24,192,157,229,255,112,  1,226,  3,  0, 92,227, 84, 16,157,229,   /* 0x1030 */
  0, 32,160,211, 11,112,193,231,  1,176,139,226, 24, 32,141,213,   /* 0x1040 */
 57,  2,  0,218, 24, 48,157,229,  9,  0, 83,227, 24, 80,157,197,   /* 0x1050 */
  3, 48, 67,210,  6, 80, 69,194, 24, 48,141,213, 24, 80,141,197,   /* 0x1060 */
 57,  2,  0,234,172, 50, 76,224,  0, 32,100,224,  8,192,157,229,   /* 0x1070 */
  8,  0, 82,225,181, 48,140,225,  6, 96,100,224,197,  0,  0,138,   /* 0x1080 */
  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,   /* 0x1090 */
  6,100,131,225,  8,  0,157,229, 24, 48,157,229,131,112,128,224,   /* 0x10a0 */
  6, 13,135,226,176,192,208,225,162, 53,160,225,156,  3,  4,224,   /* 0x10b0 */
  4,  0, 86,225,225,  0,  0, 42, 24, 32,157,229,  8, 80,157,229,   /* 0x10c0 */
  6,  0, 82,227,  2, 59,108,226,102, 30,133,226,  3, 32,160,195,   /* 0x10d0 */
 32, 80,157,229,  0, 32,160,211,195, 50,140,224, 24, 32,141,229,   /* 0x10e0 */
 28,192,157,229, 44, 32,157,229, 36, 80,141,229,  4, 16,129,226,   /* 0x10f0 */
  4, 80,160,225, 32,192,141,229, 28, 32,141,229,176, 48,192,225,   /* 0x1100 */
 98,  1,  0,234,  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,   /* 0x1110 */
176, 48,192,225,  6, 96,100,224,236,  0,  0,138,  9,  0, 94,225,   /* 0x1120 */
 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,   /* 0x1130 */
102, 95,135,226,176,192,213,225,162, 53,160,225,156,  3,  4,224,   /* 0x1140 */
  4,  0, 86,225, 26,  1,  0, 42,  2, 59,108,226,195, 50,140,224,   /* 0x1150 */
  8,  0, 84,225,176, 48,197,225,252,  0,  0,138,  9,  0, 94,225,   /* 0x1160 */
 73,  2,  0, 10,  1, 48,222,228,  4, 68,160,225,  6,100,131,225,   /* 0x1170 */
  8, 80,157,229,129, 48,133,224,138, 48,131,224, 30, 30,131,226,   /* 0x1180 */
176,192,209,225,164, 53,160,225,156,  3,  2,224,  2,  0, 86,225,   /* 0x1190 */
  6, 96, 98, 32,172, 50, 76, 32,  4, 80, 98, 32, 50,  1,  0, 42,   /* 0x11a0 */
  2, 59,108,226,195, 50,140,224,  0,  0, 91,227,176, 48,193,225,   /* 0x11b0 */
 73,  2,  0, 10, 44,192,157,229, 24, 16,157,229, 84,  0,157,229,   /* 0x11c0 */
 11, 48,108,224,  3,112,208,231,  6,  0, 81,227, 11, 16,160,195,   /* 0x11d0 */
  9, 16,160,211, 24, 16,141,229, 11,112,192,231,  2,  0,160,225,   /* 0x11e0 */
  1,176,139,226, 57,  2,  0,234,  2, 32,100,224,172, 50, 76,224,   /* 0x11f0 */
  8,  0, 82,225,176, 48,197,225,  6, 96,100,224, 37,  1,  0,138,   /* 0x1200 */
  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,   /* 0x1210 */
  6,100,131,225, 27, 30,135,226,176,192,209,225,162, 53,160,225,   /* 0x1220 */
156,  3,  4,224,  4,  0, 86,225, 52,  1,  0, 42, 44, 80,157,229,   /* 0x1230 */
  2, 59,108,226, 28, 32,157,229,195, 50,140,224, 28, 80,141,229,   /* 0x1240 */
  4, 80,160,225, 44, 32,141,229,176, 48,193,225, 90,  1,  0,234,   /* 0x1250 */
  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,176, 48,193,225,   /* 0x1260 */
  6, 96,100,224, 63,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,   /* 0x1270 */
  1, 48,222,228,  2, 36,160,225,  6,100,131,225,114, 31,135,226,   /* 0x1280 */
176,192,209,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,   /* 0x1290 */
 78,  1,  0, 42,  2, 59,108,226, 32, 32,157,229,195, 50,140,224,   /* 0x12a0 */
 44,  0,157,229, 28,192,157,229,  4, 80,160,225, 32,192,141,229,   /* 0x12b0 */
 28,  0,141,229, 49,  1,  0,234,172, 50, 76,224,176, 48,193,225,   /* 0x12c0 */
 44,192,157,229, 32, 16,141,226, 10,  0,145,232,  2, 80,100,224,   /* 0x12d0 */
 28, 32,157,229, 36, 16,141,229, 32, 32,141,229, 28,192,141,229,   /* 0x12e0 */
 44, 48,141,229,  6, 96,100,224, 24, 32,157,229,  8,  0,157,229,   /* 0x12f0 */
  6,  0, 82,227, 11, 32,160,195,  8, 32,160,211,166, 30,128,226,   /* 0x1300 */
 24, 32,141,229,  8, 16,129,226,255,116,224,227,  7,  0, 85,225,   /* 0x1310 */
106,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x1320 */
  5, 84,160,225,  6,100,131,225,176,192,209,225,165, 53,160,225,   /* 0x1330 */
156,  3,  4,224,  4,  0, 86,225,120,  1,  0, 42, 10, 34,129,224,   /* 0x1340 */
  2, 59,108,226,195, 50,140,224,  4, 80,130,226,  4,  0,160,225,   /* 0x1350 */
  3,160,160,227,  0,128,160,227,176, 48,193,225,152,  1,  0,234,   /* 0x1360 */
  5, 32,100,224,172, 50, 76,224,  7,  0, 82,225,  6, 96,100,224,   /* 0x1370 */
176, 48,193,225,131,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,   /* 0x1380 */
  1, 48,222,228,  2, 36,160,225,  6,100,131,225,178,192,209,225,   /* 0x1390 */
162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,145,  1,  0, 42,   /* 0x13a0 */
 10, 34,129,224,  2, 59,108,226,195, 50,140,224, 65, 95,130,226,   /* 0x13b0 */
  4,  0,160,225,  3,160,160,227,  8,128,160,227,178, 48,193,225,   /* 0x13c0 */
152,  1,  0,234,172, 50, 76,224,178, 48,193,225,  6, 96,100,224,   /* 0x13d0 */
  2,  0,100,224,129, 95,129,226,  8,160,160,227, 16,128,160,227,   /* 0x13e0 */
 10,112,160,225,  1, 16,160,227,  1, 48,129,226,  1,  4, 80,227,   /* 0x13f0 */
129, 64,160,225,  3, 16,129,224,164,  1,  0, 42,  9,  0, 94,225,   /* 0x1400 */
  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,   /* 0x1410 */
180, 48,149,225,160, 37,160,225,147,  2, 12,224,  2, 43, 99,226,   /* 0x1420 */
 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,  0,  0,108,224,   /* 0x1430 */
  4, 16,160, 49, 12,  0,160, 49,180, 32,133, 49,  6, 96,108, 32,   /* 0x1440 */
180, 48,133, 33,  1,112, 87,226,154,  1,  0, 26,  1, 32,160,227,   /* 0x1450 */
 18, 58, 65,224, 24, 80,157,229,  8, 48,131,224,  3,  0, 85,227,   /* 0x1460 */
 40, 48,141,229, 36,  2,  0,202,  8,192,157,229,  3,  0, 83,227,   /* 0x1470 */
  3, 48,160,163,131, 51,140,224, 54, 94,131,226,  2,112,160,225,   /* 0x1480 */
  6,128,160,227,  1, 48,135,226,  1,  4, 80,227,135, 64,160,225,   /* 0x1490 */
  3,112,135,224,203,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225,   /* 0x14a0 */
 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,180, 48,149,225,   /* 0x14b0 */
160, 37,160,225,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,   /* 0x14c0 */
194, 34,131,224,163, 50, 67,224,  0,  0,108,224,  4,112,160, 49,   /* 0x14d0 */
 12,  0,160, 49,180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,   /* 0x14e0 */
  1,128, 88,226,193,  1,  0, 26, 64, 32, 71,226,  3,  0, 82,227,   /* 0x14f0 */
  2, 80,160,209, 30,  2,  0,218,194, 64,160,225, 13,  0, 82,227,   /* 0x1500 */
  1, 48,  2,226,  1,112, 68,226,  2,192,131,227,  5, 64, 68,194,   /* 0x1510 */
  8, 32,160,193,237,  1,  0,202, 28, 87,160,225,  8, 16,157,229,   /* 0x1520 */
133, 48,129,224,130, 48, 67,224, 85, 78,131,226, 14, 64,132,226,   /* 0x1530 */
  1,  2,  0,234,  1,  4, 80,227,  1, 32,130,226,245,  1,  0, 42,   /* 0x1540 */
  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x1550 */
  6,100,131,225,160,  0,160,225,  0,  0, 86,225,140,192,160,225,   /* 0x1560 */
  6, 96, 96, 32,  1,192,140, 35,  4,  0, 82,225,237,  1,  0, 26,   /* 0x1570 */
  8, 32,157,229, 25, 77,130,226,  4, 64,132,226, 12, 82,160,225,   /* 0x1580 */
  4,112,160,227,  1,160,160,227, 10,128,160,225,  1,  4, 80,227,   /* 0x1590 */
136, 16,160,225,  1,192,136,226, 12,  2,  0, 42,  9,  0, 94,225,   /* 0x15a0 */
  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,   /* 0x15b0 */
177, 48,148,225,160, 37,160,225, 12,128,136,224,147,  2, 12,224,   /* 0x15c0 */
  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,   /* 0x15d0 */
 10, 80,133, 33,  1,128,160, 49, 12,  0,160, 49,177, 32,132, 49,   /* 0x15e0 */
177, 48,132, 33,  6, 96,108, 32,  0,  0,108, 32,  1,112, 87,226,   /* 0x15f0 */
138,160,160,225,  3,  2,  0, 26,  1, 80,149,226, 44, 80,141,229,   /* 0x1600 */
 60,  2,  0, 10, 24, 48,157,229,  7, 48,131,226, 24, 48,141,229,   /* 0x1610 */
 44, 80,157,229, 11,  0, 85,225, 73,  2,  0,138, 40,192,157,229,   /* 0x1620 */
 84, 16,157,229, 11, 48,101,224,  2, 32,140,226,  3, 64,129,224,   /* 0x1630 */
 11,192,129,224,  1, 32, 82,226, 88, 80,157,229,  0, 48,160,  3,   /* 0x1640 */
  1, 48,160, 19,  1,176,139,226,  5,  0, 91,225,  0, 48,160, 35,   /* 0x1650 */
  1, 48,  3, 50,  1,112,212,228,  0,  0, 83,227,  1,112,204,228,   /* 0x1660 */
 45,  2,  0, 26, 88,192,157,229, 12,  0, 91,225, 60,  0,  0, 58,   /* 0x1670 */
  1,  4, 80,227, 65,  2,  0, 42,  9,  0, 94,225, 73,  2,  0, 10,   /* 0x1680 */
  1,224,142,226,  4,  0,157,229,  0, 16,157,229, 92, 32,157,229,   /* 0x1690 */
 14, 48, 96,224,  0,  0,160,227,  0, 48,129,229,  0,176,130,229,   /* 0x16a0 */
 74,  2,  0,234,  1,  0,160,227, 48,208,141,226,240,143,189,232,   /* 0x16b0 */
 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x16c0 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,   /* 0x16d0 */
116,109,112, 47, 97,114,109, 45,108,105,110,117,120, 46,107,101,   /* 0x16e0 */
114,110,101,108, 46,118,109,108,105,110,117,120, 46, 98,105,110,   /* 0x16f0 */
 58, 32, 32, 32, 32, 32,102,105,108,101, 32,102,111,114,109, 97,   /* 0x1700 */
116, 32,101,108,102, 51, 50, 45,108,105,116,116,108,101, 97,114,   /* 0x1710 */
109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120,   /* 0x1720 */
 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,   /* 0x1730 */
105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32,   /* 0x1740 */
 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,   /* 0x1750 */
101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,   /* 0x1760 */
103,115, 10, 32, 32, 48, 32, 76, 73, 78, 85, 88, 48, 48, 48, 32,   /* 0x1770 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 48,   /* 0x1780 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1790 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42,   /* 0x17a0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x17b0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49,   /* 0x17c0 */
 32, 76, 73, 78, 85, 88, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x17d0 */
 48, 48, 48, 48, 48, 49, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x17e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x17f0 */
 48, 48, 48, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1800 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x1810 */
 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 76, 73, 78, 85, 88,   /* 0x1820 */
 48, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1830 */
 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1840 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 48, 32,   /* 0x1850 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x1860 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 99,116,   /* 0x1870 */
111,107, 51, 50, 46, 48, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1880 */
 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1890 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x18a0 */
 57, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x18b0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52,   /* 0x18c0 */
 32, 99,116,111,107, 51, 50, 46, 53, 48, 32, 32, 32, 32, 32, 48,   /* 0x18d0 */
 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x18e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x18f0 */
 48, 48, 48, 97, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1900 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x1910 */
 32, 32, 53, 32, 99,116,111,107, 51, 50, 46, 53, 49, 32, 32, 32,   /* 0x1920 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48,   /* 0x1930 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1940 */
 48, 48, 48, 48, 48, 48, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1950 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x1960 */
 76, 89, 10, 32, 32, 54, 32, 99,116,111,107, 51, 50, 46, 49, 48,   /* 0x1970 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 52, 32, 32, 48,   /* 0x1980 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1990 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 56, 32, 32, 50, 42, 42,   /* 0x19a0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x19b0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55,   /* 0x19c0 */
 32, 76, 73, 78, 85, 88, 48, 51, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x19d0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x19e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x19f0 */
 48, 48, 48,101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1a00 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x1a10 */
 32, 32, 56, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32,   /* 0x1a20 */
 32, 32, 48, 48, 48, 48, 48, 48, 99, 52, 32, 32, 48, 48, 48, 48,   /* 0x1a30 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1a40 */
 48, 48, 48, 48, 48, 48,101, 99, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1a50 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x1a60 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 78, 82,   /* 0x1a70 */
 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1a80 */
 48, 49, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1a90 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,   /* 0x1aa0 */
 98, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x1ab0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x1ac0 */
 78, 76, 89, 10, 32, 49, 48, 32, 78, 82, 86, 50, 69, 32, 32, 32,   /* 0x1ad0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 49, 52, 32, 32,   /* 0x1ae0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1af0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 98, 48, 32, 32, 50, 42,   /* 0x1b00 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x1b10 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,   /* 0x1b20 */
 49, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32,   /* 0x1b30 */
 48, 48, 48, 48, 48, 48, 56, 99, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1b40 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1b50 */
 48, 48, 48, 51, 99, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x1b60 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x1b70 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 76, 90, 77, 65,   /* 0x1b80 */
 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,   /* 0x1b90 */
 51, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1ba0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 53, 48,   /* 0x1bb0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1bc0 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1bd0 */
 89, 10, 32, 49, 51, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x1be0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 51, 56, 32, 32, 48, 48,   /* 0x1bf0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1c00 */
 32, 32, 48, 48, 48, 48, 48,100, 56, 56, 32, 32, 50, 42, 42, 48,   /* 0x1c10 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x1c20 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32,   /* 0x1c30 */
 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48,   /* 0x1c40 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1c50 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1c60 */
 49, 54, 99, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1c70 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x1c80 */
 49, 53, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32,   /* 0x1c90 */
 32, 48, 48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1ca0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1cb0 */
 48, 48, 48, 49, 54, 99, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1cc0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1cd0 */
 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10,   /* 0x1ce0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x1cf0 */
 32, 76, 73, 78, 85, 88, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48,   /* 0x1d00 */
 48, 48, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10, 48, 48, 48, 48,   /* 0x1d10 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,   /* 0x1d20 */
107, 51, 50, 46, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1d30 */
 99,116,111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x1d40 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51,   /* 0x1d50 */
 50, 46, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,   /* 0x1d60 */
111,107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1d70 */
 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 51,   /* 0x1d80 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88,   /* 0x1d90 */
 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x1da0 */
 32, 32,100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48,   /* 0x1db0 */
 48, 48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,   /* 0x1dc0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,   /* 0x1dd0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10,   /* 0x1de0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x1df0 */
 32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1e00 */
 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x1e10 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,   /* 0x1e20 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,   /* 0x1e30 */
 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x1e40 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x1e50 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,   /* 0x1e60 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x1e70 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x1e80 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,   /* 0x1e90 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x1ea0 */
 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,   /* 0x1eb0 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,   /* 0x1ec0 */
 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x1ed0 */
 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 49, 48,  9,   /* 0x1ee0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48, 49,   /* 0x1ef0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x1f00 */
100, 32, 32, 76, 73, 78, 85, 88, 48, 50, 48,  9, 48, 48, 48, 48,   /* 0x1f10 */
 48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48, 50, 48, 10, 48, 48,   /* 0x1f20 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,   /* 0x1f30 */
116,111,107, 51, 50, 46, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f40 */
 48, 32, 99,116,111,107, 51, 50, 46, 53, 48, 10, 48, 48, 48, 48,   /* 0x1f50 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,   /* 0x1f60 */
107, 51, 50, 46, 53, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1f70 */
 99,116,111,107, 51, 50, 46, 53, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x1f80 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72,   /* 0x1f90 */
 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88,   /* 0x1fa0 */
 49, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1fb0 */
 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,   /* 0x1fc0 */
 48, 48, 48, 48, 48, 32, 77, 69, 84, 72, 79, 68, 10, 48, 48, 48,   /* 0x1fd0 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x1fe0 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 77,   /* 0x1ff0 */
 80, 82, 69, 83, 83, 69, 68, 95, 76, 69, 78, 71, 84, 72, 10, 48,   /* 0x2000 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2010 */
 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 85,   /* 0x2020 */
 78, 67, 79, 77, 80, 82, 69, 83, 83, 69, 68, 95, 76, 69, 78, 71,   /* 0x2030 */
 84, 72, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,   /* 0x2040 */
 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,   /* 0x2050 */
 48, 48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48,   /* 0x2060 */
 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,   /* 0x2070 */
 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,   /* 0x2080 */
108,116,101,114, 95,105,100, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2090 */
 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66,  9, 48,   /* 0x20a0 */
 48, 48, 48, 48, 48, 99, 52, 32,117, 99,108, 95,110,114,118, 50,   /* 0x20b0 */
 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48,   /* 0x20c0 */
 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32,   /* 0x20d0 */
 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 49, 48, 48, 32,117,   /* 0x20e0 */
 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,112,114,   /* 0x20f0 */
101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,   /* 0x2100 */
 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48,   /* 0x2110 */
 48, 48, 49, 49, 52, 32,117, 99,108, 95,110,114,118, 50,101, 95,   /* 0x2120 */
100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 10, 82, 69,   /* 0x2130 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x2140 */
 32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 88, 48, 48, 48, 93, 58,   /* 0x2150 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x2160 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x2170 */
 69, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 65, 82, 77,   /* 0x2180 */
 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 77, 69, 84,   /* 0x2190 */
 72, 79, 68, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65,   /* 0x21a0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x21b0 */
 73, 78, 85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 51, 52,   /* 0x21c0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x21d0 */
 32, 32, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10, 48, 48, 48, 48,   /* 0x21e0 */
 48, 48, 51, 56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50,   /* 0x21f0 */
 32, 32, 32, 32, 32, 32, 32, 67, 79, 77, 80, 82, 69, 83, 83, 69,   /* 0x2200 */
 68, 95, 76, 69, 78, 71, 84, 72, 10, 48, 48, 48, 48, 48, 48, 51,   /* 0x2210 */
 99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,   /* 0x2220 */
 32, 32, 32, 32, 85, 78, 67, 79, 77, 80, 82, 69, 83, 83, 69, 68,   /* 0x2230 */
 95, 76, 69, 78, 71, 84, 72, 10, 48, 48, 48, 48, 48, 48, 52, 52,   /* 0x2240 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2250 */
 32, 32, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10, 10, 82, 69, 76,   /* 0x2260 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x2270 */
 70, 79, 82, 32, 91, 76, 73, 78, 85, 88, 48, 49, 48, 93, 58, 10,   /* 0x2280 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x2290 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x22a0 */
 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x22b0 */
 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,   /* 0x22c0 */
101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,   /* 0x22d0 */
 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32,   /* 0x22e0 */
 32, 32,102,105,108,116,101,114, 95,105,100, 10, 48, 48, 48, 48,   /* 0x22f0 */
 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2300 */
 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48,   /* 0x2310 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x2320 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,   /* 0x2330 */
 46, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x2340 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2350 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 50, 48, 32,   /* 0x2360 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2370 */
 32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48,   /* 0x2380 */
 48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2390 */
 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 49, 48,   /* 0x23a0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x23b0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93,   /* 0x23c0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x23d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x23e0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82,   /* 0x23f0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2400 */
 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65,   /* 0x2410 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2420 */
 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95,   /* 0x2430 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2440 */
 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 53, 52, 32, 82,   /* 0x2450 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2460 */
 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 52, 32,   /* 0x2470 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2480 */
 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 56,   /* 0x2490 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x24a0 */
 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54,   /* 0x24b0 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x24c0 */
 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,   /* 0x24d0 */
 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x24e0 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,   /* 0x24f0 */
 48, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2500 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,   /* 0x2510 */
 48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2520 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,   /* 0x2530 */
 48, 48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2540 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,   /* 0x2550 */
 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2560 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,   /* 0x2570 */
 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2580 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,   /* 0x2590 */
 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x25a0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,   /* 0x25b0 */
 10, 48, 48, 48, 48, 48, 48, 99, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x25c0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x25d0 */
 66, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x25e0 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68,   /* 0x25f0 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x2600 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x2610 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65,   /* 0x2620 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2630 */
 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 52, 52, 32, 82, 95,   /* 0x2640 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2650 */
 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82,   /* 0x2660 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2670 */
 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32,   /* 0x2680 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2690 */
 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 53, 99,   /* 0x26a0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x26b0 */
 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 54,   /* 0x26c0 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x26d0 */
 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,   /* 0x26e0 */
 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x26f0 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,   /* 0x2700 */
 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2710 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,   /* 0x2720 */
 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2730 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,   /* 0x2740 */
 48, 48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2750 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,   /* 0x2760 */
 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2770 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,   /* 0x2780 */
 48, 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2790 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,   /* 0x27a0 */
 48, 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x27b0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,   /* 0x27c0 */
 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x27d0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x27e0 */
 68, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65, 82, 77,   /* 0x27f0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2800 */
 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82,   /* 0x2810 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2820 */
 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95, 65,   /* 0x2830 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2840 */
 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,102, 56, 32, 82, 95,   /* 0x2850 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2860 */
 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,102, 99, 32, 82,   /* 0x2870 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2880 */
 32, 78, 82, 86, 50, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x2890 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x28a0 */
 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x28b0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x28c0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x28d0 */
 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x28e0 */
 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x28f0 */
 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2900 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,   /* 0x2910 */
 48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2920 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,   /* 0x2930 */
 48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2940 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,   /* 0x2950 */
 48, 48, 48, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2960 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,   /* 0x2970 */
 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2980 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,   /* 0x2990 */
 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x29a0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,   /* 0x29b0 */
 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x29c0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,   /* 0x29d0 */
 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x29e0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x29f0 */
 69, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95, 65, 82, 77,   /* 0x2a00 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2a10 */
 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82,   /* 0x2a20 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2a30 */
 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 65,   /* 0x2a40 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2a50 */
 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95,   /* 0x2a60 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2a70 */
 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82,   /* 0x2a80 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2a90 */
 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32,   /* 0x2aa0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2ab0 */
 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 98, 99,   /* 0x2ac0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2ad0 */
 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99,   /* 0x2ae0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2af0 */
 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x2b00 */
100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2b10 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,   /* 0x2b20 */
 48,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2b30 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,   /* 0x2b40 */
 48, 48,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2b50 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,   /* 0x2b60 */
 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2b70 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,   /* 0x2b80 */
 48, 48, 48, 49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2b90 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,   /* 0x2ba0 */
 48, 48, 48, 48, 49, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2bb0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,   /* 0x2bc0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x2bd0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76,   /* 0x2be0 */
 70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x2bf0 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2c00 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,   /* 0x2c10 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2c20 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48,   /* 0x2c30 */
 48, 48, 48, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2c40 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70,   /* 0x2c50 */
 48, 48, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82,   /* 0x2c60 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x2c70 */
 77, 65, 95, 69, 76, 70, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x2c80 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x2c90 */
 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 93, 58, 10, 79,   /* 0x2ca0 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x2cb0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x2cc0 */
 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2cd0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x2ce0 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82,   /* 0x2cf0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2d00 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x2d10 */
 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2d20 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x2d30 */
 48, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77,   /* 0x2d40 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2d50 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,102, 52,   /* 0x2d60 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2d70 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x2d80 */
 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2d90 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x2da0 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65,   /* 0x2db0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x2dc0 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,   /* 0x2dd0 */
 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2de0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x2df0 */
 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2e00 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x2e10 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82,   /* 0x2e20 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2e30 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x2e40 */
 48, 49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2e50 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x2e60 */
 48, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77,   /* 0x2e70 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2e80 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56,   /* 0x2e90 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2ea0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x2eb0 */
 48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2ec0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x2ed0 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65,   /* 0x2ee0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x2ef0 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,   /* 0x2f00 */
 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2f10 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x2f20 */
 48, 48, 48, 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2f30 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x2f40 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82,   /* 0x2f50 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2f60 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x2f70 */
 48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2f80 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x2f90 */
 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77,   /* 0x2fa0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2fb0 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56,   /* 0x2fc0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2fd0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x2fe0 */
 48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2ff0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3000 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65,   /* 0x3010 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3020 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,   /* 0x3030 */
 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3040 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x3050 */
 48, 48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3060 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3070 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82,   /* 0x3080 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3090 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x30a0 */
 48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x30b0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x30c0 */
 48, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77,   /* 0x30d0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x30e0 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99,   /* 0x30f0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3100 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x3110 */
 48, 48, 48, 51,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3120 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3130 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65,   /* 0x3140 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3150 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52,   /* 0x3160 */
 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3170 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x3180 */
 48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3190 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x31a0 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82,   /* 0x31b0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x31c0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x31d0 */
 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x31e0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x31f0 */
 48, 10, 48, 48, 48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77,   /* 0x3200 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3210 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48,   /* 0x3220 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3230 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x3240 */
 48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3250 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3260 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65,   /* 0x3270 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3280 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52,   /* 0x3290 */
102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x32a0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x32b0 */
 48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x32c0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x32d0 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82,   /* 0x32e0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x32f0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x3300 */
 48, 53, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3310 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x3320 */
 48, 10, 48, 48, 48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77,   /* 0x3330 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3340 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48,   /* 0x3350 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3360 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x3370 */
 48, 48, 48, 53,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3380 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3390 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65,   /* 0x33a0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x33b0 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54,   /* 0x33c0 */
 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x33d0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x33e0 */
 48, 48, 48, 48, 48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x33f0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3400 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82,   /* 0x3410 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3420 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x3430 */
 48, 54, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3440 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x3450 */
 48, 10, 48, 48, 48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77,   /* 0x3460 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3470 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54,100, 48,   /* 0x3480 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3490 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x34a0 */
 48, 48, 48, 54,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x34b0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x34c0 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65,   /* 0x34d0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x34e0 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55,   /* 0x34f0 */
 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3500 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x3510 */
 48, 48, 48, 48, 48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3520 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3530 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82,   /* 0x3540 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3550 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x3560 */
 48, 55, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3570 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x3580 */
 48, 10, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77,   /* 0x3590 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x35a0 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52,   /* 0x35b0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x35c0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x35d0 */
 48, 48, 48, 55,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x35e0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x35f0 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65,   /* 0x3600 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3610 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56,   /* 0x3620 */
 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3630 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x3640 */
 48, 48, 48, 48, 48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3650 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3660 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82,   /* 0x3670 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3680 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x3690 */
 48, 56, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x36a0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x36b0 */
 48, 10, 48, 48, 48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77,   /* 0x36c0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x36d0 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56,101, 56,   /* 0x36e0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x36f0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x3700 */
 48, 48, 48, 56,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3710 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3720 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65,   /* 0x3730 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3740 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 57,   /* 0x3750 */
 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3760 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x3770 */
 48, 48, 48, 48, 48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3780 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3790 */
 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x37a0 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,   /* 0x37b0 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x37c0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x37d0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x37e0 */
 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x37f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3800 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82,   /* 0x3810 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3820 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 98,   /* 0x3830 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3840 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3850 */
 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3860 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3870 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82, 95,   /* 0x3880 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3890 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x38a0 */
 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x38b0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x38c0 */
 10, 48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x38d0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x38e0 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 52, 52, 32,   /* 0x38f0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3900 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3910 */
 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3920 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3930 */
 50, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82,   /* 0x3940 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3950 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,100,   /* 0x3960 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3970 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3980 */
 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3990 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x39a0 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82, 95,   /* 0x39b0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x39c0 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x39d0 */
 50, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x39e0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x39f0 */
 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x3a00 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3a10 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 99, 32,   /* 0x3a20 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3a30 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3a40 */
 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3a50 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3a60 */
 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65, 82,   /* 0x3a70 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3a80 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 53,   /* 0x3a90 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3aa0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3ab0 */
 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3ac0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3ad0 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82, 95,   /* 0x3ae0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3af0 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3b00 */
 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3b10 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3b20 */
 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x3b30 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3b40 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32,   /* 0x3b50 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3b60 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3b70 */
 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3b80 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3b90 */
 50, 48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82, 95, 65, 82,   /* 0x3ba0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3bb0 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97,   /* 0x3bc0 */
 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3bd0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3be0 */
 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3bf0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3c00 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95,   /* 0x3c10 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3c20 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3c30 */
 51,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3c40 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3c50 */
 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x3c60 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3c70 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 50, 52, 32,   /* 0x3c80 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3c90 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3ca0 */
 48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3cb0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3cc0 */
 50, 48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82, 95, 65, 82,   /* 0x3cd0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3ce0 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56,   /* 0x3cf0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3d00 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3d10 */
 48, 48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3d20 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3d30 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48, 32, 82, 95,   /* 0x3d40 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3d50 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3d60 */
 52,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3d70 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3d80 */
 10, 48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x3d90 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3da0 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,102, 52, 32,   /* 0x3db0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3dc0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3dd0 */
 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3de0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3df0 */
 50, 48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82, 95, 65, 82,   /* 0x3e00 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3e10 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 57,   /* 0x3e20 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3e30 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3e40 */
 48, 48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3e50 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3e60 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48, 32, 82, 95,   /* 0x3e70 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3e80 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3e90 */
 53,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3ea0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3eb0 */
 10, 48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x3ec0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3ed0 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 48, 52, 32,   /* 0x3ee0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3ef0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3f00 */
 48, 48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3f10 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3f20 */
 50, 48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82, 95, 65, 82,   /* 0x3f30 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3f40 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56,   /* 0x3f50 */
 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3f60 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3f70 */
 48, 48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3f80 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3f90 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,100, 48, 32, 82, 95,   /* 0x3fa0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3fb0 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3fc0 */
 54,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3fd0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3fe0 */
 10, 48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x3ff0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x4000 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 50, 56, 32,   /* 0x4010 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x4020 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x4030 */
 48, 48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x4040 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x4050 */
 50, 48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82, 95, 65, 82,   /* 0x4060 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x4070 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 57,   /* 0x4080 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x4090 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x40a0 */
 48, 48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x40b0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x40c0 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52, 32, 82, 95,   /* 0x40d0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x40e0 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x40f0 */
 55,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x4100 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x4110 */
 10, 48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x4120 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x4130 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 48, 32,   /* 0x4140 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x4150 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x4160 */
 48, 48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x4170 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x4180 */
 50, 48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82, 95, 65, 82,   /* 0x4190 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x41a0 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 56,   /* 0x41b0 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x41c0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x41d0 */
 48, 48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x41e0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x41f0 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,101, 56, 32, 82, 95,   /* 0x4200 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4210 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x4220 */
 56,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x4230 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x4240 */
 10, 48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x4250 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x4260 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 48, 52, 32,   /* 0x4270 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x4280 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x4290 */
 48, 48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x42a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x42b0 */
 50, 48, 10                                                        /* 0x42c0 */
};
