/* arm.v4t-wince.pe.h
   created from arm.v4t-wince.pe.bin, 7572 (0x1d94) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_ARM_V4T_WINCE_PE_SIZE    7572
#define STUB_ARM_V4T_WINCE_PE_ADLER32 0x69a1fef0
#define STUB_ARM_V4T_WINCE_PE_CRC32   0x0bf18823

unsigned char stub_arm_v4t_wince_pe[7572] = {
127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
132, 11,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
 26,  0, 23,  0,  1,  0, 81,227, 10,  0,  0, 26,255, 79, 45,233,   /* 0x  30 */
 44, 48,143,226,224, 30,147,232,  1, 90,143,226,  0, 96,151,229,   /* 0x  40 */
  1,122,135,226,  5,  0, 87,225,  2,  0,  0,154, 53, 64,143,226,   /* 0x  50 */
 15,224,160,225, 20,255, 47,225,255, 79,189,232, 32,192,159,229,   /* 0x  60 */
 28,255, 47,225,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  70 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  80 */
  0,  0,  0,  0,  0,  0,  0,  0,  7,203,145, 70,100, 70, 16,181,   /* 0x  90 */
 11, 72,  0, 34, 11, 76, 15, 37,255, 38, 54,  6,247, 67,160, 66,   /* 0x  a0 */
 18,208,  3,104, 25, 14, 41, 64, 11, 41,  5,209, 25, 28, 49, 64,   /* 0x  b0 */
155, 26, 59, 64, 11, 67,  3, 96,  4, 48,  1, 50,239,231,  0,  0,   /* 0x  c0 */
  0,  0,  0,  0,  0,  0,  0,  0, 14, 72, 74, 70, 17, 31,  3,120,   /* 0x  d0 */
  1, 48,  0, 43, 24,208,240, 43,  8,211, 15, 36, 28, 64, 67,120,   /* 0x  e0 */
 36,  2,228, 24,  3,120,  2, 48, 36,  2, 27, 25,201, 24,  0, 37,   /* 0x  f0 */
 75, 93, 36,  2,228, 24,  1, 53,  4, 45,249,209,164, 24, 12, 96,   /* 0x 100 */
229,231,  0,  0,  0,  0,  0,  0,111, 70,255,176,255,176,255,176,   /* 0x 110 */
255,176, 27, 76, 32, 28,  0,240, 48,248, 53,208, 25, 73, 64, 24,   /* 0x 120 */
105, 70,  2,120,  1, 48, 10,128,  2, 49,  0, 42,249,209,104, 70,   /* 0x 130 */
  0,240, 56,248,  6, 28, 32, 29,  0,240, 48,248, 77, 70, 45, 24,   /* 0x 140 */
  8, 52, 32,120,  1, 52,  1, 40,228,212,  5,209, 33, 28, 32,120,   /* 0x 150 */
  1, 52,  0, 40,251,209,  4,224, 32,120, 97,120,  2, 52,  9,  2,   /* 0x 160 */
  9, 24, 48, 28,  0,240, 57,248,  1,197,234,231,  3, 33, 67, 92,   /* 0x 170 */
 18,  2,210, 24,  1, 57,250,213, 16, 28,112, 71, 80, 71, 88, 71,   /* 0x 180 */
  0,  0,  0,  0,  0,  0,  0,  0,189, 70,  6,188,  4, 32,150, 70,   /* 0x 190 */
  8, 71, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,   /* 0x 1a0 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x 1b0 */
  0, 45,  9, 24,254,181,  1, 36,101, 66,228,  7, 13, 39, 63,  2,   /* 0x 1c0 */
 15,224, 26,188, 64, 26,210, 26, 34, 96,240,188,  2,188,  8, 71,   /* 0x 1d0 */
  4,120,100, 65,  1, 48, 36,  6,247, 70,  3,120,  1, 48, 19,112,   /* 0x 1e0 */
  1, 50, 36, 25,254, 70,243,208,247,210,  1, 33, 36, 25,254, 70,   /* 0x 1f0 */
238,208, 73, 65, 36, 25,254, 70,234,208,247,211,203, 30,  0, 33,   /* 0x 200 */
  5,211, 27,  2,  5,120,  1, 48, 29, 67,237, 67,217,208, 36, 25,   /* 0x 210 */
254, 70,221,208, 73, 65, 36, 25,254, 70,217,208, 73, 65,  9,209,   /* 0x 220 */
  1, 33, 36, 25,254, 70,211,208, 73, 65, 36, 25,254, 70,207,208,   /* 0x 230 */
247,211,  2, 49,  1, 49,253, 66,  0,210,  1, 49, 19,120, 83, 93,   /* 0x 240 */
 19,112,  1, 50,  1, 57,250,209,203,231,255,247,254,255,252,181,   /* 0x 250 */
 15, 24,  1, 36,101, 66,228,  7,  5, 38, 54,  2, 15,224, 24,188,   /* 0x 260 */
192, 27,210, 26, 34, 96,240,188,  2,188,  8, 71,  4,120,100, 65,   /* 0x 270 */
  1, 48, 36,  6,247, 70,  3,120,  1, 48, 19,112,  1, 50, 36, 25,   /* 0x 280 */
254, 70,243,208,247,210,  1, 33,  4,224,  1, 57, 36, 25,254, 70,   /* 0x 290 */
236,208, 73, 65, 36, 25,254, 70,232,208, 73, 65, 36, 25,254, 70,   /* 0x 2a0 */
228,208,242,211,203, 30,  0, 33,  8,211, 27,  2,  5,120,  1, 48,   /* 0x 2b0 */
 29, 67,237, 67,211,208,109, 16, 19,210,  3,224, 36, 25,254, 70,   /* 0x 2c0 */
212,208, 14,210,  1, 33, 36, 25,254, 70,207,208,  9,210, 36, 25,   /* 0x 2d0 */
254, 70,203,208, 73, 65, 36, 25,254, 70,199,208,247,211,  4, 49,   /* 0x 2e0 */
  4,224, 36, 25,254, 70,193,208, 73, 65,  2, 49,238, 66,  0,210,   /* 0x 2f0 */
  1, 49, 19,120, 83, 93, 19,112,  1, 50,  1, 57,250,209,190,231,   /* 0x 300 */
255,247,254,255,  8,167,120,207,111, 70,108, 68,  0, 33,  2,180,   /* 0x 310 */
165, 69,252,209, 28,180, 35, 29, 42, 28,129, 28, 24, 29,  6, 96,   /* 0x 320 */
255,247,254,255,189, 70,  7,224,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x 330 */
  0,  0,  0,  0,  0,  0,  0,  0,240,181,159,176,  4,145,  1, 29,   /* 0x 340 */
  6,145,  3,147, 21, 28,131,120,  1, 34, 17, 28,153, 64, 11, 28,   /* 0x 350 */
  1, 59,  8,147, 67,120,154, 64,  1, 58,  9,146,  2,120,  3,153,   /* 0x 360 */
 10,146, 38,154,  0, 35, 11, 96, 19, 96, 10,155, 66,120,154, 24,   /* 0x 370 */
192, 35,204, 72,155,  0,147, 64,  6,154, 28, 24,  0, 32,  4,224,   /* 0x 380 */
128, 35,219,  0, 19,128,  1, 48,  2, 50,160, 66,248,209,  4,153,   /* 0x 390 */
 77, 25, 16,149,  0, 39, 13, 28,  0, 32, 16,154,  4,153, 83, 26,   /* 0x 3a0 */
152, 66,  0,209,115,227, 43,120, 58,  2, 23, 28,  1, 48, 31, 67,   /* 0x 3b0 */
  1, 53,  5, 40,241,209,  0, 34,  1, 33,  1, 35,148, 70, 73, 66,   /* 0x 3c0 */
  7,146, 11,146, 30,147, 12,147, 13,147, 14,147, 74,227,182, 72,   /* 0x 3d0 */
129, 66,  9,216, 16,154,149, 66,  0,209, 88,227, 43,120, 58,  2,   /* 0x 3e0 */
 23, 28,  9,  2, 31, 67,  1, 53,  8,152,  7,155, 11,154,  3, 64,   /* 0x 3f0 */
 18,  1, 17,147,  6,152,155, 24, 91,  0,196, 24,  5,146, 34,136,   /* 0x 400 */
203, 10, 22, 28, 94, 67,183, 66,  0,211,174,224,128, 35, 27,  1,   /* 0x 410 */
155, 26, 91, 17,211, 24,  9,153,  7,154, 35,128, 10,155, 10, 64,   /* 0x 420 */
 10,152,154, 64,  8, 35, 27, 26, 97, 70, 25, 65, 82, 24, 83,  0,   /* 0x 430 */
155, 24,  6,154, 91,  2,157, 72,211, 24, 11,153, 24, 24, 28,144,   /* 0x 440 */
  6, 41,  3,220,  1, 34, 49, 28, 18,146,114,224, 30,153,  7,152,   /* 0x 450 */
 36,154, 67, 26,211, 92, 19,147,  1, 35, 18,147, 49, 28,146, 75,   /* 0x 460 */
153, 66,  9,216, 16,152,133, 66,  0,209, 16,227, 43,120, 58,  2,   /* 0x 470 */
 23, 28,  9,  2, 31, 67,  1, 53, 19,154,128, 35, 82,  0, 91,  0,   /* 0x 480 */
 22, 28, 28,152, 19,146, 30, 64, 18,154,115,  0, 82,  0,195, 24,   /* 0x 490 */
128, 32,155, 24,128,  0, 28, 24,  1,146, 34,136,203, 10, 16, 28,   /* 0x 4a0 */
 88, 67,135, 66, 11,210,128, 35, 27,  1,155, 26, 91, 17,  1,153,   /* 0x 4b0 */
211, 24, 35,128, 18,145,  0, 46, 47,209,  1, 28, 11,224, 83,  9,   /* 0x 4c0 */
211, 26, 35,128, 18,155, 18,154,  1, 51,210, 24,  9, 26, 63, 26,   /* 0x 4d0 */
 18,146,  0, 46, 45,208, 18,155,255, 43, 45,220,191,231,114, 75,   /* 0x 4e0 */
153, 66,  9,216, 16,152,133, 66,  0,209,208,226, 43,120, 58,  2,   /* 0x 4f0 */
 23, 28,  9,  2, 31, 67,  1, 53, 18,154, 28,155, 86,  0,156, 25,   /* 0x 500 */
 34,136,203, 10, 16, 28, 88, 67,135, 66,  8,210,128, 35, 27,  1,   /* 0x 510 */
155, 26, 91, 17,211, 24, 35,128, 18,150,  1, 28,  9,224, 83,  9,   /* 0x 520 */
211, 26, 35,128, 18,155,  9, 26, 63, 26, 18,152,  1, 51,192, 24,   /* 0x 530 */
 18,144, 18,154,255, 42,210,221, 18,152,  3,  6, 27, 14, 24, 28,   /* 0x 540 */
 36,154,156, 70,  7,155,208, 84, 26, 28, 11,155,  1, 50,  3, 43,   /* 0x 550 */
  1,220,  0, 32,  7,224, 11,155,  9, 43,  2,220,  3, 59, 11,147,   /* 0x 560 */
127,226, 11,152,  6, 56, 11,144,123,226,136, 27, 83,  9, 78, 73,   /* 0x 570 */
211, 26,191, 27, 35,128,136, 66,  9,216, 16,154,149, 66,  0,209,   /* 0x 580 */
133,226, 43,120, 58,  2, 23, 28,  0,  2, 31, 67,  1, 53, 11,153,   /* 0x 590 */
  6,154, 75,  0,210, 24,192, 38,148, 70,118,  0,102, 68, 50,136,   /* 0x 5a0 */
195, 10, 17, 28, 89, 67,143, 66, 24,210,128, 35, 27,  1,155, 26,   /* 0x 5b0 */
 91, 17,211, 24, 51,128, 11,155,  6, 43,  2,220,  0, 32, 11,144,   /* 0x 5c0 */
  1,224,  3, 34, 11,146,  6,155, 57, 72, 30, 24, 30,152, 13,154,   /* 0x 5d0 */
 12,155, 12,144,  8, 28, 14,146, 13,147,209,224, 68, 26,127, 26,   /* 0x 5e0 */
 83,  9, 49, 73,211, 26, 51,128,140, 66,  9,216, 16,154,149, 66,   /* 0x 5f0 */
  0,209, 76,226, 43,120, 58,  2, 23, 28, 36,  2, 31, 67,  1, 53,   /* 0x 600 */
204, 38,118,  0,102, 68, 48,136,227, 10,  2, 28, 90, 67,151, 66,   /* 0x 610 */
 80,210,128, 35, 27,  1, 27, 26, 91, 17,195, 24, 51,128, 34, 75,   /* 0x 620 */
154, 66,  1,217, 16, 28,  9,224, 16,152,133, 66,  0,209, 46,226,   /* 0x 630 */
 43,120, 16,  2, 58,  2, 23, 28, 31, 67,  1, 53,  5,153,  6,154,   /* 0x 640 */
 75,  0, 17,153,211, 24, 74,  0,155, 24,240, 34, 82,  0,156, 24,   /* 0x 650 */
 34,136,195, 10, 22, 28, 94, 67,183, 66, 28,210,128, 35, 27,  1,   /* 0x 660 */
155, 26, 91, 17,211, 24, 35,128,  7,155,  0, 43,  0,209, 14,226,   /* 0x 670 */
 11,152,  6, 40,  2,220,  9, 33, 11,145,  1,224, 11, 34, 11,146,   /* 0x 680 */
  7,152, 30,153, 36,154, 67, 26,211, 92, 19, 84,  2, 28,156, 70,   /* 0x 690 */
  1, 50, 49, 28,229,225, 83,  9,211, 26,128, 27,191, 27, 35,128,   /* 0x 6a0 */
 99,224,  0,  0, 54,  7,  0,  0,255,255,255,  0,108, 14,  0,  0,   /* 0x 6b0 */
100,  6,  0,  0, 67,  9,195, 26,213, 72,164, 26,191, 26, 51,128,   /* 0x 6c0 */
132, 66,  9,216, 16,153,141, 66,  0,209,224,225, 43,120, 58,  2,   /* 0x 6d0 */
 23, 28, 36,  2, 31, 67,  1, 53,216, 38,118,  0,102, 68, 50,136,   /* 0x 6e0 */
227, 10, 16, 28, 88, 67,135, 66,  9,210,128, 35, 27,  1,155, 26,   /* 0x 6f0 */
 91, 17,211, 24, 51,128, 12,154, 30,155, 12,147, 52,224, 33, 26,   /* 0x 700 */
 63, 26, 83,  9,194, 72,211, 26, 51,128,129, 66,  9,216, 16,154,   /* 0x 710 */
149, 66,  0,209,187,225, 43,120, 58,  2, 23, 28,  9,  2, 31, 67,   /* 0x 720 */
  1, 53,228, 38,118,  0,102, 68, 50,136,203, 10, 20, 28, 92, 67,   /* 0x 730 */
167, 66, 13,210,128, 35, 27,  1,155, 26, 91, 17,211, 24, 30,152,   /* 0x 740 */
 13,154, 51,128, 12,155, 12,144, 32, 28, 13,147, 30,146, 12,224,   /* 0x 750 */
 83,  9,  8, 27, 13,153,211, 26, 51,128, 14,154, 12,155, 14,145,   /* 0x 760 */
 30,153, 13,147, 12,145, 63, 27, 30,146, 11,154,  6, 42,  2,220,   /* 0x 770 */
  8, 35, 11,147,  1,224, 11, 33, 11,145,  6,154,165, 75,214, 24,   /* 0x 780 */
163, 73,140, 70, 96, 69,  9,216, 16,154,149, 66,  0,209,126,225,   /* 0x 790 */
 43,120, 58,  2, 23, 28,  0,  2, 31, 67,  1, 53, 50,136,195, 10,   /* 0x 7a0 */
 17, 28, 89, 67,143, 66, 15,210,128, 35, 27,  1,155, 26, 91, 17,   /* 0x 7b0 */
 17,152,211, 24, 51,128,  3,  1,243, 24,  4, 51, 22,147,  3, 34,   /* 0x 7c0 */
  0, 35, 20,146, 21,147, 53,224, 83,  9,211, 26, 68, 26,127, 26,   /* 0x 7d0 */
 51,128,100, 69,  9,216, 16,152,133, 66,  0,209, 87,225, 43,120,   /* 0x 7e0 */
 58,  2, 23, 28, 36,  2, 31, 67,  1, 53,114,136,227, 10, 16, 28,   /* 0x 7f0 */
 88, 67,135, 66, 17,210,128, 35, 27,  1,155, 26, 17,153, 91, 17,   /* 0x 800 */
211, 24,115,128,130, 34, 11,  1,243, 24, 82,  0,154, 24,  1, 28,   /* 0x 810 */
  3, 35,  8, 32, 22,146, 20,147, 11,224, 83,  9,211, 26,129, 34,   /* 0x 820 */
146,  0,115,128,178, 24,  8, 35, 22,146, 20,147, 33, 26, 63, 26,   /* 0x 830 */
 16, 32, 21,144, 20,154,  1, 35, 15,147,148, 70,116, 75,153, 66,   /* 0x 840 */
  9,216, 16,152,133, 66,  0,209, 33,225, 43,120, 58,  2, 23, 28,   /* 0x 850 */
  9,  2, 31, 67,  1, 53, 15,154, 22,155, 86,  0,156, 25, 34,136,   /* 0x 860 */
203, 10, 16, 28, 88, 67,135, 66,  8,210,128, 35, 27,  1,155, 26,   /* 0x 870 */
 91, 17,211, 24,  1, 28, 35,128, 15,150,  9,224, 83,  9,211, 26,   /* 0x 880 */
 35,128, 15,155,  9, 26, 63, 26, 15,152,  1, 51,192, 24, 15,144,   /* 0x 890 */
  1, 34, 82, 66,148, 68, 99, 70,  0, 43,207,209, 20,152, 15,154,   /* 0x 8a0 */
  1, 35,131, 64, 21,152,211, 26, 11,154, 27, 24, 29,147,  3, 42,   /* 0x 8b0 */
  0,221,189,224,  3, 43,  0,221,  3, 35,  6,152,219,  1,216, 34,   /* 0x 8c0 */
195, 24,146,  0,154, 24,  6, 35, 27,146, 23,147,  1, 38, 80, 75,   /* 0x 8d0 */
153, 66,  9,216, 16,152,133, 66,  0,209,216,224, 43,120, 58,  2,   /* 0x 8e0 */
 23, 28,  9,  2, 31, 67,  1, 53,114,  0, 27,156,148, 70,100, 68,   /* 0x 8f0 */
 34,136,203, 10, 16, 28, 88, 67,135, 66,  8,210,128, 35, 27,  1,   /* 0x 900 */
155, 26, 91, 17,211, 24,102, 70,  1, 28, 35,128,  6,224, 83,  9,   /* 0x 910 */
211, 26, 35,128,115, 28,  9, 26, 63, 26,246, 24, 23,155,  1, 59,   /* 0x 920 */
 23,147,  0, 43,211,209, 48, 28, 64, 56,  3, 40,120,221, 70, 16,   /* 0x 930 */
114, 30,  1, 35,148, 70,  2, 28, 26, 64, 20, 28,  2, 35, 28, 67,   /* 0x 940 */
 13, 40, 11,220, 99, 70, 38, 28,  6,154,158, 64,115,  0,211, 24,   /* 0x 950 */
 66,  0, 49, 72,155, 26, 24, 24, 26,144, 31,224,  5, 62,  0, 32,   /* 0x 960 */
 43, 75,153, 66,  9,216, 16,154,149, 66,  0,209,143,224, 43,120,   /* 0x 970 */
 58,  2, 23, 28,  9,  2, 31, 67,  1, 53, 73,  8,100,  0,143, 66,   /* 0x 980 */
  2,211,  1, 35,127, 26, 28, 67,  1, 48,176, 66,232,209, 35, 72,   /* 0x 990 */
  6,155, 24, 24,  4, 34, 26,144, 38,  1,148, 70,  1, 35, 24,147,   /* 0x 9a0 */
 25,147, 27, 75,153, 66,  8,216, 16,152,133, 66,111,208, 43,120,   /* 0x 9b0 */
 58,  2, 23, 28,  9,  2, 31, 67,  1, 53, 25,154, 26,155, 82,  0,   /* 0x 9c0 */
156, 24,  2,146, 34,136,203, 10, 16, 28, 88, 67,135, 66,  9,210,   /* 0x 9d0 */
128, 35, 27,  1,  2,153,155, 26, 91, 17,211, 24, 25,145,  1, 28,   /* 0x 9e0 */
 35,128, 11,224, 83,  9,211, 26, 35,128, 25,155, 25,154,  1, 51,   /* 0x 9f0 */
210, 24, 24,155, 25,146,  9, 26, 63, 26, 30, 67,  1, 32, 64, 66,   /* 0x a00 */
132, 68, 98, 70,  0, 42, 12,208, 24,155, 91,  0, 24,147,200,231,   /* 0x a10 */
255,255,255,  0,104, 10,  0,  0, 94,  5,  0,  0, 68,  6,  0,  0,   /* 0x a20 */
  6, 28,  1, 54, 30,150,  0, 46, 33,208, 11,152,  7, 48, 11,144,   /* 0x a30 */
 30,154,  7,155,154, 66, 42,216,155, 26, 36,152, 29,158,  7,154,   /* 0x a40 */
196, 24,  2, 54,128, 24, 35,120,  3,112,156, 70,  7,155,  1, 50,   /* 0x a50 */
155, 25,  0,147,154, 66,  4,208, 37,155,  1, 52,  1, 48,154, 66,   /* 0x a60 */
241,209,  7,146,  7,152, 37,154,144, 66,  0,210,175,228,  9, 75,   /* 0x a70 */
153, 66,  3,216, 16,155,157, 66,  9,208,  1, 53,  4,152,  3,153,   /* 0x a80 */
 43, 26, 11, 96,  7,154, 38,155,  0, 32, 26, 96,  0,224,  1, 32,   /* 0x a90 */
 31,176,240,189,255,255,255,  0,116,109,112, 47, 97,114,109, 46,   /* 0x aa0 */
118, 52,116, 45,119,105,110, 99,101, 46,112,101, 46, 98,105,110,   /* 0x ab0 */
 58, 32, 32, 32, 32, 32,102,105,108,101, 32,102,111,114,109, 97,   /* 0x ac0 */
116, 32,101,108,102, 51, 50, 45,108,105,116,116,108,101, 97,114,   /* 0x ad0 */
109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120,   /* 0x ae0 */
 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,   /* 0x af0 */
105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32,   /* 0x b00 */
 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,   /* 0x b10 */
101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,   /* 0x b20 */
103,115, 10, 32, 32, 48, 32, 68,108,108, 83,116, 97,114,116, 32,   /* 0x b30 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48,   /* 0x b40 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x b50 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42,   /* 0x b60 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x b70 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49,   /* 0x b80 */
 32, 69,120,101, 83,116, 97,114,116, 32, 32, 32, 32, 32, 32, 48,   /* 0x b90 */
 48, 48, 48, 48, 48, 54, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x ba0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x bb0 */
 48, 48, 48, 51, 99, 32, 32, 50, 42, 42, 49, 32, 32, 67, 79, 78,   /* 0x bc0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x bd0 */
 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 85,110,102,105,108,   /* 0x be0 */
116,101,114, 95, 48,120, 53, 48, 32, 48, 48, 48, 48, 48, 48, 51,   /* 0x bf0 */
 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x c00 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 48, 32,   /* 0x c10 */
 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x c20 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x c30 */
 10, 32, 32, 51, 32, 82,101,108,111, 99,115, 32, 32, 32, 32, 32,   /* 0x c40 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 48, 48, 48,   /* 0x c50 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x c60 */
 32, 48, 48, 48, 48, 48, 48,100, 56, 32, 32, 50, 42, 42, 50, 32,   /* 0x c70 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x c80 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 73,   /* 0x c90 */
109,112,111,114,116,115, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x ca0 */
 48, 48, 48, 56, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x cb0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x cc0 */
 49, 49, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x cd0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x ce0 */
 79, 78, 76, 89, 10, 32, 32, 53, 32, 80,114,111, 99,101,115,115,   /* 0x cf0 */
 69,110,100, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32,   /* 0x d00 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x d10 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 57, 97, 32, 32, 50,   /* 0x d20 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x d30 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 85, 80, 88, 49,   /* 0x d40 */
 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x d50 */
 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x d60 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 97, 50,   /* 0x d70 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x d80 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 46,   /* 0x d90 */
117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,   /* 0x da0 */
114,101,115,115, 95, 56, 32, 48, 48, 48, 48, 48, 48, 57, 56, 32,   /* 0x db0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x dc0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 99, 50, 32, 32, 50,   /* 0x dd0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x de0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 67, 97,108,108,   /* 0x df0 */
 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x e00 */
 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x e10 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 53, 97,   /* 0x e20 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x e30 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x e40 */
 89, 10, 32, 32, 57, 32, 46,117, 99,108, 95,110,114,118, 50,101,   /* 0x e50 */
 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 32, 48, 48,   /* 0x e60 */
 48, 48, 48, 48, 98, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x e70 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x e80 */
 48, 50, 53,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x e90 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x ea0 */
 49, 48, 32, 67, 97,108,108, 50, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x eb0 */
 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48,   /* 0x ec0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x ed0 */
 48, 48, 48, 48, 51, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x ee0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x ef0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 67, 97,108,   /* 0x f00 */
108, 76, 90, 77, 65, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x f10 */
 48, 51, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x f20 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 49,   /* 0x f30 */
 52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x f40 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x f50 */
 76, 89, 10, 32, 49, 50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 79,   /* 0x f60 */
 68, 69, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x f70 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x f80 */
 48, 32, 32, 48, 48, 48, 48, 48, 51, 52, 56, 32, 32, 50, 42, 42,   /* 0x f90 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x fa0 */
 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 76, 90, 77, 65, 95, 68,   /* 0x fb0 */
 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 55, 54, 48,   /* 0x fc0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x fd0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 52, 56, 32, 32,   /* 0x fe0 */
 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x ff0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32,   /* 0x1000 */
 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1010 */
108, 32, 32, 32, 32,100, 32, 32, 69,120,101, 83,116, 97,114,116,   /* 0x1020 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69,120,101, 83,116, 97,   /* 0x1030 */
114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x1040 */
 32, 32, 32, 32, 73,109,112,111,114,116,115,  9, 48, 48, 48, 48,   /* 0x1050 */
 48, 48, 48, 48, 32, 46,114,101, 97,108, 95,115,116, 97,114,116,   /* 0x1060 */
 95,111,102, 73,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48,   /* 0x1070 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 46,117, 99,108,   /* 0x1080 */
 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,   /* 0x1090 */
115, 95, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 46,117, 99,   /* 0x10a0 */
108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,   /* 0x10b0 */
115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x10c0 */
 32, 32, 32,100, 32, 32, 46,117, 99,108, 95,110,114,118, 50,101,   /* 0x10d0 */
 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,  9, 48, 48,   /* 0x10e0 */
 48, 48, 48, 48, 48, 48, 32, 46,117, 99,108, 95,110,114,118, 50,   /* 0x10f0 */
101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48,   /* 0x1100 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32, 32, 32, 32,   /* 0x1110 */
 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69,  9, 48, 48, 48, 48,   /* 0x1120 */
 48, 48, 48, 48, 32, 46,114,101, 97,108, 95,115,116, 97,114,116,   /* 0x1130 */
 95,111,102, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69, 10, 48,   /* 0x1140 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x1150 */
 68,108,108, 83,116, 97,114,116,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x1160 */
 48, 32, 68,108,108, 83,116, 97,114,116, 10, 48, 48, 48, 48, 48,   /* 0x1170 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85,110,102,105,   /* 0x1180 */
108,116,101,114, 95, 48,120, 53, 48,  9, 48, 48, 48, 48, 48, 48,   /* 0x1190 */
 48, 48, 32, 85,110,102,105,108,116,101,114, 95, 48,120, 53, 48,   /* 0x11a0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x11b0 */
 32, 32, 82,101,108,111, 99,115,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x11c0 */
 48, 32, 82,101,108,111, 99,115, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x11d0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 73,109,112,111,114,116,   /* 0x11e0 */
115,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 73,109,112,111,114,   /* 0x11f0 */
116,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x1200 */
 32,100, 32, 32, 80,114,111, 99,101,115,115, 69,110,100,  9, 48,   /* 0x1210 */
 48, 48, 48, 48, 48, 48, 48, 32, 80,114,111, 99,101,115,115, 69,   /* 0x1220 */
110,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x1230 */
 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48,   /* 0x1240 */
 48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48,   /* 0x1250 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x1260 */
 67, 97,108,108, 50, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1270 */
 67, 97,108,108, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1280 */
108, 32, 32, 32, 32,100, 32, 32, 67, 97,108,108, 50, 69,  9, 48,   /* 0x1290 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 97,108,108, 50, 69, 10, 48,   /* 0x12a0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x12b0 */
 67, 97,108,108, 76, 90, 77, 65,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x12c0 */
 48, 32, 67, 97,108,108, 76, 90, 77, 65, 10, 48, 48, 48, 48, 48,   /* 0x12d0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,   /* 0x12e0 */
 95, 68, 69, 67, 79, 68, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x12f0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69, 10, 48, 48, 48,   /* 0x1300 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,   /* 0x1310 */
 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x1320 */
 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x1330 */
 48, 48, 48, 51, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,120,   /* 0x1340 */
101, 83,116, 97,114,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1350 */
 83, 82, 67, 48, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32,103, 32,   /* 0x1360 */
 32, 32, 32, 32, 32, 32, 69,120,101, 83,116, 97,114,116,  9, 48,   /* 0x1370 */
 48, 48, 48, 48, 48, 48, 48, 32, 68, 83, 84, 48, 10, 48, 48, 48,   /* 0x1380 */
 48, 48, 48, 52, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,120,   /* 0x1390 */
101, 83,116, 97,114,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x13a0 */
 73, 65, 84, 84, 10, 48, 48, 48, 48, 48, 48, 53, 56, 32,103, 32,   /* 0x13b0 */
 32, 32, 32, 32, 32, 32, 69,120,101, 83,116, 97,114,116,  9, 48,   /* 0x13c0 */
 48, 48, 48, 48, 48, 48, 48, 32, 69, 78, 84, 82, 10, 48, 48, 48,   /* 0x13d0 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x13e0 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,   /* 0x13f0 */
114,116, 95,111,102, 95, 99,111,109,112,114,101,115,115,101,100,   /* 0x1400 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x1410 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1420 */
 32, 99,111,109,112,114,101,115,115,101,100, 95,108,101,110,103,   /* 0x1430 */
116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,   /* 0x1440 */
 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,   /* 0x1450 */
 48, 48, 32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,   /* 0x1460 */
109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1470 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x1480 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,117,110, 99,111,109,112,114,   /* 0x1490 */
101,115,115,101,100, 95,108,101,110,103,116,104, 10, 48, 48, 48,   /* 0x14a0 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x14b0 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,   /* 0x14c0 */
103,105,110, 97,108, 95,101,110,116,114,121, 10, 48, 48, 48, 48,   /* 0x14d0 */
 48, 48, 51, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 85,110,102,   /* 0x14e0 */
105,108,116,101,114, 95, 48,120, 53, 48,  9, 48, 48, 48, 48, 48,   /* 0x14f0 */
 48, 48, 48, 32, 70, 73, 66, 83, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1500 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x1510 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,101,114, 95,   /* 0x1520 */
 98,117,102,102,101,114, 95,115,116, 97,114,116, 10, 48, 48, 48,   /* 0x1530 */
 48, 48, 48, 51, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 85,110,   /* 0x1540 */
102,105,108,116,101,114, 95, 48,120, 53, 48,  9, 48, 48, 48, 48,   /* 0x1550 */
 48, 48, 48, 48, 32, 70, 73, 66, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x1560 */
 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,   /* 0x1570 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,101,114,   /* 0x1580 */
 95, 98,117,102,102,101,114, 95,101,110,100, 10, 48, 48, 48, 48,   /* 0x1590 */
 48, 48, 51, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 82,101,108,   /* 0x15a0 */
111, 99,115,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 66, 82, 69,   /* 0x15b0 */
 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,   /* 0x15c0 */
 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x15d0 */
 48, 32,115,116, 97,114,116, 95,111,102, 95,114,101,108,111, 99,   /* 0x15e0 */
115, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32,103, 32, 32, 32, 32,   /* 0x15f0 */
 32, 32, 32, 73,109,112,111,114,116,115,  9, 48, 48, 48, 48, 48,   /* 0x1600 */
 48, 48, 48, 32, 66, 73, 77, 80, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1610 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x1620 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,114,116, 95,111,   /* 0x1630 */
102, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48,   /* 0x1640 */
 55, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 73,109,112,111,114,   /* 0x1650 */
116,115,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 79, 78, 65, 77,   /* 0x1660 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x1670 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1680 */
 32,115,116, 97,114,116, 95,111,102, 95,100,108,108, 95,110, 97,   /* 0x1690 */
109,101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,   /* 0x16a0 */
 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,   /* 0x16b0 */
 48, 48, 48, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48,   /* 0x16c0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x16d0 */
 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x16e0 */
122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,116,   /* 0x16f0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x1700 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1710 */
 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48,   /* 0x1720 */
 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,   /* 0x1730 */
 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97,   /* 0x1740 */
 95,112,114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76,   /* 0x1750 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x1760 */
 70, 79, 82, 32, 91, 68,108,108, 83,116, 97,114,116, 93, 58, 10,   /* 0x1770 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x1780 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x1790 */
 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x17a0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,120,101, 83,   /* 0x17b0 */
116, 97,114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x17c0 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69,120,   /* 0x17d0 */
101, 83,116, 97,114,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x17e0 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x17f0 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x1800 */
 49, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x1810 */
 32, 32, 32, 32, 32, 69,120,101, 83,116, 97,114,116, 10, 48, 48,   /* 0x1820 */
 48, 48, 48, 48, 51, 56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83,   /* 0x1830 */
 51, 50, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,   /* 0x1840 */
102, 95, 99,111,109,112,114,101,115,115,101,100, 10, 48, 48, 48,   /* 0x1850 */
 48, 48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51,   /* 0x1860 */
 50, 32, 32, 32, 32, 32, 32, 32, 99,111,109,112,114,101,115,115,   /* 0x1870 */
101,100, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48,   /* 0x1880 */
 52, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32,   /* 0x1890 */
 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,117,110,   /* 0x18a0 */
 99,111,109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48,   /* 0x18b0 */
 48, 52, 52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32,   /* 0x18c0 */
 32, 32, 32, 32, 32, 32,117,110, 99,111,109,112,114,101,115,115,   /* 0x18d0 */
101,100, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48,   /* 0x18e0 */
 53, 56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32,   /* 0x18f0 */
 32, 32, 32, 32, 32,111,114,105,103,105,110, 97,108, 95,101,110,   /* 0x1900 */
116,114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x1910 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85,110,102,   /* 0x1920 */
105,108,116,101,114, 95, 48,120, 53, 48, 93, 58, 10, 79, 70, 70,   /* 0x1930 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x1940 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x1950 */
 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83,   /* 0x1960 */
 51, 50, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,   /* 0x1970 */
 98,117,102,102,101,114, 95,115,116, 97,114,116, 10, 48, 48, 48,   /* 0x1980 */
 48, 48, 48, 51, 52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51,   /* 0x1990 */
 50, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 98,   /* 0x19a0 */
117,102,102,101,114, 95,101,110,100, 10, 10, 82, 69, 76, 79, 67,   /* 0x19b0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x19c0 */
 82, 32, 91, 82,101,108,111, 99,115, 93, 58, 10, 79, 70, 70, 83,   /* 0x19d0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x19e0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x19f0 */
 48, 48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51,   /* 0x1a00 */
 50, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102,   /* 0x1a10 */
 95,114,101,108,111, 99,115, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x1a20 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x1a30 */
 91, 73,109,112,111,114,116,115, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x1a40 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1a50 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x1a60 */
 48, 48, 48,101, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67,   /* 0x1a70 */
 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116, 97,   /* 0x1a80 */
114,116, 95,111,102, 73,109,112,111,114,116,115, 10, 48, 48, 48,   /* 0x1a90 */
 48, 48, 48, 50, 56, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95,   /* 0x1aa0 */
 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116,   /* 0x1ab0 */
 97,114,116, 95,111,102, 73,109,112,111,114,116,115, 10, 48, 48,   /* 0x1ac0 */
 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77,   /* 0x1ad0 */
 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,   /* 0x1ae0 */
116, 97,114,116, 95,111,102, 73,109,112,111,114,116,115, 10, 48,   /* 0x1af0 */
 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65, 82, 77, 95, 84, 72,   /* 0x1b00 */
 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,   /* 0x1b10 */
115,116, 97,114,116, 95,111,102, 73,109,112,111,114,116,115, 10,   /* 0x1b20 */
 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 65,   /* 0x1b30 */
 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116,   /* 0x1b40 */
 95,111,102, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48,   /* 0x1b50 */
 48, 48, 55, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50,   /* 0x1b60 */
 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,   /* 0x1b70 */
100,108,108, 95,110, 97,109,101,115, 10, 10, 82, 69, 76, 79, 67,   /* 0x1b80 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x1b90 */
 82, 32, 91, 67, 97,108,108, 50, 66, 93, 58, 10, 79, 70, 70, 83,   /* 0x1ba0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x1bb0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x1bc0 */
 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95,   /* 0x1bd0 */
 67, 65, 76, 76, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118,   /* 0x1be0 */
 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10,   /* 0x1bf0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x1c00 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 97,108,108, 50, 69, 93,   /* 0x1c10 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x1c20 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x1c30 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82,   /* 0x1c40 */
 77, 95, 84, 72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,117,   /* 0x1c50 */
 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,112,114,   /* 0x1c60 */
101,115,115, 95, 56, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x1c70 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,   /* 0x1c80 */
 97,108,108, 76, 90, 77, 65, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x1c90 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1ca0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x1cb0 */
 48, 49, 99, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67, 65,   /* 0x1cc0 */
 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116, 97,114,   /* 0x1cd0 */
116, 95,111,102, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69, 10,   /* 0x1ce0 */
 48, 48, 48, 48, 48, 48, 50, 52, 32, 82, 95, 65, 82, 77, 95, 65,   /* 0x1cf0 */
 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,   /* 0x1d00 */
117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32, 82,   /* 0x1d10 */
 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x1d20 */
 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,   /* 0x1d30 */
115,116, 10, 48, 48, 48, 48, 48, 48, 50, 99, 32, 82, 95, 65, 82,   /* 0x1d40 */
 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,108,122,   /* 0x1d50 */
109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 51,   /* 0x1d60 */
 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,   /* 0x1d70 */
 32, 32, 32, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,   /* 0x1d80 */
105,101,115, 10                                                    /* 0x1d90 */
};
