/* armeb-linux.kernel.vmlinux.h
   created from armeb-linux.kernel.vmlinux.bin, 17090 (0x42c2) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_ARMEB_LINUX_KERNEL_VMLINUX_SIZE    17090
#define STUB_ARMEB_LINUX_KERNEL_VMLINUX_ADLER32 0xe011e9a9
#define STUB_ARMEB_LINUX_KERNEL_VMLINUX_CRC32   0x52a225da

unsigned char stub_armeb_linux_kernel_vmlinux[17090] = {
127, 69, 76, 70,  1,  2,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  0,  1,  0, 40,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
  0,  0, 23,180,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,   /* 0x  20 */
  0, 29,  0, 26,225,160, 16,  2,225,160, 32,  0,225,160,  0, 14,   /* 0x  30 */
229, 33,192,  4,233, 33, 32, 15,227,160, 48,  0,225,160,208,  1,   /* 0x  40 */
229,159, 16, 20,229, 45, 48,  4,229,159, 48, 16,229,141, 48,  8,   /* 0x  50 */
226,141, 48,  8,235,255,255,254,234,  0,  0, 14,  0,  0,  0,  0,   /* 0x  60 */
  0,  0,  0,  0,227, 80,  0,  0, 26,  0,  0, 14,229,157,  0, 12,   /* 0x  70 */
229,157, 16,  8,227,160, 32,  0,227,160, 48,  0,235,255,255,254,   /* 0x  80 */
232,157,112, 15,224,130,  0,  3,225,160,240, 14,226,  3, 48,255,   /* 0x  90 */
227, 83,  0, 80,227, 83,  0, 81, 17,160,240, 14,225,176, 17, 33,   /* 0x  a0 */
 19, 80,  0,  0,  1,160,240, 14,226, 65, 16,  1,231,144, 33,  1,   /* 0x  b0 */
226,  2, 52, 15,227, 83,  4, 11, 26,  0,  0, 12,226,  2, 52,255,   /* 0x  c0 */
224, 66, 32,  1,227,194, 36,255,225,130, 32,  3,231,128, 33,  1,   /* 0x  d0 */
227, 81,  0,  0, 26,  0,  0,  2,225,160,240, 14,224,129, 16,  0,   /* 0x  e0 */
233, 45, 64, 62,227,224, 80,  0,227,160, 65,  2,234,  0,  0, 23,   /* 0x  f0 */
232,189,  0, 26,224, 64,  0,  1,224, 66, 32,  3,229,132, 32,  0,   /* 0x 100 */
232,189,128, 48,224,148, 64,  4, 17,160,240, 14,228,208, 64,  1,   /* 0x 110 */
224,164, 64,  4,225,176, 76,  4,225,160,240, 14,227,160, 16,  1,   /* 0x 120 */
225,160,192, 14,235,  0,  0,  8,224,177, 16,  1,235,  0,  0,  8,   /* 0x 130 */
 58,  0,  0, 16,225,160,240, 12,228,208, 48,  1,228,194, 48,  1,   /* 0x 140 */
235,  0,  0,  8, 42,  0,  0, 21,235,  0,  0, 14,226, 81, 48,  3,   /* 0x 150 */
227,160, 16,  0, 58,  0,  0, 33,228,208, 80,  1,225,133, 84,  3,   /* 0x 160 */
225,240, 80,  5, 10,  0,  0,  3,235,  0,  0,  8,224,177, 16,  1,   /* 0x 170 */
235,  0,  0,  8,224,177, 16,  1, 26,  0,  0, 40,235,  0,  0, 14,   /* 0x 180 */
226,129, 16,  2,227,117, 12, 13, 50,129, 16,  1,231,210, 48,  5,   /* 0x 190 */
226, 81, 16,  1,228,194, 48,  1, 42,  0,  0, 42,234,  0,  0, 23,   /* 0x 1a0 */
233, 45, 64,252,224,129,112,  0,227,224, 80,  0,227,160, 65,  2,   /* 0x 1b0 */
234,  0,  0, 14,232,189,  0, 24,224, 64,  0,  7,224, 66, 32,  3,   /* 0x 1c0 */
229,132, 32,  0,232,189,128,240,228,208, 64,  1,224,164, 64,  4,   /* 0x 1d0 */
225,176, 76,  4,225,160,240, 14,228,208, 48,  1,228,194, 48,  1,   /* 0x 1e0 */
224,148, 64,  4, 11,  0,  0,  8, 42,  0,  0, 12,227,160, 16,  1,   /* 0x 1f0 */
234,  0,  0, 23,226, 65, 16,  1,224,148, 64,  4, 11,  0,  0,  8,   /* 0x 200 */
224,177, 16,  1,224,148, 64,  4, 11,  0,  0,  8,224,177, 16,  1,   /* 0x 210 */
224,148, 64,  4, 11,  0,  0,  8, 58,  0,  0, 19,226, 81, 48,  3,   /* 0x 220 */
227,160, 16,  0, 58,  0,  0, 38,228,208, 80,  1,225,133, 84,  3,   /* 0x 230 */
225,240, 80,  5, 10,  0,  0,  3,225,176, 80,197,234,  0,  0, 40,   /* 0x 240 */
224,148, 64,  4, 11,  0,  0,  8,224,177, 16,  1,224,148, 64,  4,   /* 0x 250 */
 11,  0,  0,  8,224,177, 16,  1, 26,  0,  0, 53,227,160, 16,  1,   /* 0x 260 */
224,148, 64,  4, 11,  0,  0,  8,224,177, 16,  1,224,148, 64,  4,   /* 0x 270 */
 11,  0,  0,  8, 58,  0,  0, 46,226,129, 16,  2,226,129, 16,  1,   /* 0x 280 */
227,117, 12,  5, 50,129, 16,  1,229,210, 48,  0,231,210, 48,  5,   /* 0x 290 */
228,194, 48,  1,226, 81, 16,  1, 26,  0,  0, 57,234,  0,  0, 14,   /* 0x 2a0 */
233, 45, 64,252,224,129,112,  0,227,224, 80,  0,227,160, 65,  2,   /* 0x 2b0 */
234,  0,  0, 14,232,189,  0, 24,224, 64,  0,  7,224, 66, 32,  3,   /* 0x 2c0 */
229,132, 32,  0,232,189,128,240,228,208, 64,  1,224,164, 64,  4,   /* 0x 2d0 */
225,176, 76,  4,225,160,240, 14,228,208, 48,  1,228,194, 48,  1,   /* 0x 2e0 */
224,148, 64,  4, 11,  0,  0,  8, 42,  0,  0, 12,227,160, 16,  1,   /* 0x 2f0 */
234,  0,  0, 23,226, 65, 16,  1,224,148, 64,  4, 11,  0,  0,  8,   /* 0x 300 */
224,161, 16,  1,224,148, 64,  4, 11,  0,  0,  8,224,161, 16,  1,   /* 0x 310 */
224,148, 64,  4, 11,  0,  0,  8, 58,  0,  0, 19,226, 81, 48,  3,   /* 0x 320 */
227,160, 16,  0, 58,  0,  0, 39,228,208, 80,  1,225,133, 84,  3,   /* 0x 330 */
225,240, 80,  5, 10,  0,  0,  3,225,176, 80,197, 42,  0,  0, 54,   /* 0x 340 */
234,  0,  0, 42,224,148, 64,  4, 11,  0,  0,  8, 42,  0,  0, 54,   /* 0x 350 */
227,160, 16,  1,224,148, 64,  4, 11,  0,  0,  8, 42,  0,  0, 54,   /* 0x 360 */
224,148, 64,  4, 11,  0,  0,  8,224,161, 16,  1,224,148, 64,  4,   /* 0x 370 */
 11,  0,  0,  8, 58,  0,  0, 46,226,129, 16,  4,234,  0,  0, 58,   /* 0x 380 */
224,148, 64,  4, 11,  0,  0,  8,224,161, 16,  1,226,129, 16,  2,   /* 0x 390 */
227,117, 12,  5, 50,129, 16,  1,224,130, 48,  1,229, 83, 48,  1,   /* 0x 3a0 */
231,210, 48,  5,228,194, 48,  1,226, 81, 16,  1, 26,  0,  0, 62,   /* 0x 3b0 */
234,  0,  0, 14,229,221,192,  0,227, 92,  0, 14, 26,255,255,254,   /* 0x 3c0 */
233, 45, 72,  0,229,208,176,  0,227,160,204,  6,225,160,177,171,   /* 0x 3d0 */
225,160,203, 28,225,160,176, 13,226,140,205, 58,224, 77,208, 12,   /* 0x 3e0 */
229,147,192,  0,229,141, 48,  8,229,141,192,  4,229,141, 32,  0,   /* 0x 3f0 */
226,141, 48, 12,227,160,192,  0,228,131,192,  4,225, 83,  0, 11,   /* 0x 400 */
 26,  0,  0, 15,226,141, 48, 12,226, 65, 32,  2,225,160, 16,  0,   /* 0x 410 */
228,209,192,  1,226, 12,192,  7,229,205,192, 18,228,209,192,  1,   /* 0x 420 */
225,160,  2, 44,229,205,  0, 17,226, 12,192, 15,229,205,192, 16,   /* 0x 430 */
226,141,  0, 16,235,  0,  0, 33,225,160,208, 11,232,189,136,  0,   /* 0x 440 */
233, 45, 79,240,226, 77,208, 48,229,141, 48,  0,229,208, 48,  0,   /* 0x 450 */
229,208, 80,  2,229,208,224,  1,229,157,192,  0,229,141, 48, 20,   /* 0x 460 */
229,157, 48, 92,227,160, 64,  0,229,140, 64,  0,229,131, 64,  0,   /* 0x 470 */
229,157,192, 20,229,208, 48,  1,224,140, 48,  3,227,160,204,  3,   /* 0x 480 */
225,160,195, 28,227,160, 48,  1,225,160,238, 19,225,160, 53, 19,   /* 0x 490 */
226,140,206,115,226, 67, 48,  1,226, 78,224,  1,226,128,  0,  4,   /* 0x 4a0 */
226,140,192,  6,229,141, 16,  4,229,141, 48, 12,229,141,224, 16,   /* 0x 4b0 */
229,141,  0,  8,234,  0,  0, 31,229,157,  0,  8,227,160, 27,  1,   /* 0x 4c0 */
225,131, 16,176,225, 84,  0, 12,225,160, 48,132,226,132, 64,  1,   /* 0x 4d0 */
 26,  0,  0, 28,229,157, 48,  4,227,160, 96,  0,224,131,144,  2,   /* 0x 4e0 */
225,160,224,  3,225,160, 32,  6,229,157, 80,  4,224,101, 48,  9,   /* 0x 4f0 */
225, 82,  0,  3,226,142,224,  1, 10,  0,  2, 73,231,210, 48,  5,   /* 0x 500 */
226,130, 32,  1,227, 82,  0,  5,225,131,100,  6, 26,  0,  0, 40,   /* 0x 510 */
227,160,176,  0,227,160,192,  1,225,160,112, 11,227,224,  0,  0,   /* 0x 520 */
229,141,192, 44,229,141,176, 24,229,141,192, 28,229,141,192, 32,   /* 0x 530 */
229,141,192, 36,234,  0,  2, 57,227,224,132,255,225, 80,  0,  8,   /* 0x 540 */
138,  0,  0, 68,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,   /* 0x 550 */
225,160,  4,  0,225,131,100,  6,229,157, 16, 12,229,157, 32, 24,   /* 0x 560 */
224, 11,160,  1,225,160, 18,  2,224,138, 48,  1,225,160, 80,131,   /* 0x 570 */
229,157, 48,  8,225,147,192,181,225,160, 53,160,224,  4,  3,156,   /* 0x 580 */
225, 86,  0,  4, 42,  0,  0,185,229,157,  0, 20,226, 96, 48,  8,   /* 0x 590 */
225,160, 51, 87,229,157, 16, 16,224, 11, 32,  1,224,131, 48, 18,   /* 0x 5a0 */
229,157,  0,  8,227,160, 44,  6,224, 34,  2,147,229,157, 16, 24,   /* 0x 5b0 */
226,108, 59,  2,227, 81,  0,  6,224,140, 50,195,226,130,142,230,   /* 0x 5c0 */
225,128, 48,181,226,136,128, 12,209,160,  0,  4,211,160, 16,  1,   /* 0x 5d0 */
218,  0,  0,164,229,157, 32, 44,229,157, 80, 84,224, 98, 48, 11,   /* 0x 5e0 */
231,213,112,  3,225,160,  0,  4,227,160, 16,  1,225,160,112,135,   /* 0x 5f0 */
226,  7, 92,  1,225,160,160,129,224,136, 48,133,224,131, 48, 10,   /* 0x 600 */
227, 80,  4,  1,226,131, 76,  2,226,129,192,  1, 42,  0,  0,119,   /* 0x 610 */
225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,   /* 0x 620 */
225,131,100,  6,225,212, 48,176,225,160, 37,160,224,129, 16, 12,   /* 0x 630 */
224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,   /* 0x 640 */
224, 67, 50,163, 42,  0,  0,135,227, 85,  0,  0,225,160,  0, 12,   /* 0x 650 */
225,196, 32,176,225,160, 16, 10, 10,  0,  0,140,225,160,  0, 12,   /* 0x 660 */
234,  0,  0,164,227, 85,  0,  0,225,196, 48,176,224,108, 96,  6,   /* 0x 670 */
224,108,  0,  0, 10,  0,  0,164,227, 81,  0,255,202,  0,  0,168,   /* 0x 680 */
234,  0,  0,105,227, 80,  4,  1,224,129, 16,  3, 42,  0,  0,151,   /* 0x 690 */
225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,   /* 0x 6a0 */
225,131,100,  6,225,152, 48,180,225,160, 37,160,224, 12,  2,147,   /* 0x 6b0 */
226, 99, 43,  2,225, 86,  0, 12,224, 67, 82,163,224,131, 50,194,   /* 0x 6c0 */
 49,136, 48,180, 33,136, 80,180,224,108,  0,  0, 49,160, 16,  4,   /* 0x 6d0 */
 49,160,  0, 12, 32,108, 96,  6,227, 81,  0,255,225,160, 64,129,   /* 0x 6e0 */
226,129, 48,  1,218,  0,  0,143,229,157,192, 24,226,  1,112,255,   /* 0x 6f0 */
227, 92,  0,  3,229,157, 16, 84,211,160, 32,  0,231,193,112, 11,   /* 0x 700 */
226,139,176,  1,213,141, 32, 24,218,  0,  2, 57,229,157, 48, 24,   /* 0x 710 */
227, 83,  0,  9,197,157, 80, 24,210, 67, 48,  3,194, 69, 80,  6,   /* 0x 720 */
213,141, 48, 24,197,141, 80, 24,234,  0,  2, 57,224, 76, 50,172,   /* 0x 730 */
224,100, 32,  0,229,157,192,  8,225, 82,  0,  8,225,140, 48,181,   /* 0x 740 */
224,100, 96,  6,138,  0,  0,197,225, 94,  0,  9, 10,  0,  2, 73,   /* 0x 750 */
228,222, 48,  1,225,160, 36,  2,225,131,100,  6,229,157,  0,  8,   /* 0x 760 */
229,157, 48, 24,224,128,112,131,226,135, 13,  6,225,208,192,176,   /* 0x 770 */
225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  0,225,   /* 0x 780 */
229,157, 32, 24,229,157, 80,  8,227, 82,  0,  6,226,108, 59,  2,   /* 0x 790 */
226,133, 30,102,195,160, 32,  3,229,157, 80, 32,211,160, 32,  0,   /* 0x 7a0 */
224,140, 50,195,229,141, 32, 24,229,157,192, 28,229,157, 32, 44,   /* 0x 7b0 */
229,141, 80, 36,226,129, 16,  4,225,160, 80,  4,229,141,192, 32,   /* 0x 7c0 */
229,141, 32, 28,225,192, 48,176,234,  0,  1, 98,224,100, 32,  2,   /* 0x 7d0 */
224, 76, 50,172,225, 82,  0,  8,225,192, 48,176,224,100, 96,  6,   /* 0x 7e0 */
138,  0,  0,236,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,   /* 0x 7f0 */
225,160, 36,  2,225,131,100,  6,226,135, 95,102,225,213,192,176,   /* 0x 800 */
225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 26,   /* 0x 810 */
226,108, 59,  2,224,140, 50,195,225, 84,  0,  8,225,197, 48,176,   /* 0x 820 */
138,  0,  0,252,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,   /* 0x 830 */
225,160, 68,  4,225,131,100,  6,229,157, 80,  8,224,133, 48,129,   /* 0x 840 */
224,131, 48,138,226,131, 30, 30,225,209,192,176,225,160, 53,164,   /* 0x 850 */
224,  2,  3,156,225, 86,  0,  2, 32, 98, 96,  6, 32, 76, 50,172,   /* 0x 860 */
 32, 98, 80,  4, 42,  0,  1, 50,226,108, 59,  2,224,140, 50,195,   /* 0x 870 */
227, 91,  0,  0,225,193, 48,176, 10,  0,  2, 73,229,157,192, 44,   /* 0x 880 */
229,157, 16, 24,229,157,  0, 84,224,108, 48, 11,231,208,112,  3,   /* 0x 890 */
227, 81,  0,  6,195,160, 16, 11,211,160, 16,  9,229,141, 16, 24,   /* 0x 8a0 */
231,192,112, 11,225,160,  0,  2,226,139,176,  1,234,  0,  2, 57,   /* 0x 8b0 */
224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,225,197, 48,176,   /* 0x 8c0 */
224,100, 96,  6,138,  0,  1, 37,225, 94,  0,  9, 10,  0,  2, 73,   /* 0x 8d0 */
228,222, 48,  1,225,160, 36,  2,225,131,100,  6,226,135, 30, 27,   /* 0x 8e0 */
225,209,192,176,225,160, 53,162,224,  4,  3,156,225, 86,  0,  4,   /* 0x 8f0 */
 42,  0,  1, 52,229,157, 80, 44,226,108, 59,  2,229,157, 32, 28,   /* 0x 900 */
224,140, 50,195,229,141, 80, 28,225,160, 80,  4,229,141, 32, 44,   /* 0x 910 */
225,193, 48,176,234,  0,  1, 90,224,100, 32,  2,224, 76, 50,172,   /* 0x 920 */
225, 82,  0,  8,225,193, 48,176,224,100, 96,  6,138,  0,  1, 63,   /* 0x 930 */
225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,   /* 0x 940 */
225,131,100,  6,226,135, 31,114,225,209,192,176,225,160, 53,162,   /* 0x 950 */
224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 78,226,108, 59,  2,   /* 0x 960 */
229,157, 32, 32,224,140, 50,195,229,157,  0, 44,229,157,192, 28,   /* 0x 970 */
225,160, 80,  4,229,141,192, 32,229,141,  0, 28,234,  0,  1, 49,   /* 0x 980 */
224, 76, 50,172,225,193, 48,176,229,157,192, 44,226,141, 16, 32,   /* 0x 990 */
232,145,  0, 10,224,100, 80,  2,229,157, 32, 28,229,141, 16, 36,   /* 0x 9a0 */
229,141, 32, 32,229,141,192, 28,229,141, 48, 44,224,100, 96,  6,   /* 0x 9b0 */
229,157, 32, 24,229,157,  0,  8,227, 82,  0,  6,195,160, 32, 11,   /* 0x 9c0 */
211,160, 32,  8,226,128, 30,166,229,141, 32, 24,226,129, 16,  8,   /* 0x 9d0 */
227,224,116,255,225, 85,  0,  7,138,  0,  1,106,225, 94,  0,  9,   /* 0x 9e0 */
 10,  0,  2, 73,228,222, 48,  1,225,160, 84,  5,225,131,100,  6,   /* 0x 9f0 */
225,209,192,176,225,160, 53,165,224,  4,  3,156,225, 86,  0,  4,   /* 0x a00 */
 42,  0,  1,120,224,129, 34, 10,226,108, 59,  2,224,140, 50,195,   /* 0x a10 */
226,130, 80,  4,225,160,  0,  4,227,160,160,  3,227,160,128,  0,   /* 0x a20 */
225,193, 48,176,234,  0,  1,152,224,100, 32,  5,224, 76, 50,172,   /* 0x a30 */
225, 82,  0,  7,224,100, 96,  6,225,193, 48,176,138,  0,  1,131,   /* 0x a40 */
225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,   /* 0x a50 */
225,131,100,  6,225,209,192,178,225,160, 53,162,224,  4,  3,156,   /* 0x a60 */
225, 86,  0,  4, 42,  0,  1,145,224,129, 34, 10,226,108, 59,  2,   /* 0x a70 */
224,140, 50,195,226,130, 95, 65,225,160,  0,  4,227,160,160,  3,   /* 0x a80 */
227,160,128,  8,225,193, 48,178,234,  0,  1,152,224, 76, 50,172,   /* 0x a90 */
225,193, 48,178,224,100, 96,  6,224,100,  0,  2,226,129, 95,129,   /* 0x aa0 */
227,160,160,  8,227,160,128, 16,225,160,112, 10,227,160, 16,  1,   /* 0x ab0 */
226,129, 48,  1,227, 80,  4,  1,225,160, 64,129,224,129, 16,  3,   /* 0x ac0 */
 42,  0,  1,164,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,   /* 0x ad0 */
228,222, 48,  1,225,131,100,  6,225,149, 48,180,225,160, 37,160,   /* 0x ae0 */
224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,   /* 0x af0 */
224, 67, 50,163,224,108,  0,  0, 49,160, 16,  4, 49,160,  0, 12,   /* 0x b00 */
 49,133, 32,180, 32,108, 96,  6, 33,133, 48,180,226, 87,112,  1,   /* 0x b10 */
 26,  0,  1,154,227,160, 32,  1,224, 65, 58, 18,229,157, 80, 24,   /* 0x b20 */
224,131, 48,  8,227, 85,  0,  3,229,141, 48, 40,202,  0,  2, 36,   /* 0x b30 */
229,157,192,  8,227, 83,  0,  3,163,160, 48,  3,224,140, 51,131,   /* 0x b40 */
226,131, 94, 54,225,160,112,  2,227,160,128,  6,226,135, 48,  1,   /* 0x b50 */
227, 80,  4,  1,225,160, 64,135,224,135,112,  3, 42,  0,  1,203,   /* 0x b60 */
225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,   /* 0x b70 */
225,131,100,  6,225,149, 48,180,225,160, 37,160,224, 12,  2,147,   /* 0x b80 */
226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,   /* 0x b90 */
224,108,  0,  0, 49,160,112,  4, 49,160,  0, 12, 49,133, 32,180,   /* 0x ba0 */
 32,108, 96,  6, 33,133, 48,180,226, 88,128,  1, 26,  0,  1,193,   /* 0x bb0 */
226, 71, 32, 64,227, 82,  0,  3,209,160, 80,  2,218,  0,  2, 30,   /* 0x bc0 */
225,160, 64,194,227, 82,  0, 13,226,  2, 48,  1,226, 68,112,  1,   /* 0x bd0 */
227,131,192,  2,194, 68, 64,  5,193,160, 32,  8,202,  0,  1,237,   /* 0x be0 */
225,160, 87, 28,229,157, 16,  8,224,129, 48,133,224, 67, 48,130,   /* 0x bf0 */
226,131, 78, 85,226,132, 64, 14,234,  0,  2,  1,227, 80,  4,  1,   /* 0x c00 */
226,130, 32,  1, 42,  0,  1,245,225, 94,  0,  9,225,160,  4,  0,   /* 0x c10 */
 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,160,  0,160,   /* 0x c20 */
225, 86,  0,  0,225,160,192,140, 32, 96, 96,  6, 35,140,192,  1,   /* 0x c30 */
225, 82,  0,  4, 26,  0,  1,237,229,157, 32,  8,226,130, 77, 25,   /* 0x c40 */
226,132, 64,  4,225,160, 82, 12,227,160,112,  4,227,160,160,  1,   /* 0x c50 */
225,160,128, 10,227, 80,  4,  1,225,160, 16,136,226,136,192,  1,   /* 0x c60 */
 42,  0,  2, 12,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,   /* 0x c70 */
228,222, 48,  1,225,131,100,  6,225,148, 48,177,225,160, 37,160,   /* 0x c80 */
224,136,128, 12,224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,   /* 0x c90 */
224,131, 34,194,224, 67, 50,163, 33,133, 80, 10, 49,160,128,  1,   /* 0x ca0 */
 49,160,  0, 12, 49,132, 32,177, 33,132, 48,177, 32,108, 96,  6,   /* 0x cb0 */
 32,108,  0,  0,226, 87,112,  1,225,160,160,138, 26,  0,  2,  3,   /* 0x cc0 */
226,149, 80,  1,229,141, 80, 44, 10,  0,  2, 60,229,157, 48, 24,   /* 0x cd0 */
226,131, 48,  7,229,141, 48, 24,229,157, 80, 44,225, 85,  0, 11,   /* 0x ce0 */
138,  0,  2, 73,229,157,192, 40,229,157, 16, 84,224,101, 48, 11,   /* 0x cf0 */
226,140, 32,  2,224,129, 64,  3,224,129,192, 11,226, 82, 32,  1,   /* 0x d00 */
229,157, 80, 88,  3,160, 48,  0, 19,160, 48,  1,226,139,176,  1,   /* 0x d10 */
225, 91,  0,  5, 35,160, 48,  0, 50,  3, 48,  1,228,212,112,  1,   /* 0x d20 */
227, 83,  0,  0,228,204,112,  1, 26,  0,  2, 45,229,157,192, 88,   /* 0x d30 */
225, 91,  0, 12, 58,  0,  0, 60,227, 80,  4,  1, 42,  0,  2, 65,   /* 0x d40 */
225, 94,  0,  9, 10,  0,  2, 73,226,142,224,  1,229,157,  0,  4,   /* 0x d50 */
229,157, 16,  0,229,157, 32, 92,224, 96, 48, 14,227,160,  0,  0,   /* 0x d60 */
229,129, 48,  0,229,130,176,  0,234,  0,  2, 74,227,160,  0,  1,   /* 0x d70 */
226,141,208, 48,232,189,143,240,233, 45, 79,240,226, 77,208, 48,   /* 0x d80 */
229,141, 48,  0,229,208, 48,  0,229,208, 80,  2,229,208,224,  1,   /* 0x d90 */
229,157,192,  0,229,141, 48, 20,229,157, 48, 92,227,160, 64,  0,   /* 0x da0 */
229,140, 64,  0,229,131, 64,  0,229,157,192, 20,229,208, 48,  1,   /* 0x db0 */
224,140, 48,  3,227,160,204,  3,225,160,195, 28,227,160, 48,  1,   /* 0x dc0 */
225,160,238, 19,225,160, 53, 19,226,140,206,115,226, 67, 48,  1,   /* 0x dd0 */
226, 78,224,  1,226,128,  0,  4,226,140,192,  6,229,141, 16,  4,   /* 0x de0 */
229,141, 48, 12,229,141,224, 16,229,141,  0,  8,234,  0,  0, 31,   /* 0x df0 */
229,157,  0,  8,227,160, 27,  1,225,131, 16,176,225, 84,  0, 12,   /* 0x e00 */
225,160, 48,132,226,132, 64,  1, 26,  0,  0, 28,229,157, 48,  4,   /* 0x e10 */
227,160, 96,  0,224,131,144,  2,225,160,224,  3,225,160, 32,  6,   /* 0x e20 */
229,157, 80,  4,224,101, 48,  9,225, 82,  0,  3,226,142,224,  1,   /* 0x e30 */
 10,  0,  2, 73,231,210, 48,  5,226,130, 32,  1,227, 82,  0,  5,   /* 0x e40 */
225,131,100,  6, 26,  0,  0, 40,227,160,176,  0,227,160,192,  1,   /* 0x e50 */
225,160,112, 11,227,224,  0,  0,229,141,192, 44,229,141,176, 24,   /* 0x e60 */
229,141,192, 28,229,141,192, 32,229,141,192, 36,234,  0,  2, 57,   /* 0x e70 */
227,224,132,255,225, 80,  0,  8,138,  0,  0, 68,225, 94,  0,  9,   /* 0x e80 */
 10,  0,  2, 73,228,222, 48,  1,225,160,  4,  0,225,131,100,  6,   /* 0x e90 */
229,157, 16, 12,229,157, 32, 24,224, 11,160,  1,225,160, 18,  2,   /* 0x ea0 */
224,138, 48,  1,225,160, 80,131,229,157, 48,  8,225,147,192,181,   /* 0x eb0 */
225,160, 53,160,224,  4,  3,156,225, 86,  0,  4, 42,  0,  0,185,   /* 0x ec0 */
229,157,  0, 20,226, 96, 48,  8,225,160, 51, 87,229,157, 16, 16,   /* 0x ed0 */
224, 11, 32,  1,224,131, 48, 18,229,157,  0,  8,227,160, 44,  6,   /* 0x ee0 */
224, 34,  2,147,229,157, 16, 24,226,108, 59,  2,227, 81,  0,  6,   /* 0x ef0 */
224,140, 50,195,226,130,142,230,225,128, 48,181,226,136,128, 12,   /* 0x f00 */
209,160,  0,  4,211,160, 16,  1,218,  0,  0,164,229,157, 32, 44,   /* 0x f10 */
229,157, 80, 84,224, 98, 48, 11,231,213,112,  3,225,160,  0,  4,   /* 0x f20 */
227,160, 16,  1,225,160,112,135,226,  7, 92,  1,225,160,160,129,   /* 0x f30 */
224,136, 48,133,224,131, 48, 10,227, 80,  4,  1,226,131, 76,  2,   /* 0x f40 */
226,129,192,  1, 42,  0,  0,119,225, 94,  0,  9,225,160,  4,  0,   /* 0x f50 */
 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,212, 48,176,   /* 0x f60 */
225,160, 37,160,224,129, 16, 12,224, 12,  2,147,226, 99, 43,  2,   /* 0x f70 */
225, 86,  0, 12,224,131, 34,194,224, 67, 50,163, 42,  0,  0,135,   /* 0x f80 */
227, 85,  0,  0,225,160,  0, 12,225,196, 32,176,225,160, 16, 10,   /* 0x f90 */
 10,  0,  0,140,225,160,  0, 12,234,  0,  0,164,227, 85,  0,  0,   /* 0x fa0 */
225,196, 48,176,224,108, 96,  6,224,108,  0,  0, 10,  0,  0,164,   /* 0x fb0 */
227, 81,  0,255,202,  0,  0,168,234,  0,  0,105,227, 80,  4,  1,   /* 0x fc0 */
224,129, 16,  3, 42,  0,  0,151,225, 94,  0,  9,225,160,  4,  0,   /* 0x fd0 */
 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,152, 48,180,   /* 0x fe0 */
225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,   /* 0x ff0 */
224, 67, 82,163,224,131, 50,194, 49,136, 48,180, 33,136, 80,180,   /* 0x1000 */
224,108,  0,  0, 49,160, 16,  4, 49,160,  0, 12, 32,108, 96,  6,   /* 0x1010 */
227, 81,  0,255,225,160, 64,129,226,129, 48,  1,218,  0,  0,143,   /* 0x1020 */
229,157,192, 24,226,  1,112,255,227, 92,  0,  3,229,157, 16, 84,   /* 0x1030 */
211,160, 32,  0,231,193,112, 11,226,139,176,  1,213,141, 32, 24,   /* 0x1040 */
218,  0,  2, 57,229,157, 48, 24,227, 83,  0,  9,197,157, 80, 24,   /* 0x1050 */
210, 67, 48,  3,194, 69, 80,  6,213,141, 48, 24,197,141, 80, 24,   /* 0x1060 */
234,  0,  2, 57,224, 76, 50,172,224,100, 32,  0,229,157,192,  8,   /* 0x1070 */
225, 82,  0,  8,225,140, 48,181,224,100, 96,  6,138,  0,  0,197,   /* 0x1080 */
225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,   /* 0x1090 */
225,131,100,  6,229,157,  0,  8,229,157, 48, 24,224,128,112,131,   /* 0x10a0 */
226,135, 13,  6,225,208,192,176,225,160, 53,162,224,  4,  3,156,   /* 0x10b0 */
225, 86,  0,  4, 42,  0,  0,225,229,157, 32, 24,229,157, 80,  8,   /* 0x10c0 */
227, 82,  0,  6,226,108, 59,  2,226,133, 30,102,195,160, 32,  3,   /* 0x10d0 */
229,157, 80, 32,211,160, 32,  0,224,140, 50,195,229,141, 32, 24,   /* 0x10e0 */
229,157,192, 28,229,157, 32, 44,229,141, 80, 36,226,129, 16,  4,   /* 0x10f0 */
225,160, 80,  4,229,141,192, 32,229,141, 32, 28,225,192, 48,176,   /* 0x1100 */
234,  0,  1, 98,224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,   /* 0x1110 */
225,192, 48,176,224,100, 96,  6,138,  0,  0,236,225, 94,  0,  9,   /* 0x1120 */
 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,225,131,100,  6,   /* 0x1130 */
226,135, 95,102,225,213,192,176,225,160, 53,162,224,  4,  3,156,   /* 0x1140 */
225, 86,  0,  4, 42,  0,  1, 26,226,108, 59,  2,224,140, 50,195,   /* 0x1150 */
225, 84,  0,  8,225,197, 48,176,138,  0,  0,252,225, 94,  0,  9,   /* 0x1160 */
 10,  0,  2, 73,228,222, 48,  1,225,160, 68,  4,225,131,100,  6,   /* 0x1170 */
229,157, 80,  8,224,133, 48,129,224,131, 48,138,226,131, 30, 30,   /* 0x1180 */
225,209,192,176,225,160, 53,164,224,  2,  3,156,225, 86,  0,  2,   /* 0x1190 */
 32, 98, 96,  6, 32, 76, 50,172, 32, 98, 80,  4, 42,  0,  1, 50,   /* 0x11a0 */
226,108, 59,  2,224,140, 50,195,227, 91,  0,  0,225,193, 48,176,   /* 0x11b0 */
 10,  0,  2, 73,229,157,192, 44,229,157, 16, 24,229,157,  0, 84,   /* 0x11c0 */
224,108, 48, 11,231,208,112,  3,227, 81,  0,  6,195,160, 16, 11,   /* 0x11d0 */
211,160, 16,  9,229,141, 16, 24,231,192,112, 11,225,160,  0,  2,   /* 0x11e0 */
226,139,176,  1,234,  0,  2, 57,224,100, 32,  2,224, 76, 50,172,   /* 0x11f0 */
225, 82,  0,  8,225,197, 48,176,224,100, 96,  6,138,  0,  1, 37,   /* 0x1200 */
225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,   /* 0x1210 */
225,131,100,  6,226,135, 30, 27,225,209,192,176,225,160, 53,162,   /* 0x1220 */
224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 52,229,157, 80, 44,   /* 0x1230 */
226,108, 59,  2,229,157, 32, 28,224,140, 50,195,229,141, 80, 28,   /* 0x1240 */
225,160, 80,  4,229,141, 32, 44,225,193, 48,176,234,  0,  1, 90,   /* 0x1250 */
224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,225,193, 48,176,   /* 0x1260 */
224,100, 96,  6,138,  0,  1, 63,225, 94,  0,  9, 10,  0,  2, 73,   /* 0x1270 */
228,222, 48,  1,225,160, 36,  2,225,131,100,  6,226,135, 31,114,   /* 0x1280 */
225,209,192,176,225,160, 53,162,224,  4,  3,156,225, 86,  0,  4,   /* 0x1290 */
 42,  0,  1, 78,226,108, 59,  2,229,157, 32, 32,224,140, 50,195,   /* 0x12a0 */
229,157,  0, 44,229,157,192, 28,225,160, 80,  4,229,141,192, 32,   /* 0x12b0 */
229,141,  0, 28,234,  0,  1, 49,224, 76, 50,172,225,193, 48,176,   /* 0x12c0 */
229,157,192, 44,226,141, 16, 32,232,145,  0, 10,224,100, 80,  2,   /* 0x12d0 */
229,157, 32, 28,229,141, 16, 36,229,141, 32, 32,229,141,192, 28,   /* 0x12e0 */
229,141, 48, 44,224,100, 96,  6,229,157, 32, 24,229,157,  0,  8,   /* 0x12f0 */
227, 82,  0,  6,195,160, 32, 11,211,160, 32,  8,226,128, 30,166,   /* 0x1300 */
229,141, 32, 24,226,129, 16,  8,227,224,116,255,225, 85,  0,  7,   /* 0x1310 */
138,  0,  1,106,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,   /* 0x1320 */
225,160, 84,  5,225,131,100,  6,225,209,192,176,225,160, 53,165,   /* 0x1330 */
224,  4,  3,156,225, 86,  0,  4, 42,  0,  1,120,224,129, 34, 10,   /* 0x1340 */
226,108, 59,  2,224,140, 50,195,226,130, 80,  4,225,160,  0,  4,   /* 0x1350 */
227,160,160,  3,227,160,128,  0,225,193, 48,176,234,  0,  1,152,   /* 0x1360 */
224,100, 32,  5,224, 76, 50,172,225, 82,  0,  7,224,100, 96,  6,   /* 0x1370 */
225,193, 48,176,138,  0,  1,131,225, 94,  0,  9, 10,  0,  2, 73,   /* 0x1380 */
228,222, 48,  1,225,160, 36,  2,225,131,100,  6,225,209,192,178,   /* 0x1390 */
225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1,145,   /* 0x13a0 */
224,129, 34, 10,226,108, 59,  2,224,140, 50,195,226,130, 95, 65,   /* 0x13b0 */
225,160,  0,  4,227,160,160,  3,227,160,128,  8,225,193, 48,178,   /* 0x13c0 */
234,  0,  1,152,224, 76, 50,172,225,193, 48,178,224,100, 96,  6,   /* 0x13d0 */
224,100,  0,  2,226,129, 95,129,227,160,160,  8,227,160,128, 16,   /* 0x13e0 */
225,160,112, 10,227,160, 16,  1,226,129, 48,  1,227, 80,  4,  1,   /* 0x13f0 */
225,160, 64,129,224,129, 16,  3, 42,  0,  1,164,225, 94,  0,  9,   /* 0x1400 */
225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,   /* 0x1410 */
225,149, 48,180,225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,   /* 0x1420 */
225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,224,108,  0,  0,   /* 0x1430 */
 49,160, 16,  4, 49,160,  0, 12, 49,133, 32,180, 32,108, 96,  6,   /* 0x1440 */
 33,133, 48,180,226, 87,112,  1, 26,  0,  1,154,227,160, 32,  1,   /* 0x1450 */
224, 65, 58, 18,229,157, 80, 24,224,131, 48,  8,227, 85,  0,  3,   /* 0x1460 */
229,141, 48, 40,202,  0,  2, 36,229,157,192,  8,227, 83,  0,  3,   /* 0x1470 */
163,160, 48,  3,224,140, 51,131,226,131, 94, 54,225,160,112,  2,   /* 0x1480 */
227,160,128,  6,226,135, 48,  1,227, 80,  4,  1,225,160, 64,135,   /* 0x1490 */
224,135,112,  3, 42,  0,  1,203,225, 94,  0,  9,225,160,  4,  0,   /* 0x14a0 */
 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,149, 48,180,   /* 0x14b0 */
225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,   /* 0x14c0 */
224,131, 34,194,224, 67, 50,163,224,108,  0,  0, 49,160,112,  4,   /* 0x14d0 */
 49,160,  0, 12, 49,133, 32,180, 32,108, 96,  6, 33,133, 48,180,   /* 0x14e0 */
226, 88,128,  1, 26,  0,  1,193,226, 71, 32, 64,227, 82,  0,  3,   /* 0x14f0 */
209,160, 80,  2,218,  0,  2, 30,225,160, 64,194,227, 82,  0, 13,   /* 0x1500 */
226,  2, 48,  1,226, 68,112,  1,227,131,192,  2,194, 68, 64,  5,   /* 0x1510 */
193,160, 32,  8,202,  0,  1,237,225,160, 87, 28,229,157, 16,  8,   /* 0x1520 */
224,129, 48,133,224, 67, 48,130,226,131, 78, 85,226,132, 64, 14,   /* 0x1530 */
234,  0,  2,  1,227, 80,  4,  1,226,130, 32,  1, 42,  0,  1,245,   /* 0x1540 */
225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,   /* 0x1550 */
225,131,100,  6,225,160,  0,160,225, 86,  0,  0,225,160,192,140,   /* 0x1560 */
 32, 96, 96,  6, 35,140,192,  1,225, 82,  0,  4, 26,  0,  1,237,   /* 0x1570 */
229,157, 32,  8,226,130, 77, 25,226,132, 64,  4,225,160, 82, 12,   /* 0x1580 */
227,160,112,  4,227,160,160,  1,225,160,128, 10,227, 80,  4,  1,   /* 0x1590 */
225,160, 16,136,226,136,192,  1, 42,  0,  2, 12,225, 94,  0,  9,   /* 0x15a0 */
225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,   /* 0x15b0 */
225,148, 48,177,225,160, 37,160,224,136,128, 12,224, 12,  2,147,   /* 0x15c0 */
226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,   /* 0x15d0 */
 33,133, 80, 10, 49,160,128,  1, 49,160,  0, 12, 49,132, 32,177,   /* 0x15e0 */
 33,132, 48,177, 32,108, 96,  6, 32,108,  0,  0,226, 87,112,  1,   /* 0x15f0 */
225,160,160,138, 26,  0,  2,  3,226,149, 80,  1,229,141, 80, 44,   /* 0x1600 */
 10,  0,  2, 60,229,157, 48, 24,226,131, 48,  7,229,141, 48, 24,   /* 0x1610 */
229,157, 80, 44,225, 85,  0, 11,138,  0,  2, 73,229,157,192, 40,   /* 0x1620 */
229,157, 16, 84,224,101, 48, 11,226,140, 32,  2,224,129, 64,  3,   /* 0x1630 */
224,129,192, 11,226, 82, 32,  1,229,157, 80, 88,  3,160, 48,  0,   /* 0x1640 */
 19,160, 48,  1,226,139,176,  1,225, 91,  0,  5, 35,160, 48,  0,   /* 0x1650 */
 50,  3, 48,  1,228,212,112,  1,227, 83,  0,  0,228,204,112,  1,   /* 0x1660 */
 26,  0,  2, 45,229,157,192, 88,225, 91,  0, 12, 58,  0,  0, 60,   /* 0x1670 */
227, 80,  4,  1, 42,  0,  2, 65,225, 94,  0,  9, 10,  0,  2, 73,   /* 0x1680 */
226,142,224,  1,229,157,  0,  4,229,157, 16,  0,229,157, 32, 92,   /* 0x1690 */
224, 96, 48, 14,227,160,  0,  0,229,129, 48,  0,229,130,176,  0,   /* 0x16a0 */
234,  0,  2, 74,227,160,  0,  1,226,141,208, 48,232,189,143,240,   /* 0x16b0 */
 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x16c0 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,   /* 0x16d0 */
116,109,112, 47, 97,114,109,101, 98, 45,108,105,110,117,120, 46,   /* 0x16e0 */
107,101,114,110,101,108, 46,118,109,108,105,110,117,120, 46, 98,   /* 0x16f0 */
105,110, 58, 32, 32, 32, 32, 32,102,105,108,101, 32,102,111,114,   /* 0x1700 */
109, 97,116, 32,101,108,102, 51, 50, 45, 98,105,103, 97,114,109,   /* 0x1710 */
 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32,   /* 0x1720 */
 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,   /* 0x1730 */
122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32,   /* 0x1740 */
 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101,   /* 0x1750 */
 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,   /* 0x1760 */
115, 10, 32, 32, 48, 32, 76, 73, 78, 85, 88, 48, 48, 48, 32, 32,   /* 0x1770 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 48, 48,   /* 0x1780 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1790 */
 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48,   /* 0x17a0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x17b0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32,   /* 0x17c0 */
 76, 73, 78, 85, 88, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x17d0 */
 48, 48, 48, 48, 49, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x17e0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x17f0 */
 48, 48, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1800 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x1810 */
 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 76, 73, 78, 85, 88, 48,   /* 0x1820 */
 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99,   /* 0x1830 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1840 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 48, 32, 32,   /* 0x1850 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x1860 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 99,116,111,   /* 0x1870 */
107, 51, 50, 46, 48, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x1880 */
 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1890 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57,   /* 0x18a0 */
 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x18b0 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32,   /* 0x18c0 */
 99,116,111,107, 51, 50, 46, 53, 48, 32, 32, 32, 32, 32, 48, 48,   /* 0x18d0 */
 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x18e0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x18f0 */
 48, 48, 97, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1900 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x1910 */
 32, 53, 32, 99,116,111,107, 51, 50, 46, 53, 49, 32, 32, 32, 32,   /* 0x1920 */
 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48,   /* 0x1930 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1940 */
 48, 48, 48, 48, 48, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1950 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1960 */
 89, 10, 32, 32, 54, 32, 99,116,111,107, 51, 50, 46, 49, 48, 32,   /* 0x1970 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 52, 32, 32, 48, 48,   /* 0x1980 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1990 */
 32, 32, 48, 48, 48, 48, 48, 48, 97, 56, 32, 32, 50, 42, 42, 48,   /* 0x19a0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x19b0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32,   /* 0x19c0 */
 76, 73, 78, 85, 88, 48, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x19d0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x19e0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x19f0 */
 48, 48,101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1a00 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x1a10 */
 32, 56, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1a20 */
 32, 48, 48, 48, 48, 48, 48, 99, 52, 32, 32, 48, 48, 48, 48, 48,   /* 0x1a30 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1a40 */
 48, 48, 48, 48, 48,101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1a50 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x1a60 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 78, 82, 86,   /* 0x1a70 */
 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x1a80 */
 49, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1a90 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 98,   /* 0x1aa0 */
 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x1ab0 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x1ac0 */
 76, 89, 10, 32, 49, 48, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32,   /* 0x1ad0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 49, 52, 32, 32, 48,   /* 0x1ae0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1af0 */
 48, 32, 32, 48, 48, 48, 48, 48, 50, 98, 48, 32, 32, 50, 42, 42,   /* 0x1b00 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x1b10 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49,   /* 0x1b20 */
 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48,   /* 0x1b30 */
 48, 48, 48, 48, 48, 56, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1b40 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1b50 */
 48, 48, 51, 99, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1b60 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x1b70 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 76, 90, 77, 65, 95,   /* 0x1b80 */
 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 51,   /* 0x1b90 */
 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1ba0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 53, 48, 32,   /* 0x1bb0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x1bc0 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1bd0 */
 10, 32, 49, 51, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32,   /* 0x1be0 */
 32, 32, 32, 48, 48, 48, 48, 48, 57, 51, 56, 32, 32, 48, 48, 48,   /* 0x1bf0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1c00 */
 32, 48, 48, 48, 48, 48,100, 56, 56, 32, 32, 50, 42, 42, 48, 32,   /* 0x1c10 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x1c20 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 76,   /* 0x1c30 */
 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48,   /* 0x1c40 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1c50 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x1c60 */
 54, 99, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1c70 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,   /* 0x1c80 */
 53, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32,   /* 0x1c90 */
 48, 48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1ca0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1cb0 */
 48, 48, 49, 54, 99, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x1cc0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1cd0 */
 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48,   /* 0x1ce0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x1cf0 */
 76, 73, 78, 85, 88, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x1d00 */
 48, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10, 48, 48, 48, 48, 48,   /* 0x1d10 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107,   /* 0x1d20 */
 51, 50, 46, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,   /* 0x1d30 */
116,111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1d40 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50,   /* 0x1d50 */
 46, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,   /* 0x1d60 */
107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1d70 */
108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 51, 48,   /* 0x1d80 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48,   /* 0x1d90 */
 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x1da0 */
 32,100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48, 48,   /* 0x1db0 */
 48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1dc0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9,   /* 0x1dd0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48,   /* 0x1de0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x1df0 */
 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,   /* 0x1e00 */
 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1e10 */
 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,   /* 0x1e20 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69,   /* 0x1e30 */
 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1e40 */
 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x1e50 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68,   /* 0x1e60 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1e70 */
 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x1e80 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68,   /* 0x1e90 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1ea0 */
 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,   /* 0x1eb0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68,   /* 0x1ec0 */
 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1ed0 */
 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 49, 48,  9, 48,   /* 0x1ee0 */
 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48, 49, 48,   /* 0x1ef0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1f00 */
 32, 32, 76, 73, 78, 85, 88, 48, 50, 48,  9, 48, 48, 48, 48, 48,   /* 0x1f10 */
 48, 48, 48, 32, 76, 73, 78, 85, 88, 48, 50, 48, 10, 48, 48, 48,   /* 0x1f20 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,   /* 0x1f30 */
111,107, 51, 50, 46, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f40 */
 32, 99,116,111,107, 51, 50, 46, 53, 48, 10, 48, 48, 48, 48, 48,   /* 0x1f50 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107,   /* 0x1f60 */
 51, 50, 46, 53, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,   /* 0x1f70 */
116,111,107, 51, 50, 46, 53, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f80 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69,   /* 0x1f90 */
 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49,   /* 0x1fa0 */
 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,   /* 0x1fb0 */
 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,   /* 0x1fc0 */
 48, 48, 48, 48, 32, 77, 69, 84, 72, 79, 68, 10, 48, 48, 48, 48,   /* 0x1fd0 */
 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,   /* 0x1fe0 */
 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 77, 80,   /* 0x1ff0 */
 82, 69, 83, 83, 69, 68, 95, 76, 69, 78, 71, 84, 72, 10, 48, 48,   /* 0x2000 */
 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,   /* 0x2010 */
 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 85, 78,   /* 0x2020 */
 67, 79, 77, 80, 82, 69, 83, 83, 69, 68, 95, 76, 69, 78, 71, 84,   /* 0x2030 */
 72, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,   /* 0x2040 */
 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x2050 */
 48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48,   /* 0x2060 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x2070 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,   /* 0x2080 */
116,101,114, 95,105,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2090 */
103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66,  9, 48, 48,   /* 0x20a0 */
 48, 48, 48, 48, 99, 52, 32,117, 99,108, 95,110,114,118, 50, 98,   /* 0x20b0 */
 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48,   /* 0x20c0 */
 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78,   /* 0x20d0 */
 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 49, 48, 48, 32,117, 99,   /* 0x20e0 */
108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,112,114,101,   /* 0x20f0 */
115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32,   /* 0x2100 */
 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48,   /* 0x2110 */
 48, 49, 49, 52, 32,117, 99,108, 95,110,114,118, 50,101, 95,100,   /* 0x2120 */
101, 99,111,109,112,114,101,115,115, 95, 56, 10, 10, 82, 69, 76,   /* 0x2130 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x2140 */
 70, 79, 82, 32, 91, 76, 73, 78, 85, 88, 48, 48, 48, 93, 58, 10,   /* 0x2150 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x2160 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x2170 */
 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x2180 */
 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 77, 69, 84, 72,   /* 0x2190 */
 79, 68, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82,   /* 0x21a0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 73,   /* 0x21b0 */
 78, 85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 51, 52, 32,   /* 0x21c0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x21d0 */
 32, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10, 48, 48, 48, 48, 48,   /* 0x21e0 */
 48, 51, 56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32,   /* 0x21f0 */
 32, 32, 32, 32, 32, 32, 67, 79, 77, 80, 82, 69, 83, 83, 69, 68,   /* 0x2200 */
 95, 76, 69, 78, 71, 84, 72, 10, 48, 48, 48, 48, 48, 48, 51, 99,   /* 0x2210 */
 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32,   /* 0x2220 */
 32, 32, 32, 85, 78, 67, 79, 77, 80, 82, 69, 83, 83, 69, 68, 95,   /* 0x2230 */
 76, 69, 78, 71, 84, 72, 10, 48, 48, 48, 48, 48, 48, 52, 52, 32,   /* 0x2240 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2250 */
 32, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10, 10, 82, 69, 76, 79,   /* 0x2260 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x2270 */
 79, 82, 32, 91, 76, 73, 78, 85, 88, 48, 49, 48, 93, 58, 10, 79,   /* 0x2280 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x2290 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x22a0 */
 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 65,   /* 0x22b0 */
 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,   /* 0x22c0 */
114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,   /* 0x22d0 */
 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32,   /* 0x22e0 */
 32,102,105,108,116,101,114, 95,105,100, 10, 48, 48, 48, 48, 48,   /* 0x22f0 */
 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2300 */
 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10,   /* 0x2310 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x2320 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46,   /* 0x2330 */
 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x2340 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2350 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 50, 48, 32, 82,   /* 0x2360 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2370 */
 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x2380 */
 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2390 */
 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10,   /* 0x23a0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x23b0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58,   /* 0x23c0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x23d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x23e0 */
 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77,   /* 0x23f0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2400 */
 50, 66, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82,   /* 0x2410 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2420 */
 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65,   /* 0x2430 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2440 */
 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 53, 52, 32, 82, 95,   /* 0x2450 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2460 */
 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 52, 32, 82,   /* 0x2470 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2480 */
 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32,   /* 0x2490 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x24a0 */
 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 99,   /* 0x24b0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x24c0 */
 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 55,   /* 0x24d0 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x24e0 */
 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,   /* 0x24f0 */
 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2500 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,   /* 0x2510 */
 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2520 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,   /* 0x2530 */
 48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2540 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,   /* 0x2550 */
 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2560 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,   /* 0x2570 */
 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2580 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,   /* 0x2590 */
 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x25a0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,   /* 0x25b0 */
 48, 48, 48, 48, 48, 48, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x25c0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,   /* 0x25d0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x25e0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93,   /* 0x25f0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x2600 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x2610 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82,   /* 0x2620 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2630 */
 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 52, 52, 32, 82, 95, 65,   /* 0x2640 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2650 */
 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95,   /* 0x2660 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2670 */
 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82,   /* 0x2680 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2690 */
 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 53, 99, 32,   /* 0x26a0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x26b0 */
 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 54, 56,   /* 0x26c0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x26d0 */
 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 55,   /* 0x26e0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x26f0 */
 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,   /* 0x2700 */
 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2710 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,   /* 0x2720 */
 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2730 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,   /* 0x2740 */
 48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2750 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,   /* 0x2760 */
 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2770 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,   /* 0x2780 */
 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2790 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,   /* 0x27a0 */
 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x27b0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,   /* 0x27c0 */
 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x27d0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,   /* 0x27e0 */
 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x27f0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2800 */
 68, 10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77,   /* 0x2810 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2820 */
 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82,   /* 0x2830 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2840 */
 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,102, 56, 32, 82, 95, 65,   /* 0x2850 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2860 */
 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,102, 99, 32, 82, 95,   /* 0x2870 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2880 */
 78, 82, 86, 50, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x2890 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x28a0 */
 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x28b0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x28c0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48,   /* 0x28d0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x28e0 */
 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 52,   /* 0x28f0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2900 */
 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x2910 */
 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2920 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,   /* 0x2930 */
 48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2940 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,   /* 0x2950 */
 48, 48, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2960 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,   /* 0x2970 */
 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2980 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,   /* 0x2990 */
 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x29a0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,   /* 0x29b0 */
 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x29c0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,   /* 0x29d0 */
 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x29e0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,   /* 0x29f0 */
 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x2a00 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2a10 */
 69, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77,   /* 0x2a20 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2a30 */
 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82,   /* 0x2a40 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2a50 */
 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65,   /* 0x2a60 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2a70 */
 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95,   /* 0x2a80 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2a90 */
 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82,   /* 0x2aa0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2ab0 */
 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32,   /* 0x2ac0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2ad0 */
 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 52,   /* 0x2ae0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2af0 */
 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100,   /* 0x2b00 */
 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2b10 */
 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x2b20 */
100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2b30 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,   /* 0x2b40 */
 48,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2b50 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,   /* 0x2b60 */
 48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2b70 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,   /* 0x2b80 */
 48, 48, 49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2b90 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,   /* 0x2ba0 */
 48, 48, 48, 49, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2bb0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 10,   /* 0x2bc0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x2bd0 */
 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70,   /* 0x2be0 */
 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x2bf0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2c00 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82,   /* 0x2c10 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2c20 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48,   /* 0x2c30 */
 48, 48, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2c40 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,   /* 0x2c50 */
 48, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77,   /* 0x2c60 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2c70 */
 65, 95, 69, 76, 70, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x2c80 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x2c90 */
 91, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 93, 58, 10, 79, 70,   /* 0x2ca0 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x2cb0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x2cc0 */
 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2cd0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x2ce0 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95,   /* 0x2cf0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2d00 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x2d10 */
 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2d20 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x2d30 */
 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x2d40 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x2d50 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,102, 52, 32,   /* 0x2d60 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2d70 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x2d80 */
 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2d90 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x2da0 */
 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65, 82,   /* 0x2db0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x2dc0 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 52,   /* 0x2dd0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2de0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x2df0 */
 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2e00 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x2e10 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95,   /* 0x2e20 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2e30 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x2e40 */
 49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2e50 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x2e60 */
 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x2e70 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x2e80 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32,   /* 0x2e90 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2ea0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x2eb0 */
 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2ec0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x2ed0 */
 49, 48, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82,   /* 0x2ee0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x2ef0 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 51,   /* 0x2f00 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2f10 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x2f20 */
 48, 48, 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2f30 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x2f40 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95,   /* 0x2f50 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2f60 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x2f70 */
 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2f80 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x2f90 */
 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x2fa0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x2fb0 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32,   /* 0x2fc0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2fd0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x2fe0 */
 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2ff0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3000 */
 49, 48, 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65, 82,   /* 0x3010 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3020 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 48,   /* 0x3030 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3040 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x3050 */
 48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3060 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3070 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82, 95,   /* 0x3080 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3090 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x30a0 */
 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x30b0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x30c0 */
 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x30d0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x30e0 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32,   /* 0x30f0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3100 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x3110 */
 48, 48, 51,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3120 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3130 */
 49, 48, 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65, 82,   /* 0x3140 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3150 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 50,   /* 0x3160 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3170 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x3180 */
 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3190 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x31a0 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82, 95,   /* 0x31b0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x31c0 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x31d0 */
 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x31e0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x31f0 */
 10, 48, 48, 48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x3200 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3210 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48, 32,   /* 0x3220 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3230 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x3240 */
 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3250 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3260 */
 49, 48, 10, 48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65, 82,   /* 0x3270 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3280 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52,102,   /* 0x3290 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x32a0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x32b0 */
 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x32c0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x32d0 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82, 95,   /* 0x32e0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x32f0 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3300 */
 53, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3310 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x3320 */
 10, 48, 48, 48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x3330 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3340 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48, 32,   /* 0x3350 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3360 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x3370 */
 48, 48, 53,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3380 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3390 */
 49, 48, 10, 48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65, 82,   /* 0x33a0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x33b0 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54, 48,   /* 0x33c0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x33d0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x33e0 */
 48, 48, 48, 48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x33f0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3400 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82, 95,   /* 0x3410 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3420 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3430 */
 54, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3440 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x3450 */
 10, 48, 48, 48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x3460 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3470 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54,100, 48, 32,   /* 0x3480 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3490 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x34a0 */
 48, 48, 54,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x34b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x34c0 */
 49, 48, 10, 48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65, 82,   /* 0x34d0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x34e0 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 50,   /* 0x34f0 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3500 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x3510 */
 48, 48, 48, 48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3520 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3530 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82, 95,   /* 0x3540 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3550 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3560 */
 55, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3570 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x3580 */
 10, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x3590 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x35a0 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52, 32,   /* 0x35b0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x35c0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x35d0 */
 48, 48, 55,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x35e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x35f0 */
 49, 48, 10, 48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65, 82,   /* 0x3600 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3610 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56, 50,   /* 0x3620 */
 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3630 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x3640 */
 48, 48, 48, 48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3650 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3660 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82, 95,   /* 0x3670 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3680 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3690 */
 56, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x36a0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x36b0 */
 10, 48, 48, 48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x36c0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x36d0 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56,101, 56, 32,   /* 0x36e0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x36f0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x3700 */
 48, 48, 56,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3710 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3720 */
 49, 48, 10, 48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65, 82,   /* 0x3730 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3740 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 57, 48,   /* 0x3750 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3760 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x3770 */
 48, 48, 48, 48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3780 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3790 */
 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x37a0 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90,   /* 0x37b0 */
 77, 65, 95, 68, 69, 67, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x37c0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x37d0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x37e0 */
 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x37f0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3800 */
 48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77,   /* 0x3810 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3820 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 98, 56,   /* 0x3830 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3840 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3850 */
 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3860 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3870 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65,   /* 0x3880 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3890 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,   /* 0x38a0 */
 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x38b0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x38c0 */
 48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x38d0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x38e0 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82,   /* 0x38f0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3900 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3910 */
 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3920 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3930 */
 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77,   /* 0x3940 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3950 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,100, 56,   /* 0x3960 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3970 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3980 */
 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3990 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x39a0 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65,   /* 0x39b0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x39c0 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,   /* 0x39d0 */
 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x39e0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x39f0 */
 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3a00 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3a10 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 99, 32, 82,   /* 0x3a20 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3a30 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3a40 */
 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3a50 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3a60 */
 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77,   /* 0x3a70 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3a80 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 53, 56,   /* 0x3a90 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3aa0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3ab0 */
 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3ac0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3ad0 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65,   /* 0x3ae0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3af0 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,   /* 0x3b00 */
101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3b10 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3b20 */
 48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3b30 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3b40 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82,   /* 0x3b50 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3b60 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3b70 */
 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3b80 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3b90 */
 48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82, 95, 65, 82, 77,   /* 0x3ba0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3bb0 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 48,   /* 0x3bc0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3bd0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3be0 */
 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3bf0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3c00 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65,   /* 0x3c10 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3c20 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,   /* 0x3c30 */
101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3c40 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3c50 */
 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3c60 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3c70 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 50, 52, 32, 82,   /* 0x3c80 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3c90 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3ca0 */
 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3cb0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3cc0 */
 48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82, 95, 65, 82, 77,   /* 0x3cd0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3ce0 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 52,   /* 0x3cf0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3d00 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3d10 */
 48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3d20 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3d30 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48, 32, 82, 95, 65,   /* 0x3d40 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3d50 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,   /* 0x3d60 */
100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3d70 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3d80 */
 48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3d90 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3da0 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,102, 52, 32, 82,   /* 0x3db0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3dc0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3dd0 */
 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3de0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3df0 */
 48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82, 95, 65, 82, 77,   /* 0x3e00 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3e10 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 57, 56,   /* 0x3e20 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3e30 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3e40 */
 48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3e50 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3e60 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48, 32, 82, 95, 65,   /* 0x3e70 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3e80 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,   /* 0x3e90 */
101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3ea0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3eb0 */
 48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3ec0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3ed0 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 48, 52, 32, 82,   /* 0x3ee0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3ef0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3f00 */
 48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3f10 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3f20 */
 48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82, 95, 65, 82, 77,   /* 0x3f30 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3f40 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 48,   /* 0x3f50 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3f60 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3f70 */
 48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3f80 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3f90 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,100, 48, 32, 82, 95, 65,   /* 0x3fa0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3fb0 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,   /* 0x3fc0 */
101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3fd0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3fe0 */
 48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3ff0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x4000 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 50, 56, 32, 82,   /* 0x4010 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x4020 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x4030 */
 48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x4040 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x4050 */
 48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82, 95, 65, 82, 77,   /* 0x4060 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x4070 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 57, 99,   /* 0x4080 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x4090 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x40a0 */
 48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x40b0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x40c0 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52, 32, 82, 95, 65,   /* 0x40d0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x40e0 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,   /* 0x40f0 */
100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x4100 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x4110 */
 48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x4120 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x4130 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 48, 32, 82,   /* 0x4140 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x4150 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x4160 */
 48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x4170 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x4180 */
 48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82, 95, 65, 82, 77,   /* 0x4190 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x41a0 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 56, 56,   /* 0x41b0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x41c0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x41d0 */
 48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x41e0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x41f0 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,101, 56, 32, 82, 95, 65,   /* 0x4200 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x4210 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,   /* 0x4220 */
102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x4230 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x4240 */
 48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x4250 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x4260 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 48, 52, 32, 82,   /* 0x4270 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x4280 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x4290 */
 48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x42a0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x42b0 */
 48, 10                                                            /* 0x42c0 */
};
