/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "objectList.h"

#include <stdlib.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include <visu_tools.h>

/* Variables to store the glObjectList. */
/* The default size of the table to store the user
   lists. */
#define GLOBJECTLIST_INCREMENT 15
/* First value given to user to store their glObjectList. */
#define GLOBJECTLIST_FIRST 1001
/* The table that stores the identifier of user's glObjectList. */
int *glObjectListRegistered;
/* The allocated size of this table. */
int glObjectListRegisteredSize;
/* The number of stored elements. */
int nbGlObjectListRegistered;
/* The number of user's reserved numbers of the last
   entry in this table. */
int lastGlObjectListSize;

void openGLObjectList_init()
{
  /* Initialisation of the table that stores the user
     glObjectList. */
  glObjectListRegistered = (int*)0;
  glObjectListRegisteredSize = 0;
  nbGlObjectListRegistered = 0;
  lastGlObjectListSize = 0;
}


/* It returns the number that can be used to link glObjectList.
   This number is also added to the list of glObjectList to be displayed.
   The size parameter is the number of lists that could be used by
   the user for this glObjectList. Then the next call to this function
   will return the last value plus the size plus one. */
int openGLObjectList_new(int size)
{
  if (nbGlObjectListRegistered >= glObjectListRegisteredSize)
    {
      glObjectListRegisteredSize += GLOBJECTLIST_INCREMENT;
      glObjectListRegistered = g_realloc(glObjectListRegistered,
					 sizeof(int) * glObjectListRegisteredSize);
    }
  if (nbGlObjectListRegistered > 0)
    glObjectListRegistered[nbGlObjectListRegistered] = 
      glObjectListRegistered[nbGlObjectListRegistered - 1] + lastGlObjectListSize;
  else
    glObjectListRegistered[0] = GLOBJECTLIST_FIRST;
  lastGlObjectListSize = size;
  nbGlObjectListRegistered++;
  DBG_fprintf(stderr, "Object List: request %d OpenGL lists -> %d %d.\n",
	      size, glObjectListRegistered[nbGlObjectListRegistered - 1],
	      glObjectListRegistered[nbGlObjectListRegistered - 1] + size - 1);
  return glObjectListRegistered[nbGlObjectListRegistered - 1];
}


static void drawRoundedHat(GLUquadricObj *obj, float hat_length,
			   float hat_height, float radius, int nlat)
{
  gluCylinder(obj, hat_length, 0, hat_height, nlat, 1);
  glRotatef(180, 1, 0, 0);
  gluDisk(obj, 0, radius, nlat, 1);
  glRotatef(180, 1, 0, 0);
}
static void drawRoundedTail(GLUquadricObj *obj, float tail_length,
			    float tail_height, int nlat)
{
  if (tail_height <= 0.f)
    return;

  glTranslatef(0, 0, -tail_height);
  glRotatef(180, 1, 0, 0);
  gluDisk(obj, 0, (tail_length)*1.03, nlat, 1);      
  glRotatef(180, 1, 0, 0);
  gluCylinder(obj, tail_length, tail_length, tail_height, nlat, 1);
}
static void drawEdgedHat(float hat_length, float hat_height)
{
  glBegin(GL_TRIANGLE_FAN);
      
  glNormal3f(hat_height, 0, hat_length);
  glVertex3f(0, 0, hat_height); 
  glVertex3f(hat_length,-hat_length,0);
  glVertex3f(hat_length,hat_length,0);

  glNormal3f(0, hat_height, hat_length);
  glVertex3f(-hat_length,hat_length,0);
       
  glNormal3f(-hat_height, 0, hat_length);
  glVertex3f(-hat_length,-hat_length,0);

  glNormal3f(-hat_height, 0, hat_length);
  glVertex3f(hat_length,-hat_length,0);

  glEnd();

  glBegin(GL_QUADS);

  glNormal3f(0., 0., -1.);
  glVertex3f(hat_length ,hat_length ,0 );
  glVertex3f(hat_length ,-hat_length ,0 );
  glVertex3f(-hat_length ,-hat_length ,0 );
  glVertex3f(-hat_length ,hat_length ,0 );

  glEnd();
}
static void drawEdgedTail(float tail_length, float tail_height)
{
  glBegin(GL_QUADS);

  glNormal3f(0., 0., 1.);
  glVertex3f(tail_length , tail_length , 0 );
  glVertex3f(-tail_length , tail_length , 0 );
  glVertex3f(-tail_length , -tail_length , 0 );
  glVertex3f(tail_length , -tail_length , 0 );

  glNormal3f(0., 0., -1.);
  glVertex3f(tail_length ,tail_length ,-tail_height );
  glVertex3f(tail_length ,-tail_length ,-tail_height );
  glVertex3f(-tail_length ,-tail_length ,-tail_height );
  glVertex3f(-tail_length ,tail_length ,-tail_height );

  glNormal3f(1., 0., 0.);
  glVertex3f(tail_length ,tail_length ,0 );
  glVertex3f(tail_length ,-tail_length ,0 );
  glVertex3f(tail_length ,-tail_length ,-tail_height );
  glVertex3f(tail_length ,tail_length ,-tail_height );

  glNormal3f(-1., 0., 0.);
  glVertex3f(-tail_length ,tail_length ,0 );
  glVertex3f(-tail_length ,tail_length ,-tail_height );
  glVertex3f(-tail_length ,-tail_length ,-tail_height );
  glVertex3f(-tail_length ,-tail_length ,0 );

  glNormal3f(0., 1., 0.);
  glVertex3f(-tail_length ,tail_length ,-tail_height );
  glVertex3f(-tail_length ,tail_length ,0 );
  glVertex3f(tail_length ,tail_length ,0 );
  glVertex3f(tail_length ,tail_length ,-tail_height );

  glNormal3f(0., -1., 0.);
  glVertex3f(-tail_length ,-tail_length ,-tail_height );
  glVertex3f(tail_length ,-tail_length ,-tail_height );
  glVertex3f(tail_length ,-tail_length ,0 );
  glVertex3f(-tail_length ,-tail_length ,0 );

  glEnd();
}

void openGLObjectListDraw_smoothArrow(GLUquadricObj *obj, int material_id,
				      gboolean tailCentered,
				      float tailLength, float tailRadius, float tailN,
				      gboolean tailUseMat, float hatLength,
				      float hatRadius, float hatN, gboolean hatUseMat)
{
  if (tailCentered)
    glTranslatef(0.f, 0.f, tailLength / 2.f);
  else
    glTranslatef(0.f, 0.f, -(hatLength - tailLength) / 2.f);
  if(tailUseMat && hatUseMat)
    {
      glCallList(material_id);
      drawRoundedHat(obj, hatRadius,
		     hatLength, MAX(hatRadius, tailRadius)*1.03, hatN);
      drawRoundedTail(obj, tailRadius, tailLength, tailN);
    }
  else if(tailUseMat)
    {
      drawRoundedHat(obj, hatRadius, hatLength,
		     MAX(hatRadius, tailRadius)*1.03, hatN);
      glCallList(material_id);
      drawRoundedTail(obj, tailRadius, tailLength, tailN);
    }
  else if(hatUseMat)
    {
      drawRoundedTail(obj, tailRadius, tailLength, tailN);
      glTranslatef(0, 0, tailLength);
      glCallList(material_id);
      drawRoundedHat(obj, hatRadius, hatLength,
		     MAX(hatRadius, tailRadius)*1.03, hatN);
    }
  else
    {
      drawRoundedHat(obj, hatRadius, hatLength,
		     MAX(hatRadius, tailRadius)*1.03, hatN);
      drawRoundedTail(obj, tailRadius, tailLength, tailN);
    }
}
void openGLObjectListDraw_edgeArrow(int material_id, gboolean tailCentered,
				    float tailLength, float tailRadius,
				    gboolean tailUseMat, float hatLength,
				    float hatRadius, gboolean hatUseMat)
{
  /* This one is a edged arrow. */
  if (tailCentered)
    glTranslatef(0.f, 0.f, tailLength / 2.f);
  else
    glTranslatef(0.f, 0.f, -(hatLength - tailLength) / 2.f);
  if(tailUseMat && hatUseMat)
    {
      glCallList(material_id);
      drawEdgedHat(hatRadius, hatLength);
      drawEdgedTail(tailRadius, tailLength);
    }
  else if(tailUseMat)
    {
      drawEdgedHat(hatRadius, hatLength);
      glCallList(material_id);
      drawEdgedTail(tailRadius, tailLength);
    }
  else if(hatUseMat)
    {
      drawEdgedTail(tailRadius, tailLength);
      glCallList(material_id);
      drawEdgedHat(hatRadius, hatLength);
    }
  else
    {
      drawEdgedHat(hatRadius, hatLength);
      drawEdgedTail(tailRadius, tailLength);
    }
}
void openGLObjectListDraw_ellipsoid(GLUquadricObj *obj, int material_id,
				    float aAxis, float bAxis,
				    float n, gboolean useMat)
{
  if (bAxis == 0.f)
    glScalef(1.f, 1.f, 10.f);
  else
    glScalef(1.f, 1.f, aAxis / bAxis);
  if (useMat)
    glCallList(material_id);
  gluSphere(obj, bAxis, n, n);
}
void openGLObjectListDraw_torus(GLUquadricObj *obj _U_, int material_id, float radius,
				float ratio, int nA, int nB, gboolean useMat)
{
  int i, j;
  float tp, tc, dtA, dtB, xp1, yp1, xp2, yp2, xc1, yc1, xc2, yc2, alpha;
  float a[3], b[3], c[3], d[3], aa[3], bb[3], cc[3], dd[3];

  if (useMat)
    glCallList(material_id);

  glBegin(GL_QUADS);

  glEnable(GL_NORMALIZE);

  dtA = 2.f*G_PI/(float)nA;
  dtB = 2.f*G_PI/(float)nB;
  alpha = 1.f / ratio;

  /* loop on the position of the centre of the circle
     which stands vertical in the plane, and which
     is rotated to create the torus */
  for (i = 0; i < nA; i++)
    {
      tp = (float)i*dtA;
      xp1 = radius*cos(tp);
      yp1 = radius*sin(tp);
      xp2 = radius*cos(tp+dtA);
      yp2 = radius*sin(tp+dtA);

      /* loop around the circle */
      for (j = 0; j < nB; j++)
	{
	  tc = (float)j*dtB;
	  xc1 = alpha*cos(tc);
	  yc1 = alpha*sin(tc);
	  xc2 = alpha*cos(tc+dtB);
	  yc2 = alpha*sin(tc+dtB);

	  a[0] = xp1 * (1.f + xc1);
	  a[1] = yp1 * (1.f + xc1);
	  a[2] = yc1 * radius;

	  b[0] = xp2 * (1.f + xc1);
	  b[1] = yp2 * (1.f + xc1);
	  b[2] = yc1 * radius;

	  c[0] = xp1 * (1.f + xc2);
	  c[1] = yp1 * (1.f + xc2);
	  c[2] = yc2 * radius;

	  d[0] = xp2 * (1.f + xc2);
	  d[1] = yp2 * (1.f + xc2);
	  d[2] = yc2 * radius;

	  aa[0] = xp1 * xc1;
	  aa[1] = yp1 * xc1;
	  aa[2] = yc1 * radius;

	  bb[0] = xp2 * xc1;
	  bb[1] = yp2 * xc1;
	  bb[2] = yc1 * radius;
	      
	  cc[0] = xp1 * xc2;
	  cc[1] = yp1 * xc2;
	  cc[2] = yc2 * radius;

	  dd[0] = xp2 * xc2;
	  dd[1] = yp2 * xc2;
	  dd[2] = yc2 * radius;	      

	  /* Point A */
	  glNormal3fv(aa);
	  glVertex3fv(a);

	  /* Point B */
	  glNormal3fv(bb);
	  glVertex3fv(b);

	  /* Point D */
	  glNormal3fv(dd);
	  glVertex3fv(d);

	  /* Point C */
	  glNormal3fv(cc);
	  glVertex3fv(c);
	}
	  
    }

  glDisable(GL_NORMALIZE);
  glEnd();
}
