/* terminal.c generated by valac, the Vala compiler
 * generated from terminal.vala, do not modify */

/*
 * Vala-Terminal -- a lightweight terminal program
 *
 * (C) 2007-2009 Michael 'Mickey' Lauer <mickey@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <vte/vte.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gdk/gdk.h>


#define VALA_TERMINAL2_TYPE_MOKO_TERMINAL (vala_terminal2_moko_terminal_get_type ())
#define VALA_TERMINAL2_MOKO_TERMINAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TERMINAL2_TYPE_MOKO_TERMINAL, ValaTerminal2MokoTerminal))
#define VALA_TERMINAL2_MOKO_TERMINAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TERMINAL2_TYPE_MOKO_TERMINAL, ValaTerminal2MokoTerminalClass))
#define VALA_TERMINAL2_IS_MOKO_TERMINAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TERMINAL2_TYPE_MOKO_TERMINAL))
#define VALA_TERMINAL2_IS_MOKO_TERMINAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TERMINAL2_TYPE_MOKO_TERMINAL))
#define VALA_TERMINAL2_MOKO_TERMINAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TERMINAL2_TYPE_MOKO_TERMINAL, ValaTerminal2MokoTerminalClass))

typedef struct _ValaTerminal2MokoTerminal ValaTerminal2MokoTerminal;
typedef struct _ValaTerminal2MokoTerminalClass ValaTerminal2MokoTerminalClass;
typedef struct _ValaTerminal2MokoTerminalPrivate ValaTerminal2MokoTerminalPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaTerminal2MokoTerminal {
	GtkHBox parent_instance;
	ValaTerminal2MokoTerminalPrivate * priv;
};

struct _ValaTerminal2MokoTerminalClass {
	GtkHBoxClass parent_class;
};

struct _ValaTerminal2MokoTerminalPrivate {
	guint fontsize;
	GtkScrollbar* scrollbar;
	VteTerminal* terminal;
};


static char* vala_terminal2_moko_terminal_fontname;
static char* vala_terminal2_moko_terminal_fontname = NULL;
static guint vala_terminal2_moko_terminal_starting_fontsize;
static guint vala_terminal2_moko_terminal_starting_fontsize = 0U;
static gboolean vala_terminal2_moko_terminal_use_default_fore_color;
static gboolean vala_terminal2_moko_terminal_use_default_fore_color = TRUE;
static guint16 vala_terminal2_moko_terminal_fore_red;
static guint16 vala_terminal2_moko_terminal_fore_red = 0U;
static guint16 vala_terminal2_moko_terminal_fore_green;
static guint16 vala_terminal2_moko_terminal_fore_green = 0U;
static guint16 vala_terminal2_moko_terminal_fore_blue;
static guint16 vala_terminal2_moko_terminal_fore_blue = 0U;
static gboolean vala_terminal2_moko_terminal_use_default_back_color;
static gboolean vala_terminal2_moko_terminal_use_default_back_color = TRUE;
static guint16 vala_terminal2_moko_terminal_back_red;
static guint16 vala_terminal2_moko_terminal_back_red = 0U;
static guint16 vala_terminal2_moko_terminal_back_green;
static guint16 vala_terminal2_moko_terminal_back_green = 0U;
static guint16 vala_terminal2_moko_terminal_back_blue;
static guint16 vala_terminal2_moko_terminal_back_blue = 0U;
extern gint vala_terminal2_moko_terminal_starting_width;
gint vala_terminal2_moko_terminal_starting_width = 0;
extern gint vala_terminal2_moko_terminal_starting_height;
gint vala_terminal2_moko_terminal_starting_height = 0;
static gpointer vala_terminal2_moko_terminal_parent_class = NULL;

GType vala_terminal2_moko_terminal_get_type (void);
#define VALA_TERMINAL2_MOKO_TERMINAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TERMINAL2_TYPE_MOKO_TERMINAL, ValaTerminal2MokoTerminalPrivate))
enum  {
	VALA_TERMINAL2_MOKO_TERMINAL_DUMMY_PROPERTY
};
void vala_terminal2_moko_terminal_set_font (const char* font);
void vala_terminal2_moko_terminal_set_starting_fontsize (guint size);
void vala_terminal2_moko_terminal_set_fore_color (guint r, guint g, guint b);
void vala_terminal2_moko_terminal_set_back_color (guint r, guint g, guint b);
guint vala_terminal2_moko_terminal_get_font_size (ValaTerminal2MokoTerminal* self);
void vala_terminal2_moko_terminal_update_font (ValaTerminal2MokoTerminal* self);
void vala_terminal2_moko_terminal_zoom_in (ValaTerminal2MokoTerminal* self);
void vala_terminal2_moko_terminal_zoom_out (ValaTerminal2MokoTerminal* self);
void vala_terminal2_moko_terminal_paste (ValaTerminal2MokoTerminal* self);
void vala_terminal2_moko_terminal_paste_command (ValaTerminal2MokoTerminal* self, const char* command);
ValaTerminal2MokoTerminal* vala_terminal2_moko_terminal_new (void);
ValaTerminal2MokoTerminal* vala_terminal2_moko_terminal_construct (GType object_type);
static void _lambda0_ (VteTerminal* term, ValaTerminal2MokoTerminal* self);
static void __lambda0__vte_terminal_child_exited (VteTerminal* _sender, gpointer self);
static void _lambda1_ (VteTerminal* term, ValaTerminal2MokoTerminal* self);
static void __lambda1__vte_terminal_eof (VteTerminal* _sender, gpointer self);
static void _lambda2_ (VteTerminal* term, ValaTerminal2MokoTerminal* self);
static void __lambda2__vte_terminal_window_title_changed (VteTerminal* _sender, gpointer self);
static GObject * vala_terminal2_moko_terminal_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void vala_terminal2_moko_terminal_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



void vala_terminal2_moko_terminal_set_font (const char* font) {
	char* _tmp0_;
	g_return_if_fail (font != NULL);
	vala_terminal2_moko_terminal_fontname = (_tmp0_ = g_strdup (font), _g_free0 (vala_terminal2_moko_terminal_fontname), _tmp0_);
}


void vala_terminal2_moko_terminal_set_starting_fontsize (guint size) {
	vala_terminal2_moko_terminal_starting_fontsize = size;
}


void vala_terminal2_moko_terminal_set_fore_color (guint r, guint g, guint b) {
	vala_terminal2_moko_terminal_use_default_fore_color = FALSE;
	vala_terminal2_moko_terminal_fore_red = (guint16) r;
	vala_terminal2_moko_terminal_fore_green = (guint16) g;
	vala_terminal2_moko_terminal_fore_blue = (guint16) b;
}


void vala_terminal2_moko_terminal_set_back_color (guint r, guint g, guint b) {
	vala_terminal2_moko_terminal_use_default_back_color = FALSE;
	vala_terminal2_moko_terminal_back_red = (guint16) r;
	vala_terminal2_moko_terminal_back_green = (guint16) g;
	vala_terminal2_moko_terminal_back_blue = (guint16) b;
}


guint vala_terminal2_moko_terminal_get_font_size (ValaTerminal2MokoTerminal* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->fontsize;
	return result;
}


void vala_terminal2_moko_terminal_update_font (ValaTerminal2MokoTerminal* self) {
	char* font;
	g_return_if_fail (self != NULL);
	font = g_strdup_printf ("%s %u", vala_terminal2_moko_terminal_fontname, self->priv->fontsize);
	vte_terminal_set_font_from_string_full (self->priv->terminal, font, VTE_ANTI_ALIAS_FORCE_ENABLE);
	_g_free0 (font);
}


void vala_terminal2_moko_terminal_zoom_in (ValaTerminal2MokoTerminal* self) {
	g_return_if_fail (self != NULL);
	self->priv->fontsize = self->priv->fontsize + 1;
	vala_terminal2_moko_terminal_update_font (self);
}


void vala_terminal2_moko_terminal_zoom_out (ValaTerminal2MokoTerminal* self) {
	g_return_if_fail (self != NULL);
	self->priv->fontsize = self->priv->fontsize - 1;
	vala_terminal2_moko_terminal_update_font (self);
}


void vala_terminal2_moko_terminal_paste (ValaTerminal2MokoTerminal* self) {
	g_return_if_fail (self != NULL);
	vte_terminal_paste_primary (self->priv->terminal);
}


void vala_terminal2_moko_terminal_paste_command (ValaTerminal2MokoTerminal* self, const char* command) {
	char* command2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	command2 = g_strconcat (command, "\0", NULL);
	vte_terminal_feed_child (self->priv->terminal, command2, (glong) (-1));
	_g_free0 (command2);
}


ValaTerminal2MokoTerminal* vala_terminal2_moko_terminal_construct (GType object_type) {
	ValaTerminal2MokoTerminal * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


ValaTerminal2MokoTerminal* vala_terminal2_moko_terminal_new (void) {
	return vala_terminal2_moko_terminal_construct (VALA_TERMINAL2_TYPE_MOKO_TERMINAL);
}


static void _lambda0_ (VteTerminal* term, ValaTerminal2MokoTerminal* self) {
	g_return_if_fail (term != NULL);
	gtk_object_destroy ((GtkObject*) self);
}


static void __lambda0__vte_terminal_child_exited (VteTerminal* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static void _lambda1_ (VteTerminal* term, ValaTerminal2MokoTerminal* self) {
	g_return_if_fail (term != NULL);
	gtk_object_destroy ((GtkObject*) self);
}


static void __lambda1__vte_terminal_eof (VteTerminal* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda2_ (VteTerminal* term, ValaTerminal2MokoTerminal* self) {
	GtkWindow* toplevel;
	g_return_if_fail (term != NULL);
	toplevel = _g_object_ref0 (GTK_WINDOW (gtk_widget_get_toplevel ((GtkWidget*) self)));
	gtk_window_set_title (toplevel, term->window_title);
	_g_object_unref0 (toplevel);
}


static void __lambda2__vte_terminal_window_title_changed (VteTerminal* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


static GObject * vala_terminal2_moko_terminal_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ValaTerminal2MokoTerminal * self;
	parent_class = G_OBJECT_CLASS (vala_terminal2_moko_terminal_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_TERMINAL2_MOKO_TERMINAL (obj);
	{
		VteTerminal* _tmp1_;
		GtkScrollbar* _tmp2_;
		GdkColor _tmp3_ = {0};
		GdkColor fore;
		GdkColor _tmp4_ = {0};
		GdkColor back;
		GdkColor* _tmp14_;
		gint colors_size;
		gint colors_length1;
		GdkColor* _tmp13_ = NULL;
		GdkColor _tmp5_ = {0};
		GdkColor _tmp6_ = {0};
		GdkColor _tmp7_ = {0};
		GdkColor _tmp8_ = {0};
		GdkColor _tmp9_ = {0};
		GdkColor _tmp10_ = {0};
		GdkColor _tmp11_ = {0};
		GdkColor _tmp12_ = {0};
		GdkColor* colors;
		gint _tmp16__length1;
		char** _tmp16_;
		char** _tmp15_ = NULL;
		gboolean _tmp17_ = FALSE;
		fprintf (stdout, "moko-terminal constructed\n");
		if (vala_terminal2_moko_terminal_fontname == NULL) {
			char* _tmp0_;
			vala_terminal2_moko_terminal_fontname = (_tmp0_ = g_strdup ("LiberationMono"), _g_free0 (vala_terminal2_moko_terminal_fontname), _tmp0_);
		}
		if (vala_terminal2_moko_terminal_use_default_fore_color) {
			vala_terminal2_moko_terminal_fore_red = (guint16) 0xffff;
			vala_terminal2_moko_terminal_fore_green = (guint16) 0xffff;
			vala_terminal2_moko_terminal_fore_blue = (guint16) 0xffff;
		}
		if (vala_terminal2_moko_terminal_use_default_back_color) {
			vala_terminal2_moko_terminal_back_red = (guint16) 0x0000;
			vala_terminal2_moko_terminal_back_green = (guint16) 0x0000;
			vala_terminal2_moko_terminal_back_blue = (guint16) 0x0000;
		}
		self->priv->fontsize = vala_terminal2_moko_terminal_starting_fontsize;
		self->priv->terminal = (_tmp1_ = g_object_ref_sink ((VteTerminal*) vte_terminal_new ()), _g_object_unref0 (self->priv->terminal), _tmp1_);
		g_signal_connect_object (self->priv->terminal, "child-exited", (GCallback) __lambda0__vte_terminal_child_exited, self, 0);
		g_signal_connect_object (self->priv->terminal, "eof", (GCallback) __lambda1__vte_terminal_eof, self, 0);
		g_signal_connect_object (self->priv->terminal, "window-title-changed", (GCallback) __lambda2__vte_terminal_window_title_changed, self, 0);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->terminal, TRUE, TRUE, (guint) 0);
		self->priv->scrollbar = (_tmp2_ = (GtkScrollbar*) g_object_ref_sink ((GtkVScrollbar*) gtk_vscrollbar_new (self->priv->terminal->adjustment)), _g_object_unref0 (self->priv->scrollbar), _tmp2_);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->scrollbar, FALSE, FALSE, (guint) 0);
		fore = (memset (&_tmp3_, 0, sizeof (GdkColor)), _tmp3_.pixel = (guint32) 0, _tmp3_.red = vala_terminal2_moko_terminal_fore_red, _tmp3_.green = vala_terminal2_moko_terminal_fore_green, _tmp3_.blue = vala_terminal2_moko_terminal_fore_blue, _tmp3_);
		back = (memset (&_tmp4_, 0, sizeof (GdkColor)), _tmp4_.pixel = (guint32) 0, _tmp4_.red = vala_terminal2_moko_terminal_back_red, _tmp4_.green = vala_terminal2_moko_terminal_back_green, _tmp4_.blue = vala_terminal2_moko_terminal_back_blue, _tmp4_);
		colors = (_tmp14_ = (_tmp13_ = g_new0 (GdkColor, 8), _tmp13_[0] = (memset (&_tmp5_, 0, sizeof (GdkColor)), _tmp5_.pixel = (guint32) 0, _tmp5_.red = (guint16) 0x0000, _tmp5_.green = (guint16) 0x0000, _tmp5_.blue = (guint16) 0x0000, _tmp5_), _tmp13_[1] = (memset (&_tmp6_, 0, sizeof (GdkColor)), _tmp6_.pixel = (guint32) 0, _tmp6_.red = (guint16) 0x8000, _tmp6_.green = (guint16) 0x0000, _tmp6_.blue = (guint16) 0x0000, _tmp6_), _tmp13_[2] = (memset (&_tmp7_, 0, sizeof (GdkColor)), _tmp7_.pixel = (guint32) 0, _tmp7_.red = (guint16) 0x0000, _tmp7_.green = (guint16) 0x8000, _tmp7_.blue = (guint16) 0x0000, _tmp7_), _tmp13_[3] = (memset (&_tmp8_, 0, sizeof (GdkColor)), _tmp8_.pixel = (guint32) 0, _tmp8_.red = (guint16) 0x8000, _tmp8_.green = (guint16) 0x8000, _tmp8_.blue = (guint16) 0x0000, _tmp8_), _tmp13_[4] = (memset (&_tmp9_, 0, sizeof (GdkColor)), _tmp9_.pixel = (guint32) 0, _tmp9_.red = (guint16) 0x0000, _tmp9_.green = (guint16) 0x0000, _tmp9_.blue = (guint16) 0x8000, _tmp9_), _tmp13_[5] = (memset (&_tmp10_, 0, sizeof (GdkColor)), _tmp10_.pixel = (guint32) 0, _tmp10_.red = (guint16) 0x8000, _tmp10_.green = (guint16) 0x0000, _tmp10_.blue = (guint16) 0x8000, _tmp10_), _tmp13_[6] = (memset (&_tmp11_, 0, sizeof (GdkColor)), _tmp11_.pixel = (guint32) 0, _tmp11_.red = (guint16) 0x0000, _tmp11_.green = (guint16) 0x8000, _tmp11_.blue = (guint16) 0x8000, _tmp11_), _tmp13_[7] = (memset (&_tmp12_, 0, sizeof (GdkColor)), _tmp12_.pixel = (guint32) 0, _tmp12_.red = (guint16) 0x8000, _tmp12_.green = (guint16) 0x8000, _tmp12_.blue = (guint16) 0x8000, _tmp12_), _tmp13_), colors_length1 = 8, colors_size = colors_length1, _tmp14_);
		vte_terminal_set_colors (self->priv->terminal, &fore, &back, colors, colors_length1);
		vala_terminal2_moko_terminal_update_font (self);
		vte_terminal_set_scrollback_lines (self->priv->terminal, (glong) 1000);
		vte_terminal_set_mouse_autohide (self->priv->terminal, TRUE);
		vte_terminal_set_cursor_blinks (self->priv->terminal, TRUE);
		vte_terminal_set_backspace_binding (self->priv->terminal, VTE_ERASE_ASCII_DELETE);
		vte_terminal_fork_command (self->priv->terminal, (const char*) 0, (char**) 0, (_tmp16_ = (_tmp15_ = g_new0 (char*, 0 + 1), _tmp15_), _tmp16__length1 = 0, _tmp16_), g_getenv ("HOME"), TRUE, TRUE, TRUE);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
		if (vala_terminal2_moko_terminal_starting_width > 0) {
			_tmp17_ = vala_terminal2_moko_terminal_starting_height > 0;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			vte_terminal_set_size (self->priv->terminal, (glong) vala_terminal2_moko_terminal_starting_width, (glong) vala_terminal2_moko_terminal_starting_height);
		}
		colors = (g_free (colors), NULL);
	}
	return obj;
}


static void vala_terminal2_moko_terminal_class_init (ValaTerminal2MokoTerminalClass * klass) {
	vala_terminal2_moko_terminal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTerminal2MokoTerminalPrivate));
	G_OBJECT_CLASS (klass)->constructor = vala_terminal2_moko_terminal_constructor;
	G_OBJECT_CLASS (klass)->finalize = vala_terminal2_moko_terminal_finalize;
}


static void vala_terminal2_moko_terminal_instance_init (ValaTerminal2MokoTerminal * self) {
	self->priv = VALA_TERMINAL2_MOKO_TERMINAL_GET_PRIVATE (self);
}


static void vala_terminal2_moko_terminal_finalize (GObject* obj) {
	ValaTerminal2MokoTerminal * self;
	self = VALA_TERMINAL2_MOKO_TERMINAL (obj);
	_g_object_unref0 (self->priv->scrollbar);
	_g_object_unref0 (self->priv->terminal);
	G_OBJECT_CLASS (vala_terminal2_moko_terminal_parent_class)->finalize (obj);
}


GType vala_terminal2_moko_terminal_get_type (void) {
	static GType vala_terminal2_moko_terminal_type_id = 0;
	if (vala_terminal2_moko_terminal_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTerminal2MokoTerminalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_terminal2_moko_terminal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTerminal2MokoTerminal), 0, (GInstanceInitFunc) vala_terminal2_moko_terminal_instance_init, NULL };
		vala_terminal2_moko_terminal_type_id = g_type_register_static (GTK_TYPE_HBOX, "ValaTerminal2MokoTerminal", &g_define_type_info, 0);
	}
	return vala_terminal2_moko_terminal_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




