/* valaccodelinedirective.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODELINEDIRECTIVE_H__
#define __CCODE_VALACCODELINEDIRECTIVE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_LINE_DIRECTIVE (vala_ccode_line_directive_get_type ())
#define VALA_CCODE_LINE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirective))
#define VALA_CCODE_LINE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectiveClass))
#define VALA_IS_CCODE_LINE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE))
#define VALA_IS_CCODE_LINE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_LINE_DIRECTIVE))
#define VALA_CCODE_LINE_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectiveClass))

typedef struct _ValaCCodeLineDirectivePrivate ValaCCodeLineDirectivePrivate;

/**
 * Represents a line directive in the C code.
 */
struct _ValaCCodeLineDirective {
	ValaCCodeNode parent_instance;
	ValaCCodeLineDirectivePrivate * priv;
};

struct _ValaCCodeLineDirectiveClass {
	ValaCCodeNodeClass parent_class;
};


ValaCCodeLineDirective* vala_ccode_line_directive_new (const char* _filename, gint _line);
const char* vala_ccode_line_directive_get_filename (ValaCCodeLineDirective* self);
void vala_ccode_line_directive_set_filename (ValaCCodeLineDirective* self, const char* value);
gint vala_ccode_line_directive_get_line (ValaCCodeLineDirective* self);
void vala_ccode_line_directive_set_line (ValaCCodeLineDirective* self, gint value);
GType vala_ccode_line_directive_get_type (void);


G_END_DECLS

#endif
