/* valaarrayresizemethod.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarrayresizemethod.h>
#include <vala/valacodenode.h>
#include <vala/valasymbol.h>




enum  {
	VALA_ARRAY_RESIZE_METHOD_DUMMY_PROPERTY
};
static GObject * vala_array_resize_method_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_array_resize_method_parent_class = NULL;



/**
 * Creates a new array resize method.
 *
 * @return newly created method
 */
ValaArrayResizeMethod* vala_array_resize_method_new (ValaSourceReference* source_reference) {
	ValaArrayResizeMethod * self;
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_ARRAY_RESIZE_METHOD, 0, NULL);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	vala_symbol_set_name (VALA_SYMBOL (self), "resize");
	return self;
}


static GObject * vala_array_resize_method_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ValaArrayResizeMethodClass * klass;
	GObjectClass * parent_class;
	ValaArrayResizeMethod * self;
	klass = VALA_ARRAY_RESIZE_METHOD_CLASS (g_type_class_peek (VALA_TYPE_ARRAY_RESIZE_METHOD));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_ARRAY_RESIZE_METHOD (obj);
	{
		vala_method_set_cinstance_parameter_position (VALA_METHOD (self), 0.1);
	}
	return obj;
}


static void vala_array_resize_method_class_init (ValaArrayResizeMethodClass * klass) {
	vala_array_resize_method_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = vala_array_resize_method_constructor;
}


static void vala_array_resize_method_instance_init (ValaArrayResizeMethod * self) {
}


GType vala_array_resize_method_get_type (void) {
	static GType vala_array_resize_method_type_id = 0;
	if (G_UNLIKELY (vala_array_resize_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayResizeMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_resize_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayResizeMethod), 0, (GInstanceInitFunc) vala_array_resize_method_instance_init };
		vala_array_resize_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaArrayResizeMethod", &g_define_type_info, 0);
	}
	return vala_array_resize_method_type_id;
}




