;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Package: vcs-tree-system -*-
;;;; *************************************************************************
;;;; FILE IDENTIFICATION
;;;;
;;;; Name:    vcs-tree.asd
;;;; Purpose: ASDF file for vcs-tree to create executable
;;;; Author:  Kevin M. Rosenberg
;;;; Created: Sep 2003
;;;;
;;;; $Id: vcs-tree.asd 8573 2004-01-29 23:30:50Z kevin $
;;;; *************************************************************************

(in-package cl-user)
(defpackage vcs-tree-system (:use #:cl #:asdf))
(in-package vcs-tree-system)

(require 'sb-executable)

;;; From asdf-install.asd
(defclass exe-file (cl-source-file) ())
(defmethod perform :after ((o compile-op) (c exe-file))
  (sb-executable:make-executable
   (make-pathname :name "vcs-tree"
		  :type nil
		  :defaults (component-pathname c))
   (mapcar
    #'(lambda (n)
	(make-pathname :name n :type "fasl"
		       :defaults (car (output-files o c))))
    '("package" "kmrcl-excerpt" "getopt-excerpt" "main" "loader"))
   :initial-function "RUN"))

(defmethod perform ((o load-op) (c exe-file)) nil)

(defsystem vcs-tree
  :version "0.1"
  :components ((:file "package")
	       (:exe-file "loader" :depends-on ("main"))
	       (:file "kmrcl-excerpt" :depends-on ("package"))
	       (:file "getopt-excerpt" :depends-on ("package"))
	       (:file "main" :depends-on ("kmrcl-excerpt" "getopt-excerpt"))))
	       
(defmethod perform :after ((o load-op) (c (eql (find-system :vcs-tree))))
  (provide 'vcs-tree))

(defmethod perform ((o test-op) (c (eql (find-system :vcs-tree))))
  t)

