/*
File: testvdk.h
VDK 0.1 test program
*/               
#include <vdk/vdk.h>
#include <vdk/panelbar.h>
#include "waitcursor.h"
#define MAXTEST 25
#define LISTCOL 3 
/*
main form
*/
class TestForm: public VDKForm
{
  VDKMenu* menu;
  VDKMenuItem *mainmenu,*quit_menu,*testcode_menu,*rc_menu,*help_menu;
  VDKBox *vbox,*vbox1;
  VDKCustomList* list;
  VDKPixmap* pixmap;
  VDKLabel *label, *label1;
  VDKEventBrowser* browser;
  VDKPanelbar *bottombar;
  VDKTimer * timer;
  VDKCustomButton *combobutton;
  VDKMenuItem * menuitems[MAXTEST];
  VDKMenu *combomenu;
public:
TestForm(VDKApplication* app, gchar* title, int mode);
~TestForm();
void Setup();
bool CanClose();
// response functions
//bool PopMainMenu(VDKObject*);
 bool Quit(VDKObject*);
 bool TestCode(VDKObject*);
 bool RcCode(VDKObject*);
 bool HandleListSelection(VDKObject*); 
 bool HandleListUnselection(VDKObject*); 
 bool ChildList(VDKObject*); 
 bool HandleColumnClick(VDKObject*);
 void OnChildClosing(VDKForm* child); 
 bool OnClickLogo(VDKObject*, GdkEvent*);
 bool OnBrowser(VDKObject*);
 bool OnHelp(VDKObject*);
 bool TimerTick(VDKObject*);
 bool OnRealize(VDKObject*);
 bool OnUnrealize(VDKObject*);
 bool OnActivateComboMenu(VDKObject*);
 bool OnClickedComboButton(VDKObject*);
 void OnResize(VDKForm* sender, VDKPoint& newsize);
 void OnMove(VDKForm* sender);

 DECLARE_SIGNAL_MAP(TestForm); 
 DECLARE_EVENT_MAP(TestForm); 
 DECLARE_SIGNAL_LIST(TestForm);
};  
/*
test application
*/  
class TestApp: public VDKApplication
{
public:
TestApp(int* argc, char** argv);
~TestApp();
void Setup();
}; 
