%define pkg_name	vdk
%define pkg_ver		1.2.5
%define pkg_rel		1
%define pkg_copy	LGPL

Summary: The Visual Development Kit is a C++ wrapper for GTK+
Source: %{pkg_name}-%{pkg_ver}.tar.gz
URL: http://vdkbuilder.sourceforge.net/
Group: System Environment/Libraries
Name: %{pkg_name}
Version: %{pkg_ver}
Release: %{pkg_rel}
Copyright: %{pkg_copy}
BuildRoot: /var/tmp/%{pkg_name}-root

%description
VDK features 
- signal/events dispatching strategy makes a clear distinction
  between interface and application. 
- supports properties like moderns RAD tools do, user defined
  properties are supported as well. 
- will track closely Gtk+ development and relies only on Gtk+
  stable releases. 
- has a full documentation and soon a tutorial will be written. 
- is used as base library for a RAD tool , named VDKBuilder 
- using VDK is similar to Borland (Inprise) OWL and/or VCL 

%package devel
Summary: The Visual Development Kit is a C++ wrapper for GTK+
Group: Development/Libraries

%description devel
This package contains the headers and libraries needed to 
compile and link applications using VDK.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" LDFLAGS=-s \
	./configure --prefix=%{_usr} \
	--mandir=%{_mandir} \
	--enable-gnome \
	--enable-sigc

make

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%post
ldconfig

%postun
ldconfig

%files 
%doc README TODO
%{_libdir}/libvdk*.so.*

%files devel
%doc example doc/*.txt
%{_libdir}/libvdk*.so
%{_libdir}/libvdk*.la
%{_libdir}/libvdk*.a
%{_includedir}/vdk 
%{_mandir}/man1/vdk-config.1.gz
%{_bindir}/vdk-config
%{_datadir}/aclocal/vdk.m4

%changelog
* Tue Nov 07 2000 Gordon Messmer <yinyang@eburg.com>
- use build macros to play better in diverse systems

* Sat Jul 08 2000 Gordon Messmer <yinyang@eburg.com>
- configure now generates this file

* Thu Jul 06 2000 Gordon Messmer <yinyang@eburg.com>
- version 1.2.2

* Sat Jun 03 2000 Gordon Messmer <yinyang@eburg.com>
- version 1.2.1

* Tue Feb 01 2000 Gordon Messmer <yinyang@eburg.com>
- Built 1.0.6 release

* Sat Dec 25 1999 Gordon Messmer <yinyang@eburg.com>
- Built 1.0.4 release

* Mon Dec 20 1999 Gordon Messmer <yinyang@eburg.com>
- Built 1.0.3 release
