/*
 * ===========================
 * VDK Visual Development Kit
 * Version 1.0.5
 * Jan 2000
 * Revision on vdk 1.0.5
 * Jan 2000 by tl
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <config.h>
#include <vdk/sigc_events.h>
#include <gdk/gdkkeysyms.h>

/* +-----------------------------------------------------------------+
   |                        class:  VDKAnyEvent                         |
   +-----------------------------------------------------------------*/

VDKAnyEvent::VDKAnyEvent(const GdkEvent * eve, VDKObject* obj)
{
#ifdef VDKDEBUG
     g_return_if_fail(obj!=NULL);
     g_return_if_fail(eve!=NULL);
#endif /* VDKDEBUG */
     _obj=obj;
     _type=eve->type;
}

VDKObject*
VDKAnyEvent::Sender() const
{return _obj;}

/* +----------------------------------------------------------------+
   |                        class VDKKeyEvent                       |
   +----------------------------------------------------------------*/

VDKKeyEvent::VDKKeyEvent(const GdkEventKey * eve, VDKObject* obj)
     : VDKAnyEvent((const GdkEvent*) eve, obj),
       _state(eve->state),
       _keyval(eve->keyval)
{
     _string=g_strdup(eve->string);
}

VDKKeyEvent::~VDKKeyEvent()
{
     g_free(_string);
}

unsigned int
VDKKeyEvent::Key() const
{return _keyval;}

unsigned int
VDKKeyEvent::Modifier() const
{return _state;}

VDKString
VDKKeyEvent::String() const
{return _string;}

const char *
VDKKeyEvent::CString() const
{return _string;}

/* +----------------------------------------------------------------+
   |                       class VDKMouseEvent                      |
   +----------------------------------------------------------------*/

VDKMouseEvent::VDKMouseEvent(const GdkEventMotion * eve, VDKObject* obj)
     : VDKAnyEvent((const GdkEvent*)eve, obj), 
     _pos(eve->x, eve->y),
     _state(eve->state),
     _button(GDK_VoidSymbol)
{
     _gwin=eve->window;
}

VDKMouseEvent::VDKMouseEvent(const GdkEventButton * eve, VDKObject* obj)
     : VDKAnyEvent((const GdkEvent*) eve, obj),  
     _pos(eve->x, eve->y),
     _state(eve->state),
     _button(eve->button)
{
     _gwin=eve->window;
}

VDKMouseEvent::VDKMouseEvent(const GdkEventCrossing * eve, VDKObject* obj)
     : VDKAnyEvent((const GdkEvent*) eve, obj),
       _pos(eve->x, eve->y),
       _state(eve->state),
       _button(GDK_VoidSymbol)
{
     _gwin=eve->window;
}

VDKPoint const&
VDKMouseEvent::Position() const
{
     return _pos;
}

VDKPoint
VDKMouseEvent::AbsPosition() const
{
     gint x,y;
     gdk_window_get_root_origin(_gwin,&x,&y);
     VDKPoint point(_pos); 
     return point.OffsetBy(x,y);
}

unsigned int
VDKMouseEvent::Button() const
{
     return _button;
}

unsigned int
VDKMouseEvent::Modifier() const
{
     return _state;
}

/* *****************************************************************
 * ******                VDKMapEvent                          ******
 * ****************************************************************/

VDKMapEvent::VDKMapEvent(const GdkEventVisibility* eve,
			 VDKObject* sender)
     : VDKAnyEvent((const GdkEvent*) eve,sender)
{
     switch(eve->state){
     case GDK_VISIBILITY_UNOBSCURED:
	  _state=FULLY_VISIBLE;
	  break;
     case GDK_VISIBILITY_PARTIAL:
	  _state=PARTIAL_VISIBLE;
	  break;
     case GDK_VISIBILITY_FULLY_OBSCURED:
	  _state=NOT_VISIBLE;
	  break;
     default:
	  break;
     }
}

/* *****************************************************************
 * *****                VDKSelectionEvent                      *****
 * ****************************************************************/
// VDKSelection::~VDKSelection()
// {
//      if(_str_sel)
// 	  delete _str_sel;
//      if(_str_prop)
// 	  delete _str_prop;
// }

// VDKString
// VDKSelectionEvent::Selection() const
// {
//      if(!_str_sel){//if not allready fetched, then fetch
	  
//      }
//      return *_str_sel;
// }
