/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include "vdk/tooltips.h"
#include "vdk/colors.h"
#include "vdk/vdkcustom.h"
#include <string.h>
VDKTooltip::VDKTooltip(VDKForm* owner,VDKObject *tipped,
		       char* tipString, int delay):
  VDKObject(owner),tipped(tipped),delay(delay)
{
  GtkWidget* tippedGtkWidget = NULL;
  VDKCustom* custom = NULL;
  tip = new char[strlen(tipString)+1];
  strcpy(tip,tipString);
  tooltip = gtk_tooltips_new();
  widget  = (GtkWidget*) tooltip;
  if( (custom = dynamic_cast<VDKCustom*>(tipped)) )
    tippedGtkWidget = custom->CustomWidget();
  else
    tippedGtkWidget = tipped->WrappedWidget();
  gtk_tooltips_set_tip(tooltip,tippedGtkWidget,tip,NULL);
  gtk_tooltips_set_delay(tooltip,delay ? delay : 700);
  tipped->AddItem(this);
  
}

VDKTooltip::~VDKTooltip()
{
  delete[] tip;
}

void 
VDKTooltip::SetColors(int fred, int fgreen, int fblue,
		      int bred, int bgreen, int bblue)
{
  VDKColor *back = new VDKColor(Owner(),bred,bgreen,bblue);
  VDKColor *fore = new VDKColor(Owner(),fred,fgreen,fblue);
  gtk_tooltips_set_colors (tooltip, *back, *fore);

}

void 
VDKTooltip::SetDelay(int delay) 
{
  gtk_tooltips_set_delay(tooltip,delay);
} 

void
VDKTooltip::SetTip(char* tipString)
{
  GtkWidget* tippedGtkWidget = NULL;
  VDKCustom* custom = NULL;
  if(tip)
    delete[] tip;
  tip = new char[strlen(tipString)+1];
  strcpy(tip,tipString);
  tooltip = gtk_tooltips_new();
  widget  = (GtkWidget*) tooltip;
  if( (custom = dynamic_cast<VDKCustom*>(tipped)) )
    tippedGtkWidget = custom->CustomWidget();
  else
    tippedGtkWidget = tipped->WrappedWidget();
  gtk_tooltips_set_tip(tooltip,tippedGtkWidget,tip,NULL);
  gtk_tooltips_set_delay(tooltip,delay ? delay : 700);
}

