/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * February 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_search.h>
#include <string.h>

SearchList VDKBSearchForm::history = SearchList();

//=============================================
DEFINE_SIGNAL_MAP(VDKBSearchForm,VDKForm)
  ON_SIGNAL(ok,clicked_signal,Ok),
  ON_SIGNAL(cancel,clicked_signal,Cancel),
  ON_SIGNAL(combo,activate_signal,OnComboEntry)
END_SIGNAL_MAP
/*
 */
bool
VDKBSearchForm::OnComboEntry(VDKObject*)
{
Ok(NULL);
return true;
}
/*
 */
bool
VDKBSearchForm::Ok(VDKObject*)
{
char* s = combo->Text;
if(s && strlen(s) > 0)
  {
    *match = new char[strlen(s)+1];
    strcpy(*match,s);
    VDKString entry = s;
    if(! VDKBSearchForm::history.find(entry))
      VDKBSearchForm::history.add(entry);
  }
else
  *match = NULL;
Close();
return true;
}

/*
 */
bool
VDKBSearchForm::Cancel(VDKObject*)
{
*match = NULL;
Close();
return true;
}
//==========================================
/*
 */
VDKBSearchForm::VDKBSearchForm(VDKForm* owner, char** match):
    VDKForm(owner),match(match)
{
  /*
    SearchListIterator li(VDKBSearchForm::history);
    for(;li;li++)
    {
    printf("\nhistory:%s",(char*) li.current());
    fflush(stdout);
  }
  */
}
/*
 */
VDKBSearchForm::~VDKBSearchForm()
{
}
/*
 */
void 
VDKBSearchForm::Setup()
{
  Title = _(search_dialog_prompts[0]);
  VDKRadioButton *button; 
  VDKFrame *mainframe = new VDKFrame(this,
				     _(search_dialog_prompts[1]),
				     v_box,shadow_out);
  VDKTable *table1 = new VDKTable(this,1,1);
  mainframe->Add(table1);
  VDKLabel *history = new VDKLabel(this,_(search_dialog_prompts[2]));
  combo = new VDKCombo(this);
  table1->AddToCell(history,0,0);
  table1->AddToCell(combo,0,1);
  //
  if(VDKBSearchForm::history.size() > 0)
    combo->PopdownStrings = VDKBSearchForm::history;
  VDKTable *table2 = new VDKTable(this,2,2);
  mainframe->Add(table2);
  //
  VDKFrame* opt_frame = new VDKFrame(this,search_dialog_prompts[4],
				     v_box,shadow_etched_in);
  table2->AddToCell(opt_frame,0,0);
  opt_frame->Add(casesens = new VDKCheckButton(this,
					       _(search_dialog_prompts[5])));
  casesens->Checked = true;
  opt_frame->Add(wholeword = new VDKCheckButton(this,
						_(search_dialog_prompts[6])));
  wholeword->Enabled = false;
  opt_frame->Add(regex = new VDKCheckButton(this,
					    _(search_dialog_prompts[7])));    
  regex->Enabled = false;  
  //
  VDKFrame* dir_frame = new VDKFrame(this,_(search_dialog_prompts[8]),
				     v_box,shadow_etched_in);
  table2->AddToCell(dir_frame,0,1);
  direction = new VDKRadioButtonGroup(this);
  button = new VDKRadioButton(direction,_(search_dialog_prompts[9]));
  button = new VDKRadioButton(direction,_(search_dialog_prompts[10]));
  button->Enabled = false;
  direction->SetDefault(0);
  dir_frame->Add(direction); 
  //
  VDKFrame* scope_frame = new VDKFrame(this,_(search_dialog_prompts[11]),
				       v_box,shadow_etched_in);
  table2->AddToCell(scope_frame,1,0);
  scope = new VDKRadioButtonGroup(this);
  button = new VDKRadioButton(scope,_(search_dialog_prompts[12]));
  button = new VDKRadioButton(scope,_(search_dialog_prompts[13]));
  button->Enabled = false;
  scope->SetDefault(0);
  scope_frame->Add(scope); 
  //
  VDKFrame* org_frame = new VDKFrame(this,_(search_dialog_prompts[14]),
				     v_box,shadow_etched_in);
  table2->AddToCell(org_frame,1,1);
  origin = new VDKRadioButtonGroup(this);
  button = new VDKRadioButton(origin,_(search_dialog_prompts[15]));
  button->Enabled = false;
  button = new VDKRadioButton(origin,_(search_dialog_prompts[16]));
  origin->SetDefault(1);
  org_frame->Add(origin); 
  Add(mainframe);
  //
  VDKFrame *buttonframe = new VDKFrame(this,NULL,h_box,shadow_etched_in);
  buttonframe->Add(ok = new VDKLabelButton(this,_(search_dialog_prompts[17])));
  // plm 22/09/2000 label translation
  buttonframe->Add(cancel = new VDKLabelButton(this,
					       _(search_dialog_prompts[18])));
  Add(buttonframe,l_justify,false,false,false);
  // set initial position
  //gtk_window_position(GTK_WINDOW(Window()),GTK_WIN_POS_MOUSE);
  combo->CaseSensitive = true;
}



