/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.conflict;

import fr.jayasoft.ivy.ArtifactInfo;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.LatestStrategy;
import fr.jayasoft.ivy.conflict.AbstractConflictManager;
import fr.jayasoft.ivy.util.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class LatestConflictManager
extends AbstractConflictManager {
    private LatestStrategy _strategy;
    private String _strategyName;

    public LatestConflictManager() {
    }

    public LatestConflictManager(LatestStrategy strategy) {
        this._strategy = strategy;
    }

    public LatestConflictManager(String name, LatestStrategy strategy) {
        this.setName(name);
        this._strategy = strategy;
    }

    public Collection resolveConflicts(IvyNode parent, Collection conflicts) {
        Iterator iter = conflicts.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            DependencyDescriptor dd = node.getDependencyDescriptor();
            if (dd == null || !dd.isForce() || !parent.getResolvedId().equals(dd.getParentRevisionId())) continue;
            return Collections.singleton(node);
        }
        ArtifactInfo latest = this.getStrategy().findLatest(this.toArtifactInfo(conflicts), null);
        if (latest != null) {
            return Collections.singleton(((IvyNodeArtifactInfo)latest).getNode());
        }
        return conflicts;
    }

    private ArtifactInfo[] toArtifactInfo(Collection conflicts) {
        ArrayList<IvyNodeArtifactInfo> artifacts = new ArrayList<IvyNodeArtifactInfo>(conflicts.size());
        Iterator iter = conflicts.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            artifacts.add(new IvyNodeArtifactInfo(node));
        }
        return artifacts.toArray(new ArtifactInfo[artifacts.size()]);
    }

    public LatestStrategy getStrategy() {
        if (this._strategy == null) {
            if (this._strategyName != null) {
                this._strategy = this.getIvy().getLatestStrategy(this._strategyName);
                if (this._strategy == null) {
                    Message.error("unknown latest strategy: " + this._strategyName);
                    this._strategy = this.getIvy().getDefaultLatestStrategy();
                }
            } else {
                this._strategy = this.getIvy().getDefaultLatestStrategy();
            }
        }
        return this._strategy;
    }

    public void setLatest(String strategyName) {
        this._strategyName = strategyName;
    }

    public void setStrategy(LatestStrategy strategy) {
        this._strategy = strategy;
    }

    public String toString() {
        return String.valueOf(this._strategy);
    }

    private static class IvyNodeArtifactInfo
    implements ArtifactInfo {
        private final IvyNode _node;

        private IvyNodeArtifactInfo(IvyNode dep) {
            this._node = dep;
        }

        public long getLastModified() {
            return this._node.getPublication();
        }

        public String getRevision() {
            return this._node.getId().getRevision();
        }

        public IvyNode getNode() {
            return this._node;
        }
    }
}

