/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.url;

import fr.jayasoft.ivy.url.AbstractURLHandler;
import fr.jayasoft.ivy.url.URLHandler;
import fr.jayasoft.ivy.util.CopyProgressListener;
import fr.jayasoft.ivy.util.FileUtil;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;

public class HttpClientHandler
extends AbstractURLHandler {
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private String _realm = null;
    private String _host = null;
    private String _userName = null;
    private String _passwd = null;
    private int _proxyPort;
    private String _proxyRealm = null;
    private String _proxyHost = null;
    private String _proxyUserName = null;
    private String _proxyPasswd = null;
    private HttpClient _client;
    private HttpClientHelper _httpClientHelper;

    public HttpClientHandler() {
        this.configureProxy();
    }

    public HttpClientHandler(String realm, String host, String userName, String passwd) {
        this._realm = realm;
        this._host = host;
        this._userName = userName;
        this._passwd = passwd;
        if (this.useAuthentication()) {
            Message.verbose("using authentication in realm " + this._realm + " and host " + this._host + " for user " + this._userName);
        } else {
            Message.verbose("no http authentication will be used");
        }
        this.configureProxy();
    }

    private void configureProxy() {
        this._proxyRealm = null;
        this._proxyHost = System.getProperty("http.proxyHost");
        if (this.useProxy()) {
            this._proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            this._proxyUserName = System.getProperty("http.proxyUser");
            this._proxyPasswd = System.getProperty("http.proxyPassword");
            Message.verbose("proxy configured: host=" + this._proxyHost + " port=" + this._proxyPort + " user=" + this._proxyUserName);
        } else {
            Message.verbose("no proxy configured");
        }
    }

    public InputStream openStream(URL url) throws IOException {
        GetMethod get = this.doGet(url);
        InputStream is = get.getResponseBodyAsStream();
        return new GETInputStream(get);
    }

    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        GetMethod get = this.doGet(src);
        FileUtil.copy(get.getResponseBodyAsStream(), dest, l);
        get.releaseConnection();
    }

    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        HeadMethod head = null;
        try {
            head = this.doHead(url, timeout);
            int status = head.getStatusCode();
            head.releaseConnection();
            if (status == 200) {
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, this.getResponseContentLength(head), this.getLastModified(head));
                return uRLInfo;
            }
            if (status == 407) {
                Message.error("Your proxy requires authentication.");
            } else if (String.valueOf(status).startsWith("4")) {
                Message.verbose("CLIENT ERROR: " + head.getStatusText() + " url=" + url);
            } else if (String.valueOf(status).startsWith("5")) {
                Message.warn("SERVER ERROR: " + head.getStatusText() + " url=" + url);
            }
            Message.debug("HTTP response status: " + status + "=" + head.getStatusText() + " url=" + url);
        }
        catch (HttpException e) {
            Message.error("HttpClientHandler: " + e.getMessage() + ":" + e.getReasonCode() + "=" + e.getReason() + " url=" + url);
        }
        catch (UnknownHostException e) {
            Message.warn("Host " + e.getMessage() + " not found. url=" + url);
            Message.info("You probably access the destination server through a proxy server that is not well configured.");
        }
        catch (IOException e) {
            Message.error("HttpClientHandler: " + e.getMessage() + " url=" + url);
        }
        finally {
            if (head != null) {
                head.releaseConnection();
            }
        }
        return UNAVAILABLE;
    }

    private long getLastModified(HeadMethod head) {
        Header header = head.getResponseHeader("last-modified");
        if (header != null) {
            String lastModified = header.getValue();
            try {
                return LAST_MODIFIED_FORMAT.parse(lastModified).getTime();
            }
            catch (ParseException e) {
                return System.currentTimeMillis();
            }
        }
        return System.currentTimeMillis();
    }

    private long getResponseContentLength(HeadMethod head) {
        return this.getHttpClientHelper().getResponseContentLength(head);
    }

    private HttpClientHelper getHttpClientHelper() {
        if (this._httpClientHelper == null) {
            try {
                Method method = HttpMethodBase.class.getMethod("getResponseContentLength", new Class[0]);
                if (method.isAccessible()) {
                    this._httpClientHelper = new HttpClientHelper3x();
                    Message.verbose("using commons httpclient 3.x helper");
                } else {
                    this._httpClientHelper = new HttpClientHelper2x();
                    Message.verbose("using commons httpclient 2.x helper");
                }
            }
            catch (SecurityException e) {
                Message.verbose("unable to get access to getResponseContentLength of commons-httpclient HeadMethod. Please use commons-httpclient 3.0 or use ivy with sufficient security permissions.");
                Message.verbose("exception: " + e.getMessage());
                this._httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
            catch (NoSuchMethodException e) {
                this._httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
        }
        return this._httpClientHelper;
    }

    private GetMethod doGet(URL url) throws IOException, HttpException {
        HttpClient client = this.getClient();
        GetMethod get = new GetMethod(url.toExternalForm());
        get.setDoAuthentication(this.useAuthentication() || this.useProxyAuthentication());
        client.executeMethod((HttpMethod)get);
        return get;
    }

    private HeadMethod doHead(URL url, int timeout) throws IOException, HttpException {
        HttpClient client = this.getClient();
        client.setTimeout(timeout);
        HeadMethod head = new HeadMethod(url.toExternalForm());
        head.setDoAuthentication(this.useAuthentication() || this.useProxyAuthentication());
        client.executeMethod((HttpMethod)head);
        return head;
    }

    private HttpClient getClient() {
        if (this._client == null) {
            this._client = new HttpClient();
            if (this.useProxy()) {
                this._client.getHostConfiguration().setProxy(this._proxyHost, this._proxyPort);
                if (this.useProxyAuthentication()) {
                    this._client.getState().setProxyCredentials(this._proxyRealm, this._proxyHost, (Credentials)new UsernamePasswordCredentials(this._proxyUserName, this._proxyPasswd));
                }
            }
            if (this.useAuthentication()) {
                this._client.getState().setCredentials(this._realm, this._host, (Credentials)new UsernamePasswordCredentials(this._userName, this._passwd));
            }
        }
        return this._client;
    }

    private boolean useProxy() {
        return this._proxyHost != null && this._proxyHost.trim().length() > 0;
    }

    private boolean useAuthentication() {
        return this._userName != null && this._userName.trim().length() > 0;
    }

    private boolean useProxyAuthentication() {
        return this._proxyUserName != null && this._proxyUserName.trim().length() > 0;
    }

    public static interface HttpClientHelper {
        public long getResponseContentLength(HeadMethod var1);
    }

    private static final class HttpClientHelper2x
    implements HttpClientHelper {
        private HttpClientHelper2x() {
        }

        public long getResponseContentLength(HeadMethod head) {
            Header header = head.getResponseHeader("Content-Length");
            if (header != null) {
                try {
                    return Integer.parseInt(header.getValue());
                }
                catch (NumberFormatException e) {
                    Message.verbose("Invalid content-length value: " + e.getMessage());
                }
            }
            return 0L;
        }
    }

    private static final class HttpClientHelper3x
    implements HttpClientHelper {
        private HttpClientHelper3x() {
        }

        public long getResponseContentLength(HeadMethod head) {
            return head.getResponseContentLength();
        }
    }

    private static final class GETInputStream
    extends InputStream {
        private InputStream _is;
        private GetMethod _get;

        private GETInputStream(GetMethod get) throws IOException {
            this._get = get;
            this._is = get.getResponseBodyAsStream();
        }

        public int available() throws IOException {
            return this._is.available();
        }

        public void close() throws IOException {
            this._is.close();
            this._get.releaseConnection();
        }

        public boolean equals(Object obj) {
            return this._is.equals(obj);
        }

        public int hashCode() {
            return this._is.hashCode();
        }

        public void mark(int readlimit) {
            this._is.mark(readlimit);
        }

        public boolean markSupported() {
            return this._is.markSupported();
        }

        public int read() throws IOException {
            return this._is.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this._is.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this._is.read(b);
        }

        public void reset() throws IOException {
            this._is.reset();
        }

        public long skip(long n) throws IOException {
            return this._is.skip(n);
        }

        public String toString() {
            return this._is.toString();
        }
    }
}

