//=======================================================================
//	vdbcmdw.cpp:	Source for vdbCmdWindow class
//	date: 26 Sep 2000 10:35:55
//      This is the MS-WINDOWS interface to gdb
//=======================================================================

#include <v/vnotice.h>	// for vNoticeDialog
#include <v/vkeys.h>	// to map keys
#include <v/vicon.h>
#include <v/vos.h>


#include "videapp.h"	// our header
#include "vdbcmdw.h"	// our header


    // The following definitions mirror those of the edit/console
    // cmdwin (videCmdWindow), but are all no-ops except the edit
    // menu.

//@V@:BeginIDs
    enum {
	// remaining debug commands defined in videapp.h
	m_NA = 4100,
        m_x1, m_x2, m_x3, m_x4, m_x5, m_x6, m_x7, m_x8,
        m_x9, m_x10, m_x11, m_x12, m_x13, m_x14, m_x15,
	m_x16, m_x17,

	cmdAuxTimer,			// when timer ticks

	dbgLast
      };
//@V@:EndIDs

#include "vcmdcmds.h"

    static int filterIndex = 0;
    // The MS-Windows filter seems to hold only 5 entries for the
    // filter, but it doesn't die with more, it only shows the
    // first 5, so the last 3 filters won't show on MS-Windows.
    // I don't know if that is V or MS-Windows (BEW: 3/5/99)
    static char* filter[] =
      {
        "*.c;*.cpp;*.cxx;*.C;*.h;*.H;*.java;*.htm;*.html;*.txt",
        "*.c;*.cpp;*.cxx;*.h;*.hxx",
	"*.htm;*.html;*.java;*.js",
        "*.txt;*.htm;*.html",
        "*",
        "*.c;*.cpp;*.C",
	"*.h",
	"*.java",
        0
      };

// ###########################################################################

//====================>>> myAuxTimer::TimerTick <<<====================
  void dbAuxTimer::TimerTick()
  {
    cmdw->WindowCommand(cmdAuxTimer, cmdAuxTimer, C_Button); // update clock
  }

//====================>>> vdbCmdWindow::vdbCmdWindow <<<====================
  vdbCmdWindow::vdbCmdWindow(VCONST char* name, int width, int height) :
    vCmdWindow(name, width, height)
  {
    UserDebug1(Constructor,"vdbCmdWindow::vdbCmdWindow(%s) Constructor\n",name)

    // The Menu Bar
    vdbMenu = new vMenuPane(StandardMenu);
    AddPane(vdbMenu);

    // The Command Pane
    vdbCmdPane = new vCommandPane(ToolBar);
    AddPane(vdbCmdPane);

    // The Canvas
    vdbCanvas = new vTextEditor(this);
    AddPane(vdbCanvas);

    // The Status Bar
    vdbStatus = new vStatusPane(StatBar);
    AddPane(vdbStatus);

    // Show Window

    ShowWindow();

    theApp->CheckEvents();

    vdbFont = ((videApp*)theApp)->DefaultFont;
    vdbCanvas->SetFont(vdbFont);

    theApp->CheckEvents();

    if (height <= 0 || width <= 0)
	vdbCanvas->SetTextRowsCols(10,80);
    else
	vdbCanvas->SetTextRowsCols(height,width);

    vdbCanvas->ShowVScroll(1);	// Show Vert Scroll

    SetString(lblIns,"   Debug   ");
    SetString(lblEMsg,"                            ");
    SetString(lblLineCol,"        ");

    // timer to get db output
    auxTimer = new dbAuxTimer(this);	// create timer
    auxTimer->TimerSet(300);		// update 3 times a second

    dbProc = new vPipedProcess();	// to talk to debugger

    *dbCmd = 0;
    dbCmdPtr = dbCmd;		// build command in dbCmd

    dbOutLine[0] = 0;
    dbOutNext = 0;

    gdbDlg = 0;
    jdbDlg = 0;
  }

//====================>>> vdbCmdWindow::~vdbCmdWindow <<<====================
  vdbCmdWindow::~vdbCmdWindow()
  {
    UserDebug(Destructor,"vdbCmdWindow::~vdbCmdWindow() destructor\n")

    // Now put a delete for each new in the constructor.

    if (gdbDlg != 0)
      {
	gdbDlg->CloseDialog();
	delete gdbDlg;
      }

    if (jdbDlg != 0)
      {
	jdbDlg->CloseDialog();
	delete jdbDlg;
      }

    auxTimer->TimerStop();	// kill the timer first
    delete auxTimer;

    dbProc->killProcess();	// kill off process if still running
    delete dbProc;

    delete vdbMenu;
    delete vdbCanvas;
    delete vdbCmdPane;
    delete vdbStatus;

  }

//====================>>> vedCmdWindow::CloseWin <<<====================
  void vdbCmdWindow::CloseWin()
  {
    // do these things in the close because the delete can be delayed

    if (gdbDlg != 0)
      {
	gdbDlg->CloseDialog();
	delete gdbDlg;
	gdbDlg = 0;
      }

    if (jdbDlg != 0)
      {
	jdbDlg->CloseDialog();
	delete jdbDlg;
	jdbDlg = 0;
      }

    auxTimer->TimerStop();	// kill the timer first
    dbProc->killProcess();

    vCmdWindow::CloseWin();	// and the parent...
  }

//====================>>> vedCmdWindow::ChangeLoc <<<====================
  void vdbCmdWindow::ChangeLoc(long line, int col)
  {
#ifdef USETHISCODE
    char buff[20];
    char colbuff[10];
    char outbuff[20];
    int ll;

    LongToStr(line,buff);

    IntToStr(col,colbuff);

    // center the line/col string

    int totalLen = strlen(buff) + strlen(colbuff) + 1;

    int add = (9 - totalLen) / 2;

    for (ll = 0 ; ll < add ; ++ll)
	outbuff[ll] = ' ';
    outbuff[ll] = 0;

    strcat(outbuff,buff); strcat(outbuff,"/");
    strcat(outbuff,colbuff);

    // pad with trailing blanks so X doesn't shift things

    for (ll = strlen(outbuff) ; ll < 9 ; ++ll)
	outbuff[ll] = ' ';
    outbuff[ll] = 0;
    SetString(lblLineCol,outbuff);
#endif

  }

//====================>>> videCmdWindow::SetSens <<<====================
  void vdbCmdWindow::SetToolBar(ItemVal id, int indx, int val)
  {
  
    SetValueAll(id,val,Sensitive);
    ToolBar[indx].Sensitive = val;
  }

//====================>>> vdbCmdWindow::StatusMessage <<<====================
  void vdbCmdWindow::StatusMessage(char *msg)
  {
    char lineout[42];
    int ix;

    // copy up to 40 chars
    for (ix = 0 ; ix < 40 && msg[ix] ; ++ix)
	lineout[ix] = msg[ix];

    // pad with trailing blanks
    for ( ; ix < 40 ; ++ix)
	lineout[ix] = ' ';

    lineout[ix] = 0;

    SetString(lblEMsg,lineout);
  }

//====================>>> vdbCmdWindow::KeyIn <<<====================
  void vdbCmdWindow::KeyIn(vKey keysym, unsigned int shift)
  {
    
    if (keysym ==  vk_Return)		// send a command...
      {
	*dbCmdPtr++ = '\n';
	*dbCmdPtr = 0;
	dbCmdPtr = dbCmd;
	vdbCanvas->bufferBottom();
	vdbCanvas->charInsert('\n');
	dbSendCmd(dbCmd, 0);
      }
    else if (keysym == vk_BackSpace || keysym == vk_Delete)
      {
	if (dbCmdPtr != dbCmd)
	  {
	    --dbCmdPtr;
	    vdbCanvas->bufferBottom();
	    vdbCanvas->charDelete(-1);
	  }
	
      }
    else if (keysym >= ' ' && keysym <= 127)
      {
        *dbCmdPtr++ = (char) keysym;	// add to command buffer
	vdbCanvas->bufferBottom();
        vdbCanvas->charInsert((char) keysym);
      }
    else
        vdbCanvas->EditKeyIn(keysym, shift);


  }

//====================>>> videCmdWindow::GotoDebugLine <<<====================
  videCmdWindow* vdbCmdWindow::GotoDebugLine(char* info)
  {
    // This is passed the gdb or jdb breakpoint line info.
    // Open that file, go to the line
    // The gdb info line is in the format:
    //     fullfilename:##:misc other stuff
    // The fullfile name CAN include a drive, and thus a :,
    // so must account for that...

    // The jdb infoline is in the format:
    //    Breakpoint hit: SimpleExample.main (SimpleExample:137)
    // This doesn't have drive info, so we must hope we are in
    // the same directory! Eventually, we might have to see if
    // we can use classpath...

    // First, get pointer to the error message window
    // so we can use the helper methods in videCmdWindow class

    videCmdWindow* cmdw = ((videApp*)theApp)->GetMsgWindow();

    // char errLine[100];

    // line number will be somewhere on line in format filename.c:##
    // error line in format "  ! filename.cpp:###:msg"

    char fullFileName[maxFileNameSize+2];
    char filePath[maxFileNameSize+2];
    char fileBase[maxFileNameSize+2];

    char cLineNum[20];

#ifdef V_VersionWindows
    // Windows version would prefer to have all \ for file names
    if (debugModel == dbGDB)
      {
	for (char* cp = info ; *cp ; ++cp)
	  {
	    if (*cp == '/')
		*cp = '\\';
	  }
      }
#endif

    if (debugModel == dbGDB)
      {
	int ifn, ffn;		// index to info, fullfile name
	// pick up the full file name
	if ((info[0] == '/' && info[1] == '/') ||
	    (info[0] == '\\' && info[1] == '\\')) // must be //c/foo format (1.17)
	  {
	    fullFileName[0] = info[2];
	    fullFileName[1] = ':';		// convert to C: format
	    ffn = 2;
	    ifn = 3;
	  }
	else
	  {
	    ffn = ifn = 2;
	    fullFileName[0] = info[0];
	    fullFileName[1] = info[1];	// These skip possible : in name
	  }
	while ( ifn < maxFileNameSize && info[ifn] != ':' && info[ifn])
	  {
	    fullFileName[ffn++] = info[ifn++];
	  }

	fullFileName[ffn] = 0;

	// fullFilename now has full file path

	// ifn points to the : before the line number

	char* np = &cLineNum[0];		// get the line number
	for ( ++ifn ; info[ifn] >= '0' && info[ifn] <= '9' ; ++ifn)
	    *np++ = info[ifn];
	*np = 0;

      }
    else if (debugModel == dbJDB)
      {
	//    Breakpoint hit: SimpleExample.main (SimpleExample:137)
	vOS vos;
	vos.vGetCWD(fullFileName,maxFileNameSize);
	strcat(fullFileName,"/");
	fileBase[0] = 0;
	// Check for java. breaks - hit on single steps, don't want
	// to see these usually, so just ignore.

	if (strstr(info,"hit: java.") != 0 ||
		strstr(info,"hit: sun.") != 0)
	  {
	    dbSendCmd("next\n");
	    return 0;
	  }

	for (int ix = 0 ; ix < dbOutMax ; ++ix)
	  {
	    if (info[ix] == '(')
	      {
		++ix;		// skip the (
		int ij;
		for (ij = 0 ; info[ix] && info[ix] != ':' ; )
		    fileBase[ij++] = info[ix++];
		fileBase[ij] = 0;
		strcat(fileBase,".java");	// add this!
		if (!info[ix])
		    break;
		ix++;		// skip the ':', and get the line num
		for (ij = 0 ; info[ix] && info[ix] != ')' ; )
		    cLineNum[ij++] = info[ix++];
		cLineNum[ij] = 0;
		break;
	      }
	  }
	strcat(fullFileName,fileBase);
      }
    else
	return 0;

    long lineNum = StrToLong(cLineNum);

    // get parts
    splitFileName(fullFileName,filePath,fileBase,0);

    
    // start by seeing if file is in the supplied full name
 

    videCmdWindow* openw = cmdw->FindCmdWin(fullFileName);

    if (openw == 0)		// nope, then try the base name only
      {
        openw = cmdw->FindCmdWin(fileBase);
      }

    if (openw != 0)		// EASY, already open
      {
        (openw->GetTextEd())->EditCommand(edLineGoto, lineNum);
        openw->setCurPC(lineNum);	// set PC to current line
        (openw->GetTextEd())->EditCommand(edCenterScreen, 0);
	RaiseWindow();		// first, raise myself
	openw->RaiseWindow();	// then, the target
        return openw;
      }

    // Not already open, so need to open a new window.
    openw = new videCmdWindow("VIDE", -1, -1);
    (void) theApp->NewAppWin((vWindow*) cmdw, "", -1, -1, 0);

    if (!openw)
        return 0;	       // should never happen...

    if (!openw->OpenFile(fullFileName,0,0))
      {
      	// hmmm - the file doesn't exist on Makefile path
        // try something else
        vFileSelect fsel(this);     // make an instance
        if (!fsel.FileSelect("Debug: Open Source File",fileBase,maxFileNameSize,
             filter,filterIndex))
          {
            theApp->CloseAppWin(openw);
            return 0;
          }
        if (!openw->OpenFile(fileBase,0,0))
	  {
            theApp->CloseAppWin(openw);
	    return 0;
          }
        (openw->GetTextEd())->EditCommand(edLineGoto, lineNum);
        openw->setCurPC(lineNum);	// set PC to current line
        (openw->GetTextEd())->EditCommand(edCenterScreen, 0);
      }
    else
      {
        (openw->GetTextEd())->EditCommand(edLineGoto, lineNum);
        openw->setCurPC(lineNum);	// set PC to current line
        (openw->GetTextEd())->EditCommand(edCenterScreen, 0);
      }
    RaiseWindow();		// first, raise myself
    openw->RaiseWindow();	// then, the target
    return openw;
  }

//====================>>> vdbCmdWindow::doBreakCmd <<<====================
  void vdbCmdWindow::doBreakCmd(videCmdWindow* win, char* bcmd)
  {
    long curlin = (win->GetTextEd())->GetCurLine();
    char *fileName = win->GetFileName();
    char fileBase[maxFileNameSize+2];
    char cmd[maxFileNameSize+2];
    char lNum[20];

    splitFileName(fileName,0,fileBase,0);
    strcpy(cmd,bcmd);

    if (debugModel == dbJDB)	// need to strip the .java
      {
	int ix = strlen(fileBase);
	if (ix > 5 && fileBase[ix-5] == '.')
	    fileBase[ix-5] = 0;
      }

    strcat(cmd,fileBase);
    strcat(cmd,":");
    LongToStr(curlin, lNum);
    strcat(cmd,lNum);
    strcat(cmd,"\n");
    dbSendCmd(cmd);
  }


//====================>>> vdbCmdWindow::breakCmd <<<====================
  void vdbCmdWindow::breakCmd(char* fname, long line, ItemVal id)
  {
    char fileBase[maxFileNameSize+2];
    char cmd[maxFileNameSize+2];
    char lNum[20];

    // get file base name
    splitFileName(fname,0,fileBase,0);
    if (debugModel == dbJDB)	// need to strip the .java
      {
	int ix = strlen(fileBase);
	if (ix > 5 && fileBase[ix-5] == '.')
	    fileBase[ix-5] = 0;
      }


    // build the first part of the command
    if (debugModel == dbGDB)
      {
	switch (id)
	  {
	    case m_SetBP:
	      {
		strcpy(cmd, "break ");
		break;
	      }

	    case m_DeleteBP:
	      {
		strcpy(cmd, "clear ");
		break;
	      }

	    case m_ShowBreakpoints:
	      {
		dbSendCmd("info breakpoints\n");
		return;
	      }

	    case m_DeleteBreakpoints:
	      {
		dbSendCmd("delete breakpoints\n");
		return;
	      }

	    default:
		return;
          }
      }
    else			// JDB commands....
      {
	switch (id)
	  {
	    case m_SetBP:
	      {
		strcpy(cmd, "stop at ");
		break;
	      }

	    case m_DeleteBP:
	      {
		strcpy(cmd, "clear ");
		break;
	      }

	    case m_ShowBreakpoints:
	      {
		dbSendCmd("clear\n");
		return;
	      }

	    default:
		return;
          }
      }

    // have the command, now add a file name and line number
    strcat(cmd,fileBase);
    strcat(cmd,":");
    LongToStr(line, lNum);
    strcat(cmd,lNum);
    strcat(cmd,"\n");
    dbSendCmd(cmd);

  }

//====================>>> vdbCmdWindow::debugCmd <<<====================
  void vdbCmdWindow::debugCmd(videCmdWindow* win, ItemVal id)
  {
    if (debugModel == dbGDB)
      {
	switch (id)
	  {
	    case m_StepOver:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("next\n");
		break;
	      }

	    case m_StepInto:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("step\n");
		break;
	      }

	    case m_CallStack:
	      {
		dbSendCmd("bt\n");
		break;
	      }

	    case m_Inspect:
	    case m_InspectInd:
	      {
		char varName[82];
		int res = (win->GetTextEd())->getSelection(varName, 80);
		if (!res || strlen(varName) < 1)
		  {
		    vNoticeDialog note(this);
		    note.Notice("Highlight variable to inspect first!");
		    break;
		  }
		char cmd[90];
		if (id == m_Inspect)
		    strcpy(cmd,"print ");
		else
		    strcpy(cmd,"print* ");
		strcat(cmd,varName);
		strcat(cmd,"\n");
		dbSendCmd(cmd);
		break;
	      }

	    case m_Up:
	      {
		dbSendCmd("up\n");
		break;
	      }

	    case m_Down:
	      {
		dbSendCmd("down\n");
		break;
	      }

	    case m_Args:
	      {
		dbSendCmd("info args\n");
		break;
	      }

	    case m_Locals:
	      {
		dbSendCmd("info locals\n");
		break;
	      }

	    case m_Continue:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("continue\n");
		break;
	      }

	    case m_Kill:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("kill\n");
		break;
	      }

	    case m_DBRun:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("run\n");
		break;
	      }

	    case m_SetArgs:
	      {
		break;
	      }

	    case m_RunTo:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		doBreakCmd(win,"until ");
		break;
	      }

	    case m_DBHelp:
	      {
		dbSendCmd("help\n");
		break;
	      }

	    default:
	      {
		break;
	      }
	  }
      }
    else			// JDB commands....
      {
	switch (id)
	  {
	    case m_StepOver:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("next\n");
		break;
	      }

	    case m_StepInto:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("step\n");
		break;
	      }

	    case m_CallStack:
	      {
		dbSendCmd("where\n");
		break;
	      }

	    case m_Inspect:
	      {
		char varName[82];
		int res = (win->GetTextEd())->getSelection(varName, 80);
		if (!res || strlen(varName) < 1)
		  {
		    vNoticeDialog note(this);
		    note.Notice("Highlight variable to inspect first!");
		    break;
		  }
		char cmd[90];
		strcpy(cmd,"print ");
		strcat(cmd,varName);
		strcat(cmd,"\n");
		dbSendCmd(cmd);
		break;
	      }

	    case m_Continue:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("cont\n");
		break;
	      }

	    case m_Kill:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("suspend\n");
		break;
	      }

	    case m_DBRun:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("run\n");
		break;
	      }

	    case m_SetArgs:
	      {
		vBeep();
		break;
	      }

	    case m_DBHelp:
	      {
		dbSendCmd("help\n");
		break;
	      }

	    case m_jdbLocals:
	      {
		dbSendCmd("locals\n");
		break;
	      }

	    case m_jdbClasses:
	      {
		dbSendCmd("classes\n");
		break;
	      }

	    case m_jdbStepUp:
	      {
		theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp
		dbSendCmd("step up\n");
		break;
	      }

	    case m_jdbMemory:
	      {
		dbSendCmd("memory\n");
		break;
	      }

	    default:
	      {
		break;
	      }

	  }
      }

  }

//====================>>> vdbCmdWindow::WindowCommand <<<====================
  void vdbCmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)
  {
    // Default: route menu and toolbar commands here


    UserDebug1(CmdEvents,"vdbCmdWindow:WindowCommand(%d)\n",id)

    // First, check for all debug commands so we can route them
    // through one place.
    switch (id)
      {
	case cmdAuxTimer:	// when timer ticks
	  {
	    dbShowOut();	// show any output
	    break;
	  }

	default:		// route unhandled commands
	  {
	    if (((videApp*)theApp)->getCurCmdWin() != 0)
		(((videApp*)theApp)->getCurCmdWin())->WindowCommand(id, val, cType);
	    else  if (((videApp*)theApp)->GetMsgWindow() != 0)
		(((videApp*)theApp)->GetMsgWindow())->WindowCommand(id, val, cType);
	    else
		vCmdWindow::WindowCommand(id, val, cType);
	    break;
	  }
      }
  }

//====================>>> vdbCmdWindow::OpenDebugger <<<====================
  bool vdbCmdWindow::OpenDebugger(const char* debugger, const char* exe)
  {
    char cmd[maxFileNameSize+20];

    strcpy(cmd,"");
    if (strstr(debugger,"gdb") != 0)	// any gdb style
      {
	debugModel = dbGDB;
	strcat(cmd, debugger);
	strcat(cmd," -q -f");		// emacs output format from gdb
      }
    else if (strcmp(debugger,"jdb") == 0 || strstr(debugger,"appletviewer") != 0)
      {
	strcat(cmd, debugger);
	debugModel = dbJDB;
      }
    else			// not one we know about
      {
	debugModel = dbNone;
	return false;
      }

    dbOutLine[0] = 0;
    dbOutNext = 0;

    if (exe && *exe)
      {
	strcat(cmd," ");
	strcat(cmd,exe);
      }
    
    vdbCanvas->addLine(cmd);		// show how we are starting debugger
    if (!dbProc->startPipedProcess(cmd))
      {
	vdbCanvas->addLine("CreateProcess Fails....");
	vdbCanvas->bufferBottom();
	return 0;
      }
    vdbCanvas->addLine("--- Debugger running---");
    vdbCanvas->addLine(" ");
    vdbCanvas->lineDown(1);

    switch (debugModel)
      {
	case dbGDB:
	  {
	    if (!gdbDlg)
		gdbDlg = new gdbDialog(this, "gdb");
	    gdbDlg->ShowDialog("gdb");
	    int l,t,w,h;
	    GetPosition(l,t,w,h);   // my position
	    gdbDlg->SetDialogPosition(l+w-100,t+30);   // put quick pick here
	    break;
	  }
	    
	case dbJDB:
	  {
	    if (!gdbDlg)
		jdbDlg = new jdbDialog(this, "Java jdb"); // @@@
	    jdbDlg->ShowDialog("jdb");
	    int l,t,w,h;
	    GetPosition(l,t,w,h);   // my position
	    gdbDlg->SetDialogPosition(l+w-100,t+30);   // put quick pick here
	    break;
	  }
	    
      }

    // now, send the bps we already have available

    ((videApp*)theApp)->getBreakPoints()->sendForAllBreakPoints(m_SetBP);
    return 1;

  }

//====================>>> vdbCmdWindow::dbSendCmd <<<====================
  void vdbCmdWindow::dbSendCmd(char* cmd, int echo)
  {
    if (echo)
      {
         vdbCanvas->bufferBottom();
         for (char* cp = cmd ; *cp && *cp != '\n' ; ++cp)
             vdbCanvas->charInsert(*cp);
         vdbCanvas->charInsert('\n');
	 vdbCanvas->lineDown(1);
      }
    else
	theApp->UpdateAllViews(this, ChangePC, 0);	// fix bp

    // output will be displayed by dbShowOut...

    dbProc->writeChars(cmd);
    return;

  }

//====================>>> vdbCmdWindow::dbShowOut <<<====================
  bool vdbCmdWindow::dbShowOut(bool atBottom)
  {
    // This routine checks for output from the debugger

    int bytesRead;

    char chrin[10] = "";

    bool first = true;
    static int colOut = 0;		// current output column

    for ( ; ; )		// read all debugger output available
      {
	// first, see if any output is available...
	bytesRead = dbProc->readChar(chrin);
	if (bytesRead == 0)		// just in case
	    return false;

	if (first)			// buffer bottom once...
	  {
	    first = false;
	    if (!atBottom)
	      {
		vdbCanvas->bufferBottom();		// add at bottom
		vdbCanvas->lineDown(1);
	      }
	  }

	// add the character to the display
	if (*chrin == '\032')		// prefix from gdb for break
	  {
	    // should be 2 \032's in a row. wait for rest of line...
	    bytesRead = dbProc->readChar(chrin);
	    if (bytesRead == 0)		// just in case
		return false;
	    if (*chrin != '\32')
		continue;
	    // ok - special formatted breakpoint line coming...
	    // read it all
	    char info[maxFileNameSize+2];
	    char* cp = info;
	    for ( ; ; )
	      {
		bytesRead = dbProc->readChar(chrin);
		if (bytesRead == 0)		// just in case
		    return false;
		if (*chrin == '\n')
		  {
		    *cp = 0;
                    for (char* lp = info ; *lp ; ++lp)
                        vdbCanvas->charInsert(*lp, /*doundo*/ false);
                    vdbCanvas->charInsert('\n', /*doundo*/ false);
		    vdbCanvas->lineDown(1);
		    (void) GotoDebugLine(info);
		    dbOutNext = 0;
                    return true;
		  }
		else
		    *cp++ = *chrin;

		theApp->CheckEvents();
	      }
	    dbOutNext = 0;
	    return true;
	  }
	else if (*chrin != '\r')
	  {
	    if (*chrin == '\n')
	      {
		dbOutLine[dbOutNext] = 0;
		dbOutNext = 0;
		colOut = 0;
		vdbCanvas->charInsert(*chrin, /*doundo*/ false);
		vdbCanvas->lineDown(1);
		if (debugModel == dbJDB)	// need to check for breakpoints
		  {
		    if (strstr(dbOutLine,"Breakpoint hit:") == dbOutLine)
		      {
			(void) GotoDebugLine(dbOutLine);
		      }
		  }
	      }
	    else 
	      {
		if (colOut++ >= vdbCanvas->GetCols())
		  {
		    colOut = 3;
		    vdbCanvas->charInsert('\n', /*doundo*/ false);
		    vdbCanvas->charInsert(' ', /*doundo*/ false);
		    vdbCanvas->charInsert('+', /*doundo*/ false);
		    vdbCanvas->charInsert(*chrin, /*doundo*/ false);
		    dbOutNext = 0;
		  }
		if (dbOutNext < dbOutMax)	// save out line to check for jdb breaks
		    dbOutLine[dbOutNext++] = *chrin;
		vdbCanvas->charInsert(*chrin, /*doundo*/ false);
	      }
	  }
      }
    return true;
  }
