/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             H A R D C O P Y . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 2000                   *
*                                                                              *
********************************************************************************
*
* $Id: hardcopy.c,v 1.5 2000/12/10 15:08:16 jrh Exp $
* $Log: hardcopy.c,v $
* Revision 1.5  2000/12/10 15:08:16  jrh
* Release 2.3
*
* Revision 1.4  1999/05/24 01:25:46  jrh
* Release 2.2.1
*
* Revision 1.3  1999/02/07 21:50:02  jrh
* Release 2.2
*
* Revision 1.2  1998/01/26 00:47:54  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:41:06  jrh
* Initial revision
*
*/
#include<pwd.h>
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<sys/types.h>
#include<X11/Xatom.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<Xm/Xm.h>
#include<GL/glu.h>
#include "tiffio.h"
#include "viewmol.h"
#include "dialog.h"

char *saveTiff(int, char *, int);
char *saveVectorFile(int, char *, int);
void writeTiff(TIFF *, unsigned char *, int, int, XColor *);

extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern FILE *hpglInit(char *, double, double, double, double, double, double,
                      int);
extern FILE *PostscriptInit(char *, double, double, double, int, int);
extern void PostscriptClose(FILE *);
extern void (*drawString)(char *, double, double, double, double, GLuint);
extern FILE *raytraceInit(char *, Dimension, Dimension);
extern void raytraceClose(FILE *);
extern void setDrawingDevice(int);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern void redraw(int);
extern void hpglClose(FILE *);
extern int  messgb(Widget, int, char *, struct PushButtonRow *, int);
extern int  StringWidth(XFontStruct *, char *);
extern int  StringHeight(XFontStruct *);
extern void setWindowColor(int, Pixel, const float *);
extern void writeFeedback(FILE *, int, GLfloat *, int, int, int, int);
extern XVisualInfo *getVisualInfo(Display *, Visual *);

extern Widget topShell;
extern struct MOLECULE *molecules;
extern struct WINDOW windows[];
extern Pixel stdcol[9];
extern double paperWidth, paperHeight, sphereres;
/* extern char title[]; */
extern char *text, *textPointer;
/* extern int na, nb; */
extern int iwavef, shadows, ground;
extern int rgbMode, swapBuffers, primitive, debug;

char *saveTiff(int window, char *file, int compression)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  FILE *f;
  TIFF *tif;
  struct passwd *entry;
  Dimension width, height;
  Colormap colormap;
  XColor *colors=NULL;
  Visual *vi;
  XVisualInfo *visualInfo;
  unsigned char *data;
  char str[MAXLENLINE], *word;
  int ncolors, imol;
  register long rps;
  register int i;

/* Try to open file to catch possible problems with permissions
   before using TIFF library to open file */

  if ((f=fopen(file, "w")) == NULL)
  {
    word=getStringResource(topShell, "unableToOpen");
    sprintf(str, word, file);
    messgb(topShell, 1, str, buttons, 1);
    return(NULL);
  }
  else
  {
    fclose(f);
    if ((tif=TIFFOpen(file, "w")) == NULL)
    {
      word=getStringResource(topShell, "unableToOpen");
      sprintf(str, word, file);
      messgb(topShell, 1, str, buttons, 1);
      return(NULL);
    }
  }

  if (windows[window].set >= 0)
    imol=windows[window].set;
  else
    imol=0;
  XtVaGetValues(windows[window].widget, XmNwidth, &width, XmNheight, &height,
                XmNcolormap, &colormap, NULL);
  XtVaGetValues(topShell, XtNvisual, &vi, NULL);
  visualInfo=getVisualInfo(XtDisplay(windows[window].widget), vi);
  if (width % 4 != 0) width-=(width % 4);
  ncolors=visualInfo->colormap_size;
  TIFFSetField(tif, TIFFTAG_IMAGEWIDTH, width);
  TIFFSetField(tif, TIFFTAG_IMAGELENGTH, height);
  TIFFSetField(tif, TIFFTAG_COMPRESSION, compression);
  rps=(long)8*1024/TIFFScanlineSize(tif);
  TIFFSetField(tif, TIFFTAG_ROWSPERSTRIP, rps == 0 ? 1L : rps);
  TIFFSetField(tif, TIFFTAG_XRESOLUTION, 1.0);
  TIFFSetField(tif, TIFFTAG_YRESOLUTION, 1.0);
  TIFFSetField(tif, TIFFTAG_RESOLUTIONUNIT, 1);
  TIFFSetField(tif, TIFFTAG_PLANARCONFIG, PLANARCONFIG_CONTIG);
  TIFFSetField(tif, TIFFTAG_ORIENTATION, ORIENTATION_BOTLEFT);
  entry=getpwuid(getuid());
  TIFFSetField(tif, TIFFTAG_ARTIST, entry->pw_gecos);
  TIFFSetField(tif, TIFFTAG_IMAGEDESCRIPTION, molecules[imol].title);
  strcpy(str, PROGRAM);
  strcat(str, " ");
  strcat(str, VERSION);
  TIFFSetField(tif, TIFFTAG_SOFTWARE, str);
  TIFFSetField(tif, TIFFTAG_BITSPERSAMPLE, 8);
  TIFFSetField(tif, TIFFTAG_SAMPLESPERPIXEL, 3);
  TIFFSetField(tif, TIFFTAG_PHOTOMETRIC, PHOTOMETRIC_RGB);

  glXMakeCurrent(XtDisplay(windows[window].widget), XtWindow(windows[window].widget), windows[window].context);
  if (rgbMode)
  {
    data=(unsigned char *)getmem((width+1)*(height+1), 3*sizeof(unsigned char));
    glReadPixels((GLint)0, (GLint)0, (GLsizei)width, (GLsizei)height, GL_RGB,
                 GL_UNSIGNED_BYTE, data);
  }
  else
  {
    data=(unsigned char *)getmem((width+1)*(height+1), sizeof(unsigned int));
    glReadPixels((GLint)0, (GLint)0, (GLsizei)width, (GLsizei)height,
                 GL_COLOR_INDEX, GL_UNSIGNED_INT, data);
    colors=(XColor *)getmem(ncolors, sizeof(XColor));
    for (i=0; i<ncolors; i++)
      colors[i].pixel=(long)i;
    XQueryColors(XtDisplay(windows[window].widget), colormap, colors, ncolors);
    for (i=0; i<ncolors; i++)
    {
      colors[i].red >>= 8;
      colors[i].green >>= 8;
      colors[i].blue >>= 8;
    }
  }
  writeTiff(tif, data, width, height, colors);
  TIFFClose(tif);
  if (colors != NULL) free((void *)colors);
  free((void *)data);
  word=getStringResource(topShell, "TIFFSaved");
  return(word);
}

void writeTiff(TIFF *tif, unsigned char *data, int width, int height,
               XColor *colors)
{
  unsigned char *scanline=NULL;
  unsigned char *ssc=NULL;
  unsigned int  *ssi=NULL;
  register unsigned int v;
  register int i, j;
  register unsigned char *pp;

  if (colors)
    ssi=(unsigned int *)data;
  else
    ssc=data;

  for (j = 0; j < height; j++)
  {
    if (!colors)
    {
      scanline=(unsigned char *)ssc;
      ssc += 3*width;
    }
    else
    {
      scanline=(unsigned char *)malloc(TIFFScanlineSize(tif));
      pp = scanline;
      for (i = 0; i < width; i++)
      {
        v = *ssi;
        pp[0]=(char)colors[v].red;
        pp[1]=(char)colors[v].green;
        pp[2]=(char)colors[v].blue;
        pp += 3;
        ssi++;
      }
    }
    if (TIFFWriteScanline(tif, scanline, j, 0) < 0) break;
  }
  if (colors) free(scanline);
}

char *saveVectorFile(int window, char *file, int format)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton,
                                            (XtPointer)0, NULL}};
  FILE *f=NULL;
  Dimension width, height;
  int modeSave=windows[window].mode, nentries=(-1), size, shadowsSave;
  int imol;
  GLfloat *feedbackBuffer;
  double fontSizeX, fontSizeY;
  const float black[4]   = {0.0, 0.0, 0.0, 0.0};
  int portrait, smooth=FALSE, ntrials=5;
  char *word=NULL, str[MAXLENLINE];

  if (windows[window].set >= 0)
    imol=windows[window].set;
  else
    imol=0;
  glXMakeCurrent(XtDisplay(windows[window].widget), XtWindow(windows[window].widget), windows[window].context);
  swapBuffers=FALSE;
  shadowsSave=shadows;
  if (format != POSTSCRIPT) shadows=FALSE;
  strcpy(str, PROGRAM);
  strcat(str, " ");
  strcat(str, VERSION);
  strcat(str, ": ");
  strcat(str, molecules[imol].title);
  XtVaGetValues(windows[window].widget,
                XtNwidth, &width,
                XtNheight, &height,
                NULL);
  portrait=paperWidth < paperHeight ? TRUE : FALSE;
  fontSizeX=(double)StringWidth(windows[window].font, "1000.");
  fontSizeY=(double)StringHeight(windows[window].font);
  switch (format)
  {
    case HPGL:       f=hpglInit(file, (double)width, (double)height, paperWidth,
                                paperHeight, fontSizeX/110., fontSizeY/40.,
                                portrait);
                     ground=FALSE;
                     break;
    case POSTSCRIPT: if (window == VIEWER && (windows[window].mode != WIREMODEL || iwavef != ALL_OFF)
                         && primitive == GLU_FILL) smooth=TRUE;
                     f=PostscriptInit(file, paperWidth, paperHeight, fontSizeY,
                                      window, smooth);
                     break;
    case RAYTRACER:  f=raytraceInit(file, width, height);
                     if (windows[window].mode == WIREMODEL)
                       windows[window].mode=STICKMODEL;
                     break;
  }
  if (f != NULL)
  {
    setDrawingDevice(format);
    if (format == RAYTRACER)
      redraw(window);
    else
    {
      size=(size_t)(molecules[imol].na*(sphereres/10.+0.1)*(sphereres/10.+0.1)
          *4152+molecules[imol].nb*1000.*sphereres/10.);
      feedbackBuffer=getmem(size, sizeof(GLfloat));
      text=(char *)getmem(200, sizeof(char));
      textPointer=text;
      while (nentries < 0 && ntrials)
      {
        glFeedbackBuffer(size, GL_3D_COLOR, feedbackBuffer);
        (void)glRenderMode(GL_FEEDBACK);
        redraw(window);
        setWindowColor(FOREGROUND, stdcol[BLACK], black);
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        glOrtho(windows[window].left, windows[window].right, windows[window].bottom,
                windows[window].top, windows[window].near, windows[window].far);
        glMatrixMode(GL_MODELVIEW);
        glPushMatrix();
        glLoadIdentity();
        (*drawString)(str, windows[window].right, windows[window].bottom,
                      windows[window].near, 1.0, windows[window].GLfontId);
        glPopMatrix();
        nentries=glRenderMode(GL_RENDER);
        if (debug) printf("Size of feedback buffer: %d, used: %d\n", size, nentries);
        if (nentries > 0)
          writeFeedback(f, nentries, feedbackBuffer, window, format, smooth, portrait);
        else
        {
          size*=2;
          feedbackBuffer=expmem((void *)feedbackBuffer, (size_t)size, sizeof(GLfloat));
          ntrials--;
        }
      }
      fremem((void *)&feedbackBuffer);
      fremem((void *)&text);
      if (!ntrials)
      {
        word=getStringResource(topShell, "unableToWriteFeedback");
        messgb(topShell, 1, word, buttons, 1);
      }
    }
    setDrawingDevice(SCREEN);
  }
  else
  {
    word=getStringResource(topShell, "unableToOpen");
    sprintf(str, word, file);
    messgb(topShell, 1, str, buttons, 1);
    swapBuffers=TRUE;
    shadows=shadowsSave;
    return(NULL);
  }
  switch (format)
  {
    case HPGL:       hpglClose(f);
                     word=getStringResource(topShell, "HPGLSaved");
                     ground=TRUE;
                     break;
    case POSTSCRIPT: PostscriptClose(f);
                     word=getStringResource(topShell, "PostscriptSaved");
                     break;
    case RAYTRACER:  raytraceClose(f);
                     word=getStringResource(topShell, "RaytracerSaved");
                     windows[window].mode=modeSave;
                     break;
  }
  swapBuffers=TRUE;
  shadows=shadowsSave;
  return(word);
}
