/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _H_EXTENDED_SCROLLVIEW
#define _H_EXTENDED_SCROLLVIEW

#include <AppKit/NSScrollView.h>

// we use forward declarations here because
// Cocoas header files seem to be not include-safe.
@class NSTextField;
@class NSView;
@class NSButton;


@interface ExtendedScrollView : NSScrollView
{
   NSView*       controlsView;
   NSTextField*  currentPageField;
   NSTextField*  pageOfField;
   NSButton*     firstPageButton;
   NSButton*     nextPageButton;
   NSButton*     prevPageButton;
   NSButton*     lastPageButton;
   BOOL          displayPageControls;
}

- (id) initWithFrame: (NSRect)frame;
- (void) dealloc;

- (void) tile;

- (void) setDisplayPageControls: (BOOL)displayControls;
- (BOOL) displayPageControls;

// outlets
- (NSButton*) firstPageButton;
- (NSButton*) nextPageButton;
- (NSButton*) prevPageButton;
- (NSButton*) lastPageButton;
- (NSTextField*) currentPageField;
- (NSTextField*) pageOfField;

@end

#endif
