#!/bin/bash

function check_success()
{
  expected=$1
  shift
  for value in "$@"
  do
    result=`./degrees_converter "$value" | cut -d' ' -f3`
    diff=`echo "$result - $expected" | bc -l`
    if [ $diff != 0 ]
    then
      echo "$value -> $result != $expected"
      exit 1
    fi
  done
}

function check_failure()
{
  expected=$1
  shift
  for value in "$@"
  do
    result=`./degrees_converter "$value" | cut -d' ' -f3`
    diff=`echo "$result - $expected" | bc -l`
    if [ $diff = 0 ]
    then
      echo "$value -> $result = $expected"
      exit 1
    fi
  done
}

check_success 3.5 3.5 330 "330'0.00"
check_failure 3.5 3.6 340 "330'1.00"

exit 0
