/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef DATAVECTOR_H
#define DATAVECTOR_H

//---------------------------------------------------------------------------

#include <Types.h>

class DataVector
  {

public:

    DataVector();
    DataVector(uint Size);
    virtual ~DataVector();

    DataVector& operator= (const DataVector& vector);
    TComplex& operator()(uint pos);

    void zero();    
    uint getSize();
    void addPoint(TComplex value);

private:
    DataVector(const DataVector& vector);
    

private:
    TComplex *vector_;
    uint vectorSize_;
    uint pointer_;
  };
#endif
