/* @(#)  Routine called by the main program to update the history of an image
 * @(#) if required. 
 * @(#)   A string with argcc, argvc and the time followed by a CR, is appended
 * @(#) to the existing Hist memeber of the out IMAGE descriptor
 * @(#) This routine should be called by all main programs only.
 * @(#)  The Hist part of descriptor should have been set by either the
 * @(#) generated routine (im_mmapin, im_openout, or im_setbuf)
 * @(#) however the program checks whether the history part exists
 * @(#) If the history is on existant then none of the library image 
 * @(#) generated routines stated above has  been used.
 * @(#)  In the case of im_openout, history is not created but it must have been
 * @(#) copied when using im_cp_desc.  The program however checks whether the
 * @(#) Hist part of the image descriptor is set and if not, an one line
 * @(#) desc file is created followed by argc argv and the date
 * @(#)  If the Hist pointer of out is NULL, then history is initialted from
 * @(#) this point by copying the filenameCR into Hist (im_newHist())
 * @(#) and writing one line of history.
 * @(#)
 * @(#) int im_updatehist(argcc, argvc, in, out)
 * @(#) IMAGE *in, *out;
 * @(#) int argcc;
 * @(#) char *argvc;
 * @(#) 
 * @(#)  Returns either 0 (success) or -1 (fail)
 * @(#) 
 *
 * Copyright: Nicos Dessipris
 * Written on: 16/01/1990
 * Modified on : 28/10/1992 J. Cupitt
 *	- now calls im_histlin, much simpler
 *	- many bugs in old version ...
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <stdio.h>
#include <string.h>
#include <time.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

#define IM_MAX_LINE (4096)

int 
im_updatehist( IMAGE *out, int argc, char *argv[] )
{	
	int i, j;
	char line[IM_MAX_LINE];

	/* Build command line again.
	 */
	j = 0;
	for( i = 0; i < argc; i++ ) {
		int len = strlen( argv[i] );

		if( j + len + 2 > IM_MAX_LINE ) {
			im_errormsg( "im_updatehist: line too long" );
			return( -1 );
		}

		strcpy( line + j, argv[i] );
		j += strlen( argv[i] );
		strcpy( line + j, " " );
		j += 1;
	}
	line[j] = '\0';

	if( im_histlin( out, line ) ) 
		return( -1 );

	return( 0 );
}
