/*
  File: trace.h                                 

  trace instruction for different format

  Authors: 
    Mathieu Faverge - faverge@labri.fr

  Dates: 
    Varsion 0.0 - from 12 apr 2008
                  to   12 apr 2008
*/
#ifndef TRACE_H
#define TRACE_H

typedef enum Trace_State {
  STATE_ALLOC	     = 27,
  STATE_FREE         = 28
} Trace_State_t;       

/*
 * Common part :
 *    - TraceFmt_t  fmt     : Format de trace
 *    - FILE       *file    : fichier de trace
 *    - double      time    : timestamp
 *    - INT         procnum
 *    - INT         thrdnum
 * State :
 *    - INT           level : niveau de trace (+il est grand plus c'est dtaill)
 *    - Trace_State_T state : Etat dans lequel se retrouve le proc
 *    - INT           id    : identifiant de la tche
 * Comm :
 *    - INT          dest/src : destinataire ou source du message
 *    - Trace_Comm_t Type     : type de communication
 *    - INT          id       : identifiant du message
 *    - INT          size     : taille du message
 */   

#define trace_start(file, time, procnum, thrdnum) \
  fprintf(file, "%9.9lf %ld %ld 0 -1 0\n", (double)time, (long)(procnum), (long)(thrdnum));

#define trace_finish(file, time, procnum, thrdnum) \
  fprintf(file, "%9.9lf %ld %ld 0 -1 1\n", (double)time, (long)(procnum), (long)(thrdnum));

#define trace_malloc(file, time, procnum, state, memory)	\
  fprintf(file, "%9.9lf %ld 0 0 4 %ld %f\n",				\
	  (double)time, (long)procnum, (long)state, (double)memory/(1<<20));

#endif /* TRACE_H */
