/* ==================================================== ======== ======= *
 *
 *  widgets.hh : Athena, Motif and Ubit Widgets for the VREng GUI
 *
 *  VREng Project
 *  Author: Eric Lecolinet @ ENST Paris (elc@enst.fr)
 *  Date:   29 Nov 01
 *
 *  http://www.infres.enst.fr/net/vreng/
 *  http://www.enst.fr/~elc/ubit
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 */


#ifndef GUI_WIDGETS_HH
#define GUI_WIDGETS_HH

#define VRENG_WELCOME	"Welcome to VREng!"
#define PLEASE_WAIT	"Please Wait! Loading the Rendez-Vous World..."
#define TOOLBAR_HEIGHT	30
#define MESSAGES_HEIGHT	85
#define LIST_WIDTH	70


#ifdef WANT_UBIT
typedef class UBox *GuiUser;
typedef class UBox *GuiWorld;
#else
typedef Widget GuiUser;
typedef Widget GuiWorld;
#endif

/* ==================================================== ======== ======= */

class GuiWidgets {
  class GUI &gui;	// points to the containing GUI class
public:
  static class WTheme theme;  // the theme used to paramaterize the GUI

  GuiWidgets(class GUI&);

  // default resource specs for X Window
  static char** getFallbackResources();

  // adds a new message to the message box
  void writeMessage(const char *mode, const char *from, const char *mess);

  //opens alert box if arg is not null, closes it if arg is null
  void alert(const char* message);
  void resizeGLZone(int width, int height);

  GuiUser addUser(User *);
  void updateUser(GuiUser, User *);
  void removeUser(GuiUser);

  GuiWorld addWorld(struct _World *world, boolean isCurrentWorld);
  void updateWorld(struct _World *world, boolean isCurrentWorld);
  void removeWorld(struct _World *world);

#ifdef WANT_UBIT    // UBIT Toolkit
  // updates object info (infobox in the toolbar and contextual info menu)
  // NB: delete the infobox and makes it disappear if button = 0
  class UMenu* updateObjectInfo(ObjInfo*, int mouse_button);
  class UFrame* getFrame()     {return frame;}
  class UIncrust* getGLZone()  {return glzone;}
  class UMenu* getOpenedMenu() {return openedMenu;}

  // pour VNC 
  class Vnc* vnc;
  class UDialog* vnc_dialog;
  class UStr *vnc_server, *vnc_port, *vnc_passwd;

  void redirectToVnc(class Vnc*);
  void launchVncConnect(Vnc*);
  void initVncConnect(Vnc*);
  // fin VNC

private:
  boolean followMouseMode;
  class UFrame *frame;    // main frame of the application
  class UBox   *toolbar, *users, *worlds, *messages, *entry, 
    *worldsPane, *usersPane, *controlPanel;
  class UDialog *alertBox; 
  class UScrollPane *messagesPane;
  class UIncrust *glzone;   //OpenGL Drawing Zone
  class UWidth   *glzoneWidth;
  class UHeight  *glzoneHeight;
  class UStr     *entryStr, *alertStr;
  // contextual info and naviguation
  class UBox     *infobox;
  class UMenu    *infoMenu, *navigMenu, *openedMenu;
  // current mouse position and pressed button
  int x_ref, y_ref;
  int button;

  UBox* makeNavigator(int);
  UBox* makeControlPanel();

  void mpress(class UEvent*);
  void mrelease(class UEvent*);
  void mmove(class UEvent*);
  void mdrag(class UEvent*);
  void kpress(class UEvent*);
  void krelease(class UEvent*);

  void setMouseRef(class UEvent*);
  void startMotion(class UEvent*);
  void startMotion(class UEvent*, class Mvt* mvt1, class Mvt* mvt2);
  void stopMotion(class UEvent*);
  void motion(class UEvent*);
  void entryAction(class UEvent*);

#else // ATHENA or MOTIF
public:
  int glwin_x, glwin_y;
private:
 Widget frame, glzone, users, worlds, messages, entry,
    menuBar, toolBar, moveBar, objectBar, objectMenu, rightPanel, 
    worldsPane, usersPane;

  static void glzoneMousePressEH(Widget, XtPointer, XEvent*, Boolean*);
  static void glzoneKeyPressEH(Widget, XtPointer, XEvent*, Boolean*);
  static void glzoneKeyReleaseEH(Widget, XtPointer, XEvent*, Boolean*);
  static void glzoneMouseMoveEH(Widget, XtPointer, XEvent*, Boolean*);
  static void glzoneSetFocusEH(Widget, XtPointer, XEvent*, Boolean*);
  static void entrySetFocusEH(Widget, XtPointer, XEvent*, Boolean*);
  static void entryActionEH(Widget, XtPointer, XEvent*, Boolean*);
  static void entryActionCB(Widget, XtPointer, XtPointer);
#endif
};


#endif // GUI_WIDGETS_HH
