#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "payload.h"	/* putPayload */
#include "anim.h"

#include "zv.h"		/* parseGeometry */


const WClass Anim::wclass(ANIM_TYPE, "Animator", Anim::creator);

static u_int16 oid = 1;


/* anim creation from a file */
void Anim::creator(char *l)
{
  new Anim(l);
}

Anim::Anim(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  status = atoi(l);
  l = strtok(NULL, SEP);
  nb_frames = atoi(l);
  l = strtok(NULL, SEP);
  frame = (atoi(l) % nb_frames);
  l = strtok(NULL, SEP);
  ttl = (float) atof(l);
  l = strtok(NULL, SEP);
  soh = parseGeometry(l);

  initializeObject(this, ANIM_TYPE, VR_MOBILE);
  initializeNetObject(this, oid++, ANIM_PROPS, VR_PERMANENT);


  if (status == 1) {
    struct timeval te;
    gettimeofday(&te, NULL);
    move.sec = te.tv_sec;
    move.usec = te.tv_usec;
  }
} 

/* anim update to the network */
boolean Anim::updateToNetwork(const Pos &oldpos)
{
  boolean change = FALSE;
#if 0
  Anim *poldanim = dynamic_cast<Anim *>(pold);
  if (poldanim == NULL)
    return FALSE;
  
  if (this->frame != poldanim->frame) {
    declareObjDelta(&(this->noh), ANIM_PROPFRAME);
    change = TRUE;
  }
#undef CHANGENBFRAMES
#ifdef CHANGENBFRAMES
  if (this->nb_frames != poldanim->nb_frames) {
    declareObjDelta(&(this->noh), ANIM_PROPNBFRAMES);
    change = TRUE;
  }
#endif
#undef CHANGEANIMTTL
#ifdef CHANGEANIMTTL
  if (this->ttl != poldanim->ttl) {
    declareObjDelta(&(this->noh), ANIM_PROPTTL);
    change = TRUE;
  }
#endif
#endif
  return change;
}

static
void animStart(Anim *po, void *datas, time_t sec, time_t usec)
{
  po->move.sec = sec;
  po->move.usec = usec;
  po->status = 1;
}

static
void animStop(Anim *po, void *datas, time_t sec, time_t usec)
{
  po->status = 0;
}

/* object intersects: stop */
void Anim::whenIntersect(WObject *pcur, WObject *pold)
{
  copyPositionAndBB(pold, pcur);
}

boolean Anim::change()
{
  return status;
}

void Anim::updateTime(time_t sec, time_t usec, float *lasting)
{
  *lasting = (float)(sec - move.sec) + ((float)(usec - move.usec) / 1e6);
  if (*lasting > ttl) {
    move.sec = sec;
    move.usec = usec;
  }
}

void Anim::changePosition(float lasting)
{
  if (lasting > ttl) {
    frame = (frame + 1) % nb_frames;
    setSolidFrame(soh, frame);
  }
}

void set_frame(Anim *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;
  
  getPayload(pp, "d", &(pcur->frame));
  setSolidFrame(pcur->soh, pcur->frame);
  updateReplica(pcur, oldpos);
}

static
void get_frame(Anim *po, Payload *pp)
{
  putPayload(pp, "d", po->frame);
}

static
void set_nb_frames(Anim *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;
  
  getPayload(pp, "d", &(pcur->nb_frames));
  updateReplica(pcur, oldpos);
}

static
void get_nb_frames(Anim *po, Payload *pp)
{
  putPayload(pp, "d", po->nb_frames);
}

static
void set_ttl(Anim *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;
  
  getPayload(pp, "f", &(pcur->ttl));
  updateReplica(pcur, oldpos);
}

static
void get_ttl(Anim *po, Payload *pp)
{
  putPayload(pp, "f", po->ttl);
}

void Anim::quit()
{
  oid = 1;
}

/* anim functions initialization */
void animInitFuncList(void)
{
  setFuncList[ANIM_PROPFRAME][ANIM_TYPE].pf = WO_PAYLOAD set_frame;
  getFuncList[ANIM_PROPFRAME][ANIM_TYPE].pf = WO_PAYLOAD get_frame;
  setFuncList[ANIM_PROPNBFRAMES][ANIM_TYPE].pf = WO_PAYLOAD set_nb_frames;
  getFuncList[ANIM_PROPNBFRAMES][ANIM_TYPE].pf = WO_PAYLOAD get_nb_frames;
  setFuncList[ANIM_PROPTTL][ANIM_TYPE].pf = WO_PAYLOAD set_ttl;
  getFuncList[ANIM_PROPTTL][ANIM_TYPE].pf = WO_PAYLOAD get_ttl;

  setMethodFunc(ANIM_TYPE, 0, WO_ACTION animStart, "Start");
  setMethodFunc(ANIM_TYPE, 1, WO_ACTION animStop, "Stop");
}

#endif /* !VRENGD */
