#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"
#include "grid.h"

ObjectList *grid[GRIDL][GRIDW][GRIDH];


/* clear all pointers in the grid */
void clearGrid(void)
{
  for (int x = 0; x < GRIDL; x++)
    for (int y = 0; y < GRIDW; y++)
      for (int z = 0; z < GRIDH; z++)
	grid[x][y][z] = NULL;
}

/* free all the grid */
void freeGrid(void)
{
  for (int x = 0; x < GRIDL; x++)
    for (int y = 0; y < GRIDW; y++)
      for (int z = 0; z < GRIDH; z++) {
        if (grid[x][y][z] != NULL)
	  freeObjectList(grid[x][y][z]);
      }
  clearGrid();
}

/* evalue et remplit le tableau igrid, tableaux d'indices de la position
 * de pos dans la grille
 */
void calculateCoordinatesIntoGrid(float pos[3], int igrid[3])
{
  igrid[0] = (int) ((pos[0] + (float)GRIDdX * (GRIDL/2)) / GRIDdX);
  igrid[1] = (int) ((pos[1] + (float)GRIDdY * (GRIDW/2)) / GRIDdY);
  igrid[2] = (int) ((pos[2] + (float)GRIDdZ * (GRIDH/2)) / GRIDdZ);

  igrid[0] = MAXI(0, igrid[0]);
  igrid[0] = MINI(GRIDL-1, igrid[0]);
  igrid[1] = MAXI(0, igrid[1]);
  igrid[1] = MINI(GRIDW-1, igrid[1]);
  igrid[2] = MAXI(0, igrid[2]);
  igrid[2] = MINI(GRIDH-1, igrid[2]);
}

/* add an object in the grid */
void insertObjectIntoGrid(WObject *po)
{
  float pmin[3], pmax[3];

  if (!isValidType(po->noh.type)) {
    trace(DBG_FORCE, "insertObjectIntoGrid: invalid type=%d p=%p", po->noh.type, po);
  //PD   return;
  }
  for (int i = 0; i < 3; i++) {
    pmin[i] = po->pos.bbcenter.v[i] - po->pos.bbsize.v[i]; /* coord. min */
    pmax[i] = po->pos.bbcenter.v[i] + po->pos.bbsize.v[i]; /* coord. max */
  }

  int imin[3], imax[3];

  calculateCoordinatesIntoGrid(pmin, imin);
  calculateCoordinatesIntoGrid(pmax, imax);

  for (int x = imin[0]; x <= imax[0]; x++)
    for (int y = imin[1]; y <= imax[1]; y++)
      for (int z = imin[2]; z <= imax[2]; z++)
	grid[x][y][z] = addObjectToListOnce(po, grid[x][y][z], 1);
}

/* delete an object in the grid */
void deleteObjectFromGrid(WObject *po)
{
#if 0
  float pmin[3], pmax[3];

  if (!isValidType(po->noh.type)) {
    trace(DBG_FORCE, "deleteObjectFromGrid: invalid type=%d p=%p", po->noh.type, po);
  //PD   return;
  }
// M.S. : this estimation doesn't work 100%.
// Doing the above reduces crash rate when
// sending a bunch of darts.
  for (int i = 0; i < 3; i++) {
    pmin[i] = po->pos.bbcenter.v[i] - po->pos.bbsize.v[i];
    pmax[i] = po->pos.bbcenter.v[i] + po->pos.bbsize.v[i];
  }

  int imin[3], imax[3];

  calculateCoordinatesIntoGrid(pmin, imin);
  calculateCoordinatesIntoGrid(pmax, imax);

  for (int x = imin[0]; x <= imax[0]; x++)
    for (int y = imin[1]; y <= imax[1]; y++)
      for (int z = imin[2]; z <= imax[2]; z++)
	grid[x][y][z] = deleteObjectFromList(po, grid[x][y][z]);    
#else
  for (int x = 0; x < GRIDL; x++)
    for (int y = 0; y < GRIDW; y++)
      for (int z = 0; z < GRIDH; z++)
        if (grid[x][y][z] != NULL)
          grid[x][y][z] = deleteObjectFromList(po, grid[x][y][z]);
#endif
}

/* update an object in the grid */
void updateObjectIntoGrid(WObject *po, const Pos &oldpos)
{
  float pmin1[3], pmax1[3], pmin2[3], pmax2[3];

  if (!isValidType(po->noh.type)) {
    trace(DBG_FORCE, "updateObjectIntoGrid: invalid type=%d p=%p", po->noh.type, po);
  //PD   return;
  }
  for (int i = 0; i < 3; i++) {
    pmin1[i] = po->pos.bbcenter.v[i] - po->pos.bbsize.v[i];
    pmax1[i] = po->pos.bbcenter.v[i] + po->pos.bbsize.v[i];
    pmin2[i] = oldpos.bbcenter.v[i] - oldpos.bbsize.v[i];
    pmax2[i] = oldpos.bbcenter.v[i] + oldpos.bbsize.v[i];
  }

  int imin1[3], imax1[3], imin2[3], imax2[3];

  calculateCoordinatesIntoGrid(pmin1, imin1);
  calculateCoordinatesIntoGrid(pmax1, imax1);
  calculateCoordinatesIntoGrid(pmin2, imin2);
  calculateCoordinatesIntoGrid(pmax2, imax2);

  boolean change = FALSE;

  for (int i = 0; i < 3; i++)
    if ((imin1[i] != imin2[i]) || (imax1[i] != imax2[i]))
      change = TRUE;

  if (change == TRUE) {
#if 0
    for (int x = imin2[0]; x <= imax2[0]; x++)
      for (int y = imin2[1]; y <= imax2[1]; y++)
	for (int z = imin2[2]; z <= imax2[2]; z++) {
          //D if (grid[x][y][z] == NULL)
          //D   trace(DBG_WMGT, "updateObjectIntoGrid: grid[%d][%d][%d]=%x", x, y, z, grid[x][y][z]);
          //D   continue;
	  grid[x][y][z] = deleteObjectFromList(po, grid[x][y][z]);    
        }
#else
    deleteObjectFromGrid(po);
#endif
    for (int x = imin1[0]; x <= imax1[0]; x++)
      for (int y = imin1[1]; y <= imax1[1]; y++)
	for (int z = imin1[2]; z <= imax1[2]; z++)
	  grid[x][y][z] = addObjectToListOnce(po, grid[x][y][z], 2);
  }
}

/* place an object in the grid */
//PD void placeObjectInGrid(WObject *po)
void initBB(Pos &pos)
{
  pos.bbcenter.v[0] = GRIDdX/2;
  pos.bbcenter.v[1] = GRIDdY/2;
  pos.bbcenter.v[2] = GRIDdZ/2;
  pos.bbsize.v[0] = GRIDdX/10;
  pos.bbsize.v[1] = GRIDdY/10;
  pos.bbsize.v[2] = GRIDdZ/10;
}

void testGrid(const char *label)
{
#if 1
  for (int x = 0; x < GRIDL; x++)
    for (int y = 0; y < GRIDW; y++)
      for (int z = 0; z < GRIDH; z++) {
	ObjectList *tmp = grid[x][y][z];
	while (tmp != NULL) {
	  if ((unsigned long)tmp > (unsigned long)0x3000000) {
	    trace(DBG_FORCE, "%s %d %d %d %p",label,x,y,z, tmp);
	    return;
	  }
          //if ((unsigned long)(tmp->pobject) > (unsigned long)0x3000000) {
          //  trace(DBG_FORCE, "p %s %d %d %d %p",label,x,y,z, tmp->pobject);
          //  return;
          //}
	  tmp = tmp->next;
	}
      }
#endif
}  

#endif /* !VRENGD */
