
  // ------------------------------------------------------------------------ //
  // Author               : This file has been written by                     //
  //                            Yann Renard (MyselF / Dim4)                   //
  // Copyright            : This file is totaly free and you may distribute   //
  //                        it to anyone you want, without modifying this     //
  //                        header. If you use it in a commercial project (?) //
  //                        or in bigger project (!), I would be glad to know //
  //                        about it :) Please mail me...                     //
  //                        be glad to know about it, please mail me          //
  // Contact              : You can contact me at                             //
  //                            renard@esiea-ouest.fr                         //
  //                            myself_yr@hotmail.com                         //
  // Bug reports          : Mail me please so I can know about it             //
  // Purpose of this file : This package is my first experiment in bones      //
  //                        programming. I feel it works great for a first    //
  //                        time. For sure their are lots of optim to do...   //
  //                        Your ideas are welcome :)                         //
  // Version              : 1.0                                               //
  // History              : none                                              //
  // ToDo                 : lot's of things :)                                //
  //                        other things :))))                                //
  //                        Maybe buid an HTML tutorial about this subject ?  //
  // Greets               : Dim4 members :)                                   //
  //                        Latex, teacher forever                            //
  //                        Ethereal, thx for ideas of implementation         //
  //                        #codefr, thx for url                              //
  //                        comp.graphics.algorithm && comp.graphics.opengl   //
  //                        pech' and yoyo... newbies in demo hey !           //
  // ------------------------------------------------------------------------ //

#ifndef __BONEMESH3D_H__
#define __BONEMESH3D_H__

#include "boneCommon.h"
#include "boneName.h"
#include "boneVertex.h"
#include "boneTriangle.h"
#include "boneLink.h"
#include "boneList.h"

   class MESH3D : public NAMEABLE
    {
     public :

     //----------------------------
     // Champs de la classe mesh3d

     // -> Gestion des sommets
     LIST < VERTEX > vertexList;
     VERTEX       ** vertex;
     int             vertices;
     int             vertexListCompiled;

     // -> Gestion des faces triangulaires
     LIST < TRIANGLE > triangleList;
     TRIANGLE       ** triangle;
     int               triangles;
     int               triangleListCompiled;

     //---------------------------
     // Infos de boite englobante
     float minx,miny,minz;
     float maxx,maxy,maxz;

     //-----------------------------
     // Constructeurs / destructeur
     MESH3D ( void );
     ~MESH3D ( void );

     //------------------------
     // Actions sur les champs
     void addVertex ( VECT3D & zePosition );
     void addVertex ( VECT3D * zePosition );
     void addVertex ( float ox, float oy, float oz );
     void addTriangle ( int index1, int index2, int index3 );
     void generateBoundingBox ( void );

     //----------------------
     // Modification du mesh
     void rebuildNormals ( void );
     void flipNormals ( void );

     void mirrorx ( void );
     void mirrory ( void );
     void mirrorz ( void );
     void scale     ( float sx, float sy, float sz ); // Definitive action !
     void translate ( float dx, float dy, float dz ); // Definitive action !

     void planarMappingX ( void );
     void planarMappingY ( void );
     void planarMappingZ ( void );
     void cylinderMapping ( void );

     void projectLight ( void );

     //--------------------
     // Fonctions internes
     void compileVertexList ( void );
     void compileTriangleList ( void );
    };

#endif
