// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1994
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        unixsocket.h
// 
// Purpose:     
// 
// Created:     4 May 95   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#ifndef hg_utils_unixsocket_h
#define hg_utils_unixsocket_h

#ifndef WIN32
#include "socket.h"


// <class> 
//  
// Name:             UNIXSocket
// 
// Purpose:          
// 
// a UNIX domain socket.
// 
// Public Interface: 
// 
// - UNIXSocket()
//   default constructor. results in an invalid file number.
// - UNIXSocket (int fd, boolean close)
//   as it is with the INETSocket
// - UNIXSocket (const char* path)
//   connect to a socket listening on path
// - boolean connect (const char* path)
//   ditto
// - boolean listen (const char* path)
//   as it is with the INETSocket
// - boolean sendFd (int)
// - boolean recvFd (int& fd)
//   Send a file number (of any kind) my process has opened to another process.
//   Receive it.
//   These works only on certain platforms (in fact, on most).
//   Doesn't work under Linux.
// 
// Description:      
// 
// none but this one:
// when you start listening on a UNIX socket, you have to specify a path in the file system.
// this path is not removed on destruction, so if you perform *real* cleanup, you will have 
// to do it by yourself.
// 
// This is not done by the object itself because one could fork() after the accept() on the 
// service and have the child close() or delete the service. Of course this should not affect 
// the parent (a daemon?), whereas unlink()ing the parent's service would do so.
// 
// </class> 
class UNIXSocket : public Socket {
public:
   UNIXSocket() ;
   UNIXSocket (int fd) ;
   UNIXSocket (const char* path) ; // connect to ...
   ~UNIXSocket() ;
   
   boolean connect (const char* path) ;
   boolean listen (const char* path) ;

   // OS dependent
   static boolean haveSendFd() ;
   boolean sendFd (int) ;
   // ATTENTION: this one blocks even if the socket is designated
   // nonblocking:
   boolean recvFd (int& fd) ;

private:
   UNIXSocket (const UNIXSocket&) {}
   UNIXSocket& operator = (const UNIXSocket&) { return *this; }

public:
   static const char* version1 ;
} ;
static const char* hg_utils_unixsocket_version = UNIXSocket::version1 ;

SmartPtrdeclare (UNIXSocketPtr, UNIXSocket) 

#endif /* WIN32*/
#endif
