/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.util;

import org.web3d.vrml.lang.VRMLNodeTemplate;

public class NodeTemplateArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int INCREMENT_SIZE = 256;
    private int valueCount;
    private VRMLNodeTemplate[] array;

    public NodeTemplateArray() {
        this(512);
    }

    public NodeTemplateArray(int n) {
        this.array = new VRMLNodeTemplate[n];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        for (int i = 0; i < this.valueCount; ++i) {
            this.array[i] = null;
        }
        this.valueCount = 0;
    }

    public void add(VRMLNodeTemplate vRMLNodeTemplate) {
        if (this.valueCount == this.array.length) {
            VRMLNodeTemplate[] vRMLNodeTemplateArray = new VRMLNodeTemplate[this.array.length + 256];
            System.arraycopy(this.array, 0, vRMLNodeTemplateArray, 0, this.array.length);
            this.array = vRMLNodeTemplateArray;
        }
        this.array[this.valueCount++] = vRMLNodeTemplate;
    }

    public void add(VRMLNodeTemplate[] vRMLNodeTemplateArray) {
        if (vRMLNodeTemplateArray == null) {
            return;
        }
        int n = this.valueCount + vRMLNodeTemplateArray.length;
        if (n >= this.array.length) {
            VRMLNodeTemplate[] vRMLNodeTemplateArray2 = new VRMLNodeTemplate[n];
            System.arraycopy(this.array, 0, vRMLNodeTemplateArray2, 0, this.array.length);
            this.array = vRMLNodeTemplateArray2;
        }
        System.arraycopy(vRMLNodeTemplateArray, 0, this.array, this.valueCount, vRMLNodeTemplateArray.length);
        this.valueCount = n;
    }

    public void add(NodeTemplateArray nodeTemplateArray) {
        if (nodeTemplateArray == null) {
            return;
        }
        int n = this.valueCount + nodeTemplateArray.valueCount;
        if (n >= this.array.length) {
            VRMLNodeTemplate[] vRMLNodeTemplateArray = new VRMLNodeTemplate[n];
            System.arraycopy(this.array, 0, vRMLNodeTemplateArray, 0, this.array.length);
            this.array = vRMLNodeTemplateArray;
        }
        System.arraycopy(nodeTemplateArray.array, 0, this.array, this.valueCount, nodeTemplateArray.valueCount);
        this.valueCount = n;
    }

    public void add(VRMLNodeTemplate[] vRMLNodeTemplateArray, int n, int n2) {
        int n3 = this.valueCount + n2;
        if (n3 >= this.array.length) {
            VRMLNodeTemplate[] vRMLNodeTemplateArray2 = new VRMLNodeTemplate[n3];
            System.arraycopy(this.array, 0, vRMLNodeTemplateArray2, 0, this.array.length);
            this.array = vRMLNodeTemplateArray2;
        }
        System.arraycopy(vRMLNodeTemplateArray, n, this.array, this.valueCount, n2);
        this.valueCount = n3;
    }

    public VRMLNodeTemplate get(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, VRMLNodeTemplate vRMLNodeTemplate) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = vRMLNodeTemplate;
    }

    public void set(NodeTemplateArray nodeTemplateArray) {
        int n = nodeTemplateArray.valueCount;
        if (n >= this.array.length) {
            this.array = new VRMLNodeTemplate[n];
        } else if (n < this.valueCount) {
            this.clear();
        }
        System.arraycopy(nodeTemplateArray.array, 0, this.array, 0, nodeTemplateArray.valueCount);
        this.valueCount = nodeTemplateArray.valueCount;
    }

    public VRMLNodeTemplate remove(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        VRMLNodeTemplate vRMLNodeTemplate = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.array.length - n - 1);
        --this.valueCount;
        return vRMLNodeTemplate;
    }

    public VRMLNodeTemplate remove(VRMLNodeTemplate vRMLNodeTemplate) {
        if (vRMLNodeTemplate == null) {
            return null;
        }
        int n = -1;
        for (int i = 0; i < this.valueCount; ++i) {
            if (!vRMLNodeTemplate.equals(this.array[i])) continue;
            n = -1;
            break;
        }
        VRMLNodeTemplate vRMLNodeTemplate2 = null;
        if (n != -1) {
            vRMLNodeTemplate2 = this.remove(n);
        }
        return vRMLNodeTemplate2;
    }

    public void remove(NodeTemplateArray nodeTemplateArray) {
        if (nodeTemplateArray == null) {
            return;
        }
        for (int i = 0; i < nodeTemplateArray.valueCount; ++i) {
            this.remove(nodeTemplateArray.array[i]);
        }
    }

    public VRMLNodeTemplate[] toArray() {
        VRMLNodeTemplate[] vRMLNodeTemplateArray = new VRMLNodeTemplate[this.valueCount];
        System.arraycopy(this.array, 0, vRMLNodeTemplateArray, 0, this.valueCount);
        return vRMLNodeTemplateArray;
    }

    public VRMLNodeTemplate[] toArray(VRMLNodeTemplate[] vRMLNodeTemplateArray) {
        VRMLNodeTemplate[] vRMLNodeTemplateArray2 = null;
        vRMLNodeTemplateArray2 = vRMLNodeTemplateArray.length >= this.valueCount ? vRMLNodeTemplateArray : new VRMLNodeTemplate[this.valueCount];
        System.arraycopy(this.array, 0, vRMLNodeTemplateArray2, 0, this.valueCount);
        return vRMLNodeTemplateArray2;
    }
}

